<?php

namespace App\Http\Controllers\Supervisor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Production;
use App\Models\Sale;

class MonitoringController extends Controller
{
    public function orders()
    {
        $orders = Order::with(['product', 'user'])->latest()->paginate(20);
        return view('supervisor.monitoring.orders', compact('orders'));
    }

    public function productions()
    {
        $productions = Production::with(['order', 'product'])->latest()->paginate(20);
        return view('supervisor.monitoring.productions', compact('productions'));
    }

    public function sales()
    {
        $sales = Sale::with(['order', 'product', 'user'])->latest()->paginate(20);
        return view('supervisor.monitoring.sales', compact('sales'));
    }

    public function purchases()
    {
        $purchases = \App\Models\Purchase::with(['items'])->latest()->paginate(20);
        return view('supervisor.monitoring.purchases', compact('purchases'));
    }
}






