<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;

class TestController extends Controller
{
    public function testCreate()
    {
        try {
            // Test apakah kategori ada
            $categories = Category::where('type', 'service')->get();
            echo "Categories found: " . $categories->count() . "\n";
            
            foreach ($categories as $cat) {
                echo "Category: " . $cat->name . " (ID: " . $cat->id . ")\n";
            }
            
            // Test membuat produk
            $product = new Product();
            $product->product_title = 'Test Product ' . now();
            $product->product_prices = 100000;
            $product->category_id = $categories->first()->id ?? 1;
            $product->is_active = true;
            $product->save();
            
            echo "Product created successfully with ID: " . $product->id . "\n";
            
        } catch (\Exception $e) {
            echo "Error: " . $e->getMessage() . "\n";
            echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "\n";
        }
    }

    public function testFormSubmission()
    {
        try {
            // Simulasi data form
            $testData = [
                'product_title' => 'Test Service ' . now(),
                'product_description' => 'Test description',
                'product_prices' => 150000,
                'category_id' => 1,
                'product_work_duration' => '3 hari',
                'product_garansi' => '6 bulan',
                'service_fee' => 50000,
            ];

            // Test validasi
            $validator = \Validator::make($testData, [
                'product_title' => 'required|string|max:255',
                'product_description' => 'nullable|string',
                'product_prices' => 'required|integer|min:1',
                'category_id' => 'required|exists:categories,id',
                'product_work_duration' => 'nullable|string|max:255',
                'product_garansi' => 'nullable|string|max:255',
                'service_fee' => 'nullable|integer|min:0',
            ]);

            if ($validator->fails()) {
                echo "Validation failed:\n";
                foreach ($validator->errors()->all() as $error) {
                    echo "- " . $error . "\n";
                }
                return;
            }

            // Test create product
            $product = Product::create($testData);
            echo "Product created successfully with ID: " . $product->id . "\n";
            echo "Product title: " . $product->product_title . "\n";
            echo "Product price: " . $product->product_prices . "\n";
            
        } catch (\Exception $e) {
            echo "Error: " . $e->getMessage() . "\n";
            echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "\n";
            echo "Trace: " . $e->getTraceAsString() . "\n";
        }
    }
}