<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use App\Models\ProductInquiry;
use App\Models\Order;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserDashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        // Get user's orders
        $orders = Order::where('user_id', $user->id)
            ->with('product')
            ->latest()
            ->limit(5)
            ->get();
        
        // Statistics
        $userOrdersQuery = Order::where('user_id', $user->id);
        
        $stats = [
            'total_orders' => (clone $userOrdersQuery)->count(),
            'pending_orders' => (clone $userOrdersQuery)
                ->where(function($q) {
                    $q->where('order_status', 'menunggu')
                      ->orWhere('status', 'menunggu_verifikasi');
                })
                ->count(),
            'completed_orders' => (clone $userOrdersQuery)
                ->where('status', 'selesai')
                ->count(),
            'total_spent' => 'Rp ' . number_format(
                (clone $userOrdersQuery)->where('status', 'selesai')->sum('total_price') ?? 0,
                0, ',', '.'
            ),
        ];
        
        return view('user.dashboard', compact('orders', 'stats'));
    }
}
