<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductRab extends Model
{
    protected $fillable = ['product_id', 'item', 'cost'];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    // Agar view bisa pakai $rab->rab_item dan $rab->rab_cost
    public function getRabItemAttribute()
    {
        return $this->item;
    }

    public function getRabCostAttribute()
    {
        return $this->cost;
    }
}
