<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add tracking fields to contacts table
        Schema::table('contacts', function (Blueprint $table) {
            $table->string('tracking_code')->unique()->after('id');
            $table->text('admin_reply')->nullable()->after('pesan');
            $table->timestamp('admin_replied_at')->nullable()->after('admin_reply');
            $table->enum('reply_method', ['email', 'whatsapp', 'phone'])->nullable()->after('admin_replied_at');
            $table->boolean('user_notified')->default(false)->after('reply_method');
        });

        // Add tracking fields to product_inquiries table
        Schema::table('product_inquiries', function (Blueprint $table) {
            $table->string('tracking_code')->unique()->after('id');
            $table->text('admin_reply')->nullable()->after('message');
            $table->timestamp('admin_replied_at')->nullable()->after('admin_reply');
            $table->enum('reply_method', ['email', 'whatsapp', 'phone'])->nullable()->after('admin_replied_at');
            $table->boolean('user_notified')->default(false)->after('reply_method');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->dropColumn(['tracking_code', 'admin_reply', 'admin_replied_at', 'reply_method', 'user_notified']);
        });

        Schema::table('product_inquiries', function (Blueprint $table) {
            $table->dropColumn(['tracking_code', 'admin_reply', 'admin_replied_at', 'reply_method', 'user_notified']);
        });
    }
};
