<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('product_inquiries', function (Blueprint $table) {
            // Status penawaran
            $table->enum('status', ['pending', 'admin_review', 'supervisor_review', 'teknisi_review', 'approved', 'rejected'])->default('pending')->after('message');
            
            // Estimasi harga dari Supervisor
            $table->decimal('min_price', 15, 2)->nullable()->after('status');
            $table->decimal('max_price', 15, 2)->nullable()->after('min_price');
            $table->text('supervisor_note')->nullable()->after('max_price');
            $table->foreignId('supervisor_id')->nullable()->constrained('users')->onDelete('set null')->after('supervisor_note');
            $table->timestamp('supervisor_approved_at')->nullable()->after('supervisor_id');
            
            // Estimasi pengerjaan dari Teknisi
            $table->integer('estimated_days')->nullable()->after('supervisor_approved_at');
            $table->decimal('labor_cost', 15, 2)->nullable()->after('estimated_days');
            $table->text('teknisi_note')->nullable()->after('labor_cost');
            $table->foreignId('teknisi_id')->nullable()->constrained('users')->onDelete('set null')->after('teknisi_note');
            $table->timestamp('teknisi_estimated_at')->nullable()->after('teknisi_id');
            
            // Final response dari Admin
            $table->decimal('final_price', 15, 2)->nullable()->after('teknisi_estimated_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('product_inquiries', function (Blueprint $table) {
            $table->dropForeign(['supervisor_id']);
            $table->dropForeign(['teknisi_id']);
            $table->dropColumn([
                'status',
                'min_price',
                'max_price',
                'supervisor_note',
                'supervisor_id',
                'supervisor_approved_at',
                'estimated_days',
                'labor_cost',
                'teknisi_note',
                'teknisi_id',
                'teknisi_estimated_at',
                'final_price'
            ]);
        });
    }
};
