<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('product_inquiries', function (Blueprint $table) {
            // Status alur
            if (!Schema::hasColumn('product_inquiries', 'status')) {
                $table->string('status')->default('pending');
            }

            // Estimasi teknisi
            if (!Schema::hasColumn('product_inquiries', 'estimated_days')) {
                $table->integer('estimated_days')->nullable();
            }
            if (!Schema::hasColumn('product_inquiries', 'labor_cost')) {
                $table->decimal('labor_cost', 15, 2)->nullable();
            }
            if (!Schema::hasColumn('product_inquiries', 'teknisi_note')) {
                $table->text('teknisi_note')->nullable();
            }
            if (!Schema::hasColumn('product_inquiries', 'teknisi_id')) {
                $table->unsignedBigInteger('teknisi_id')->nullable()->index();
            }
            if (!Schema::hasColumn('product_inquiries', 'teknisi_estimated_at')) {
                $table->timestamp('teknisi_estimated_at')->nullable();
            }

            // Breakdown (pakai longText agar kompatibel semua versi MySQL)
            if (!Schema::hasColumn('product_inquiries', 'materials_breakdown')) {
                $table->longText('materials_breakdown')->nullable();
            }
            if (!Schema::hasColumn('product_inquiries', 'spareparts_breakdown')) {
                $table->longText('spareparts_breakdown')->nullable();
            }

            // Total biaya
            if (!Schema::hasColumn('product_inquiries', 'materials_total_cost')) {
                $table->decimal('materials_total_cost', 15, 2)->default(0);
            }
            if (!Schema::hasColumn('product_inquiries', 'spareparts_total_cost')) {
                $table->decimal('spareparts_total_cost', 15, 2)->default(0);
            }
            if (!Schema::hasColumn('product_inquiries', 'labor_cost_total')) {
                $table->decimal('labor_cost_total', 15, 2)->default(0);
            }
            if (!Schema::hasColumn('product_inquiries', 'total_cost')) {
                $table->decimal('total_cost', 15, 2)->default(0);
            }
            if (!Schema::hasColumn('product_inquiries', 'engineer_suggested_price')) {
                $table->decimal('engineer_suggested_price', 15, 2)->nullable();
            }

            // Range harga supervisor
            if (!Schema::hasColumn('product_inquiries', 'supervisor_floor_price')) {
                $table->decimal('supervisor_floor_price', 15, 2)->nullable();
            }
            if (!Schema::hasColumn('product_inquiries', 'supervisor_target_price')) {
                $table->decimal('supervisor_target_price', 15, 2)->nullable();
            }
            if (!Schema::hasColumn('product_inquiries', 'supervisor_ceiling_price')) {
                $table->decimal('supervisor_ceiling_price', 15, 2)->nullable();
            }
            if (!Schema::hasColumn('product_inquiries', 'validity_until')) {
                $table->dateTime('validity_until')->nullable();
            }

            // Final offer admin & interaksi customer
            if (!Schema::hasColumn('product_inquiries', 'final_offer_price')) {
                $table->decimal('final_offer_price', 15, 2)->nullable();
            }
            if (!Schema::hasColumn('product_inquiries', 'admin_final_notes')) {
                $table->text('admin_final_notes')->nullable();
            }
            if (!Schema::hasColumn('product_inquiries', 'customer_bid_price')) {
                $table->decimal('customer_bid_price', 15, 2)->nullable();
            }
        });
    }

    public function down(): void
    {
        Schema::table('product_inquiries', function (Blueprint $table) {
            $cols = [
                'status','estimated_days','labor_cost','teknisi_note','teknisi_id','teknisi_estimated_at',
                'materials_breakdown','spareparts_breakdown','materials_total_cost','spareparts_total_cost','labor_cost_total','total_cost','engineer_suggested_price',
                'supervisor_floor_price','supervisor_target_price','supervisor_ceiling_price','validity_until',
                'final_offer_price','admin_final_notes','customer_bid_price'
            ];
            foreach ($cols as $c) {
                if (Schema::hasColumn('product_inquiries', $c)) {
                    $table->dropColumn($c);
                }
            }
        });
    }
};
