<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Pastikan tabel product_inquiries sudah ada
        if (!Schema::hasTable('product_inquiries')) {
            return;
        }

        // Tambahkan kolom order_id jika belum ada
        if (!Schema::hasColumn('product_inquiries', 'order_id')) {
            Schema::table('product_inquiries', function (Blueprint $table) {
                $table->foreignId('order_id')
                    ->nullable()
                    ->after('product_id')
                    ->constrained('orders')
                    ->onDelete('set null');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('product_inquiries') && Schema::hasColumn('product_inquiries', 'order_id')) {
            Schema::table('product_inquiries', function (Blueprint $table) {
                $table->dropForeign(['order_id']);
                $table->dropColumn('order_id');
            });
        }
    }
};