@extends('layouts.admin')

@section('title', 'Tambah Kategori')

@section('content')
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.categories.index') }}" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Tambah Kategori</h1>
        </div>
    </div>

    <!-- Form Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
        <div class="p-6">

        <!-- Form -->
        <form action="{{ route('admin.categories.store') }}" method="POST" enctype="multipart/form-data" class="space-y-6">
            @csrf

            <!-- Nama -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Nama Kategori <span class="text-red-500">*</span>
                </label>
                <input type="text" name="name" id="name" value="{{ old('name') }}" required
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('name') border-red-500 dark:border-red-500 @enderror"
                    placeholder="Masukkan nama kategori">
                @error('name')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Tipe -->
            <div>
                <label for="type" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Tipe <span class="text-red-500">*</span>
                </label>
                <select name="type" id="type" required
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('type') border-red-500 dark:border-red-500 @enderror">
                    <option value="service" {{ old('type', 'service') == 'service' ? 'selected' : '' }}>Jasa</option>
                </select>
                @error('type')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Parent Category -->
            <div>
                <label for="parent_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Kategori Besar (Parent) <span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional - Kosongkan untuk membuat kategori besar)</span>
                </label>
                <select name="parent_id" id="parent_id"
                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200 @error('parent_id') border-red-500 dark:border-red-500 @enderror">
                    <option value="">-- Pilih Kategori Besar (atau kosongkan) --</option>
                    @foreach($parentCategories as $parent)
                        <option value="{{ $parent->id }}" {{ old('parent_id') == $parent->id ? 'selected' : '' }}>
                            {{ $parent->name }}
                        </option>
                    @endforeach
                </select>
                <p class="mt-2 text-xs text-gray-500 dark:text-gray-400">
                    <i class="fas fa-info-circle mr-1"></i>
                    Kosongkan untuk membuat kategori besar baru, atau pilih kategori besar untuk membuat sub kategori.
                </p>
                @error('parent_id')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Gambar -->
            <div>
                <label for="image" id="imageLabel" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Gambar Kategori <span id="imageRequired" class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>
                </label>
                <div class="relative">
                    <input type="file" name="image" id="image" accept="image/*"
                        class="w-full px-4 py-3 text-sm text-gray-700 dark:text-gray-300 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 rounded-lg cursor-pointer focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 dark:file:bg-blue-900 dark:file:text-blue-200 @error('image') border-red-500 dark:border-red-500 @enderror">
                </div>
                <p id="imageHelpText" class="mt-2 text-xs text-gray-500 dark:text-gray-400">
                    <i class="fas fa-info-circle mr-1"></i>
                    <span id="imageHelpContent">Gambar opsional untuk kategori besar.</span>
                </p>
                @error('image')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror

                <!-- Preview -->
                <div class="mt-4">
                    <div class="flex items-center justify-center w-48 h-48 bg-gray-50 dark:bg-gray-700/50 rounded-lg border-2 border-dashed border-gray-300 dark:border-gray-600" id="previewContainer">
                        <img id="previewImage" class="hidden max-w-full max-h-full object-contain rounded-lg" style="background: transparent;">
                        <div id="previewPlaceholder" class="text-center">
                            <i class="fas fa-image text-4xl text-gray-400 dark:text-gray-500 mb-2"></i>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Preview gambar</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Buttons -->
            <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200 dark:border-gray-700">
                <a href="{{ route('admin.categories.index') }}"
                    class="px-6 py-3 text-gray-600 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200 font-medium">
                    Batal
                </a>
                <button type="submit"
                    class="px-6 py-3 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200 flex items-center space-x-2">
                    <i class="fas fa-save"></i>
                    <span>Simpan Kategori</span>
                </button>
            </div>
        </form>
    </div>

    <!-- Script Preview Gambar & Dynamic Label -->
    <script>
        const parentSelect = document.getElementById('parent_id');
        const imageInput = document.getElementById('image');
        const imageLabel = document.getElementById('imageLabel');
        const imageRequired = document.getElementById('imageRequired');
        const imageHelpContent = document.getElementById('imageHelpContent');

        // Function untuk update label gambar berdasarkan pilihan parent
        function updateImageLabel() {
            const hasParent = parentSelect.value !== '';
            
            if (hasParent) {
                // Sub kategori - gambar wajib
                imageRequired.innerHTML = '<span class="text-red-500">*</span> <span class="text-gray-500 dark:text-gray-400">(Wajib)</span>';
                imageInput.setAttribute('required', 'required');
                imageHelpContent.textContent = 'Gambar wajib untuk sub kategori karena akan ditampilkan di halaman depan.';
                imageHelpContent.classList.remove('text-gray-500');
                imageHelpContent.classList.add('text-blue-600', 'dark:text-blue-400');
            } else {
                // Kategori besar - gambar opsional
                imageRequired.innerHTML = '<span class="text-gray-500 dark:text-gray-400 text-sm">(Opsional)</span>';
                imageInput.removeAttribute('required');
                imageHelpContent.textContent = 'Gambar opsional untuk kategori besar.';
                imageHelpContent.classList.remove('text-blue-600', 'dark:text-blue-400');
                imageHelpContent.classList.add('text-gray-500');
            }
        }

        // Event listener untuk perubahan parent
        parentSelect.addEventListener('change', updateImageLabel);

        // Initialize label saat page load
        updateImageLabel();

        // Preview gambar
        imageInput.addEventListener('change', function(event) {
            const file = event.target.files[0];
            const preview = document.getElementById('previewImage');
            const placeholder = document.getElementById('previewPlaceholder');
            const container = document.getElementById('previewContainer');

            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.classList.remove('hidden');
                    preview.style.display = 'block';
                    placeholder.style.display = 'none';
                    placeholder.classList.add('hidden');
                    container.classList.remove('border-dashed');
                    container.classList.add('border-solid', 'border-gray-200', 'dark:border-gray-600');
                };
                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                preview.classList.add('hidden');
                preview.style.display = 'none';
                placeholder.style.display = 'block';
                placeholder.classList.remove('hidden');
                container.classList.add('border-dashed');
                container.classList.remove('border-solid');
            }
        });
    </script>
@endsection
