<!-- Sparepart Edit Form Card -->
<div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5">
    <!-- Header Card -->
    <div class="flex items-center mb-5">
        <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Sparepart</h3>
    </div>

    <!-- Basic Information -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5 mb-5">
        <!-- Kode Sparepart -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kode Sparepart</label>
            <input type="text" name="part_code" value="{{ old('part_code', $sparepart->part_code) }}"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Jika kosong, otomatis dibuat unik">
            @error('part_code')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <!-- Nama Sparepart -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Nama Sparepart <span class="text-red-500">*</span>
            </label>
            <input type="text" name="name" value="{{ old('name', $sparepart->name) }}" required
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Masukkan nama sparepart">
            @error('name')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <!-- Brand -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Brand</label>
            <input type="text" name="brand" value="{{ old('brand', $sparepart->brand) }}"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Merk / brand">
            @error('brand')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>
    </div>

    <!-- Additional Information -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5 mb-5">
        <!-- Tipe -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tipe</label>
            <input type="text" name="type" value="{{ old('type', $sparepart->type) }}"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Tipe sparepart">
            @error('type')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <!-- Part Number -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Part Number</label>
            <input type="text" name="part_number" value="{{ old('part_number', $sparepart->part_number) }}"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="Nomor part">
            @error('part_number')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <!-- Stok -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Stok <span class="text-red-500">*</span>
            </label>
            <input type="number" name="stock" value="{{ old('stock', $sparepart->stock) }}" min="0" required
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="0">
            @error('stock')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>
    </div>

    <!-- Stock & Pricing -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-5 mb-5">
        <!-- Satuan -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Satuan</label>
            <input type="text" name="unit" value="{{ old('unit', $sparepart->unit) }}"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="cth: pcs, unit, set">
            @error('unit')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <!-- Harga -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Harga Satuan (Rp)</label>
            <input type="number" name="price" value="{{ old('price', $sparepart->price) }}" min="0" step="0.01"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm"
                placeholder="cth: 50000">
            @error('price')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <!-- Status -->
        <div class="flex items-center">
            <input type="checkbox" name="is_active" value="1"
                {{ old('is_active', $sparepart->is_active) ? 'checked' : '' }}
                class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 dark:border-gray-600 rounded bg-white dark:bg-gray-700">
            <label class="ml-3 block text-sm font-medium text-gray-700 dark:text-gray-300">Aktif</label>
        </div>
    </div>

    <!-- Description & Image -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-5 mb-5">
        <!-- Deskripsi -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Deskripsi</label>
            <textarea name="description" rows="4"
                class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 resize-none text-sm"
                placeholder="Tuliskan deskripsi sparepart jika perlu...">{{ old('description', $sparepart->description) }}</textarea>
            @error('description')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <!-- Gambar -->
        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Gambar</label>
            <div class="space-y-3">
                <!-- Existing Image -->
                @if ($sparepart->image)
                    <div class="relative inline-block w-full max-w-xs">
                        <img src="{{ asset('uploads/spareparts/' . $sparepart->image) }}" alt="Current Image"
                            class="w-full h-48 object-contain rounded-lg border border-gray-200 dark:border-gray-600 bg-gray-50 dark:bg-gray-700/50"
                            style="background: transparent;">
                        
                        <!-- Remove Existing Image Button -->
                        <button type="button" onclick="removeExistingImage(this)"
                            class="absolute -top-2 -right-2 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200">
                            <i class="fas fa-times text-sm"></i>
                        </button>
                        <input type="hidden" name="remove_image" value="0">
                    </div>
                @endif

                <!-- New Image Upload -->
                <input type="file" name="image" accept="image/*" onchange="previewImage(this)"
                    class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm">
                
                <!-- New Image Preview -->
                <div id="newImagePreview" class="relative inline-block w-full max-w-xs hidden">
                    <img src="" alt="Preview" 
                        class="w-full h-48 object-contain rounded-lg border border-gray-200 dark:border-gray-600 bg-gray-50 dark:bg-gray-700/50 hidden"
                        style="background: transparent;">
                    
                    <!-- Remove New Image Button -->
                    <button type="button" id="removeNewImageBtn" onclick="removeImage(this)"
                        class="absolute -top-2 -right-2 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 hidden">
                        <i class="fas fa-times text-sm"></i>
                    </button>
                </div>
            </div>
            @error('image')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>
    </div>

    <!-- Stock Rusak -->
    <div class="mb-5">
        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Jumlah Unit Rusak</label>
        <div class="flex items-center space-x-4">
            <input type="number" name="damaged_stock" 
                value="{{ old('damaged_stock', $sparepart->damaged_stock ?? 0) }}" 
                min="0" max="{{ $sparepart->stock }}"
                class="w-32 px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm">
            <span class="text-sm text-gray-600 dark:text-gray-400">
                dari {{ $sparepart->stock }} {{ $sparepart->unit }} total
                @if($sparepart->damaged_stock > 0)
                    ({{ $sparepart->damage_percentage ?? 0 }}% rusak)
                @endif
            </span>
        </div>
        @error('damaged_stock')
            <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
        @enderror
    </div>

    <!-- Catatan Kerusakan -->
    <div class="mb-5" id="damage-notes-section" style="display: {{ old('damaged_stock', $sparepart->damaged_stock ?? 0) > 0 ? 'block' : 'none' }};">
        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Catatan Kerusakan</label>
        <textarea name="damage_notes" rows="3"
            class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 resize-none text-sm"
            placeholder="Jelaskan kondisi kerusakan unit-unit tersebut...">{{ old('damage_notes', $sparepart->damage_notes) }}</textarea>
        @error('damage_notes')
            <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
        @enderror
    </div>

    <!-- Tanggal Kerusakan -->
    <div class="mb-5" id="damage-date-section" style="display: {{ old('damaged_stock', $sparepart->damaged_stock ?? 0) > 0 ? 'block' : 'none' }};">
        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tanggal Kerusakan</label>
        <input type="date" name="damage_date" 
            value="{{ old('damage_date', $sparepart->damage_date ? $sparepart->damage_date->format('Y-m-d') : '') }}"
            class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-white transition duration-200 text-sm">
        @error('damage_date')
            <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
        @enderror
    </div>
</div>

