{{-- 
    Daftar Request Item dari Teknisi - ADMIN
    Variables: $production, $itemRequestsByProposal, $pendingRequests
--}}

@if($pendingRequests && $pendingRequests->count() > 0)
<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border-2 border-amber-300 dark:border-amber-700 overflow-hidden mb-6">
    <div class="px-4 py-3 bg-gradient-to-r from-amber-500 to-orange-500">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <div class="w-10 h-10 bg-white/20 rounded-lg flex items-center justify-center mr-3">
                    <i class="fas fa-bell text-white text-lg animate-pulse"></i>
                </div>
                <div>
                    <h2 class="text-lg font-bold text-white">Request Item dari Teknisi</h2>
                    <p class="text-xs text-amber-100">{{ $pendingRequests->count() }} request menunggu diproses</p>
                </div>
            </div>
        </div>
    </div>

    <div class="p-4">
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-amber-50 dark:bg-amber-900/20">
                    <tr>
                        <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300">Usulan</th>
                        <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300">Tipe</th>
                        <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300">Nama Item</th>
                        <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300">Jumlah</th>
                        <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300">Alasan</th>
                        <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300">Stok</th>
                        <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-200 dark:divide-gray-700">
                    @foreach($pendingRequests as $request)
                    <tr class="hover:bg-amber-50/50 dark:hover:bg-amber-900/10">
                        <td class="px-3 py-2">
                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-indigo-100 text-indigo-700">
                                Ke-{{ $request->proposal_number }}
                            </span>
                        </td>
                        <td class="px-3 py-2">
                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium {{ $request->item_type === 'material' ? 'bg-emerald-100 text-emerald-700' : 'bg-blue-100 text-blue-700' }}">
                                {{ $request->item_type_label }}
                            </span>
                            @if($request->is_new_item)
                            <span class="ml-1 inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium bg-purple-100 text-purple-700">
                                Item Baru
                            </span>
                            @endif
                        </td>
                        <td class="px-3 py-2">
                            <div class="font-medium text-slate-900 dark:text-white">{{ $request->item_name_display }}</div>
                            @if($request->item_description)
                            <div class="text-xs text-slate-500">{{ Str::limit($request->item_description, 50) }}</div>
                            @endif
                            <div class="text-[10px] text-slate-400 mt-1">
                                <i class="fas fa-user mr-1"></i>{{ $request->requester->name ?? 'N/A' }} - {{ $request->requested_at->format('d/m/Y H:i') }}
                            </div>
                        </td>
                        <td class="px-3 py-2 text-center">
                            <span class="font-semibold">{{ $request->quantity }}</span>
                            <span class="text-slate-500">{{ $request->unit }}</span>
                            @if($request->estimated_price)
                            <div class="text-[10px] text-slate-500">Est: Rp {{ number_format($request->estimated_price, 0, ',', '.') }}</div>
                            @endif
                        </td>
                        <td class="px-3 py-2 text-slate-600 dark:text-gray-400 text-xs max-w-xs">
                            {{ Str::limit($request->reason, 100) }}
                        </td>
                        <td class="px-3 py-2 text-center">
                            @if(!$request->is_new_item)
                                @php
                                    $currentStock = $request->current_stock;
                                    $hasStock = $currentStock >= $request->quantity;
                                @endphp
                                <span class="{{ $hasStock ? 'text-green-600' : 'text-red-600' }} font-medium">
                                    {{ $currentStock }}
                                </span>
                                @if(!$hasStock)
                                <div class="text-[10px] text-red-500">Kurang {{ $request->stock_shortage }}</div>
                                @endif
                            @else
                                <span class="text-slate-400 text-xs">N/A</span>
                            @endif
                        </td>
                        <td class="px-3 py-2 text-center">
                            <div class="flex items-center justify-center gap-1">
                                {{-- Approve Button --}}
                                <form action="{{ route('admin.productions.item-requests.approve', [$production, $request]) }}" method="POST" class="inline">
                                    @csrf
                                    <button type="submit" class="px-2 py-1 text-xs font-medium text-white bg-green-500 hover:bg-green-600 rounded transition-colors" title="Setujui">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </form>
                                
                                {{-- Reject Button with Modal --}}
                                <button type="button" onclick="openRejectModal({{ $request->id }})" class="px-2 py-1 text-xs font-medium text-white bg-red-500 hover:bg-red-600 rounded transition-colors" title="Tolak">
                                    <i class="fas fa-times"></i>
                                </button>
                                
                                {{-- Direct Purchase Link --}}
                                @if($request->is_new_item || $request->stock_shortage > 0)
                                <a href="{{ route('admin.transaksi.purchases.create', [
                                    'from_item_request' => $request->id,
                                    'item_type' => $request->item_type,
                                    'item_name' => $request->item_name_display,
                                    'quantity' => $request->is_new_item ? $request->quantity : $request->stock_shortage,
                                    'unit' => $request->unit,
                                    'estimated_price' => $request->estimated_price,
                                    'production_id' => $production->id
                                ]) }}" 
                                   class="px-2 py-1 text-xs font-medium text-white bg-indigo-500 hover:bg-indigo-600 rounded transition-colors" title="Langsung Beli">
                                    <i class="fas fa-shopping-cart"></i>
                                </a>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

{{-- Reject Modal --}}
<div id="rejectModal" class="fixed inset-0 z-50 hidden overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:p-0">
        <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75" onclick="closeRejectModal()"></div>
        
        <div class="relative inline-block w-full max-w-md p-6 overflow-hidden text-left align-middle transition-all transform bg-white dark:bg-gray-800 shadow-xl rounded-2xl">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-bold text-gray-900 dark:text-white">
                    <i class="fas fa-times-circle text-red-500 mr-2"></i>Tolak Request
                </h3>
                <button type="button" onclick="closeRejectModal()" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <form id="rejectForm" method="POST">
                @csrf
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Alasan Penolakan *</label>
                    <textarea name="admin_notes" required rows="3" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-red-500 dark:bg-gray-700 dark:text-white" placeholder="Berikan alasan penolakan..."></textarea>
                </div>
                
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeRejectModal()" class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200 dark:bg-gray-700 dark:text-gray-300">
                        Batal
                    </button>
                    <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-red-500 rounded-lg hover:bg-red-600">
                        <i class="fas fa-times mr-1"></i> Tolak Request
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function openRejectModal(requestId) {
    const form = document.getElementById('rejectForm');
    form.action = '{{ route("admin.productions.item-requests.reject", [$production, "__ID__"]) }}'.replace('__ID__', requestId);
    document.getElementById('rejectModal').classList.remove('hidden');
}

function closeRejectModal() {
    document.getElementById('rejectModal').classList.add('hidden');
}
</script>
@endif

{{-- History of All Item Requests (grouped by proposal) --}}
@if($itemRequestsByProposal && $itemRequestsByProposal->count() > 0)
<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border border-slate-200 dark:border-gray-700 overflow-hidden mb-6">
    <div class="px-4 py-3 bg-gradient-to-r from-slate-600 to-slate-700">
        <div class="flex items-center">
            <div class="w-10 h-10 bg-white/20 rounded-lg flex items-center justify-center mr-3">
                <i class="fas fa-history text-white text-lg"></i>
            </div>
            <div>
                <h2 class="text-lg font-bold text-white">Riwayat Request Item</h2>
                <p class="text-xs text-slate-300">Semua usulan dari teknisi</p>
            </div>
        </div>
    </div>

    <div class="p-4">
        @foreach($itemRequestsByProposal as $proposalNum => $requests)
        <div class="mb-4 last:mb-0">
            <h3 class="text-sm font-semibold text-slate-700 dark:text-gray-300 mb-2 flex items-center">
                <i class="fas fa-file-alt mr-2 text-indigo-500"></i>
                Usulan ke-{{ $proposalNum }}
                <span class="ml-2 text-xs text-slate-500">({{ $requests->count() }} item)</span>
            </h3>
            <div class="overflow-x-auto border border-slate-200 dark:border-gray-700 rounded-lg">
                <table class="w-full text-sm">
                    <thead class="bg-slate-50 dark:bg-gray-700">
                        <tr>
                            <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300">Item</th>
                            <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300">Jumlah</th>
                            <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300">Status</th>
                            <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300">Catatan Admin</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200 dark:divide-gray-700">
                        @foreach($requests as $request)
                        <tr class="hover:bg-slate-50 dark:hover:bg-gray-700/50">
                            <td class="px-3 py-2">
                                <span class="inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium {{ $request->item_type === 'material' ? 'bg-emerald-100 text-emerald-700' : 'bg-blue-100 text-blue-700' }} mr-1">
                                    {{ $request->item_type_label }}
                                </span>
                                <span class="font-medium text-slate-900 dark:text-white">{{ $request->item_name_display }}</span>
                            </td>
                            <td class="px-3 py-2 text-center">
                                {{ $request->quantity }} {{ $request->unit }}
                            </td>
                            <td class="px-3 py-2 text-center">
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium {{ $request->status_badge_class }}">
                                    {{ $request->status_label }}
                                </span>
                            </td>
                            <td class="px-3 py-2 text-slate-600 dark:text-gray-400 text-xs">
                                {{ $request->admin_notes ?? '-' }}
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endforeach
    </div>
</div>
@endif

