<script>
    // Tampilkan loader saat halaman mulai load
    document.addEventListener("DOMContentLoaded", function() {
        const loader = document.getElementById('loader');
        loader.classList.remove('hidden');

        // Simulasi load selama 1 detik
        setTimeout(() => {
            loader.classList.add('hidden');
        }, 1000);
    });

    // Contoh fungsi untuk tombol atau AJAX
    function showLoader() {
        document.getElementById('loader').classList.remove('hidden');
    }

    // Toggle Sidebar function is defined in sidebar.blade.php
    // Removed duplicate function to avoid conflicts

    // Toggle Dropdown Menu (with icon rotation support)
    function toggleDropdown(id, iconId) {
        const dropdown = document.getElementById(id);
        if (!dropdown) return;
        
        dropdown.classList.toggle('hidden');
        dropdown.classList.toggle('block');
        
        // Rotate icon if provided
        if (iconId) {
            const icon = document.getElementById(iconId);
            if (icon) {
                icon.classList.toggle('rotate-90'); // ubah panah dari > ke v
            }
        }
    }

    // Toggle Profile Menu
    function toggleProfileMenu() {
        const menu = document.getElementById('profileMenu');
        if (menu) {
            menu.classList.toggle('hidden');
        }
    }

    // Close profile menu when clicking outside
    document.addEventListener('click', function(event) {
        const profileMenu = document.getElementById('profileMenu');
        const profileButton = event.target.closest('button[onclick="toggleProfileMenu()"]');

        if (profileMenu && !profileButton && !event.target.closest('#profileMenu')) {
            profileMenu.classList.add('hidden');
        }
    });

    // Chart instances akan dibuat oleh dashboard-charts-script.blade.php
</script>
