<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LAPORAN BARANG LIMIT - {{ date('d M Y') }}</title>
    <style>
        @page {
            margin: 20mm;
            size: A4;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background-color: white;
            color: #1f2937;
            font-size: 11px;
            line-height: 1.4;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #1f2937;
            padding-bottom: 20px;
        }
        
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 5px;
            letter-spacing: 1px;
        }
        
        .company-address {
            font-size: 12px;
            color: #6b7280;
            margin-bottom: 10px;
        }
        
        .report-title {
            font-size: 18px;
            font-weight: bold;
            color: #1f2937;
            margin-top: 15px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .report-period {
            font-size: 12px;
            color: #6b7280;
            margin-top: 5px;
        }
        
        .info-section {
            margin-bottom: 25px;
            background: #fef2f2;
            padding: 15px;
            border-radius: 5px;
            border-left: 4px solid #ef4444;
        }
        
        .info-grid {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }
        
        .info-row {
            display: table-row;
        }
        
        .info-label {
            display: table-cell;
            width: 30%;
            font-weight: bold;
            color: #374151;
            padding: 5px 0;
        }
        
        .info-value {
            display: table-cell;
            color: #1f2937;
            padding: 5px 0;
        }
        
        .summary-section {
            margin-bottom: 25px;
        }
        
        .summary-title {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 15px;
            text-transform: uppercase;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 5px;
        }
        
        .summary-grid {
            display: table;
            width: 100%;
            border-collapse: collapse;
        }
        
        .summary-row {
            display: table-row;
        }
        
        .summary-cell {
            display: table-cell;
            width: 25%;
            padding: 10px;
            text-align: center;
            border: 1px solid #d1d5db;
            background: #f9fafb;
        }
        
        .summary-cell.critical {
            background: #fef2f2;
            font-weight: bold;
            color: #991b1b;
        }
        
        .summary-cell.warning {
            background: #fef3c7;
            font-weight: bold;
            color: #92400e;
        }
        
        .summary-cell.info {
            background: #dbeafe;
            font-weight: bold;
            color: #1e40af;
        }
        
        .summary-cell.success {
            background: #d1fae5;
            font-weight: bold;
            color: #166534;
        }
        
        .summary-label {
            font-size: 10px;
            color: #6b7280;
            text-transform: uppercase;
            margin-bottom: 5px;
        }
        
        .summary-value {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
        }
        
        .data-section {
            margin-bottom: 25px;
        }
        
        .data-title {
            font-size: 14px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 15px;
            text-transform: uppercase;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 5px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 10px;
        }
        
        th {
            background: #374151;
            color: white;
            font-weight: bold;
            font-size: 10px;
            text-transform: uppercase;
            padding: 8px 6px;
            text-align: left;
            border: 1px solid #1f2937;
        }
        
        td {
            padding: 6px;
            border: 1px solid #d1d5db;
            font-size: 10px;
            vertical-align: top;
        }
        
        tr:nth-child(even) {
            background: #f9fafb;
        }
        
        tr:nth-child(odd) {
            background: white;
        }
        
        .status-badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .status-critical {
            background: #fef2f2;
            color: #991b1b;
        }
        
        .status-low {
            background: #fef3c7;
            color: #92400e;
        }
        
        .status-medium {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .status-good {
            background: #dcfce7;
            color: #166534;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .font-bold {
            font-weight: bold;
        }
        
        .footer {
            margin-top: 30px;
            border-top: 2px solid #e5e7eb;
            padding-top: 15px;
            display: table;
            width: 100%;
        }
        
        .footer-left {
            display: table-cell;
            width: 50%;
            font-size: 10px;
            color: #6b7280;
        }
        
        .footer-right {
            display: table-cell;
            width: 50%;
            text-align: right;
            font-size: 10px;
            color: #6b7280;
        }
        
        .signature-section {
            margin-top: 40px;
            display: table;
            width: 100%;
        }
        
        .signature-left {
            display: table-cell;
            width: 50%;
            text-align: center;
        }
        
        .signature-right {
            display: table-cell;
            width: 50%;
            text-align: center;
        }
        
        .signature-line {
            border-bottom: 1px solid #374151;
            width: 200px;
            margin: 0 auto 5px auto;
            height: 40px;
        }
        
        .signature-label {
            font-size: 10px;
            color: #6b7280;
            margin-top: 5px;
        }
        
        .page-break {
            page-break-before: always;
        }
        
        .no-data {
            text-align: center;
            padding: 30px;
            color: #6b7280;
            font-style: italic;
        }
        
        .alert-box {
            background: #fef2f2;
            border: 1px solid #fecaca;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .alert-title {
            font-weight: bold;
            color: #991b1b;
            margin-bottom: 5px;
        }
        
        .alert-text {
            color: #7f1d1d;
            font-size: 10px;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="company-name">PT. POLJAM TECH</div>
        <div class="company-address">
            Jl. Lingkar Barat II Lr. Veteran Rt. 04 Kel. Bagan Pete, Kec. Alam Barajo, Kota Jambi
        </div>
        <div class="report-title">Laporan Barang Limit</div>
        <div class="report-period">
            Periode: {{ request('category') ? 'Kategori ' . request('category') : 'Semua Kategori' }} 
            {{ request('brand') ? ' | Brand ' . request('brand') : '' }}
        </div>
    </div>

    <!-- Alert Section -->
    <div class="alert-box">
        <div class="alert-title">⚠️ PERHATIAN - STOCK RENDAH</div>
        <div class="alert-text">
            Laporan ini menampilkan barang dengan stock rendah yang memerlukan perhatian segera. 
            Materials dengan stock ≤ 10 dan Spareparts dengan stock ≤ 5.
        </div>
    </div>

    <!-- Info Section -->
    <div class="info-section">
        <div class="info-grid">
            <div class="info-row">
                <div class="info-label">Tanggal Laporan:</div>
                <div class="info-value">{{ now()->format('d M Y H:i') }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Kategori Filter:</div>
                <div class="info-value">{{ request('category') ?: 'Semua Kategori' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Brand Filter:</div>
                <div class="info-value">{{ request('brand') ?: 'Semua Brand' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Total Barang Limit:</div>
                <div class="info-value">{{ $totalLowStock }} item</div>
            </div>
        </div>
    </div>

    <!-- Summary Section -->
    <div class="summary-section">
        <div class="summary-title">Ringkasan Stock Rendah</div>
        <div class="summary-grid">
            <div class="summary-row">
                <div class="summary-cell critical">
                    <div class="summary-label">Total Barang Limit</div>
                    <div class="summary-value">{{ number_format($totalLowStock, 0, ',', '.') }}</div>
                </div>
                <div class="summary-cell warning">
                    <div class="summary-label">Materials Limit</div>
                    <div class="summary-value">{{ number_format($totalMaterialsLow, 0, ',', '.') }}</div>
                </div>
                <div class="summary-cell info">
                    <div class="summary-label">Spareparts Limit</div>
                    <div class="summary-value">{{ number_format($totalSparepartsLow, 0, ',', '.') }}</div>
                </div>
                <div class="summary-cell success">
                    <div class="summary-label">Total Value</div>
                    <div class="summary-value">Rp {{ number_format($totalValueLowStock, 0, ',', '.') }}</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Materials Section -->
    <div class="data-section">
        <div class="data-title">Materials dengan Stock Rendah (≤ 10)</div>
        
        @if($materials->count() > 0)
        <table>
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 12%;">Kode</th>
                    <th style="width: 25%;">Nama Material</th>
                    <th style="width: 8%;">Stock</th>
                    <th style="width: 8%;">Unit</th>
                    <th style="width: 12%;">Harga</th>
                    <th style="width: 12%;">Total Value</th>
                    <th style="width: 10%;">Kategori</th>
                    <th style="width: 10%;">Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($materials as $index => $material)
                <tr>
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td class="text-center font-bold">{{ $material->material_code }}</td>
                    <td>{{ $material->name }}</td>
                    <td class="text-center">
                        <span class="status-badge {{ $material->stock <= 5 ? 'status-critical' : 'status-low' }}">
                            {{ $material->stock }}
                        </span>
                    </td>
                    <td class="text-center">{{ $material->unit }}</td>
                    <td class="text-right">Rp {{ number_format($material->price, 0, ',', '.') }}</td>
                    <td class="text-right font-bold">Rp {{ number_format($material->stock * $material->price, 0, ',', '.') }}</td>
                    <td class="text-center">{{ $material->category }}</td>
                    <td class="text-center">
                        <span class="status-badge {{ $material->stock_status == 'critical' ? 'status-critical' : 'status-low' }}">
                            {{ $material->stock_status_label }}
                        </span>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @else
        <div class="no-data">
            <p>Tidak ada materials dengan stock rendah.</p>
        </div>
        @endif
    </div>

    <div class="page-break"></div>

    <!-- Spareparts Section -->
    <div class="data-section">
        <div class="data-title">Spareparts dengan Stock Rendah (≤ 5)</div>
        
        @if($spareparts->count() > 0)
        <table>
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 12%;">Kode</th>
                    <th style="width: 25%;">Nama Sparepart</th>
                    <th style="width: 8%;">Stock</th>
                    <th style="width: 8%;">Unit</th>
                    <th style="width: 12%;">Harga</th>
                    <th style="width: 12%;">Total Value</th>
                    <th style="width: 10%;">Brand</th>
                    <th style="width: 10%;">Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($spareparts as $index => $sparepart)
                <tr>
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td class="text-center font-bold">{{ $sparepart->part_code }}</td>
                    <td>{{ $sparepart->name }}</td>
                    <td class="text-center">
                        <span class="status-badge {{ $sparepart->stock <= 3 ? 'status-critical' : 'status-low' }}">
                            {{ $sparepart->stock }}
                        </span>
                    </td>
                    <td class="text-center">{{ $sparepart->unit }}</td>
                    <td class="text-right">Rp {{ number_format($sparepart->price, 0, ',', '.') }}</td>
                    <td class="text-right font-bold">Rp {{ number_format($sparepart->stock * $sparepart->price, 0, ',', '.') }}</td>
                    <td class="text-center">{{ $sparepart->brand }}</td>
                    <td class="text-center">
                        <span class="status-badge {{ $sparepart->stock_status == 'critical' ? 'status-critical' : 'status-low' }}">
                            {{ $sparepart->stock_status_label }}
                        </span>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @else
        <div class="no-data">
            <p>Tidak ada spareparts dengan stock rendah.</p>
        </div>
        @endif
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="footer-left">
            <p><strong>PT. POLJAM TECH</strong></p>
            <p>Laporan ini dibuat secara otomatis oleh sistem</p>
        </div>
        <div class="footer-right">
            <p>Halaman 1 dari 1</p>
            <p>Dicetak pada: {{ now()->format('d M Y H:i') }}</p>
        </div>
    </div>

    <!-- Signature Section -->
    <div class="signature-section">
        <div class="signature-left">
            <div class="signature-line"></div>
            <div class="signature-label">Mengetahui,<br>Manager Inventory</div>
        </div>
        <div class="signature-right">
            <div class="signature-line"></div>
            <div class="signature-label">Jakarta, {{ now()->format('d M Y') }}<br>Direktur</div>
        </div>
    </div>
</body>
</html>