@extends('layouts.admin')

@section('title', 'Management User')

@section('content')

    <!-- Notifikasi Modern -->
    <x-admin-notification />

    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800 dark:text-white mb-4">Management User</h1>

        <!-- Statistics Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
            <!-- Total Users -->
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total User</p>
                        <h2 class="text-xl font-bold text-gray-800 dark:text-white">{{ $stats['total'] }}</h2>
                    </div>
                    <div class="p-2.5 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                        <i class="fas fa-users text-blue-600 dark:text-blue-400 text-lg"></i>
                    </div>
                </div>
            </div>

            <!-- Active Users -->
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">User Aktif</p>
                        <h2 class="text-xl font-bold text-green-600 dark:text-green-400">{{ $stats['active'] }}</h2>
                    </div>
                    <div class="p-2.5 bg-green-100 dark:bg-green-900/40 rounded-lg">
                        <i class="fas fa-user-check text-green-600 dark:text-green-400 text-lg"></i>
                    </div>
                </div>
            </div>

            <!-- Inactive Users -->
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">User Nonaktif</p>
                        <h2 class="text-xl font-bold text-red-600 dark:text-red-400">{{ $stats['inactive'] }}</h2>
                    </div>
                    <div class="p-2.5 bg-red-100 dark:bg-red-900/40 rounded-lg">
                        <i class="fas fa-user-slash text-red-600 dark:text-red-400 text-lg"></i>
                    </div>
                </div>
            </div>

            <!-- New This Month -->
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Baru Bulan Ini</p>
                        <h2 class="text-xl font-bold text-purple-600 dark:text-purple-400">{{ $stats['new_this_month'] }}</h2>
                    </div>
                    <div class="p-2.5 bg-purple-100 dark:bg-purple-900/40 rounded-lg">
                        <i class="fas fa-user-plus text-purple-600 dark:text-purple-400 text-lg"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filter Section -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <form method="GET" action="{{ route('admin.users.index') }}" id="filterForm" class="flex flex-col sm:flex-row items-end gap-3">
                <!-- Search Bar -->
                <div class="relative flex-1 w-full sm:w-auto">
                    <input type="text" name="search" id="searchInput" value="{{ request('search') }}" placeholder="Cari nama, email, atau telepon..."
                        class="form-input-search" />
                    <i class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                    @if (request('search'))
                        <button type="button" onclick="clearSearch()"
                            class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 hover:text-gray-600 dark:hover:text-gray-300">
                            <i class="fas fa-times"></i>
                        </button>
                    @endif
                </div>

                <!-- Filter Role -->
                <div class="relative w-full sm:w-auto">
                    <select name="role" id="roleSelect" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Role</option>
                        <option value="user" {{ request('role') === 'user' ? 'selected' : '' }}>User</option>
                        <option value="teknisi" {{ request('role') === 'teknisi' ? 'selected' : '' }}>Teknisi</option>
                        <option value="supervisor" {{ request('role') === 'supervisor' ? 'selected' : '' }}>Supervisor</option>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <!-- Filter Status -->
                <div class="relative w-full sm:w-auto">
                    <select name="status" id="statusSelect" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Status</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Aktif</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Nonaktif</option>
                        <option value="never_logged_in" {{ request('status') === 'never_logged_in' ? 'selected' : '' }}>Belum Login</option>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-center gap-2 w-full sm:w-auto">
                    <a href="{{ route('admin.users.create') }}" class="action-btn-primary">
                        <i class="fas fa-plus mr-2"></i>
                        <span>Tambah User</span>
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Active Filters Info -->
    @if (request('search') || request('role') || request('status'))
        <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4">
            <div class="flex flex-wrap items-center gap-2">
                <span class="text-sm font-medium text-blue-800 dark:text-blue-200">Filter Aktif:</span>
                
                @if (request('search'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-200">
                        <i class="fas fa-search mr-1"></i>
                        Pencarian: "{{ request('search') }}"
                        <button onclick="clearFilter('search')" class="ml-2 hover:text-blue-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                @if (request('role'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-200">
                        <i class="fas fa-user-tag mr-1"></i>
                        Role: {{ ucfirst(request('role')) }}
                        <button onclick="clearFilter('role')" class="ml-2 hover:text-green-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif

                @if (request('status'))
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800 dark:bg-yellow-800 dark:text-yellow-200">
                        <i class="fas fa-filter mr-1"></i>
                        Status: {{ request('status') === 'active' ? 'Aktif' : (request('status') === 'inactive' ? 'Nonaktif' : 'Belum Login') }}
                        <button onclick="clearFilter('status')" class="ml-2 hover:text-yellow-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                @endif
                
                <button onclick="clearAllFilters()" 
                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200 hover:bg-red-200 dark:hover:bg-red-700 transition-colors">
                    <i class="fas fa-times-circle mr-1"></i>
                    Hapus Semua Filter
                </button>
            </div>
        </div>
    @endif

    <!-- Bulk Actions -->
    <div id="bulkActionsContainer" class="mb-4 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-700 rounded-lg p-4 hidden">
        <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3">
            <div class="flex items-center gap-2">
                <span class="text-sm font-medium text-yellow-800 dark:text-yellow-200">
                    <span id="selectedCount">0</span> user dipilih
                </span>
            </div>
            <div class="flex items-center gap-2 flex-wrap">
                <form id="bulkActionForm" method="POST" action="{{ route('admin.users.bulk-action') }}" class="inline">
                    @csrf
                    <input type="hidden" name="user_ids" id="bulkUserIds">
                    <select name="action" id="bulkActionSelect" class="form-select text-sm" onchange="confirmBulkAction()">
                        <option value="">Pilih Aksi...</option>
                        <option value="activate">Aktifkan</option>
                        <option value="deactivate">Nonaktifkan</option>
                        <option value="delete">Hapus</option>
                    </select>
                </form>
                <button onclick="clearSelection()" class="px-3 py-1.5 text-sm text-gray-600 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                    Batal
                </button>
            </div>
        </div>
    </div>

    <!-- Table Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-600">
                    <tr>
                        <th class="w-12 px-4 py-3.5 text-center">
                            <input type="checkbox" id="selectAll" onchange="toggleSelectAll(this)"
                                class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                        </th>
                        <th class="w-16 px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">No</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Foto</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            <a href="{{ route('admin.users.index', array_merge(request()->all(), ['sort_by' => 'name', 'sort_order' => request('sort_by') === 'name' && request('sort_order') === 'asc' ? 'desc' : 'asc'])) }}" class="hover:text-blue-600 dark:hover:text-blue-400">
                                Nama
                                @if(request('sort_by') === 'name')
                                    <i class="fas fa-sort-{{ request('sort_order') === 'asc' ? 'up' : 'down' }} ml-1"></i>
                                @else
                                    <i class="fas fa-sort ml-1 text-gray-400"></i>
                                @endif
                            </a>
                        </th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Email</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Telepon</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Role</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Status</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            <a href="{{ route('admin.users.index', array_merge(request()->all(), ['sort_by' => 'last_login_at', 'sort_order' => request('sort_by') === 'last_login_at' && request('sort_order') === 'asc' ? 'desc' : 'asc'])) }}" class="hover:text-blue-600 dark:hover:text-blue-400">
                                Last Login
                                @if(request('sort_by') === 'last_login_at')
                                    <i class="fas fa-sort-{{ request('sort_order') === 'asc' ? 'up' : 'down' }} ml-1"></i>
                                @else
                                    <i class="fas fa-sort ml-1 text-gray-400"></i>
                                @endif
                            </a>
                        </th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse ($users as $user)
                        <tr class="hover:bg-blue-50/50 dark:hover:bg-gray-700/80 transition-colors duration-200 {{ !$user->is_active ? 'opacity-60' : '' }}">
                            <td class="px-4 py-4 text-center align-middle">
                                <input type="checkbox" name="user_ids[]" value="{{ $user->id }}" 
                                    onchange="updateBulkActions()"
                                    class="user-checkbox w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                            </td>
                            <td class="px-4 py-4 text-sm text-gray-900 dark:text-gray-100 text-center align-middle">
                                {{ $loop->iteration + $users->firstItem() - 1 }}
                            </td>
                            <td class="px-6 py-4 text-center align-middle">
                                @php
                                    $hasPhoto = false;
                                    $photoUrl = '';
                                    if ($user->photo) {
                                        // Handle jika photo sudah berisi path 'profiles/' atau hanya filename
                                        $photoPath = (strpos($user->photo, 'profiles/') === 0) 
                                            ? $user->photo 
                                            : 'profiles/' . $user->photo;
                                        
                                        // Cek apakah file exists
                                        if (\Storage::disk('uploads')->exists($photoPath)) {
                                            $hasPhoto = true;
                                            // Untuk URL, gunakan path yang benar
                                            $photoFileName = (strpos($user->photo, 'profiles/') === 0) 
                                                ? $user->photo 
                                                : 'profiles/' . $user->photo;
                                            $photoUrl = asset('uploads/' . $photoFileName);
                                        }
                                    }
                                @endphp
                                @if ($hasPhoto)
                                    <div class="flex justify-center">
                                        <img src="{{ $photoUrl }}" alt="Foto Profil"
                                            class="h-12 w-12 rounded-full object-cover"
                                            onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                        <div class="h-12 w-12 bg-gray-100 dark:bg-gray-600 rounded-full flex items-center justify-center" style="display: none;">
                                            <i class="fas fa-user text-gray-400 dark:text-gray-500"></i>
                                        </div>
                                    </div>
                                @else
                                    <div class="flex justify-center">
                                        <div class="h-12 w-12 bg-gray-100 dark:bg-gray-600 rounded-full flex items-center justify-center">
                                            <i class="fas fa-user text-gray-400 dark:text-gray-500"></i>
                                        </div>
                                    </div>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100 font-medium align-middle">
                                <a href="{{ route('admin.users.show', $user->id) }}" 
                                   class="text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 hover:underline">
                                    {{ $user->name }}
                                </a>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100 align-middle">
                                {{ $user->email }}
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100 align-middle">
                                {{ $user->phone ?? '-' }}
                            </td>
                            <td class="px-6 py-4 align-middle">
                                @if($user->user_type === 'teknisi')
                                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-blue-100 dark:bg-blue-900/40 text-blue-800 dark:text-blue-200">
                                        <i class="fas fa-tools mr-1"></i> Teknisi
                                    </span>
                                @elseif($user->user_type === 'supervisor')
                                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-purple-100 dark:bg-purple-900/40 text-purple-800 dark:text-purple-200">
                                        <i class="fas fa-user-shield mr-1"></i> Supervisor
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-200">
                                        <i class="fas fa-user mr-1"></i> User
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4 align-middle">
                                @if($user->is_active)
                                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-200">
                                        <i class="fas fa-check-circle mr-1"></i> Aktif
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-red-100 dark:bg-red-900/40 text-red-800 dark:text-red-200">
                                        <i class="fas fa-times-circle mr-1"></i> Nonaktif
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100 align-middle">
                                @if($user->last_login_at)
                                    <div class="flex flex-col">
                                        <span>{{ $user->last_login_at->format('d/m/Y') }}</span>
                                        <span class="text-xs text-gray-500 dark:text-gray-400">{{ $user->last_login_at->format('H:i') }}</span>
                                    </div>
                                @else
                                    <span class="text-gray-400 dark:text-gray-500 italic">Belum pernah</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-center align-middle">
                                <div class="flex justify-center items-center space-x-1">
                                    <a href="{{ route('admin.users.show', $user->id) }}"
                                        class="inline-flex items-center justify-center w-9 h-9 text-indigo-600 dark:text-indigo-400 hover:text-indigo-700 dark:hover:text-indigo-300 hover:bg-indigo-50 dark:hover:bg-indigo-900/20 rounded transition-colors duration-200"
                                        title="Detail">
                                        <i class="fas fa-eye text-base"></i>
                                    </a>
                                    <a href="{{ route('admin.users.edit', $user->id) }}"
                                        class="inline-flex items-center justify-center w-9 h-9 text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded transition-colors duration-200"
                                        title="Edit">
                                        <i class="fas fa-edit text-base"></i>
                                    </a>
                                    <form action="{{ route('admin.users.toggle-status', $user->id) }}" method="POST" class="inline">
                                        @csrf
                                        <button type="submit"
                                            class="inline-flex items-center justify-center w-9 h-9 {{ $user->is_active ? 'text-orange-600 dark:text-orange-400 hover:text-orange-700 dark:hover:text-orange-300 hover:bg-orange-50 dark:hover:bg-orange-900/20' : 'text-green-600 dark:text-green-400 hover:text-green-700 dark:hover:text-green-300 hover:bg-green-50 dark:hover:bg-green-900/20' }} rounded transition-colors duration-200"
                                            title="{{ $user->is_active ? 'Nonaktifkan' : 'Aktifkan' }}"
                                            onclick="return confirm('Yakin ingin {{ $user->is_active ? 'menonaktifkan' : 'mengaktifkan' }} user ini?');">
                                            <i class="fas fa-{{ $user->is_active ? 'ban' : 'check' }} text-base"></i>
                                        </button>
                                    </form>
                                    <form action="{{ route('admin.users.reset-password', $user->id) }}" method="POST" class="inline"
                                        onsubmit="return confirm('Yakin ingin mereset password user ini? Password baru akan ditampilkan setelah reset.');">
                                        @csrf
                                        <button type="submit"
                                            class="inline-flex items-center justify-center w-9 h-9 text-yellow-600 dark:text-yellow-400 hover:text-yellow-700 dark:hover:text-yellow-300 hover:bg-yellow-50 dark:hover:bg-yellow-900/20 rounded transition-colors duration-200"
                                            title="Reset Password">
                                            <i class="fas fa-key text-base"></i>
                                        </button>
                                    </form>
                                    <button onclick="confirmDelete({{ $user->id }})"
                                        class="inline-flex items-center justify-center w-9 h-9 text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 hover:bg-red-50 dark:hover:bg-red-900/20 rounded transition-colors duration-200"
                                        title="Hapus">
                                        <i class="fas fa-trash text-base"></i>
                                    </button>
                                </div>
                                <form id="delete-form-{{ $user->id }}"
                                    action="{{ route('admin.users.destroy', $user->id) }}" method="POST" class="hidden">
                                    @csrf
                                    @method('DELETE')
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="10" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-4">
                                        <i class="fas fa-users text-2xl text-gray-400 dark:text-gray-500"></i>
                                    </div>
                                    <p class="text-gray-500 dark:text-gray-400 text-lg font-medium">Belum ada data user</p>
                                    <p class="text-gray-400 dark:text-gray-500 text-sm mt-1">Mulai dengan menambahkan user pertama</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    @if ($users->hasPages())
        <div class="mt-6 flex justify-center">
            {{ $users->onEachSide(1)->links() }}
        </div>
    @endif

    <style>
        /* Konsisten Style untuk semua Index Pages */
        .form-input-search,
        .form-select {
            height: 40px !important;
            min-height: 40px !important;
            max-height: 40px !important;
            box-sizing: border-box !important;
            line-height: 1.5 !important;
            padding: 0 2.5rem 0 2.5rem !important;
            margin: 0 !important;
        }
        
        .form-input-search {
            width: 100%;
            padding-left: 2.5rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            transition: all 0.2s;
        }
        
        .dark .form-input-search {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-input-search:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
        
        .form-select {
            width: 100%;
            padding-left: 1rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            transition: all 0.2s;
        }
        
        .dark .form-select {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-select:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
        
        .action-btn-primary {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            height: 40px;
            padding: 0 1rem;
            background-color: rgb(59 130 246);
            color: white;
            font-size: 0.875rem;
            font-weight: 500;
            border-radius: 0.5rem;
            transition: all 0.2s;
            white-space: nowrap;
        }
        
        .action-btn-primary:hover {
            background-color: rgb(37 99 235);
        }
        
        .action-btn-primary:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
    </style>

    <script>
        function submitFilter() {
            document.getElementById('filterForm').submit();
        }

        function clearSearch() {
            document.getElementById('searchInput').value = '';
            submitFilter();
        }

        function clearFilter(filterName) {
            const form = document.getElementById('filterForm');
            if (filterName === 'search') {
                document.getElementById('searchInput').value = '';
            } else if (filterName === 'role') {
                document.getElementById('roleSelect').value = '';
            } else if (filterName === 'status') {
                document.getElementById('statusSelect').value = '';
            }
            form.submit();
        }

        function clearAllFilters() {
            document.getElementById('searchInput').value = '';
            document.getElementById('roleSelect').value = '';
            document.getElementById('statusSelect').value = '';
            document.getElementById('filterForm').submit();
        }

        function confirmDelete(id) {
            if (confirm('Yakin ingin menghapus user ini?')) {
                document.getElementById('delete-form-' + id).submit();
            }
        }

        // Bulk Actions
        function toggleSelectAll(checkbox) {
            const checkboxes = document.querySelectorAll('.user-checkbox');
            checkboxes.forEach(cb => cb.checked = checkbox.checked);
            updateBulkActions();
        }

        function updateBulkActions() {
            const checkboxes = document.querySelectorAll('.user-checkbox:checked');
            const count = checkboxes.length;
            const container = document.getElementById('bulkActionsContainer');
            const countSpan = document.getElementById('selectedCount');
            
            if (count > 0) {
                container.classList.remove('hidden');
                countSpan.textContent = count;
                
                // Update select all checkbox
                const selectAll = document.getElementById('selectAll');
                const allCheckboxes = document.querySelectorAll('.user-checkbox');
                selectAll.checked = count === allCheckboxes.length;
            } else {
                container.classList.add('hidden');
            }
        }

        function clearSelection() {
            const checkboxes = document.querySelectorAll('.user-checkbox');
            checkboxes.forEach(cb => cb.checked = false);
            document.getElementById('selectAll').checked = false;
            document.getElementById('bulkActionSelect').value = '';
            updateBulkActions();
        }

        function confirmBulkAction() {
            const action = document.getElementById('bulkActionSelect').value;
            if (!action) return;
            
            const checkboxes = document.querySelectorAll('.user-checkbox:checked');
            const userIds = Array.from(checkboxes).map(cb => cb.value);
            
            if (userIds.length === 0) {
                alert('Pilih minimal 1 user!');
                document.getElementById('bulkActionSelect').value = '';
                return;
            }
            
            let message = '';
            switch(action) {
                case 'activate':
                    message = `Yakin ingin mengaktifkan ${userIds.length} user?`;
                    break;
                case 'deactivate':
                    message = `Yakin ingin menonaktifkan ${userIds.length} user?`;
                    break;
                case 'delete':
                    message = `Yakin ingin menghapus ${userIds.length} user? Tindakan ini tidak dapat dibatalkan!`;
                    break;
            }
            
            if (confirm(message)) {
                document.getElementById('bulkUserIds').value = JSON.stringify(userIds);
                document.getElementById('bulkActionForm').submit();
            } else {
                document.getElementById('bulkActionSelect').value = '';
            }
        }
    </script>
@endsection
