@props(['type' => 'success', 'message' => null, 'autoClose' => true, 'duration' => 4000])

@php
    $message = $message ?? (session('success') ?? session('error') ?? session('add_message') ?? session('update_message') ?? session('delete_message'));
    $type = session('success') || session('add_message') || session('update_message') ? 'success' : (session('error') || session('delete_message') ? 'error' : $type);
    
    $config = [
        'success' => [
            'bg' => 'bg-gradient-to-r from-green-500 to-emerald-600',
            'icon' => 'fas fa-check-circle',
            'iconBg' => 'bg-white/20',
        ],
        'error' => [
            'bg' => 'bg-gradient-to-r from-red-500 to-rose-600',
            'icon' => 'fas fa-exclamation-circle',
            'iconBg' => 'bg-white/20',
        ],
        'warning' => [
            'bg' => 'bg-gradient-to-r from-yellow-500 to-amber-600',
            'icon' => 'fas fa-exclamation-triangle',
            'iconBg' => 'bg-white/20',
        ],
        'info' => [
            'bg' => 'bg-gradient-to-r from-blue-500 to-cyan-600',
            'icon' => 'fas fa-info-circle',
            'iconBg' => 'bg-white/20',
        ],
    ];
    
    $style = $config[$type] ?? $config['success'];
@endphp

@if($message)
<div x-data="{ show: true }" 
     x-show="show" 
     x-transition:enter="transition transform ease-out duration-500"
     x-transition:enter-start="-translate-y-10 opacity-0 scale-95" 
     x-transition:enter-end="translate-y-0 opacity-100 scale-100"
     x-transition:leave="transition transform ease-in duration-300"
     x-transition:leave-start="translate-y-0 opacity-100 scale-100" 
     x-transition:leave-end="-translate-y-10 opacity-0 scale-95"
     @if($autoClose) x-init="setTimeout(() => show = false, {{ $duration }})" @endif
     class="fixed top-6 left-1/2 transform -translate-x-1/2 z-[9999] w-[90%] sm:w-[500px] {{ $style['bg'] }} text-white shadow-2xl rounded-xl px-6 py-4 flex items-center justify-between space-x-3 backdrop-blur-sm"
     style="animation: slideDown 0.5s ease-out;">
    <div class="flex items-center space-x-3 flex-1 min-w-0">
        <div class="flex items-center justify-center w-10 h-10 {{ $style['iconBg'] }} rounded-full flex-shrink-0">
            <i class="{{ $style['icon'] }} text-lg text-white"></i>
        </div>
        <div class="flex-1 font-semibold text-sm sm:text-base leading-relaxed break-words">
            {!! $message !!}
        </div>
    </div>
    <button @click="show = false" 
            class="flex-shrink-0 hover:bg-white/20 rounded-full p-1.5 transition-all duration-200 hover:scale-110 active:scale-95 ml-2">
        <i class="fas fa-times text-white text-sm"></i>
    </button>
</div>

<style>
    @keyframes slideDown {
        from {
            transform: translate(-50%, -100%);
            opacity: 0;
        }
        to {
            transform: translate(-50%, 0);
            opacity: 1;
        }
    }
</style>
@endif

