@props(['items'])

<nav class="mb-6" aria-label="Breadcrumb">
    <ol class="flex flex-wrap items-center space-x-2 text-sm">
        @foreach($items as $index => $item)
            @if($loop->last)
                <li class="flex items-center">
                    <span class="text-blue-600 dark:text-blue-400 font-semibold">{{ $item['label'] }}</span>
                </li>
            @else
                <li class="flex items-center">
                    <a href="{{ $item['url'] }}" class="text-gray-500 dark:text-gray-400 hover:text-blue-600 dark:hover:text-blue-400 transition-colors duration-200 flex items-center">
                        {{ $item['label'] }}
                    </a>
                    <span class="mx-2 text-gray-400 dark:text-gray-500">
                        <i class="fas fa-chevron-right text-xs"></i>
                    </span>
                </li>
            @endif
        @endforeach
    </ol>
</nav>

