@props(['compact' => false])

@if(!$compact)
<div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700 mb-6 shadow-sm">
    <div class="flex items-center justify-between mb-3">
        <h4 class="text-sm font-semibold text-gray-700 dark:text-gray-300 flex items-center">
            <i class="fas fa-info-circle mr-2 text-blue-500"></i>
            Keterangan Status
        </h4>
        <span class="text-xs text-gray-500 dark:text-gray-400">*Hover pada badge untuk detail</span>
    </div>
    <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-3">
        <div class="flex items-center justify-between p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-200 mr-2 border border-green-200 dark:border-green-700">
                Selesai
            </span>
            <span class="text-xs text-gray-600 dark:text-gray-400">Aktif</span>
        </div>
        
        <div class="flex items-center justify-between p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-yellow-100 dark:bg-yellow-900 text-yellow-800 dark:text-yellow-200 mr-2 border border-yellow-200 dark:border-yellow-700">
                Menunggu
            </span>
            <span class="text-xs text-gray-600 dark:text-gray-400">Diproses</span>
        </div>
        
        <div class="flex items-center justify-between p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-200 mr-2 border border-blue-200 dark:border-blue-700">
                Dalam Proses
            </span>
            <span class="text-xs text-gray-600 dark:text-gray-400">On Going</span>
        </div>
        
        <div class="flex items-center justify-between p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-red-100 dark:bg-red-900 text-red-800 dark:text-red-200 mr-2 border border-red-200 dark:border-red-700">
                Gagal
            </span>
            <span class="text-xs text-gray-600 dark:text-gray-400">Error</span>
        </div>
        
        <div class="flex items-center justify-between p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-200 mr-2 border border-gray-200 dark:border-gray-600">
                Draft
            </span>
            <span class="text-xs text-gray-600 dark:text-gray-400">Sementara</span>
        </div>
        
        <div class="flex items-center justify-between p-2 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-purple-100 dark:bg-purple-900 text-purple-800 dark:text-purple-200 mr-2 border border-purple-200 dark:border-purple-700">
                Lunas
            </span>
            <span class="text-xs text-gray-600 dark:text-gray-400">Paid</span>
        </div>
    </div>
</div>
@else
<div class="mb-4">
    <button onclick="toggleLegend()" class="text-sm text-gray-600 dark:text-gray-400 hover:text-blue-600 dark:hover:text-blue-400 flex items-center">
        <i class="fas fa-info-circle mr-1"></i>
        <span>Lihat Keterangan Status</span>
    </button>
    <div id="legendContent" class="hidden mt-2 p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
        <div class="flex flex-wrap gap-2 text-xs">
            <span class="px-2 py-1 bg-green-100 text-green-800 rounded">Hijau=Selesai</span>
            <span class="px-2 py-1 bg-yellow-100 text-yellow-800 rounded">Kuning=Menunggu</span>
            <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded">Biru=Proses</span>
            <span class="px-2 py-1 bg-red-100 text-red-800 rounded">Merah=Gagal</span>
            <span class="px-2 py-1 bg-gray-100 text-gray-800 rounded">Abu=Draft</span>
        </div>
    </div>
</div>

<script>
function toggleLegend() {
    const content = document.getElementById('legendContent');
    content.classList.toggle('hidden');
}
</script>
@endif

