<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notifikasi Produksi Selesai - POLJAM TECH</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f8f9fa;
        }
        .container {
            background-color: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #e9ecef;
        }
        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #2563eb;
            margin-bottom: 10px;
        }
        .notification-item {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            border-left: 4px solid #2563eb;
            margin: 20px 0;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            border-bottom: 1px solid #eee;
            padding-bottom: 10px;
        }
        .info-label {
            font-weight: bold;
            color: #555;
        }
        .action-button {
            display: inline-block;
            background-color: #2563eb;
            color: white;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 6px;
            font-weight: bold;
            margin-top: 20px;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e9ecef;
            text-align: center;
            color: #6b7280;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="logo">POLJAM TECH</div>
            <h2>Notifikasi Produksi Selesai</h2>
        </div>

        <p>Yth. Supervisor,</p>
        
        <p>Teknisi telah menyelesaikan produksi dan mengirimkan permintaan approval. Mohon segera ditinjau.</p>

        <div class="notification-item">
            <h3>Detail Produksi #{{ $production->id }}</h3>
            
            <div class="info-row">
                <span class="info-label">Produk:</span>
                <span>{{ $production->product->product_title ?? 'N/A' }}</span>
            </div>
            
            <div class="info-row">
                <span class="info-label">Order ID:</span>
                <span>#{{ $production->order->id ?? 'N/A' }}</span>
            </div>
            
            <div class="info-row">
                <span class="info-label">Jumlah:</span>
                <span>{{ $production->quantity }}</span>
            </div>
            
            <div class="info-row">
                <span class="info-label">Teknisi:</span>
                <span>{{ $production->teknisi->name ?? 'N/A' }}</span>
            </div>
            
            <div class="info-row">
                <span class="info-label">Tanggal Selesai:</span>
                <span>{{ $production->completed_at->format('d M Y H:i') }}</span>
            </div>
            
            @if($production->notes)
            <div class="info-row" style="flex-direction: column;">
                <span class="info-label">Catatan Teknisi:</span>
                <p style="margin-top: 5px;">{{ $production->notes }}</p>
            </div>
            @endif
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <a href="{{ url('/supervisor/productions') }}" class="action-button">
                Review Produksi Sekarang
            </a>
        </div>

        <div class="footer">
            <p>Email ini dikirim otomatis oleh sistem POLJAM TECH.</p>
            <p>&copy; {{ date('Y') }} POLJAM TECH. All rights reserved.</p>
        </div>
    </div>
</body>
</html>