@extends('layouts.main')

@section('hero')
    @include('partials.hero', ['heroes' => $heroes ?? collect()])
@endsection

@section('content')
    <!-- Section Stats/Counter -->
    <section class="py-12 sm:py-16 bg-white">
        <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
            <!-- Header -->
            <div class="text-center mb-8 sm:mb-12">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 leading-tight">Pencapaian Kami</h2>
                <p class="text-sm sm:text-base text-gray-600 max-w-2xl mx-auto leading-relaxed">
                    Komitmen kami dalam memberikan solusi terbaik untuk bisnis Anda
                </p>
            </div>
            <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 sm:gap-6 md:gap-8">
                <!-- Stat 1 - Mesin Diproduksi -->
                <div class="group text-center bg-gradient-to-br from-white to-blue-50/30 rounded-xl border-2 border-gray-200 shadow-md hover:shadow-xl hover:border-blue-300 hover:bg-gradient-to-br hover:from-blue-50 hover:to-blue-100/50 p-6 sm:p-8 transition-all duration-300">
                    <div class="relative mb-4">
                        <div class="w-16 h-16 sm:w-20 sm:h-20 bg-gradient-to-br from-blue-500 to-blue-600 rounded-2xl flex items-center justify-center mx-auto shadow-lg transition-all duration-300">
                            <svg class="w-8 h-8 sm:w-10 sm:h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                        </div>
                        <div class="absolute -top-1 -right-1 w-6 h-6 bg-blue-500 rounded-full opacity-0 group-hover:opacity-100 transition-opacity duration-300 animate-pulse"></div>
                    </div>
                    <div class="text-4xl sm:text-5xl md:text-6xl font-extrabold bg-gradient-to-br from-blue-600 to-blue-700 bg-clip-text text-transparent mb-2" data-count="{{ $totalProducts ?? 0 }}">0<span class="text-2xl sm:text-3xl md:text-4xl">+</span></div>
                    <div class="text-sm sm:text-base md:text-lg text-gray-700 font-bold">Mesin Diproduksi</div>
                    <p class="text-xs text-gray-500 mt-1 opacity-0 group-hover:opacity-100 transition-opacity duration-300">Kualitas terjamin</p>
                </div>
                
                <!-- Stat 2 - Tahun Pengalaman -->
                <div class="group text-center bg-gradient-to-br from-white to-blue-50/30 rounded-xl border-2 border-gray-200 shadow-md hover:shadow-xl hover:border-blue-300 hover:bg-gradient-to-br hover:from-blue-50 hover:to-blue-100/50 p-6 sm:p-8 transition-all duration-300">
                    <div class="relative mb-4">
                        <div class="w-16 h-16 sm:w-20 sm:h-20 bg-gradient-to-br from-blue-500 to-blue-600 rounded-2xl flex items-center justify-center mx-auto shadow-lg transition-all duration-300">
                            <svg class="w-8 h-8 sm:w-10 sm:h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                        <div class="absolute -top-1 -right-1 w-6 h-6 bg-blue-500 rounded-full opacity-0 group-hover:opacity-100 transition-opacity duration-300 animate-pulse"></div>
                    </div>
                    <div class="text-4xl sm:text-5xl md:text-6xl font-extrabold bg-gradient-to-br from-blue-600 to-blue-700 bg-clip-text text-transparent mb-2" data-count="{{ $yearsOfExperience ?? 8 }}">0</div>
                    <div class="text-sm sm:text-base md:text-lg text-gray-700 font-bold">Tahun Pengalaman</div>
                    <p class="text-xs text-gray-500 mt-1 opacity-0 group-hover:opacity-100 transition-opacity duration-300">Terpercaya & berpengalaman</p>
                </div>
                
                <!-- Stat 3 - Kerja Sama -->
                <div class="group text-center bg-gradient-to-br from-white to-blue-50/30 rounded-xl border-2 border-gray-200 shadow-md hover:shadow-xl hover:border-blue-300 hover:bg-gradient-to-br hover:from-blue-50 hover:to-blue-100/50 p-6 sm:p-8 transition-all duration-300">
                    <div class="relative mb-4">
                        <div class="w-16 h-16 sm:w-20 sm:h-20 bg-gradient-to-br from-blue-500 to-blue-600 rounded-2xl flex items-center justify-center mx-auto shadow-lg transition-all duration-300">
                            <svg class="w-8 h-8 sm:w-10 sm:h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                        </div>
                        <div class="absolute -top-1 -right-1 w-6 h-6 bg-blue-500 rounded-full opacity-0 group-hover:opacity-100 transition-opacity duration-300 animate-pulse"></div>
                    </div>
                    <div class="text-4xl sm:text-5xl md:text-6xl font-extrabold bg-gradient-to-br from-blue-600 to-blue-700 bg-clip-text text-transparent mb-2" data-count="{{ $totalCooperations ?? 0 }}">0<span class="text-2xl sm:text-3xl md:text-4xl">+</span></div>
                    <div class="text-sm sm:text-base md:text-lg text-gray-700 font-bold">Kerja Sama</div>
                    <p class="text-xs text-gray-500 mt-1 opacity-0 group-hover:opacity-100 transition-opacity duration-300">Dengan PT, Perusahaan & UMKM</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Section Kategori dengan Horizontal Carousel (Alibaba Style) -->
    <section class="py-12 sm:py-16 bg-gray-100">
        <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
            <!-- Title di Tengah -->
            <div class="text-center mb-6 sm:mb-8">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 leading-tight">Kategori Produk</h2>
                <p class="text-sm sm:text-base text-gray-600 max-w-2xl mx-auto leading-relaxed">
                    Pilih kategori sesuai kebutuhan bisnis Anda
                </p>
            </div>

            <!-- Category Carousel Card -->
            @if ($allCategories->count() > 0)
                <div class="bg-white rounded-xl shadow-md border border-gray-200 p-4 sm:p-5 md:p-6 relative overflow-hidden">
                    <!-- Navigation Arrows - Inside Card, Thin Square Style -->
                    <button onclick="scrollCategoryCarousel('left')" 
                        class="category-scroll-btn category-scroll-left absolute left-0 z-30 w-6 h-16 sm:w-8 sm:h-20 bg-black/70 hover:bg-blue-600 transition-colors duration-200 rounded-none flex items-center justify-center text-white opacity-50 hover:opacity-100 border-0 cursor-pointer"
                        style="top: 50%; transform: translateY(-50%); display: flex !important;"
                        onmouseenter="this.style.setProperty('background-color', '#2563eb', 'important'); this.style.setProperty('background', '#2563eb', 'important'); this.style.setProperty('opacity', '1', 'important'); this.style.setProperty('filter', 'none', 'important');"
                        onmouseleave="this.style.removeProperty('background-color'); this.style.removeProperty('background'); this.style.removeProperty('opacity'); this.style.removeProperty('filter');"
                        ontouchstart="this.style.setProperty('background-color', '#2563eb', 'important'); this.style.setProperty('background', '#2563eb', 'important'); this.style.setProperty('opacity', '1', 'important'); this.style.setProperty('filter', 'none', 'important');"
                        ontouchend="requestAnimationFrame(() => { this.style.removeProperty('background-color'); this.style.removeProperty('background'); this.style.removeProperty('opacity'); this.style.removeProperty('filter'); this.blur(); });"
                        ontouchcancel="requestAnimationFrame(() => { this.style.removeProperty('background-color'); this.style.removeProperty('background'); this.style.removeProperty('opacity'); this.style.removeProperty('filter'); this.blur(); });">
                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-white" fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24">
                            <polyline points="15 18 9 12 15 6"></polyline>
                        </svg>
                    </button>
                    <button onclick="scrollCategoryCarousel('right')" 
                        class="category-scroll-btn category-scroll-right absolute right-0 z-30 w-6 h-16 sm:w-8 sm:h-20 bg-black/70 hover:bg-blue-600 transition-colors duration-200 rounded-none flex items-center justify-center text-white opacity-50 hover:opacity-100 border-0 cursor-pointer"
                        style="top: 50%; transform: translateY(-50%); display: flex !important;"
                        onmouseenter="this.style.setProperty('background-color', '#2563eb', 'important'); this.style.setProperty('background', '#2563eb', 'important'); this.style.setProperty('opacity', '1', 'important'); this.style.setProperty('filter', 'none', 'important');"
                        onmouseleave="this.style.removeProperty('background-color'); this.style.removeProperty('background'); this.style.removeProperty('opacity'); this.style.removeProperty('filter');"
                        ontouchstart="this.style.setProperty('background-color', '#2563eb', 'important'); this.style.setProperty('background', '#2563eb', 'important'); this.style.setProperty('opacity', '1', 'important'); this.style.setProperty('filter', 'none', 'important');"
                        ontouchend="requestAnimationFrame(() => { this.style.removeProperty('background-color'); this.style.removeProperty('background'); this.style.removeProperty('opacity'); this.style.removeProperty('filter'); this.blur(); });"
                        ontouchcancel="requestAnimationFrame(() => { this.style.removeProperty('background-color'); this.style.removeProperty('background'); this.style.removeProperty('opacity'); this.style.removeProperty('filter'); this.blur(); });">
                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-white" fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24">
                            <polyline points="9 18 15 12 9 6"></polyline>
                        </svg>
                    </button>

                    <!-- Category Carousel Container -->
                    <div class="category-carousel-wrapper overflow-hidden">
                        <div id="categoryCarouselTrack" class="flex">
                            @foreach ($allCategories as $category)
                                                    <a href="{{ route('all', ['category' => $category->id]) }}"
                                   class="category-item-carousel flex-shrink-0 flex flex-col items-center justify-center text-center group cursor-pointer w-[110px] sm:w-[130px] md:w-[150px]">
                                    <!-- Circular Category Image/Icon - Larger Size -->
                                    <div class="mb-2 flex-shrink-0">
                                                        @if ($category->image)
                                            <div class="w-24 h-24 sm:w-28 sm:h-28 md:w-32 md:h-32 mx-auto rounded-full overflow-hidden bg-white flex items-center justify-center p-1.5 sm:p-2.5 transition-colors duration-200 border-2 border-gray-200 group-hover:border-blue-500 shadow-sm">
                                                                <img src="{{ asset('uploads/' . $category->image) }}"
                                                    alt="{{ $category->name }}" 
                                                    class="w-full h-full object-contain group-hover:scale-110 transition-transform duration-200">
                                                            </div>
                                                        @else
                                            <div class="w-24 h-24 sm:w-28 sm:h-28 md:w-32 md:h-32 mx-auto rounded-full bg-gradient-to-br from-blue-50 to-cyan-50 flex items-center justify-center transition-colors duration-200 border-2 border-gray-200 group-hover:border-blue-500 shadow-sm">
                                                <i class="lni lni-package text-2xl sm:text-3xl md:text-4xl text-blue-600"></i>
                                                            </div>
                                                        @endif
                                                </div>
                                    
                                    <!-- Category Name -->
                                    <h6 class="text-xs sm:text-sm font-semibold text-gray-700 group-hover:text-blue-600 transition-colors duration-200 leading-tight line-clamp-2 px-2">
                                        {{ $category->name }}
                                    </h6>
                                </a>
                                            @endforeach
                                        </div>
                    </div>
                                                                </div>
                                                            @else
                <div class="text-center py-12 bg-white rounded-xl shadow-md border border-gray-200">
                    <p class="text-gray-500">Belum ada kategori yang tersedia.</p>
                                                                </div>
                                                            @endif
                                                    </div>
    </section>

    <!-- Section Why Choose Us -->
    <section class="py-12 sm:py-16 bg-white">
        <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
            <!-- Header -->
            <div class="text-center mb-8 sm:mb-12">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 leading-tight">Mengapa Memilih Kami?</h2>
                <p class="text-sm sm:text-base text-gray-600 max-w-2xl mx-auto leading-relaxed">
                    Kami berkomitmen memberikan solusi mesin teknologi terdepan dengan kualitas terbaik untuk kebutuhan bisnis Anda
                </p>
                                            </div>

            <!-- Features Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8">
                <!-- Feature 1 -->
                <div class="bg-white rounded-lg p-6 shadow-md hover:shadow-xl transition-all duration-300 border border-gray-100">
                    <div class="w-14 h-14 bg-blue-600 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                                    </div>
                    <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 leading-tight">Custom Design</h3>
                    <p class="text-sm sm:text-base text-gray-600 leading-relaxed">
                        Mesin dirancang khusus sesuai kebutuhan dan spesifikasi produksi Anda
                    </p>
                                </div>

                <!-- Feature 2 -->
                <div class="bg-white rounded-lg p-6 shadow-md hover:shadow-xl transition-all duration-300 border border-gray-100">
                    <div class="w-14 h-14 bg-blue-600 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 leading-tight">Kualitas Premium</h3>
                    <p class="text-sm sm:text-base text-gray-600 leading-relaxed">
                        Menggunakan material berkualitas tinggi dengan standar industri terbaik
                    </p>
                        </div>

                <!-- Feature 3 -->
                <div class="bg-white rounded-lg p-6 shadow-md hover:shadow-xl transition-all duration-300 border border-gray-100">
                    <div class="w-14 h-14 bg-blue-600 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 leading-tight">Tim Berpengalaman</h3>
                    <p class="text-sm sm:text-base text-gray-600 leading-relaxed">
                        Tim engineering profesional dengan pengalaman bertahun-tahun di industri
                    </p>
                </div>

                <!-- Feature 4 -->
                <div class="bg-white rounded-lg p-6 shadow-md hover:shadow-xl transition-all duration-300 border border-gray-100">
                    <div class="w-14 h-14 bg-blue-600 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                        </svg>
                            </div>
                    <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 leading-tight">Garansi & Support</h3>
                    <p class="text-sm sm:text-base text-gray-600 leading-relaxed">
                        Garansi produk dan layanan after-sales untuk kepuasan jangka panjang
                    </p>
                    </div>

                <!-- Feature 5 -->
                <div class="bg-white rounded-lg p-6 shadow-md hover:shadow-xl transition-all duration-300 border border-gray-100">
                    <div class="w-14 h-14 bg-blue-600 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                </div>
                    <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 leading-tight">Estimasi Jelas</h3>
                    <p class="text-sm sm:text-base text-gray-600 leading-relaxed">
                        Waktu pengerjaan yang transparan dan dapat diandalkan untuk perencanaan Anda
                    </p>
                </div>

                <!-- Feature 6 -->
                <div class="bg-white rounded-lg p-6 shadow-md hover:shadow-xl transition-all duration-300 border border-gray-100">
                    <div class="w-14 h-14 bg-blue-600 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 leading-tight">Konsultasi Gratis</h3>
                    <p class="text-sm sm:text-base text-gray-600 leading-relaxed">
                        Konsultasi gratis untuk membantu menentukan solusi terbaik bagi bisnis Anda
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Section Produk -->
    <section class="py-12 sm:py-16 bg-white">
        <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
            <!-- Header Produk -->
            <div class="text-center mb-8 sm:mb-12">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 leading-tight">Produk Terbaru</h2>
                <p class="text-sm sm:text-base text-gray-600 max-w-2xl mx-auto mb-2 leading-relaxed">
                    Temukan mesin teknologi terbaru untuk meningkatkan produktivitas bisnis Anda
                </p>
                <p class="text-xs sm:text-sm text-gray-500 max-w-2xl mx-auto mb-4 italic">
                    <i class="fas fa-info-circle mr-1"></i>Semua produk dibuat sesuai pesanan (Made to Order)
                </p>
                <a href="{{ route('all', ['type' => 'services']) }}" class="inline-block text-blue-600 hover:text-blue-800 font-semibold text-sm sm:text-base transition-colors">
                    Lihat Semua Produk →
                </a>
            </div>

            <!-- Grid Produk -->
            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-2.5 sm:gap-3 md:gap-4 gap-y-4 sm:gap-y-6 md:gap-y-8">
                @forelse ($products as $product)
                    <div class="product-card-wrapper group">
                        <a href="{{ route('product_details', $product->id) }}" class="block">
                            <div
                                class="bg-white border border-gray-200 overflow-hidden rounded-lg shadow-md hover:shadow-xl transition-shadow duration-300">
                                <!-- Product Image -->
                                <div class="relative aspect-square overflow-hidden bg-white">
                                    @if ($product->product_image)
                                        <img src="{{ asset('uploads/products/' . $product->product_image) }}"
                                            alt="{{ $product->product_title }}"
                                            class="product-image w-full h-full object-contain shadow-inner">
                                    @elseif ($product->images->isNotEmpty())
                                        <img src="{{ asset('uploads/products/' . $product->images->first()->image_path) }}"
                                            alt="{{ $product->product_title }}"
                                            class="product-image w-full h-full object-contain shadow-inner">
                                    @else
                                        <div class="w-full h-full flex items-center justify-center bg-gray-100">
                                            <i class="fas fa-image text-gray-400 text-4xl"></i>
                                        </div>
                                    @endif
                                </div>

                                <!-- Product Info -->
                                <div class="p-2 sm:p-3">
                                    <!-- Product Name -->
                                    <h3 class="product-title text-xs sm:text-sm font-semibold text-gray-800 mb-0.5 sm:mb-1 line-clamp-2 min-h-[2rem] sm:min-h-[2.5rem]">
                                        {{ $product->product_title }}
                                    </h3>

                                    <!-- Category -->
                                    @if ($product->category)
                                        <p class="text-[10px] sm:text-xs text-gray-500 mb-0.5 sm:mb-1">{{ $product->category->name }}</p>
                                    @endif

                                    <!-- Price -->
                                    <div class="mt-0.5 sm:mt-1 mb-0.5 sm:mb-1">
                                        <p class="text-sm sm:text-base md:text-lg font-bold text-blue-600">
                                            Rp{{ number_format($product->product_prices ?? 0, 0, ',', '.') }}
                                        </p>
                                    </div>

                                    <!-- Hover Buttons - Muncul di bagian bawah -->
                                    {{-- <div class="product-buttons flex gap-2">
                                        <button onclick="event.preventDefault(); event.stopPropagation();"
                                            class="product-btn bg-white text-gray-800 hover:bg-blue-600 hover:text-white border border-gray-300 flex-1 py-2 rounded-lg font-medium text-xs transition-all duration-300 flex items-center justify-center gap-1.5">
                                            <i class="fas fa-shopping-cart"></i>
                                            <span class="btn-text">Keranjang</span>
                                        </button>
                                        <button onclick="event.preventDefault(); event.stopPropagation();"
                                            class="product-btn bg-green-600 text-white hover:bg-green-700 flex-1 py-2 rounded-lg font-medium text-xs transition-all duration-300 flex items-center justify-center gap-1.5">
                                            <i class="fas fa-bag-shopping"></i>
                                            <span class="btn-text">Beli</span>
                                        </button>
                                    </div> --}}
                                </div>
                            </div>
                        </a>
                    </div>
                @empty
                    <div class="col-span-full text-center py-8">
                        <p class="text-gray-500">Belum ada produk yang tersedia.</p>
                    </div>
                @endforelse
            </div>
        </div>
    </section>

    <!-- Section Produk Terlaris -->
    <section class="py-12 sm:py-16 bg-white">
        <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
            <!-- Header Produk Terlaris -->
            <div class="text-center mb-8 sm:mb-12">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3">Produk Terlaris</h2>
                <p class="text-sm sm:text-base text-gray-600 max-w-2xl mx-auto mb-4">
                    Produk pilihan yang paling banyak dipilih oleh klien kami
                </p>
                <a href="{{ route('best-selling') }}" class="inline-block text-blue-600 hover:text-blue-800 font-semibold text-sm sm:text-base transition-colors">
                    Lihat Semua Produk Terlaris →
                </a>
            </div>

            @php
                // Produk terlaris sudah diambil dari controller dengan data real
                $bestSellingProducts = $bestSellingProducts ?? collect();
            @endphp

            <!-- Carousel Container -->
            <div class="relative best-selling-carousel-container">
                <!-- Navigation Controls -->
                @if ($bestSellingProducts && $bestSellingProducts->count() > 0)
                    <!-- Previous Button -->
                    <button onclick="prevBestSellingSlide()"
                        class="best-selling-nav-btn best-selling-nav-prev absolute w-6 h-16 sm:w-8 sm:h-20 bg-black/70 hover:bg-blue-600 transition-colors duration-200 rounded-none z-20 flex items-center justify-center opacity-50 hover:opacity-100 border-0 cursor-pointer"
                        style="left: -8px;"
                        type="button">
                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-white" fill="none" stroke="currentColor" stroke-width="3"
                            viewBox="0 0 24 24">
                            <polyline points="15 18 9 12 15 6"></polyline>
                        </svg>
                    </button>

                    <!-- Next Button -->
                    <button onclick="nextBestSellingSlide()"
                        class="best-selling-nav-btn best-selling-nav-next absolute w-6 h-16 sm:w-8 sm:h-20 bg-black/70 hover:bg-blue-600 transition-colors duration-200 rounded-none z-20 flex items-center justify-center opacity-50 hover:opacity-100 border-0 cursor-pointer"
                        style="right: -8px;"
                        type="button">
                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-white" fill="none" stroke="currentColor" stroke-width="3"
                            viewBox="0 0 24 24">
                            <polyline points="9 18 15 12 9 6"></polyline>
                        </svg>
                    </button>
                @endif

                <!-- Carousel Track -->
                <div class="overflow-hidden pb-4 md:pb-6 lg:pb-8">
                    <div id="bestSellingTrack" class="flex transition-transform duration-500 ease-in-out">
                        @foreach ($bestSellingProducts as $product)
                            <div class="best-selling-slide flex-shrink-0 w-1/2 lg:w-1/4 px-2">
                                <div class="product-card-wrapper group min-h-[280px] sm:min-h-[300px] md:min-h-[320px] mb-2 md:mb-4 lg:mb-6">
                                    <a href="{{ route('product_details', $product->id) }}" class="block">
                                        <div
                                            class="bg-white border border-gray-200 overflow-hidden rounded-lg shadow-md hover:shadow-xl transition-shadow duration-300 w-full h-full flex flex-col">
                                        <!-- Product Image with Terlaris Label -->
                                        <div class="relative aspect-square overflow-hidden bg-white flex-shrink-0">
                                            <!-- Terlaris Label -->
                                            <div class="absolute top-2 left-2 z-10">
                                                <span class="bg-red-600 text-white text-xs font-bold px-2 py-1 rounded">TERLARIS</span>
                                            </div>
                                            @if ($product->product_image)
                                                <img src="{{ asset('uploads/products/' . $product->product_image) }}"
                                                    alt="{{ $product->product_title }}"
                                                    class="product-image w-full h-full object-contain shadow-inner">
                                            @elseif ($product->images->isNotEmpty())
                                                <img src="{{ asset('uploads/products/' . $product->images->first()->image_path) }}"
                                                    alt="{{ $product->product_title }}"
                                                    class="product-image w-full h-full object-contain shadow-inner">
                                            @else
                                                <div
                                                    class="w-full h-full flex items-center justify-center bg-gray-100">
                                                    <i class="fas fa-image text-gray-400 text-4xl"></i>
                                                </div>
                                            @endif
                                        </div>

                                        <!-- Product Info -->
                                        <div class="p-2 sm:p-3 flex-1 flex flex-col justify-between">
                                            <!-- Product Name -->
                                            <h3
                                                class="product-title text-[10px] sm:text-xs md:text-sm font-semibold text-gray-800 mb-0.5 sm:mb-1 line-clamp-2 min-h-[2rem] sm:min-h-[2.5rem]">
                                                {{ $product->product_title }}
                                            </h3>

                                            <!-- Price -->
                                            <div class="mb-1 sm:mb-2">
                                                <p class="text-sm sm:text-base md:text-lg font-bold text-blue-600">
                                                    Rp{{ number_format($product->product_prices ?? 0, 0, ',', '.') }}
                                                </p>
                                            </div>

                                            <!-- Sold -->
                                            <div class="flex items-center gap-1 sm:gap-2 text-[10px] sm:text-xs mb-0.5 sm:mb-1">
                                                <span class="text-gray-500">Terjual:</span>
                                                <span class="font-medium text-green-600">
                                                    {{ $product->sold ?? 0 }} unit
                                                </span>
                                            </div>

                                            <!-- No Buttons for Best Selling -->
                                        </div>
                                    </div>
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Tampilkan pesan jika tidak ada produk -->
            @if (!$bestSellingProducts || $bestSellingProducts->isEmpty())
                <div class="text-center py-4">
                    <p class="text-gray-500">Belum ada produk terlaris.</p>
                </div>
            @endif
        </div>
    </section>

    <!-- Section Sertifikasi & Standar Kualitas -->
    <section class="py-12 sm:py-16 bg-gray-100">
        <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
            <!-- Header -->
            <div class="text-center mb-8 sm:mb-12">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 leading-tight">Sertifikasi & Standar Kualitas</h2>
                <p class="text-sm sm:text-base text-gray-600 max-w-2xl mx-auto leading-relaxed">
                    Komitmen kami terhadap kualitas dan standar industri terbaik
                </p>
            </div>

            <!-- Certifications Grid -->
            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 sm:gap-6">
                <!-- Certification 1 -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-all duration-300 border border-gray-100 group text-center">
                    <div class="w-20 h-20 sm:w-24 sm:h-24 bg-gradient-to-br from-blue-50 to-cyan-50 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300">
                        <svg class="w-8 h-8 sm:w-10 sm:h-10 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                        </svg>
                    </div>
                    <h3 class="text-sm sm:text-base font-semibold text-gray-800 mb-2 leading-tight">Standar Industri</h3>
                    <p class="text-xs sm:text-sm text-gray-600 leading-relaxed">Mengikuti standar industri nasional dan internasional</p>
                </div>

                <!-- Certification 2 -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-all duration-300 border border-gray-100 group text-center">
                    <div class="w-20 h-20 sm:w-24 sm:h-24 bg-gradient-to-br from-blue-50 to-cyan-50 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300">
                        <svg class="w-8 h-8 sm:w-10 sm:h-10 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                        </svg>
                    </div>
                    <h3 class="text-sm sm:text-base font-semibold text-gray-800 mb-2 leading-tight">Quality Control</h3>
                    <p class="text-xs sm:text-sm text-gray-600 leading-relaxed">Pemeriksaan kualitas ketat di setiap tahap produksi</p>
                </div>

                <!-- Certification 3 -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-all duration-300 border border-gray-100 group text-center">
                    <div class="w-20 h-20 sm:w-24 sm:h-24 bg-gradient-to-br from-blue-50 to-cyan-50 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300">
                        <svg class="w-8 h-8 sm:w-10 sm:h-10 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-sm sm:text-base font-semibold text-gray-800 mb-2 leading-tight">Material Premium</h3>
                    <p class="text-xs sm:text-sm text-gray-600 leading-relaxed">Menggunakan material berkualitas tinggi dan tahan lama</p>
                </div>

                <!-- Certification 4 -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-all duration-300 border border-gray-100 group text-center">
                    <div class="w-20 h-20 sm:w-24 sm:h-24 bg-gradient-to-br from-blue-50 to-cyan-50 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300">
                        <svg class="w-8 h-8 sm:w-10 sm:h-10 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-sm sm:text-base font-semibold text-gray-800 mb-2 leading-tight">Teknologi Terdepan</h3>
                    <p class="text-xs sm:text-sm text-gray-600 leading-relaxed">Menggunakan teknologi modern dan inovatif</p>
                </div>
            </div>

            <!-- Additional Info -->
            <div class="mt-8 sm:mt-12 bg-white rounded-xl shadow-md p-6 sm:p-8 border border-gray-100">
                <div class="flex flex-col md:flex-row items-center gap-4 md:gap-6">
                    <div class="flex-shrink-0">
                        <div class="w-16 h-16 bg-blue-600 rounded-full flex items-center justify-center">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="flex-1 text-center md:text-left">
                        <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 leading-tight">Komitmen Kualitas</h3>
                        <p class="text-sm sm:text-base text-gray-600 leading-relaxed">
                            Setiap mesin yang kami produksi melalui proses quality control yang ketat untuk memastikan kualitas terbaik. Kami berkomitmen memberikan produk yang memenuhi standar industri dan harapan klien.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Section Portfolio/Gallery -->
    <section class="py-12 sm:py-16 bg-white">
        <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
            <!-- Header -->
            <div class="text-center mb-8 sm:mb-12">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 leading-tight">Portfolio Kami</h2>
                <p class="text-sm sm:text-base text-gray-600 max-w-2xl mx-auto leading-relaxed">
                    Beberapa mesin yang telah kami produksi dan digunakan oleh klien kami
                </p>
            </div>

            <!-- Gallery Grid -->
            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 sm:gap-6">
                @foreach ($products->take(8) as $product)
                    <div class="group relative overflow-hidden rounded-lg shadow-md hover:shadow-xl transition-all duration-300 bg-white border border-gray-100">
                        <a href="{{ route('portfolio.detail', $product->id) }}" class="block">
                            <div class="aspect-square overflow-hidden bg-white flex items-center justify-center p-4 sm:p-6">
                                @if ($product->product_image)
                                    <img src="{{ asset('uploads/products/' . $product->product_image) }}"
                                        alt="{{ $product->product_title }}"
                                        class="w-full h-full object-contain group-hover:scale-105 transition-transform duration-300">
                                @elseif ($product->images->isNotEmpty())
                                    <img src="{{ asset('uploads/products/' . $product->images->first()->image_path) }}"
                                        alt="{{ $product->product_title }}"
                                        class="w-full h-full object-contain group-hover:scale-105 transition-transform duration-300">
                                @else
                                    <div class="w-full h-full flex items-center justify-center">
                                        <i class="fas fa-image text-gray-400 text-3xl"></i>
                                    </div>
                                @endif
                            </div>
                            <div class="p-3 sm:p-4 bg-white border-t border-gray-100">
                                <h4 class="font-semibold text-sm text-gray-800 mb-1 line-clamp-2 group-hover:text-blue-600 transition-colors">{{ $product->product_title }}</h4>
                                @if ($product->category)
                                    <p class="text-xs text-gray-500">{{ $product->category->name }}</p>
                                @endif
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>

            <!-- View More Button -->
            <div class="text-center mt-8">
                <a href="{{ route('all') }}" class="inline-block bg-blue-600 hover:bg-blue-700 text-white font-medium py-3 px-8 rounded-lg transition duration-200 shadow-md hover:shadow-lg">
                    Lihat Semua Produk
                </a>
            </div>
        </div>
    </section>

    <!-- Section Proses Pemesanan -->
    <section class="py-12 sm:py-16 bg-gray-100">
        <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
            <!-- Header -->
            <div class="text-center mb-8 sm:mb-12">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 leading-tight">Proses Pemesanan</h2>
                <p class="text-sm sm:text-base text-gray-600 max-w-2xl mx-auto leading-relaxed">
                    Pilih metode pemesanan sesuai kebutuhan Anda
                </p>
            </div>

            <!-- Two Paths: Pesan Sekarang vs Penawaran -->
            <div class="grid md:grid-cols-2 gap-6 sm:gap-8 mb-8 sm:mb-12">
                <!-- Path 1: Pesan Sekarang -->
                <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-6 sm:p-8">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full flex items-center justify-center mx-auto mb-4 shadow-md">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl sm:text-2xl font-bold text-gray-800 mb-2">Pesan Sekarang</h3>
                        <p class="text-sm text-gray-600">Untuk produk yang sudah tersedia di katalog</p>
                    </div>
                    <div class="space-y-3">
                        <!-- Step 1 -->
                        <div class="flex items-start gap-3 group hover:bg-blue-50 rounded-lg p-2 -m-2 transition-colors duration-200">
                            <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5 shadow-sm group-hover:shadow-md transition-shadow">
                                <span class="text-sm font-bold text-white">1</span>
                            </div>
                            <div class="flex-1">
                                <h4 class="text-sm font-semibold text-gray-800 mb-1">Pilih Produk</h4>
                                <p class="text-xs text-gray-600 leading-relaxed">Pilih mesin dari katalog yang sesuai kebutuhan Anda</p>
                            </div>
                        </div>
                        
                        <!-- Step 2 -->
                        <div class="flex items-start gap-3 group hover:bg-blue-50 rounded-lg p-2 -m-2 transition-colors duration-200">
                            <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5 shadow-sm group-hover:shadow-md transition-shadow">
                                <span class="text-sm font-bold text-white">2</span>
                            </div>
                            <div class="flex-1">
                                <h4 class="text-sm font-semibold text-gray-800 mb-1">Checkout & Pembayaran</h4>
                                <p class="text-xs text-gray-600 leading-relaxed">Lakukan pembayaran DP (Down Payment) atau pembayaran lunas</p>
                            </div>
                        </div>
                        
                        <!-- Step 3 -->
                        <div class="flex items-start gap-3 group hover:bg-blue-50 rounded-lg p-2 -m-2 transition-colors duration-200">
                            <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5 shadow-sm group-hover:shadow-md transition-shadow">
                                <span class="text-sm font-bold text-white">3</span>
                            </div>
                            <div class="flex-1">
                                <h4 class="text-sm font-semibold text-gray-800 mb-1">Produksi & QC</h4>
                                <p class="text-xs text-gray-600 leading-relaxed">Mesin diproduksi sesuai pesanan dan melalui quality control ketat</p>
                            </div>
                        </div>
                        
                        <!-- Step 4 -->
                        <div class="flex items-start gap-3 group hover:bg-blue-50 rounded-lg p-2 -m-2 transition-colors duration-200">
                            <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5 shadow-sm group-hover:shadow-md transition-shadow">
                                <span class="text-sm font-bold text-white">4</span>
                            </div>
                            <div class="flex-1">
                                <h4 class="text-sm font-semibold text-gray-800 mb-1">Pengiriman & Instalasi</h4>
                                <p class="text-xs text-gray-600 leading-relaxed">Delivery dan instalasi mesin ke lokasi Anda</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Path 2: Penawaran Custom -->
                <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-6 sm:p-8">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-gradient-to-br from-green-500 to-green-600 rounded-full flex items-center justify-center mx-auto mb-4 shadow-md">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl sm:text-2xl font-bold text-gray-800 mb-2">Ajukan Penawaran</h3>
                        <p class="text-sm text-gray-600">Untuk produk custom atau dengan spesifikasi tambahan</p>
                    </div>
                    <div class="space-y-3">
                        <!-- Step 1 -->
                        <div class="flex items-start gap-3 group hover:bg-green-50 rounded-lg p-2 -m-2 transition-colors duration-200">
                            <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-green-600 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5 shadow-sm group-hover:shadow-md transition-shadow">
                                <span class="text-sm font-bold text-white">1</span>
                            </div>
                            <div class="flex-1">
                                <h4 class="text-sm font-semibold text-gray-800 mb-1">Ajukan Penawaran</h4>
                                <p class="text-xs text-gray-600 leading-relaxed">Isi form dengan kebutuhan dan spesifikasi produk yang diinginkan</p>
                            </div>
                        </div>
                        
                        <!-- Step 2 -->
                        <div class="flex items-start gap-3 group hover:bg-green-50 rounded-lg p-2 -m-2 transition-colors duration-200">
                            <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-green-600 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5 shadow-sm group-hover:shadow-md transition-shadow">
                                <span class="text-sm font-bold text-white">2</span>
                            </div>
                            <div class="flex-1">
                                <h4 class="text-sm font-semibold text-gray-800 mb-1">Rancangan Teknisi</h4>
                                <p class="text-xs text-gray-600 leading-relaxed">Teknisi merancang desain, fungsi, RAB detail, bahan & upah pengerjaan</p>
                            </div>
                        </div>
                        
                        <!-- Step 3 -->
                        <div class="flex items-start gap-3 group hover:bg-green-50 rounded-lg p-2 -m-2 transition-colors duration-200">
                            <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-green-600 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5 shadow-sm group-hover:shadow-md transition-shadow">
                                <span class="text-sm font-bold text-white">3</span>
                            </div>
                            <div class="flex-1">
                                <h4 class="text-sm font-semibold text-gray-800 mb-1">Review & Set Koridor Harga</h4>
                                <p class="text-xs text-gray-600 leading-relaxed">Admin review, lalu supervisor review RAB & set koridor harga (floor, target, ceiling)</p>
                            </div>
                        </div>
                        
                        <!-- Step 4 -->
                        <div class="flex items-start gap-3 group hover:bg-green-50 rounded-lg p-2 -m-2 transition-colors duration-200">
                            <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-green-600 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5 shadow-sm group-hover:shadow-md transition-shadow">
                                <span class="text-sm font-bold text-white">4</span>
                            </div>
                            <div class="flex-1">
                                <h4 class="text-sm font-semibold text-gray-800 mb-1">Penawaran ke Customer</h4>
                                <p class="text-xs text-gray-600 leading-relaxed">Admin mengirimkan penawaran dengan harga dalam koridor untuk disetujui customer</p>
                            </div>
                        </div>
                        
                        <!-- Step 5 -->
                        <div class="flex items-start gap-3 group hover:bg-green-50 rounded-lg p-2 -m-2 transition-colors duration-200">
                            <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-green-600 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5 shadow-sm group-hover:shadow-md transition-shadow">
                                <span class="text-sm font-bold text-white">5</span>
                            </div>
                            <div class="flex-1">
                                <h4 class="text-sm font-semibold text-gray-800 mb-1">Persetujuan Customer</h4>
                                <p class="text-xs text-gray-600 leading-relaxed">Customer review & setujui penawaran, lalu sistem convert ke pesanan</p>
                            </div>
                        </div>
                        
                        <!-- Step 6 -->
                        <div class="flex items-start gap-3 group hover:bg-green-50 rounded-lg p-2 -m-2 transition-colors duration-200">
                            <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-green-600 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5 shadow-sm group-hover:shadow-md transition-shadow">
                                <span class="text-sm font-bold text-white">6</span>
                            </div>
                            <div class="flex-1">
                                <h4 class="text-sm font-semibold text-gray-800 mb-1">Pembayaran & Produksi</h4>
                                <p class="text-xs text-gray-600 leading-relaxed">Pilih metode pembayaran (DP atau lunas), lalu produksi dimulai</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Section CTA Konsultasi -->
    <section class="pt-12 sm:pt-16 pb-0 bg-gray-100">
        <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4 pb-8 sm:pb-10 mb-0">
            <div class="bg-white rounded-2xl shadow-xl p-8 sm:p-12 text-center">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-4 leading-tight">Siap Meningkatkan Produktivitas Bisnis Anda?</h2>
                <p class="text-base sm:text-lg text-gray-600 mb-8 max-w-2xl mx-auto leading-relaxed">
                    Konsultasikan kebutuhan mesin Anda dengan tim ahli kami. Dapatkan solusi custom yang tepat untuk bisnis Anda.
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="{{ route('konsultasi') }}" class="inline-block bg-blue-600 text-white hover:bg-blue-700 font-semibold py-3 px-8 rounded-lg transition duration-200 shadow-md hover:shadow-lg">
                        <i class="fas fa-comments mr-2"></i>Konsultasi Gratis
                    </a>
                    <a href="{{ route('guest.contact') }}" class="inline-block bg-gray-100 text-gray-800 hover:bg-gray-200 font-semibold py-3 px-8 rounded-lg transition duration-200 border border-gray-200">
                        <i class="fas fa-envelope mr-2"></i>Hubungi Kami
                    </a>
                </div>
            </div>
        </div>
    </section>

    {{-- script --}}
    <script>
        // ======================================
        // STATS COUNTER ANIMATION
        // ======================================
        function animateCounter(element, target, duration = 2000) {
            let start = 0;
            const increment = target / (duration / 16);
            // Deteksi suffix dari element (bisa %, +, atau kosong)
            const hasPlus = element.innerHTML.includes('+');
            const hasPercent = element.textContent.includes('%');
            const suffix = hasPercent ? '%' : (hasPlus ? '+' : '');
            
            const timer = setInterval(() => {
                start += increment;
                if (start >= target) {
                    if (hasPlus) {
                        element.innerHTML = target + '<span class="text-2xl sm:text-3xl">+</span>';
                    } else {
                        element.textContent = target + suffix;
                    }
                    clearInterval(timer);
                } else {
                    if (hasPlus) {
                        element.innerHTML = Math.floor(start) + '<span class="text-2xl sm:text-3xl">+</span>';
                    } else {
                        element.textContent = Math.floor(start) + suffix;
                    }
                }
            }, 16);
        }

        // Intersection Observer untuk trigger animasi saat scroll
        document.addEventListener('DOMContentLoaded', function() {
            // Cari semua counter dengan data-count dan ambil parent section-nya
            const counters = document.querySelectorAll('[data-count]');
            if (counters.length > 0) {
                // Ambil section pertama yang berisi counter (section pencapaian)
                const statsSection = counters[0].closest('section');
                if (statsSection) {
                    const observer = new IntersectionObserver((entries) => {
                        entries.forEach(entry => {
                            if (entry.isIntersecting) {
                                const sectionCounters = entry.target.querySelectorAll('[data-count]');
                                sectionCounters.forEach(counter => {
                                    const target = parseInt(counter.getAttribute('data-count'));
                                    if (!counter.classList.contains('counted')) {
                                        counter.classList.add('counted');
                                        animateCounter(counter, target);
                                    }
                                });
                                observer.unobserve(entry.target);
                            }
                        });
                    }, { threshold: 0.5 });

                    observer.observe(statsSection);
                }
            }
        });

        // ======================================
        // CATEGORY HORIZONTAL CAROUSEL SECTION
        // ======================================
        // Category Horizontal Carousel Scroll - Per 1 Item (Smooth)
        function scrollCategoryCarousel(direction) {
            const wrapper = document.querySelector('.category-carousel-wrapper');
            if (!wrapper) return;

            const track = document.getElementById('categoryCarouselTrack');
            if (!track) return;

            // Get first item
            const firstItem = track.querySelector('.category-item-carousel');
            if (!firstItem) return;

            // Calculate item width including margin-right
            const itemWidth = firstItem.offsetWidth;
            const itemStyle = window.getComputedStyle(firstItem);
            const marginRight = parseFloat(itemStyle.marginRight) || 0;
            const scrollAmount = itemWidth + marginRight;
            
            const currentScroll = wrapper.scrollLeft || 0;
            const newScroll = direction === 'left' 
                ? currentScroll - scrollAmount 
                : currentScroll + scrollAmount;

            wrapper.scrollTo({
                left: newScroll,
                behavior: 'smooth'
            });
        }

        // Auto-hide navigation buttons based on scroll position
        // Panah muncul jika masih ada konten, hilang jika di ujung
        document.addEventListener('DOMContentLoaded', function() {
            const wrapper = document.querySelector('.category-carousel-wrapper');
            const leftBtn = document.querySelector('.category-scroll-left');
            const rightBtn = document.querySelector('.category-scroll-right');

            if (wrapper && leftBtn && rightBtn) {
                function updateNavButtons() {
                    const maxScroll = wrapper.scrollWidth - wrapper.clientWidth;
                    const currentScroll = wrapper.scrollLeft;
                    const isMobile = window.innerWidth <= 640;
                    const threshold = 5; // Threshold untuk deteksi ujung

                    // Left button: muncul jika masih ada konten di kiri, hilang jika di awal
                    if (currentScroll <= threshold) {
                        // Di ujung kiri - sembunyikan panah kiri
                        if (isMobile) {
                            leftBtn.style.setProperty('display', 'none', 'important');
                            leftBtn.style.setProperty('visibility', 'hidden', 'important');
                        } else {
                            leftBtn.style.display = 'none';
                            leftBtn.style.visibility = 'hidden';
                        }
                        leftBtn.style.pointerEvents = 'none';
                    } else {
                        // Masih ada konten di kiri - tampilkan panah kiri
                        if (isMobile) {
                            leftBtn.style.setProperty('display', 'flex', 'important');
                            leftBtn.style.setProperty('visibility', 'visible', 'important');
                            leftBtn.style.setProperty('opacity', '0.5', 'important');
                            leftBtn.style.setProperty('z-index', '40', 'important'); /* Lebih rendah dari navbar (z-50) */
                        } else {
                            leftBtn.style.display = 'flex';
                            leftBtn.style.visibility = 'visible';
                            leftBtn.style.opacity = '0.5';
                        }
                        leftBtn.style.pointerEvents = 'auto';
                    }

                    // Right button: muncul jika masih ada konten di kanan, hilang jika di akhir
                    if (currentScroll >= maxScroll - threshold) {
                        // Di ujung kanan - sembunyikan panah kanan
                        if (isMobile) {
                            rightBtn.style.setProperty('display', 'none', 'important');
                            rightBtn.style.setProperty('visibility', 'hidden', 'important');
                        } else {
                            rightBtn.style.display = 'none';
                            rightBtn.style.visibility = 'hidden';
                        }
                        rightBtn.style.pointerEvents = 'none';
                    } else {
                        // Masih ada konten di kanan - tampilkan panah kanan
                        if (isMobile) {
                            rightBtn.style.setProperty('display', 'flex', 'important');
                            rightBtn.style.setProperty('visibility', 'visible', 'important');
                            rightBtn.style.setProperty('opacity', '0.5', 'important');
                            rightBtn.style.setProperty('z-index', '40', 'important'); /* Lebih rendah dari navbar (z-50) */
                        } else {
                            rightBtn.style.display = 'flex';
                            rightBtn.style.visibility = 'visible';
                            rightBtn.style.opacity = '0.5';
                        }
                        rightBtn.style.pointerEvents = 'auto';
                    }
                }

                // Initial check
                setTimeout(function() {
                    updateNavButtons();
                }, 100);

                // Update on scroll
                wrapper.addEventListener('scroll', updateNavButtons);

                // Update on resize
                window.addEventListener('resize', function() {
                    setTimeout(function() {
                        updateNavButtons();
                    }, 100);
                });
            }
        });

        // ======================================
        // OLD CATEGORY CAROUSEL (KEEP FOR COMPATIBILITY)
        // ======================================
        document.addEventListener('DOMContentLoaded', function() {
            let currentCategorySlide = 0;
            let isSliding = false;
            let isMobile = window.innerWidth <= 768;

            // Ambil semua kategori dari DOM (dari desktop slides)
            let allCategories = [];
            document.querySelectorAll('.category-col[data-category]').forEach(col => {
                try {
                    const categoryData = JSON.parse(col.getAttribute('data-category'));
                    allCategories.push(categoryData);
                } catch (e) {
                    console.error('Error parsing category data:', e);
                }
            });

            const desktopContainer = document.getElementById('desktopSlidesContainer');
            const mobileContainer = document.getElementById('mobileSlidesContainer');
            const carouselInner = document.querySelector('.category-carousel-inner');

            function initializeCategoryCarousel() {
                isMobile = window.innerWidth <= 768;
                currentCategorySlide = 0;

                // Defer setup untuk fix timing render di mobile refresh
                requestAnimationFrame(() => {
                    if (isMobile) {
                        setupMobileLayout();
                    } else {
                        setupDesktopLayout();
                    }
                    updateNavigationButtons();
                });
            }

            function setupDesktopLayout() {
                // Sembunyikan mobile dengan class untuk CSS support
                mobileContainer.classList.add('hidden');
                mobileContainer.style.display = 'none';

                // Tampilkan desktop
                desktopContainer.classList.remove('hidden');
                desktopContainer.style.display = 'block';

                // Kelola desktop slides
                const desktopSlides = desktopContainer.querySelectorAll('.category-slide-desktop');
                desktopSlides.forEach((slide, index) => {
                    slide.style.display = 'none';
                    slide.classList.remove('active');
                    if (index === 0) {
                        slide.style.display = 'block';
                        slide.classList.add('active');
                    }
                });

                // Sembunyikan pesan empty jika ada
                const emptyMessage = carouselInner.querySelector('.category-slide.text-center');
                if (emptyMessage) {
                    emptyMessage.style.display = allCategories.length > 0 ? 'none' : 'block';
                }

                // Force reflow untuk desktop
                carouselInner.offsetHeight;
            }

            function setupMobileLayout() {
                // Sembunyikan desktop dengan class
                desktopContainer.classList.add('hidden');
                desktopContainer.style.display = 'none';

                // Tampilkan dan bersihkan mobile
                mobileContainer.classList.remove('hidden');
                mobileContainer.style.display = 'block';
                mobileContainer.innerHTML = '';

                // Buat mobile slides (9 items per slide: 3 rows x 3 columns)
                const itemsPerSlide = 9;
                const totalSlides = Math.ceil(allCategories.length / itemsPerSlide);

                if (totalSlides === 0) {
                    // Jika kosong, biarkan pesan empty tampil
                    return;
                }

                // Set temporary height untuk hindari collapse saat build
                const tempHeight = 280; // Estimasi 3 rows dengan ukuran lebih kecil
                carouselInner.style.minHeight = tempHeight + 'px';

                for (let slideIdx = 0; slideIdx < totalSlides; slideIdx++) {
                    const slideDiv = document.createElement('div');
                    slideDiv.className = `category-slide category-slide-mobile ${slideIdx === 0 ? 'active' : ''}`;
                    slideDiv.setAttribute('data-slide-index', slideIdx);

                    const gridDiv = document.createElement('div');
                    gridDiv.className = 'category-grid';

                    // Create 3 rows x 3 columns (9 items per slide)
                    // Empty slots akan disembunyikan oleh CSS untuk tampilan yang rapi
                    for (let row = 0; row < 3; row++) {
                        const rowDiv = document.createElement('div');
                        rowDiv.className = 'category-row flex flex-wrap border-t border-l border-[#f0f0f0]';

                        for (let col = 0; col < 3; col++) {
                            const index = slideIdx * itemsPerSlide + row * 3 + col;
                            const category = allCategories[index];

                            if (category) {
                                const colDiv = document.createElement('div');
                                colDiv.className = 'category-col';
                                colDiv.innerHTML = `
                            <a href="/all?category=${category.id}" class="category-item">
                                ${category.image 
                                    ? `<div class="category-image-wrapper">
                                                        <img src="/uploads/${category.image}" alt="${category.name}" class="category-image">
                                                        </div>`
                                    : `<div class="category-icon-wrapper">
                                                        <i class="lni lni-package"></i>
                                                        </div>`
                                }
                                <h6 class="category-name">${category.name}</h6>
                            </a>
                        `;
                                rowDiv.appendChild(colDiv);
                            } else {
                                // Buat empty slot tapi akan disembunyikan oleh CSS
                                const emptyDiv = document.createElement('div');
                                emptyDiv.className = 'category-col-empty';
                                rowDiv.appendChild(emptyDiv);
                            }
                        }

                        gridDiv.appendChild(rowDiv);
                    }

                    slideDiv.appendChild(gridDiv);
                    mobileContainer.appendChild(slideDiv);

                    // Hide all except first
                    if (slideIdx !== 0) {
                        slideDiv.style.display = 'none';
                    }
                }

                // Force reflow setelah build semua slides
                carouselInner.offsetHeight;

                // Tambahan: Force centering dan width untuk simetri di mobile refresh
                mobileContainer.style.width = '100%';
                mobileContainer.style.margin = '0 auto';
                const rows = mobileContainer.querySelectorAll('.category-row');
                rows.forEach(row => {
                    row.style.justifyContent = 'center';
                    row.style.width = '100%';
                    row.style.margin = '0 auto';
                });

                // Reset min-height dan set actual height dari first slide
                const firstSlide = mobileContainer.querySelector('.category-slide-mobile.active');
                if (firstSlide) {
                    const actualHeight = firstSlide.offsetHeight;
                    carouselInner.style.transition = 'height 0.3s ease';
                    carouselInner.style.height = actualHeight + 'px';
                    setTimeout(() => {
                        carouselInner.style.transition = '';
                        carouselInner.style.height = '';
                        carouselInner.style.minHeight = ''; // Reset ke CSS default
                    }, 300);
                }

                // Sembunyikan pesan empty jika ada
                const emptyMessage = carouselInner.querySelector('.category-slide.text-center');
                if (emptyMessage) {
                    emptyMessage.style.display = allCategories.length > 0 ? 'none' : 'block';
                }
            }

            function updateNavigationButtons() {
                const container = isMobile ? mobileContainer : desktopContainer;
                const totalSlides = container ? container.querySelectorAll('.category-slide').length : 0;

                const navControls = document.querySelector('.category-nav-controls');
                if (totalSlides <= 1) {
                    navControls.style.display = 'none';
                } else {
                    navControls.style.display = 'block';
                }
            }

            // Category Carousel Navigation - Dengan animasi slide (fix posisi slide kedua)
            function showCategorySlide(index) {
                if (isSliding) return;

                const container = isMobile ? mobileContainer : desktopContainer;
                const slides = container.querySelectorAll('.category-slide');

                const totalSlides = slides.length;

                if (totalSlides === 0) return;

                let newIndex = index;
                if (index >= totalSlides) {
                    newIndex = 0;
                } else if (index < 0) {
                    newIndex = totalSlides - 1;
                }

                if (newIndex === currentCategorySlide) return;

                isSliding = true;

                const currentSlideEl = slides[currentCategorySlide];
                const newSlideEl = slides[newIndex];

                // Ambil height dari slide yang aktif
                const containerHeight = carouselInner.offsetHeight;

                // Lock height container dengan transition smooth
                carouselInner.style.transition = 'height 0.5s ease-in-out';
                carouselInner.style.height = containerHeight + 'px';

                // Tampilkan new slide di background untuk measure height
                newSlideEl.style.position = 'absolute';
                newSlideEl.style.top = '0';
                newSlideEl.style.left = '0'; // Tambahan: Fix posisi left
                newSlideEl.style.width = '100%';
                newSlideEl.style.visibility = 'hidden';
                newSlideEl.style.display = 'block';

                // Measure new slide height
                const newHeight = newSlideEl.offsetHeight;

                // Reset visibility
                newSlideEl.style.visibility = 'visible';

                // Set both slides untuk animasi
                currentSlideEl.style.position = 'absolute';
                currentSlideEl.style.top = '0';
                currentSlideEl.style.left = '0'; // Tambahan: Fix posisi left
                currentSlideEl.style.width = '100%';
                currentSlideEl.style.display = 'block';

                // SELALU slide dari kanan ke kiri (slide masuk dari kanan)
                newSlideEl.style.transition = 'none';
                newSlideEl.style.transform = 'translateX(100%)';

                // Force reflow
                newSlideEl.offsetHeight;

                // Add transitions
                currentSlideEl.style.transition = 'transform 0.5s ease-in-out';
                newSlideEl.style.transition = 'transform 0.5s ease-in-out';

                // Animate - SELALU ke kiri dan adjust height
                requestAnimationFrame(() => {
                    currentSlideEl.style.transform = 'translateX(-100%)';
                    newSlideEl.style.transform = 'translateX(0)';
                    carouselInner.style.height = newHeight + 'px';
                });

                // Clean up after animation (enhanced untuk fix posisi)
                setTimeout(() => {
                    // Hide old slide
                    currentSlideEl.classList.remove('active');
                    currentSlideEl.style.display = 'none';
                    currentSlideEl.style.position = '';
                    currentSlideEl.style.left = ''; // Tambahan reset
                    currentSlideEl.style.transform = '';
                    currentSlideEl.style.transition = '';

                    // Show new slide
                    newSlideEl.classList.add('active');
                    newSlideEl.style.position = 'relative';
                    newSlideEl.style.left = '0'; // Tambahan: Force left 0
                    newSlideEl.style.transform = '';
                    newSlideEl.style.transition = '';

                    // Force reflow setelah reset
                    newSlideEl.offsetHeight;

                    // Reset container height dengan smooth transition
                    setTimeout(() => {
                        carouselInner.style.transition = '';
                        carouselInner.style.height = '';
                    }, 50);

                    currentCategorySlide = newIndex;
                    isSliding = false;
                }, 500);
            }

            window.nextCategorySlide = function() {
                showCategorySlide(currentCategorySlide + 1);
            };

            window.prevCategorySlide = function() {
                showCategorySlide(currentCategorySlide - 1);
            };

            // Initialize on load
            initializeCategoryCarousel();

            // Re-initialize on resize
            let resizeTimer;
            let lastWidth = window.innerWidth;
            
            window.addEventListener('resize', function() {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(function() {
                    const currentWidth = window.innerWidth;
                    const wasMobile = isMobile;
                    isMobile = currentWidth <= 768;

                    // ALWAYS reinitialize if width change OR mode change
                    if (Math.abs(currentWidth - lastWidth) > 50 || wasMobile !== isMobile) {
                        console.log('Resize detected. Reinitializing carousel...');
                        initializeCategoryCarousel();
                        lastWidth = currentWidth;
                    }
                }, 150);
            });
        });


        // ======================================
        // BEST SELLING CAROUSEL SECTION
        // ======================================
        // Best Selling Carousel Navigation (slide per item untuk transisi smooth)
        let currentBestSellingSlide = 0;
        let autoBestSellingInterval;
        let itemsPerView = 2; // Default mobile: 2 items per view
        let maxSlide = 0;

        // Fungsi untuk update items per view berdasarkan screen size
        function updateBestSellingItemsPerView() {
            const width = window.innerWidth;
            // Sesuai dengan Tailwind breakpoint: lg = 1024px
            if (width >= 1024) {
                itemsPerView = 4; // Desktop (lg): 4 items per view (w-1/4)
            } else {
                itemsPerView = 2; // Mobile/Tablet: 2 items per view (w-1/2)
            }
            
            const track = document.getElementById('bestSellingTrack');
            if (track) {
                const totalItems = track.children.length;
                maxSlide = Math.max(0, totalItems - itemsPerView);
                // Reset ke slide pertama jika current slide melebihi max
                if (currentBestSellingSlide > maxSlide) {
                    currentBestSellingSlide = maxSlide;
                    updateBestSellingTransform();
                }
            }
        }

        // Fungsi untuk update transform
        function updateBestSellingTransform() {
            const track = document.getElementById('bestSellingTrack');
            if (!track) return;
            
            // Slide per item: setiap item adalah 50% di mobile (w-1/2) atau 25% di desktop (w-1/4)
            const slideWidth = 100 / itemsPerView;
            track.style.transform = `translateX(-${currentBestSellingSlide * slideWidth}%)`;
        }

        // Fungsi untuk memulai auto-slide otomatis (setiap 4 detik)
        function startBestSellingAuto() {
            stopBestSellingAuto(); // Stop existing interval first
            autoBestSellingInterval = setInterval(() => {
                nextBestSellingSlide();
            }, 4000);
        }

        // Fungsi untuk menghentikan auto-slide
        function stopBestSellingAuto() {
            if (autoBestSellingInterval) {
                clearInterval(autoBestSellingInterval);
                autoBestSellingInterval = null;
            }
        }

        // Fungsi untuk slide berikutnya (next) - slide 1 item per klik
        function nextBestSellingSlide() {
            const track = document.getElementById('bestSellingTrack');
            if (!track) return;

            updateBestSellingItemsPerView();
            
            // Slide 1 item ke kanan
            if (currentBestSellingSlide < maxSlide) {
                currentBestSellingSlide++;
            } else {
                // Loop kembali ke awal
                currentBestSellingSlide = 0;
            }
            
            updateBestSellingTransform();
        }

        // Fungsi untuk slide sebelumnya (prev) - slide 1 item per klik
        function prevBestSellingSlide() {
            const track = document.getElementById('bestSellingTrack');
            if (!track) return;

            updateBestSellingItemsPerView();
            
            // Slide 1 item ke kiri
            if (currentBestSellingSlide > 0) {
                currentBestSellingSlide--;
            } else {
                // Loop ke akhir
                currentBestSellingSlide = maxSlide;
            }
            
            updateBestSellingTransform();
        }

        // ======================================
        // INITIALIZATION SECTION
        // ======================================
        // Initialize semua carousel saat DOM loaded
        document.addEventListener('DOMContentLoaded', function() {
            // Category Carousel Init
            const categorySlides = document.querySelectorAll('.category-slide');
            const categoryCarousel = document.getElementById('categoryCarousel');

            // Set carousel height berdasarkan slide pertama
            if (categorySlides.length > 0) {
                categorySlides[0].style.display = 'block';
                const firstSlideHeight = categorySlides[0].offsetHeight;
                if (firstSlideHeight > 0) {
                    categoryCarousel.style.height = firstSlideHeight + 'px';
                }
            }

            categorySlides.forEach((slide, index) => {
                if (index === 0) {
                    slide.classList.add('active');
                    slide.style.position = 'relative';
                    slide.style.display = 'block';
                } else {
                    slide.style.position = 'absolute';
                    slide.style.display = 'none';
                }
            });
            currentCategorySlide = 0;

            // Best Selling Carousel Init
            const bestSellingTrack = document.getElementById('bestSellingTrack');
            if (bestSellingTrack && bestSellingTrack.children.length > 0) {
                // Initialize items per view
                updateBestSellingItemsPerView();
                currentBestSellingSlide = 0;
                updateBestSellingTransform();
                
                // Function untuk centering navigation arrows secara presisi
                function centerBestSellingNavArrows() {
                    const firstSlide = bestSellingTrack.querySelector('.best-selling-slide');
                    if (firstSlide) {
                        const cardWrapper = firstSlide.querySelector('.product-card-wrapper');
                        if (cardWrapper) {
                            // Ambil card element yang sebenarnya (div dengan class bg-white)
                            const cardElement = cardWrapper.querySelector('div.bg-white, a > div');
                            if (cardElement && cardElement.offsetHeight > 0) {
                                const cardRect = cardElement.getBoundingClientRect();
                                const cardHeight = cardRect.height;
                                const container = document.querySelector('.best-selling-carousel-container');
                                
                                if (container) {
                                    const containerRect = container.getBoundingClientRect();
                                    
                                    // Hitung tengah card dari atas container
                                    const cardTop = cardRect.top - containerRect.top;
                                    const cardCenter = cardTop + (cardHeight / 2);
                                    
                                    // Di mobile, adjust untuk padding-bottom yang besar
                                    const isMobile = window.innerWidth < 1024;
                                    let containerHeight = containerRect.height;
                                    
                                    if (isMobile) {
                                        // Di mobile, kurangi padding-bottom dari tinggi container untuk perhitungan
                                        const trackContainer = bestSellingTrack.parentElement;
                                        if (trackContainer) {
                                            const computedStyle = window.getComputedStyle(trackContainer);
                                            const paddingBottom = parseFloat(computedStyle.paddingBottom) || 0;
                                            // Gunakan tinggi container dikurangi padding-bottom untuk perhitungan yang lebih akurat
                                            containerHeight = containerRect.height - paddingBottom;
                                        }
                                    }
                                    
                                    // Pastikan perhitungan valid
                                    if (containerHeight > 0 && cardHeight > 0) {
                                        // Convert ke percentage dengan clamp untuk safety
                                        const centerPercentage = Math.max(5, Math.min(95, (cardCenter / containerHeight) * 100));
                                        
                                        // Apply ke semua nav buttons dengan !important untuk override CSS
                                        const navButtons = container.querySelectorAll('.best-selling-nav-btn');
                                        navButtons.forEach(btn => {
                                            btn.style.setProperty('top', centerPercentage + '%', 'important');
                                            btn.style.setProperty('transform', 'translateY(-50%)', 'important');
                                        });
                                    }
                                }
                            }
                        }
                    }
                }
                
                // Function untuk center arrows dengan retry mechanism
                function centerArrowsWithRetry(attempts = 0) {
                    const maxAttempts = 5;
                    centerBestSellingNavArrows();
                    
                    // Retry jika card belum ter-render (terutama di mobile)
                    if (attempts < maxAttempts) {
                        const firstCard = bestSellingTrack.querySelector('.best-selling-slide .product-card-wrapper div.bg-white');
                        if (!firstCard || firstCard.offsetHeight === 0) {
                            setTimeout(() => centerArrowsWithRetry(attempts + 1), 100);
                        }
                    }
                }
                
                // Center arrows on load - gunakan multiple attempts untuk memastikan DOM ready
                setTimeout(() => centerArrowsWithRetry(), 100);
                setTimeout(() => centerArrowsWithRetry(), 300);
                setTimeout(() => centerArrowsWithRetry(), 500);
                
                // Center arrows on resize dengan debounce
                let resizeTimer;
                window.addEventListener('resize', function() {
                    clearTimeout(resizeTimer);
                    resizeTimer = setTimeout(function() {
                        centerArrowsWithRetry();
                        // Double check setelah resize
                        setTimeout(() => centerArrowsWithRetry(), 100);
                    }, 150);
                });
                
                // Center arrows setelah images loaded (untuk mobile yang mungkin load lebih lambat)
                window.addEventListener('load', function() {
                    setTimeout(() => centerArrowsWithRetry(), 200);
                });
                
                // Center arrows saat card terlihat (Intersection Observer untuk mobile)
                if ('IntersectionObserver' in window) {
                    const observer = new IntersectionObserver((entries) => {
                        entries.forEach(entry => {
                            if (entry.isIntersecting) {
                                setTimeout(() => centerArrowsWithRetry(), 100);
                            }
                        });
                    }, { threshold: 0.1 });
                    
                    const firstCard = bestSellingTrack.querySelector('.best-selling-slide');
                    if (firstCard) {
                        observer.observe(firstCard);
                    }
                }
                
                // Mulai auto-slide
                startBestSellingAuto();
            }

            // Tambahkan event hover untuk pause/resume auto-slide pada container carousel Best Selling
            if (bestSellingTrack) {
                const bestSellingContainer = bestSellingTrack.closest('.relative');
                if (bestSellingContainer) {
                    bestSellingContainer.addEventListener('mouseenter', stopBestSellingAuto);
                    bestSellingContainer.addEventListener('mouseleave', startBestSellingAuto);
                }
            }

            // Update items per view saat resize
            let resizeBestSellingTimer;
            window.addEventListener('resize', function() {
                clearTimeout(resizeBestSellingTimer);
                resizeBestSellingTimer = setTimeout(function() {
                    updateBestSellingItemsPerView();
                    if (currentBestSellingSlide > maxSlide) {
                        currentBestSellingSlide = maxSlide;
                    }
                    updateBestSellingTransform();
                }, 150);
            });
        });
    </script>
@endsection
