@extends('layouts.main')

@section('title', $product->product_title . ' - Detail Produk')

@section('content')
    <div class="min-h-screen">
        <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">

            <!-- Breadcrumb -->
            <nav class="mb-3 sm:mb-4 text-xs sm:text-sm">
                <ol class="flex items-center space-x-1.5 sm:space-x-2 text-gray-600 overflow-x-auto scrollbar-hide">
                    <li><a href="/" class="hover:text-blue-600 transition whitespace-nowrap">Home</a></li>
                    <li><span class="mx-1 sm:mx-2">›</span></li>
                    <li><a href="{{ route('all', ['type' => 'services']) }}" class="hover:text-blue-600 transition whitespace-nowrap">Produk</a>
                    </li>
                    <li><span class="mx-1 sm:mx-2">›</span></li>
                    <li class="text-blue-600 font-medium truncate max-w-[200px] sm:max-w-none">{{ $product->product_title }}</li>
                </ol>
            </nav>

            <div class="grid lg:grid-cols-3 gap-4 sm:gap-5 md:gap-6">
                <!-- Left Section: Product Image & Info (2 columns) -->
                <div class="lg:col-span-2 space-y-3 sm:space-y-4 md:space-y-6">

                    <!-- Product Images & Basic Info -->
                    <div class="bg-white rounded-lg shadow-sm overflow-hidden">
                        <div class="p-3 sm:p-4 md:p-6">

                            <!-- Main Image Display -->
                            <div class="relative">
                                <button onclick="openGallery(0)"
                                    class="w-full bg-gray-50 rounded-lg overflow-hidden cursor-zoom-in group mb-3 md:mb-4">
                                    <img src="{{ asset('uploads/products/' . $product->product_image) }}"
                                        alt="{{ $product->product_title }}" id="mainDisplayImage"
                                        class="w-full h-[250px] sm:h-[300px] md:h-[350px] object-contain p-3 sm:p-4 md:p-6 group-hover:scale-105 transition-transform duration-500">
                                </button>

                                <!-- Thumbnail Gallery - Grid 2 rows x 3 cols on mobile, horizontal scroll on desktop -->
                                @if ($product->images->count() > 0)
                                    <div class="relative mt-3">
                                        <!-- Photo Count Badge - Mobile Friendly -->
                                        @if ($product->images->count() > 0)
                                            <div class="mb-2 flex items-center justify-between">
                                                <p class="text-xs sm:text-sm text-gray-600 font-medium">
                                                    <i class="fas fa-images mr-1.5 text-blue-600"></i>
                                                    {{ $product->images->count() + 1 }} Foto
                                                </p>
                                                <p class="hidden md:block text-xs text-gray-400">Geser untuk melihat lebih banyak</p>
                                            </div>
                                        @endif
                                        
                                        <!-- Mobile: Grid 2 rows x 3 cols -->
                                        <div class="md:hidden">
                                            @php
                                                $allImages = collect([['path' => $product->product_image, 'index' => 0]])->merge(
                                                    $product->images->map(function($img, $idx) {
                                                        return ['path' => $img->image_path, 'index' => $idx + 1];
                                                    })
                                                );
                                                $firstRow = $allImages->take(3);
                                                $secondRow = $allImages->skip(3)->take(3);
                                            @endphp
                                            
                                            <!-- Baris Pertama (3 gambar) -->
                                            <div class="grid grid-cols-3 gap-2.5 mb-2.5">
                                                @foreach ($firstRow as $imgData)
                                                    <button
                                                        onclick="changeMainImage('{{ asset('uploads/products/' . $imgData['path']) }}', {{ $imgData['index'] }})"
                                                        class="thumbnail-btn w-full aspect-square bg-white rounded-lg border-2 {{ $imgData['index'] === 0 ? 'border-blue-500' : 'border-gray-200' }} overflow-hidden hover:border-blue-500 active:scale-95 transition-all relative shadow-sm">
                                                        <img src="{{ asset('uploads/products/' . $imgData['path']) }}"
                                                            alt="{{ $imgData['index'] === 0 ? $product->product_title : 'Gambar tambahan' }}"
                                                            class="w-full h-full object-contain p-1.5">
                                                    </button>
                                                @endforeach
                                            </div>
                                            
                                            <!-- Baris Kedua (3 gambar) -->
                                            @if ($secondRow->count() > 0)
                                                <div class="grid grid-cols-3 gap-2.5">
                                                    @foreach ($secondRow as $imgData)
                                                        <button
                                                            onclick="changeMainImage('{{ asset('uploads/products/' . $imgData['path']) }}', {{ $imgData['index'] }})"
                                                            class="thumbnail-btn w-full aspect-square bg-white rounded-lg border-2 border-gray-200 overflow-hidden hover:border-blue-500 active:scale-95 transition-all relative shadow-sm">
                                                            <img src="{{ asset('uploads/products/' . $imgData['path']) }}"
                                                                alt="Gambar tambahan"
                                                                class="w-full h-full object-contain p-1.5">
                                                        </button>
                                                    @endforeach
                                                    
                                                    <!-- Jika kurang dari 3 gambar di baris kedua, isi dengan empty space -->
                                                    @if ($secondRow->count() < 3)
                                                        @for ($i = $secondRow->count(); $i < 3; $i++)
                                                            <div class="aspect-square"></div>
                                                        @endfor
                                                    @endif
                                                </div>
                                            @endif
                                        </div>
                                        
                                        <!-- Desktop: Horizontal Scroll -->
                                        <div class="hidden md:flex gap-2.5 sm:gap-3 overflow-x-auto pb-3 scrollbar-thin scrollbar-thumb-gray-300 scrollbar-track-gray-100 snap-x snap-mandatory -mx-1 px-1">
                                            <!-- Main Image Thumbnail -->
                                            <button
                                                onclick="changeMainImage('{{ asset('uploads/products/' . $product->product_image) }}', 0)"
                                                class="thumbnail-btn flex-shrink-0 w-20 h-20 bg-white rounded-lg border-2 border-blue-500 overflow-hidden hover:border-blue-600 active:scale-95 transition-all snap-start relative shadow-sm">
                                                <img src="{{ asset('uploads/products/' . $product->product_image) }}"
                                                    alt="{{ $product->product_title }}"
                                                    class="w-full h-full object-contain p-1.5">
                                            </button>

                                            <!-- Additional Images Thumbnails -->
                                            @foreach ($product->images as $index => $img)
                                                <button
                                                    onclick="changeMainImage('{{ asset('uploads/products/' . $img->image_path) }}', {{ $index + 1 }})"
                                                    class="thumbnail-btn flex-shrink-0 w-20 h-20 bg-white rounded-lg border-2 border-gray-200 hover:border-blue-500 active:scale-95 overflow-hidden transition-all snap-start relative shadow-sm">
                                                    <img src="{{ asset('uploads/products/' . $img->image_path) }}"
                                                        alt="Gambar tambahan" class="w-full h-full object-contain p-1.5">
                                                </button>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            </div>

                        </div>
                    </div>

                    <!-- Product Details Tabs -->
                    <div class="bg-white rounded-lg shadow-lg border border-gray-100 overflow-hidden">
                        <div class="border-b border-gray-200 bg-gray-50">
                            <div class="flex items-center justify-between px-3 sm:px-4 md:px-6 pt-3 sm:pt-4">
                                <nav class="flex space-x-3 sm:space-x-4 md:space-x-6 overflow-x-auto scrollbar-hide" aria-label="Tabs">
                                    <button
                                        class="detail-tab active py-3 sm:py-4 border-b-2 border-blue-600 font-medium text-xs sm:text-sm text-blue-600 whitespace-nowrap"
                                        data-tab="detail">Detail Produk</button>
                                    @if ($product->specifications->count() > 0)
                                        <button
                                            class="detail-tab py-3 sm:py-4 border-b-2 border-transparent font-medium text-xs sm:text-sm text-gray-500 hover:text-gray-700 whitespace-nowrap"
                                            data-tab="specifications">Spesifikasi</button>
                                    @endif
                                </nav>
                                <!-- Link ke Portfolio Detail -->
                                <a href="{{ route('portfolio.detail', $product->id) }}" 
                                    class="hidden sm:flex items-center gap-2 text-xs sm:text-sm text-blue-600 hover:text-blue-700 font-medium whitespace-nowrap ml-4 px-3 py-2 rounded-lg hover:bg-blue-50 transition-colors">
                                    <i class="fas fa-award text-xs"></i>
                                    <span>Lihat Portfolio</span>
                                </a>
                            </div>
                        </div>

                        <div class="p-4 sm:p-5 md:p-6">
                            <!-- Detail Produk Tab -->
                            <div id="detail-content" class="detail-content">
                                <div class="space-y-3 sm:space-y-0">
                                    @if($product->product_description)
                                    <div class="border-b border-gray-100 pb-3 sm:pb-0 sm:table-row hover:bg-gray-50 transition-colors">
                                        <div class="block sm:table-cell sm:py-3 sm:pr-4">
                                            <div class="text-xs sm:text-sm text-gray-600 font-medium mb-1 sm:mb-0">Deskripsi</div>
                                        </div>
                                        <div class="block sm:table-cell sm:py-3">
                                            <div class="text-xs sm:text-sm text-gray-900 leading-relaxed">{{ $product->product_description }}</div>
                                        </div>
                                    </div>
                                    @endif
                                    @if($product->product_work_duration)
                                    <div class="border-b border-gray-100 pb-3 sm:pb-0 sm:table-row hover:bg-gray-50 transition-colors">
                                        <div class="block sm:table-cell sm:py-3 sm:pr-4">
                                            <div class="text-xs sm:text-sm text-gray-600 font-medium mb-1 sm:mb-0">
                                                <i class="far fa-clock mr-2 text-blue-600"></i>Lama Pengerjaan
                                            </div>
                                        </div>
                                        <div class="block sm:table-cell sm:py-3">
                                            <div class="text-xs sm:text-sm text-gray-900 font-medium">
                                                {{ $product->product_work_duration }}
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                    @if($product->product_garansi)
                                    <div class="border-b border-gray-100 pb-3 sm:pb-0 sm:table-row hover:bg-gray-50 transition-colors">
                                        <div class="block sm:table-cell sm:py-3 sm:pr-4">
                                            <div class="text-xs sm:text-sm text-gray-600 font-medium mb-1 sm:mb-0">
                                                <i class="fas fa-shield-alt mr-2 text-blue-600"></i>Garansi
                                            </div>
                                        </div>
                                        <div class="block sm:table-cell sm:py-3">
                                            <div class="text-xs sm:text-sm text-gray-900 font-medium">
                                                {{ $product->product_garansi }}
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Spesifikasi Tab -->
                            @if ($product->specifications->count() > 0)
                                <div id="specifications-content" class="detail-content hidden">
                                    <div class="space-y-3 sm:space-y-0">
                                        @foreach ($product->specifications as $spec)
                                            <div class="border-b border-gray-100 pb-3 sm:pb-0 sm:table-row hover:bg-gray-50 transition-colors">
                                                <div class="block sm:table-cell sm:py-3 sm:pr-4 sm:w-1/3">
                                                    <div class="text-xs sm:text-sm text-gray-600 font-medium mb-1 sm:mb-0">{{ $spec->key }}</div>
                                                </div>
                                                <div class="block sm:table-cell sm:py-3">
                                                    <div class="text-xs sm:text-sm text-gray-900">{{ $spec->value }}</div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        </div>
                        
                        <!-- Link Portfolio untuk Mobile -->
                        <div class="sm:hidden px-4 pb-4 pt-4 border-t border-gray-200">
                            <a href="{{ route('portfolio.detail', $product->id) }}" 
                                class="flex items-center justify-center gap-2 text-sm text-blue-600 hover:text-blue-700 font-medium px-4 py-2 rounded-lg border border-blue-200 hover:bg-blue-50 transition-colors">
                                <i class="fas fa-award"></i>
                                <span>Lihat Portfolio Lengkap</span>
                                <i class="fas fa-arrow-right text-xs"></i>
                            </a>
                        </div>
                    </div>

                </div>

                <!-- Right Section: Purchase Panel (1 column) -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-lg shadow-lg border border-gray-100 p-4 sm:p-5 md:p-6 lg:sticky lg:top-6">

                        <!-- Product Title -->
                        <h1 class="text-lg sm:text-xl md:text-2xl font-bold text-gray-900 mb-3 sm:mb-4 leading-tight">{{ $product->product_title }}
                        </h1>
                        
                        <!-- Category Badge -->
                        @if($product->category)
                        <div class="mb-3 sm:mb-4">
                            <span class="inline-flex items-center px-2.5 sm:px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                <i class="fas fa-tag mr-1.5 text-xs"></i>
                                {{ $product->category->name }}
                            </span>
                        </div>
                        @endif

                        <!-- Price -->
                        <div class="mb-4 sm:mb-6 pb-4 sm:pb-6 border-b border-gray-200">
                            <p class="text-xs sm:text-sm text-gray-600 mb-1.5 sm:mb-2">Harga</p>
                            <p class="text-2xl sm:text-3xl md:text-4xl font-bold text-blue-600" id="displayPrice">
                                Rp {{ number_format($product->product_prices, 0, ',', '.') }}
                            </p>
                        </div>

                        <!-- Quantity Selector -->
                        {{-- <div class="mb-4 md:mb-6">
                            <p class="text-sm font-semibold text-gray-700 mb-2 md:mb-3">Jumlah</p>
                            <div class="flex items-center border border-gray-300 rounded-lg w-full">
                                <button onclick="decreaseQty()"
                                    class="px-4 py-3 text-gray-600 hover:bg-gray-100 transition">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M20 12H4" />
                                    </svg>
                                </button>
                                <input type="number" id="quantity" value="1" min="1"
                                    max="{{ $product->product_quantity }}"
                                    class="flex-1 text-center py-3 border-x border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500"
                                    onchange="updatePrice()">
                                <button onclick="increaseQty()"
                                    class="px-4 py-3 text-gray-600 hover:bg-gray-100 transition">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 4v16m8-8H4" />
                                    </svg>
                                </button>
                            </div>
                            <p class="text-xs text-gray-500 mt-2">Tersedia: {{ $product->product_quantity }} Unit</p>
                        </div> --}}

                        <!-- Subtotal -->
                        {{-- <div class="mb-4 md:mb-6 pb-4 md:pb-6 border-b border-gray-200">
                            <div class="flex justify-between items-center">
                                <p class="text-sm text-gray-600">Subtotal</p>
                                <p class="text-lg md:text-xl font-bold text-gray-900" id="subtotalPrice">
                                    Rp {{ number_format($product->product_prices, 0, ',', '.') }}
                                </p>
                            </div>
                        </div> --}}

                        <!-- Product Info Quick -->
                        <div class="mb-6 space-y-3">
                            @if($product->product_work_duration)
                            <div class="flex items-center text-sm text-gray-700">
                                <i class="far fa-clock w-5 text-blue-600"></i>
                                <span class="ml-2">{{ $product->product_work_duration }}</span>
                            </div>
                            @endif
                            @if($product->product_garansi)
                            <div class="flex items-center text-sm text-gray-700">
                                <i class="fas fa-shield-alt w-5 text-blue-600"></i>
                                <span class="ml-2">{{ $product->product_garansi }}</span>
                            </div>
                            @endif
                        </div>

                        <!-- Action Buttons -->
                        <div class="space-y-3">
                            @auth
                                {{-- Jika user sudah login --}}
                                <a href="{{ route('checkout.form', $product->id) }}"
                                    class="w-full bg-blue-600 text-white px-6 py-3.5 rounded-lg font-semibold hover:bg-blue-700 transition-all duration-300 flex items-center justify-center shadow-md hover:shadow-lg">
                                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                                    </svg>
                                    Pesan Sekarang
                                </a>
                            @else
                                {{-- Jika belum login --}}
                                <a href="{{ route('login') }}"
                                    class="w-full bg-blue-600 text-white px-6 py-3.5 rounded-lg font-semibold hover:bg-blue-700 transition-all duration-300 flex items-center justify-center shadow-md hover:shadow-lg">
                                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                                    </svg>
                                    Pesan Sekarang
                                </a>
                            @endauth

                            {{-- Tombol Tanya Produk --}}
                            <button onclick="handleAskProduct()"
                                class="w-full border-2 border-blue-600 text-blue-700 px-6 py-3.5 rounded-lg font-semibold hover:bg-blue-50 transition-all duration-300 flex items-center justify-center">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" />
                                </svg>
                                Ajukan Penawaran
                            </button>
                        </div>

                        {{-- Modal Form Ajukan Penawaran (Wizard) --}}
                        <div id="askProductModal"
                            class="fixed inset-0 bg-black/60 backdrop-blur-sm z-[100] hidden items-center justify-center p-4 pt-16 sm:pt-20 md:pt-32">
                            <div class="bg-white rounded-xl shadow-2xl max-w-lg w-full border border-gray-100 max-h-[70vh] sm:max-h-[75vh] md:max-h-[80vh] overflow-hidden flex flex-col mt-0">
                                <!-- Modal Header -->
                                <div class="px-6 py-5 border-b border-gray-200 bg-gradient-to-r from-blue-50 to-indigo-50 flex-shrink-0">
                                    <div class="flex items-center justify-between">
                                        <div class="flex items-center space-x-3">
                                            <div class="flex-shrink-0 w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                                                <i class="fas fa-file-invoice-dollar text-blue-600 text-lg"></i>
                                            </div>
                                            <div>
                                                <h3 class="text-lg font-semibold text-gray-900">Ajukan Penawaran</h3>
                                                <p class="text-xs text-gray-500">Isi data kontak dan detail penawaran</p>
                                            </div>
                                        </div>
                                        <button onclick="closeAskProductModal()"
                                            class="text-gray-400 hover:text-gray-600 hover:bg-white rounded-lg p-2 transition-all">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                            </svg>
                                        </button>
                                    </div>
                                    <!-- Step Indicator -->
                                    <div class="mt-4 flex items-center space-x-2 text-xs">
                                        <div id="askStepIndicator1" class="flex items-center">
                                            <span class="w-6 h-6 rounded-full flex items-center justify-center bg-blue-600 text-white font-bold">1</span>
                                            <span class="ml-2 text-gray-700">Data Kontak</span>
                                        </div>
                                        <span class="text-gray-400">›</span>
                                        <div id="askStepIndicator2" class="flex items-center opacity-60">
                                            <span class="w-6 h-6 rounded-full flex items-center justify-center bg-gray-200 text-gray-600 font-bold">2</span>
                                            <span class="ml-2 text-gray-500">Detail Penawaran</span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Modal Body -->
                                <div class="flex-1 overflow-y-auto overflow-x-hidden p-4 md:p-6 bg-gray-50 scrollbar-modal min-h-0" style="scrollbar-width: thin; scrollbar-color: #94a3b8 #e5e7eb; -webkit-overflow-scrolling: touch;">
                                    <!-- Success View -->
                                    <div id="askSuccessView" class="hidden">
                                        <div class="text-center">
                                            <div class="mx-auto w-16 h-16 rounded-full bg-green-100 flex items-center justify-center">
                                                <i class="fas fa-check text-green-600 text-2xl"></i>
                                            </div>
                                            <h4 class="mt-4 text-lg font-semibold text-gray-900">Permintaan penawaran terkirim</h4>
                                            <p class="mt-1 text-sm text-gray-600">Kami telah mengirim kode pelacakan ke email Anda.</p>
                                            <div class="mt-4 bg-white border border-gray-200 rounded-lg p-4 text-left">
                                                <div class="flex items-center justify-between">
                                                    <div>
                                                        <p class="text-xs text-gray-500">Kode Pelacakan</p>
                                                        <p id="askTrackingCode" class="text-sm font-semibold text-gray-900">-</p>
                                                    </div>
                                                    <button type="button" id="askCopyTrackingBtn" class="px-3 py-2 text-xs bg-gray-100 hover:bg-gray-200 rounded-md font-medium">Salin</button>
                                                </div>
                                                <div class="mt-3">
                                                    <a id="askTrackingLink" href="#" target="_blank" class="text-blue-600 hover:text-blue-700 text-sm font-medium">Lihat status penawaran</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Form Wizard -->
                                    <form id="askProductForm" class="space-y-5">
                                        @csrf
                                        <input type="hidden" id="product_id" name="product_id" value="{{ $product->id }}">

                                        <!-- STEP 1: Data Kontak -->
                                        <div id="askStep1" class="space-y-5">
                                            <!-- Nama -->
                                            <div>
                                                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
                                                    <i class="fas fa-user mr-2 text-gray-400"></i>Nama Lengkap
                                                </label>
                                                <input type="text" id="name" name="name" required placeholder="Masukkan nama lengkap Anda"
                                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all"
                                                    @auth value="{{ auth()->user()->name }}" @endauth>
                                            </div>

                                            <!-- Email -->
                                            <div>
                                                <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                                                    <i class="fas fa-envelope mr-2 text-gray-400"></i>Email
                                                </label>
                                                <input type="email" id="email" name="email" required placeholder="Masukkan alamat email"
                                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all"
                                                    @auth value="{{ auth()->user()->email }}" @endauth>
                                            </div>

                                            <!-- Phone -->
                                            <div>
                                                <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">
                                                    <i class="fas fa-phone mr-2 text-gray-400"></i>No Telepon
                                                </label>
                                                <input type="tel" id="phone" name="phone" required placeholder="Masukkan nomor telepon"
                                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all"
                                                    @auth value="{{ auth()->user()->phone ?? '' }}" @endauth>
                                            </div>

                                            <p class="text-xs text-gray-500">Data kontak digunakan untuk mengirim balasan penawaran.</p>
                                        </div>

                                        <!-- STEP 2: Detail Penawaran -->
                                        <div id="askStep2" class="space-y-5 hidden">
                                            <div class="bg-white border border-gray-200 rounded-lg p-4">
                                                <p class="text-xs text-gray-500">Produk</p>
                                                <p class="text-sm font-semibold text-gray-900">{{ $product->product_title }}</p>
                                            </div>

                                            <div>
                                                <label class="block text-sm font-medium text-gray-700 mb-2">Jenis Permintaan</label>
                                                <div class="space-y-2">
                                                    <label class="flex items-center gap-2 text-sm text-gray-700">
                                                        <input type="radio" name="request_type" value="template" class="text-blue-600" checked>
                                                        Produk sesuai katalog
                                                    </label>
                                                    <label class="flex items-center gap-2 text-sm text-gray-700">
                                                        <input type="radio" name="request_type" value="custom_addon" class="text-blue-600">
                                                        Produk dengan tambahan custom
                                                    </label>
                                                    <label class="flex items-center gap-2 text-sm text-gray-700">
                                                        <input type="radio" name="request_type" value="custom_new" class="text-blue-600">
                                                        Produk custom (baru)
                                                    </label>
                                                </div>
                                            </div>

                                            <div id="addonContainer" class="hidden space-y-3">
                                                <div id="addonList" class="space-y-2"></div>
                                                <button type="button" id="addAddonBtn" class="w-full px-4 py-3 bg-blue-50 hover:bg-blue-100 active:bg-blue-200 border-2 border-blue-300 hover:border-blue-400 text-blue-700 hover:text-blue-800 rounded-lg text-sm font-semibold transition-all duration-200 shadow-sm hover:shadow-md flex items-center justify-center gap-2">
                                                    <i class="fas fa-plus-circle text-base"></i>
                                                    <span>Tambah Spesifikasi</span>
                                                </button>
                                            </div>

                                            <div>
                                                <label for="message" class="block text-sm font-medium text-gray-700 mb-2">
                                                    <i class="fas fa-comment-alt mr-2 text-gray-400"></i>Detail Pertanyaan/Penawaran
                                                </label>
                                                <textarea id="message" name="message" rows="4" required placeholder="Ceritakan kebutuhan atau detail penawaran yang diinginkan..."
                                                    class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 resize-none transition-all"></textarea>
                                            </div>
                                        </div>
                                    </form>
                                </div>

                                <!-- Modal Footer -->
                                <div id="askModalFooter" class="px-3 sm:px-6 py-3 sm:py-4 border-t border-gray-200 bg-white flex-shrink-0">
                                    <!-- Step 1: Batal & Lanjut -->
                                    <div id="askFooterStep1" class="flex justify-between items-center gap-2 sm:gap-3">
                                        <button type="button" onclick="closeAskProductModal()"
                                            class="flex-1 sm:flex-none px-3 sm:px-5 py-2.5 sm:py-3 text-xs sm:text-sm text-gray-700 bg-gray-100 hover:bg-gray-200 active:bg-gray-300 rounded-lg font-medium transition-all duration-200 flex items-center justify-center shadow-sm">
                                            <i class="fas fa-times mr-1.5 sm:mr-2 text-xs"></i>
                                            <span>Batal</span>
                                        </button>
                                        <button type="button" id="askNextBtn" onclick="goToAskStep(2)" class="flex-1 sm:flex-none px-3 sm:px-5 py-2.5 sm:py-3 text-xs sm:text-sm bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-lg font-medium hover:from-blue-700 hover:to-indigo-700 active:from-blue-800 active:to-indigo-800 transition-all duration-200 shadow-md hover:shadow-lg flex items-center justify-center">
                                            <span>Lanjut</span>
                                        </button>
                                    </div>
                                    <!-- Step 2: Batal, Kembali & Kirim -->
                                    <div id="askFooterStep2" class="hidden flex flex-col sm:flex-row justify-between items-stretch sm:items-center gap-2 sm:gap-3">
                                        <button type="button" onclick="closeAskProductModal()"
                                            class="order-3 sm:order-1 flex-1 sm:flex-none px-3 sm:px-5 py-2.5 sm:py-3 text-xs sm:text-sm text-gray-700 bg-gray-100 hover:bg-gray-200 active:bg-gray-300 rounded-lg font-medium transition-all duration-200 flex items-center justify-center shadow-sm">
                                            <i class="fas fa-times mr-1.5 sm:mr-2 text-xs"></i>
                                            <span>Batal</span>
                                        </button>
                                        <button type="button" id="askPrevBtn" onclick="goToAskStep(1)" class="order-2 flex-1 sm:flex-none px-3 sm:px-5 py-2.5 sm:py-3 text-xs sm:text-sm text-gray-700 bg-gray-100 hover:bg-gray-200 active:bg-gray-300 rounded-lg font-medium transition-all duration-200 flex items-center justify-center shadow-sm">
                                            <i class="fas fa-arrow-left mr-1.5 sm:mr-2 text-xs"></i>
                                            <span>Kembali</span>
                                        </button>
                                        <button type="submit" id="askSubmitBtn" form="askProductForm" class="order-1 sm:order-3 flex-1 sm:flex-none px-3 sm:px-5 py-2.5 sm:py-3 text-xs sm:text-sm bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-lg font-medium hover:from-blue-700 hover:to-indigo-700 active:from-blue-800 active:to-indigo-800 transition-all duration-200 shadow-md hover:shadow-lg flex items-center justify-center">
                                            <i class="fas fa-paper-plane mr-1.5 sm:mr-2 text-xs"></i>
                                            <span>Kirim</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </div>

    <!-- Gallery Modal -->
    <div id="galleryModal" class="fixed inset-0 bg-black bg-opacity-95 z-[100] hidden items-center justify-center p-2 md:p-4"
        onclick="closeGallery()">
        <div class="relative w-full max-w-6xl h-full max-h-screen flex flex-col min-h-0" onclick="event.stopPropagation()">

            <!-- Modal Header -->
            <div class="flex items-center justify-between mb-2 md:mb-4 flex-shrink-0 px-2 md:px-0 py-2">
                <h3 class="text-white text-sm md:text-lg font-semibold truncate pr-4">{{ $product->product_title }}</h3>
                <button onclick="closeGallery()" class="text-white hover:text-gray-300 transition flex-shrink-0 z-20 bg-black bg-opacity-50 rounded-full p-2">
                    <svg class="w-5 h-5 md:w-6 md:h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>

            <!-- Main Image Container -->
            <div class="flex-1 flex items-center justify-center mb-2 md:mb-4 overflow-hidden min-h-0 relative px-2" style="min-height: 200px;">
                <img id="galleryMainImage" src="" alt="Product Image"
                    class="w-full h-full max-w-full max-h-full object-contain rounded-lg block transition-opacity duration-300"
                    style="max-height: calc(100vh - 200px);">
            </div>

            <!-- Thumbnail Navigation -->
            @php
                $totalImages = 1 + $product->images->count();
            @endphp
            @if ($totalImages > 1)
            <div class="bg-gray-900 bg-opacity-50 rounded-lg p-2 sm:p-3 md:p-4 flex-shrink-0">
                <div class="flex gap-2 sm:gap-2.5 md:gap-3 overflow-x-auto justify-center snap-x snap-mandatory pb-1">
                    <!-- Main Product Image Thumbnail -->
                    <button onclick="changeGalleryImage('{{ asset('uploads/products/' . $product->product_image) }}', 0)"
                        class="gallery-thumb flex-shrink-0 w-16 h-16 sm:w-18 sm:h-18 md:w-20 md:h-20 rounded-lg overflow-hidden border-2 border-white transition-all hover:border-blue-400 active:scale-95 snap-start">
                        <img src="{{ asset('uploads/products/' . $product->product_image) }}"
                            alt="{{ $product->product_title }}" class="w-full h-full object-cover">
                    </button>

                    <!-- Additional Images Thumbnails -->
                    @foreach ($product->images as $index => $img)
                        <button
                            onclick="changeGalleryImage('{{ asset('uploads/products/' . $img->image_path) }}', {{ $index + 1 }})"
                            class="gallery-thumb flex-shrink-0 w-16 h-16 sm:w-18 sm:h-18 md:w-20 md:h-20 rounded-lg overflow-hidden border-2 border-gray-600 transition-all hover:border-blue-400 active:scale-95 snap-start">
                            <img src="{{ asset('uploads/products/' . $img->image_path) }}" alt="Gambar tambahan"
                                class="w-full h-full object-cover">
                        </button>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Navigation Arrows - Visible on Mobile and Desktop (only if more than 1 image) -->
            @if ($totalImages > 1)
            <button onclick="prevImage()"
                class="absolute left-2 md:left-4 top-1/2 -translate-y-1/2 bg-white bg-opacity-80 hover:bg-opacity-100 text-gray-900 p-2.5 md:p-3 rounded-full transition z-20 shadow-lg">
                <svg class="w-5 h-5 md:w-6 md:h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                </svg>
            </button>
            <button onclick="nextImage()"
                class="absolute right-2 md:right-4 top-1/2 -translate-y-1/2 bg-white bg-opacity-80 hover:bg-opacity-100 text-gray-900 p-2.5 md:p-3 rounded-full transition z-20 shadow-lg">
                <svg class="w-5 h-5 md:w-6 md:h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
            </button>
            @endif

        </div>
    </div>

    <!-- SweetAlert2 CDN -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        const basePrice = {{ $product->product_prices }};

        // Gallery Images Array
        const galleryImages = [
            '{{ asset('uploads/products/' . $product->product_image) }}',
            @foreach ($product->images as $img)
                '{{ asset('uploads/products/' . $img->image_path) }}',
            @endforeach
        ];
        let currentImageIndex = 0;

        // Quantity Functions
        function updatePrice() {
            const quantity = parseInt(document.getElementById('quantity').value) || 1;
            const validQuantity = Math.max(1, quantity);

            document.getElementById('quantity').value = validQuantity;

            const totalPrice = basePrice * validQuantity;
            document.getElementById('subtotalPrice').textContent = 'Rp ' + formatNumber(totalPrice);
        }

        function increaseQty() {
            const qtyInput = document.getElementById('quantity');
            const currentQty = parseInt(qtyInput.value) || 1;

            // Tidak dibatasi stok
            qtyInput.value = currentQty + 1;
            updatePrice();
        }

        function decreaseQty() {
            const qtyInput = document.getElementById('quantity');
            const currentQty = parseInt(qtyInput.value) || 1;

            if (currentQty > 1) {
                qtyInput.value = currentQty - 1;
                updatePrice();
            }
        }


        function formatNumber(num) {
            return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
        }

        // Image Display Functions
        function changeMainImage(imageSrc, index) {
            document.getElementById('mainDisplayImage').src = imageSrc;
            currentImageIndex = index;

            // Update thumbnail borders
            const thumbnails = document.querySelectorAll('.thumbnail-btn');
            thumbnails.forEach((thumb, i) => {
                if (i === index) {
                    thumb.classList.remove('border-gray-200');
                    thumb.classList.add('border-blue-500');
                } else {
                    thumb.classList.remove('border-blue-500');
                    thumb.classList.add('border-gray-200');
                }
            });
        }

        // Gallery Modal Functions
        function openGallery(index) {
            currentImageIndex = index || 0;
            const modal = document.getElementById('galleryModal');
            const mainImage = document.getElementById('galleryMainImage');

            if (!mainImage || !galleryImages || galleryImages.length === 0) {
                console.error('Gallery image not found');
                return;
            }

            if (index >= galleryImages.length) {
                currentImageIndex = 0;
            }

            // Show modal first
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.style.overflow = 'hidden';

            // Set image source immediately
            const imageUrl = galleryImages[currentImageIndex];
            mainImage.style.opacity = '0.3';
            mainImage.style.display = 'block';
            
            // Preload image for smooth transition
            const img = new Image();
            img.onload = function() {
                mainImage.src = imageUrl;
                mainImage.style.opacity = '1';
            };
            img.onerror = function() {
                console.error('Failed to load image:', imageUrl);
                mainImage.src = imageUrl;
                mainImage.style.opacity = '1';
            };
            img.src = imageUrl;

            // Show/hide navigation arrows based on image count
            const prevBtn = modal.querySelector('button[onclick="prevImage()"]');
            const nextBtn = modal.querySelector('button[onclick="nextImage()"]');
            if (galleryImages.length > 1) {
                if (prevBtn) prevBtn.style.display = 'block';
                if (nextBtn) nextBtn.style.display = 'block';
            } else {
                if (prevBtn) prevBtn.style.display = 'none';
                if (nextBtn) nextBtn.style.display = 'none';
            }

            updateGalleryThumbs();
        }

        function closeGallery() {
            const modal = document.getElementById('galleryModal');
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.style.overflow = 'auto';
        }

        function changeGalleryImage(imageSrc, index) {
            currentImageIndex = index;
            const mainImage = document.getElementById('galleryMainImage');
            if (mainImage) {
                mainImage.style.opacity = '0.5';
                mainImage.src = imageSrc;
                mainImage.onload = function() {
                    mainImage.style.opacity = '1';
                };
            }
            updateGalleryThumbs();
        }

        function updateGalleryThumbs() {
            const thumbs = document.querySelectorAll('.gallery-thumb');
            thumbs.forEach((thumb, i) => {
                if (i === currentImageIndex) {
                    thumb.classList.remove('border-gray-600');
                    thumb.classList.add('border-white');
                } else {
                    thumb.classList.remove('border-white');
                    thumb.classList.add('border-gray-600');
                }
            });
        }

        function prevImage() {
            if (galleryImages.length <= 1) return;
            currentImageIndex = (currentImageIndex - 1 + galleryImages.length) % galleryImages.length;
            const mainImage = document.getElementById('galleryMainImage');
            if (mainImage) {
                mainImage.style.opacity = '0.5';
                mainImage.src = galleryImages[currentImageIndex];
                mainImage.onload = function() {
                    mainImage.style.opacity = '1';
                };
            }
            updateGalleryThumbs();
        }

        function nextImage() {
            if (galleryImages.length <= 1) return;
            currentImageIndex = (currentImageIndex + 1) % galleryImages.length;
            const mainImage = document.getElementById('galleryMainImage');
            if (mainImage) {
                mainImage.style.opacity = '0.5';
                mainImage.src = galleryImages[currentImageIndex];
                mainImage.onload = function() {
                    mainImage.style.opacity = '1';
                };
            }
            updateGalleryThumbs();
        }

        // Tab Switching
        document.addEventListener('DOMContentLoaded', function() {
            const tabButtons = document.querySelectorAll('.detail-tab');
            const tabContents = document.querySelectorAll('.detail-content');

            tabButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const tabName = button.getAttribute('data-tab');

                    tabButtons.forEach(btn => {
                        btn.classList.remove('active', 'border-blue-600', 'text-blue-600');
                        btn.classList.add('border-transparent', 'text-gray-500');
                    });

                    button.classList.add('active', 'border-blue-600', 'text-blue-600');
                    button.classList.remove('border-transparent', 'text-gray-500');

                    tabContents.forEach(content => {
                        content.classList.add('hidden');
                    });

                    const selectedContent = document.getElementById(tabName + '-content');
                    if (selectedContent) {
                        selectedContent.classList.remove('hidden');
                    }
                });
            });
        });

        // Action Handlers
        function handleBuyNow() {
            const quantity = document.getElementById('quantity').value;
            // Redirect to checkout or show product inquiry form
            // This is just a placeholder - actual implementation depends on your flow
        }

        // Keyboard Navigation for Gallery
        document.addEventListener('keydown', function(e) {
            const modal = document.getElementById('galleryModal');
            if (!modal.classList.contains('hidden')) {
                if (e.key === 'Escape') {
                    closeGallery();
                } else if (e.key === 'ArrowLeft') {
                    prevImage();
                } else if (e.key === 'ArrowRight') {
                    nextImage();
                }
            }
        });

        // Tanya Produk Modal Functions
        function handleAskProduct() {
            const modal = document.getElementById('askProductModal');
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.style.overflow = 'hidden';
            // Reset wizard state
            const successView = document.getElementById('askSuccessView');
            if (successView) successView.classList.add('hidden');
            const form = document.getElementById('askProductForm');
            if (form) form.classList.remove('hidden');
            // Tampilkan footer kembali saat modal dibuka
            const footerEl = document.getElementById('askModalFooter');
            if (footerEl) footerEl.classList.remove('hidden');
            if (typeof goToAskStep === 'function') {
                goToAskStep(1);
            }
            const addonList = document.getElementById('addonList');
            if (addonList) addonList.innerHTML = '';
        }

        function closeAskProductModal() {
            const modal = document.getElementById('askProductModal');
            modal.classList.remove('flex');
            modal.classList.add('hidden');
            document.body.style.overflow = 'auto';
            const form = document.getElementById('askProductForm');
            if (form) {
                form.reset();
                form.classList.remove('hidden');
            }
            const successView = document.getElementById('askSuccessView');
            if (successView) successView.classList.add('hidden');
            // Tampilkan footer kembali saat modal ditutup (reset state)
            const footerEl = document.getElementById('askModalFooter');
            if (footerEl) footerEl.classList.remove('hidden');
            if (typeof goToAskStep === 'function') {
                goToAskStep(1);
            }
        }

        // Tutup modal jika klik di luar
        document.addEventListener('click', function(e) {
            const modal = document.getElementById('askProductModal');
            if (e.target === modal) {
                closeAskProductModal();
            }
        });

        // Keyboard ESC for modal
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                const askModal = document.getElementById('askProductModal');
                if (!askModal.classList.contains('hidden')) {
                    closeAskProductModal();
                }
            }
        });

        // Wizard Controls for Ask Product
        function goToAskStep(step) {
            const step1 = document.getElementById('askStep1');
            const step2 = document.getElementById('askStep2');
            const ind1 = document.getElementById('askStepIndicator1');
            const ind2 = document.getElementById('askStepIndicator2');
            const footerStep1 = document.getElementById('askFooterStep1');
            const footerStep2 = document.getElementById('askFooterStep2');

            if (!step1 || !step2) return;

            if (step === 1) {
                step1.classList.remove('hidden');
                step2.classList.add('hidden');
                if (ind1 && ind2) {
                    ind1.classList.remove('opacity-60');
                    ind2.classList.add('opacity-60');
                    const i1 = ind1.querySelector('span.w-6');
                    const i2 = ind2.querySelector('span.w-6');
                    if (i1 && i2) {
                        i1.classList.add('bg-blue-600','text-white');
                        i1.classList.remove('bg-gray-200','text-gray-600');
                        i2.classList.add('bg-gray-200','text-gray-600');
                        i2.classList.remove('bg-blue-600','text-white');
                    }
                }
                if (footerStep1) footerStep1.classList.remove('hidden');
                if (footerStep2) footerStep2.classList.add('hidden');
            } else {
                step1.classList.add('hidden');
                step2.classList.remove('hidden');
                if (ind1 && ind2) {
                    ind1.classList.add('opacity-60');
                    ind2.classList.remove('opacity-60');
                    const i1 = ind1.querySelector('span.w-6');
                    const i2 = ind2.querySelector('span.w-6');
                    if (i1 && i2) {
                        i1.classList.add('bg-gray-200','text-gray-600');
                        i1.classList.remove('bg-blue-600','text-white');
                        i2.classList.add('bg-blue-600','text-white');
                        i2.classList.remove('bg-gray-200','text-gray-600');
                    }
                }
                if (footerStep1) footerStep1.classList.add('hidden');
                if (footerStep2) footerStep2.classList.remove('hidden');
            }
        }

        // Submit Handler dengan Fix CSRF & Timeout
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('askProductForm');
            const addBtn = document.getElementById('addAddonBtn');
            const addonContainer = document.getElementById('addonContainer');
            const addonList = document.getElementById('addonList');
            const typeRadios = document.querySelectorAll('input[name="request_type"]');

            function toggleAddonFields() {
                const selected = document.querySelector('input[name="request_type"]:checked')?.value;
                if (selected === 'custom_addon') {
                    addonContainer?.classList.remove('hidden');
                    if (addonList && addonList.children.length === 0) addAddonRow();
                } else {
                    addonContainer?.classList.add('hidden');
                }
            }

            function addAddonRow() {
                const row = document.createElement('div');
                row.className = 'flex items-center gap-2';
                row.innerHTML = `
                    <input type="text" name="addon_name[]" placeholder="Nama spesifikasi" class="flex-1 px-3 py-2 bg-white border border-gray-300 rounded-md text-sm" />
                    <input type="text" name="addon_value[]" placeholder="Nilai/Detail" class="flex-1 px-3 py-2 bg-white border border-gray-300 rounded-md text-sm" />
                    <button type="button" class="px-3 py-2 bg-red-100 hover:bg-red-200 text-red-700 rounded-md text-xs removeAddonBtn">Hapus</button>
                `;
                addonList?.appendChild(row);
                const removeBtn = row.querySelector('.removeAddonBtn');
                removeBtn?.addEventListener('click', function() { row.remove(); });
            }

            typeRadios.forEach(r => r.addEventListener('change', toggleAddonFields));
            addBtn?.addEventListener('click', addAddonRow);
            toggleAddonFields();
            if (form) {
                form.addEventListener('submit', function(e) {
                    e.preventDefault();
                    console.log('Submit triggered!');

                    const formData = new FormData(this);
                    console.log('Form data:', Object.fromEntries(formData));
                    const submitBtn = document.getElementById('askSubmitBtn');
                    if (submitBtn) {
                        submitBtn.disabled = true;
                        submitBtn.textContent = 'Mengirim...';
                    }

                    const token = document.querySelector('meta[name="csrf-token"]')?.getAttribute(
                        'content');
                    if (!token) {
                        Swal.fire({
                            icon: 'error',
                            title: 'CSRF Token Tidak Ditemukan',
                            text: 'Refresh halaman dan coba lagi.',
                            confirmButtonColor: '#2563eb',
                            confirmButtonText: 'Mengerti',
                            position: 'center'
                        });
                        if (submitBtn) submitBtn.disabled = false, submitBtn.textContent = 'Kirim';
                        return;
                    }

                    const reqType = document.querySelector('input[name="request_type"]:checked')?.value || 'template';
                    const addons = [];
                    const names = document.querySelectorAll('input[name="addon_name[]"]');
                    const values = document.querySelectorAll('input[name="addon_value[]"]');
                    names.forEach((n, i) => {
                        const nameVal = n.value?.trim();
                        const valueVal = values[i]?.value?.trim();
                        if (nameVal || valueVal) addons.push({ name: nameVal || '-', value: valueVal || '-' });
                    });
                    const originalMsg = (formData.get('message') || '').toString();
                    let prefix = `[REQUEST_TYPE] ${reqType}`;
                    if (reqType === 'custom_addon' && addons.length > 0) {
                        prefix += `\n[ADDONS] ${JSON.stringify(addons)}`;
                    }
                    if (reqType === 'custom_new') {
                        prefix += `\n[NOTE] Permintaan mesin baru`;
                    }
                    formData.set('message', `${prefix}\n\n${originalMsg}`);

                    const url = '{{ route('product.inquiry.store') }}' || '/product-inquiry';
                    console.log('URL:', url, 'Token:', token);

                    fetch(url, {
                            method: 'POST',
                            body: formData,
                            headers: {
                                'X-CSRF-TOKEN': token,
                                'Accept': 'application/json',
                                'X-Requested-With': 'XMLHttpRequest' // Tambah untuk AJAX detection
                            }
                        })
                        .then(async (response) => {
                            console.log('Status:', response.status);
                            if (response.status === 419) {
                                throw new Error(
                                    'CSRF token mismatch. Refresh halaman atau login ulang.');
                            }
                            if (!response.ok) {
                                const errorText = await response.text();
                                console.error('Error body:', errorText);
                                throw new Error(
                                    `HTTP ${response.status}: ${errorText.substring(0, 100)}`);
                            }
                            return response.json();
                        })
                        .then((data) => {
                            console.log('Success data:', data);
                            if (data.success) {
                                // Show success view with tracking info
                                const successView = document.getElementById('askSuccessView');
                                const trackingCodeEl = document.getElementById('askTrackingCode');
                                const trackingLinkEl = document.getElementById('askTrackingLink');
                                const copyBtn = document.getElementById('askCopyTrackingBtn');
                                const footerEl = document.getElementById('askModalFooter');
                                
                                if (trackingCodeEl && data.tracking_code) trackingCodeEl.textContent = data.tracking_code;
                                if (trackingLinkEl && data.tracking_url) trackingLinkEl.href = data.tracking_url;
                                
                                const formEl = document.getElementById('askProductForm');
                                if (formEl) formEl.classList.add('hidden');
                                if (successView) successView.classList.remove('hidden');
                                
                                // Sembunyikan footer saat success view ditampilkan
                                if (footerEl) footerEl.classList.add('hidden');

                                if (copyBtn) {
                                    copyBtn.onclick = function() {
                                        const code = trackingCodeEl?.textContent || '';
                                        if (!code) return;
                                        navigator.clipboard.writeText(code).then(() => {
                                            copyBtn.textContent = 'Tersalin';
                                            setTimeout(() => copyBtn.textContent = 'Salin', 1500);
                                        });
                                    };
                                }
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Gagal Mengirim',
                                    text: data.message || 'Terjadi kesalahan saat mengirim permintaan. Silakan coba lagi.',
                                    confirmButtonColor: '#2563eb',
                                    confirmButtonText: 'Mengerti',
                                    position: 'center'
                                });
                                if (submitBtn) {
                                    submitBtn.disabled = false;
                                    submitBtn.textContent = 'Kirim';
                                }
                            }
                        })
                        .catch((error) => {
                            console.error('Catch error:', error);
                            Swal.fire({
                                icon: 'error',
                                title: 'Gagal Mengirim',
                                text: error.message || 'Terjadi kesalahan saat mengirim permintaan. Silakan coba lagi.',
                                confirmButtonColor: '#2563eb',
                                confirmButtonText: 'Mengerti',
                                position: 'center',
                                footer: 'Cek console untuk detail lebih lanjut'
                            });
                            if (submitBtn) {
                                submitBtn.disabled = false;
                                submitBtn.textContent = 'Kirim';
                            }
                        })
                        .finally(() => {
                            if (submitBtn) {
                                submitBtn.disabled = false;
                                submitBtn.textContent = 'Kirim';
                            }
                        });
                });
            } else {
                console.error('Form not found');
            }
        });
    </script>

@endsection
