<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @auth
        <meta name="user-authenticated" content="true">
        <meta name="user-type" content="{{ Auth::user()->user_type }}">
    @endauth
    <title>@yield('title', 'Dashboard Supervisor - POLJAM TECH')</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/jpeg" href="{{ asset('favicon-logo.jpeg') }}">
    <link rel="shortcut icon" type="image/jpeg" href="{{ asset('favicon-logo.jpeg') }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('favicon-logo.jpeg') }}">
    <link rel="icon" type="image/jpeg" sizes="32x32" href="{{ asset('favicon-logo.jpeg') }}">
    <link rel="icon" type="image/jpeg" sizes="16x16" href="{{ asset('favicon-logo.jpeg') }}">
    <meta name="msapplication-TileImage" content="{{ asset('favicon-logo.jpeg') }}">
    
    <!-- Tailwind CSS -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- SweetAlert Helper - Inline untuk memastikan selalu tersedia -->
    <script>
    // SweetAlert Configuration
    const SwalConfig = {
        confirmButton: { class: 'px-6 py-2.5 rounded-lg font-semibold transition-all duration-200 shadow-lg hover:shadow-xl' },
        cancelButton: { class: 'px-6 py-2.5 rounded-lg font-semibold transition-all duration-200' },
        popup: { class: 'rounded-2xl shadow-2xl border border-gray-200 dark:border-gray-700' }
    };

    // Modern Confirm Dialog
    function showConfirm(options) {
        const {
            title = 'Konfirmasi',
            text = 'Apakah Anda yakin?',
            confirmText = 'Ya, Lanjutkan',
            cancelText = 'Batal',
            icon = 'question',
            confirmColor = '#3b82f6',
            onConfirm = null,
            onCancel = null,
            showLoader = false
        } = options;

        return Swal.fire({
            title: title,
            text: text,
            icon: icon,
            showCancelButton: true,
            confirmButtonColor: confirmColor,
            cancelButtonColor: '#6b7280',
            confirmButtonText: `<i class="fas fa-check mr-2"></i>${confirmText}`,
            cancelButtonText: `<i class="fas fa-times mr-2"></i>${cancelText}`,
            reverseButtons: true,
            allowOutsideClick: !showLoader,
            allowEscapeKey: !showLoader,
            customClass: {
                popup: SwalConfig.popup.class,
                confirmButton: SwalConfig.confirmButton.class,
                cancelButton: SwalConfig.cancelButton.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
            didOpen: () => { if (showLoader) Swal.showLoading(); }
        }).then((result) => {
            if (result.isConfirmed && onConfirm) {
                onConfirm(result);
            } else if (result.isDismissed && onCancel) {
                onCancel(result);
            }
            return result;
        });
    }

    // Modern Success Notification
    function showSuccess(message, title = 'Berhasil!', duration = 3000) {
        return Swal.fire({
            icon: 'success',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: false,
            customClass: {
                popup: SwalConfig.popup.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Error Notification
    function showError(message, title = 'Terjadi Kesalahan!', duration = 4000) {
        return Swal.fire({
            icon: 'error',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: true,
            confirmButtonText: '<i class="fas fa-times mr-2"></i>Tutup',
            confirmButtonColor: '#ef4444',
            customClass: {
                popup: SwalConfig.popup.class,
                confirmButton: SwalConfig.confirmButton.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Warning Notification
    function showWarning(message, title = 'Peringatan!', duration = 4000) {
        return Swal.fire({
            icon: 'warning',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: true,
            confirmButtonText: '<i class="fas fa-check mr-2"></i>Mengerti',
            confirmButtonColor: '#f59e0b',
            customClass: {
                popup: SwalConfig.popup.class,
                confirmButton: SwalConfig.confirmButton.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Info Notification
    function showInfo(message, title = 'Informasi', duration = 3000) {
        return Swal.fire({
            icon: 'info',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: false,
            customClass: {
                popup: SwalConfig.popup.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Loading Indicator
    function showLoading(title = 'Memproses...', text = 'Harap tunggu sebentar') {
        return Swal.fire({
            title: title,
            text: text,
            allowOutsideClick: false,
            allowEscapeKey: false,
            showConfirmButton: false,
            didOpen: () => { Swal.showLoading(); },
            customClass: {
                popup: SwalConfig.popup.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
        });
    }

    // Export functions globally
    window.showConfirm = showConfirm;
    window.showSuccess = showSuccess;
    window.showError = showError;
    window.showWarning = showWarning;
    window.showInfo = showInfo;
    window.showLoading = showLoading;
    </script>
    
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- Custom CSS -->
    @stack('styles')
</head>

<body class="bg-gray-100 dark:bg-gray-900 transition-colors duration-300">
    <!-- Sidebar -->
    @include('supervisor.partials.sidebar')

    <!-- Main Content -->
    <div id="mainContent" class="ml-0 lg:ml-60 transition-all duration-300 flex flex-col min-h-screen">
        @include('supervisor.partials.navbar')

        <!-- Page Content -->
        <main class="flex-1 p-6 md:p-8 lg:p-12">
            <!-- Flash Notifications -->
            @include('partials.flash-notifications')
            
            @hasSection('content')
                @yield('content')
            @else
                <p class="text-gray-600 dark:text-gray-300">Selamat datang di dashboard supervisor.</p>
            @endif
        </main>

        <!-- Footer -->
        @include('supervisor.partials.footer')
    </div>

    <!-- Scripts -->
    <!-- Gunakan fungsi toggleSidebar dari partial sidebar untuk konsistensi -->

    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="{{ asset('js/notifications.js') }}?v={{ time() }}"></script>
    
    <!-- Ensure notification system is initialized after all scripts -->
    <script>
        // Initialize notification system for supervisor
        document.addEventListener('DOMContentLoaded', function() {
            console.log('[Supervisor Layout] DOMContentLoaded, initializing notification system...');
            
            // Ensure notification system is initialized
            if (!window.notificationSystem) {
                console.log('[Supervisor Layout] Creating new NotificationSystem instance...');
                window.notificationSystem = new NotificationSystem();
            } else {
                console.log('[Supervisor Layout] NotificationSystem already exists, checking notifications...');
                // Trigger immediate check
                if (typeof window.notificationSystem.checkNotifications === 'function') {
                    setTimeout(() => {
                        window.notificationSystem.checkNotifications();
                    }, 500);
                }
            }
            
            // Force re-bind events after page load
            setTimeout(() => {
                if (window.notificationSystem && typeof window.notificationSystem.bindEvents === 'function') {
                    console.log('[Supervisor Layout] Re-binding notification events...');
                    window.notificationSystem.bindEvents();
                }
            }, 500);
        });
        
        // Also try after window load as fallback
        window.addEventListener('load', () => {
            setTimeout(() => {
                if (window.notificationSystem && typeof window.notificationSystem.bindEvents === 'function') {
                    console.log('[Supervisor Layout] Re-binding notification events after page load...');
                    window.notificationSystem.bindEvents();
                }
                // Trigger check notifications to update badges
                if (window.notificationSystem && typeof window.notificationSystem.checkNotifications === 'function') {
                    window.notificationSystem.checkNotifications();
                }
            }, 500);
        });
    </script>

    @stack('scripts')
</body>

</html>


