@extends('layouts.main')

@section('content')
    <div class="min-h-screen py-6 sm:py-8 lg:py-12">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="text-center mb-8">
                <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-2">
                    @if($order->payment_method === 'dp')
                        Konfirmasi Pembayaran DP
                    @else
                        Konfirmasi Pembayaran Transfer
                    @endif
                </h1>
                <p class="text-sm sm:text-base text-gray-600">
                    @if($order->payment_method === 'dp')
                        Upload bukti pembayaran DP untuk memproses pesanan Anda. Verifikasi akan dilakukan dalam 1x24 jam.
                    @else
                        Upload bukti transfer untuk memproses pesanan Anda. Verifikasi akan dilakukan dalam 1x24 jam.
                    @endif
                </p>
            </div>

            <!-- Alert Messages -->
            @if (session('success'))
                <div class="mb-6 p-4 bg-green-50 border-l-4 border-green-500 rounded">
                    <div class="flex items-center">
                        <svg class="h-5 w-5 text-green-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        <p class="text-sm font-medium text-green-800">{{ session('success') }}</p>
                    </div>
                </div>
            @endif

            @if ($errors->any())
                <div class="mb-6 p-4 bg-red-50 border-l-4 border-red-500 rounded">
                    <div class="flex items-start">
                        <svg class="h-5 w-5 text-red-500 mr-3 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                        </svg>
                        <div>
                            <p class="text-sm font-medium text-red-800 mb-1">Terjadi kesalahan:</p>
                            <ul class="text-xs sm:text-sm text-red-700 space-y-1">
                                @foreach ($errors->all() as $error)
                                    <li>• {{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Single Card Container -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm">
                <div class="grid md:grid-cols-2 divide-y md:divide-y-0 md:divide-x divide-gray-200">
                    <!-- Left Section: Bank Information -->
                    <div class="p-6">
                        <div class="px-6 py-4 -mx-6 -mt-6 mb-6 border-b border-gray-200 bg-blue-50 md:border-b md:border-r md:border-b-0">
                            <h2 class="text-lg font-semibold text-gray-900">Informasi Rekening Bank</h2>
                        </div>
                        <div class="space-y-4">
                            <div>
                                <div class="flex items-center mb-3">
                                    <div class="w-10 h-10 bg-green-600 rounded-lg flex items-center justify-center mr-3">
                                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                        </svg>
                                    </div>
                                    <h3 class="text-base font-semibold text-gray-900">Bank Syariah Indonesia (BSI)</h3>
                                </div>
                                <div class="ml-13 space-y-2.5 text-sm">
                                    <div class="flex items-start">
                                        <span class="text-gray-600 w-24 flex-shrink-0">Perusahaan:</span>
                                        <span class="text-gray-900 font-medium">PT Poljam Tech</span>
                                    </div>
                                    <div class="flex items-start">
                                        <span class="text-gray-600 w-24 flex-shrink-0">No. Rekening:</span>
                                        <span class="text-gray-900 font-mono font-semibold">1234567890</span>
                                    </div>
                                    <div class="flex items-start">
                                        <span class="text-gray-600 w-24 flex-shrink-0">Atas Nama:</span>
                                        <span class="text-gray-900 font-medium">Poljam Technology Indonesia</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Info Box for DP -->
                        @if($order->payment_method === 'dp')
                        <div class="mt-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
                            <div class="flex items-start">
                                <svg class="h-5 w-5 text-blue-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                                </svg>
                                <div class="text-sm text-blue-800">
                                    <p class="font-medium mb-1">Cara Pembayaran DP:</p>
                                    <ul class="space-y-1 text-xs">
                                        <li>• Transfer ke rekening BSI di atas</li>
                                        <li>• Atau bayar tunai langsung ke workshop</li>
                                        <li>• Upload bukti pembayaran setelah selesai</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                    <!-- Right Section: Order Detail -->
                    <div class="p-6">
                        <div class="px-6 py-4 -mx-6 -mt-6 mb-6 border-b border-gray-200 bg-blue-50 md:border-b-0 md:border-l">
                            <h2 class="text-lg font-semibold text-gray-900">Detail Pesanan</h2>
                        </div>
                        <div class="space-y-3">
                            <div class="flex justify-between items-center py-2 border-b border-gray-100">
                                <span class="text-sm text-gray-600">ID Pesanan</span>
                                <span class="text-sm font-semibold text-gray-900">#{{ $order->id }}</span>
                            </div>
                            <div class="flex justify-between items-center py-2 border-b border-gray-100">
                                <span class="text-sm text-gray-600">Nama Pelanggan</span>
                                <span class="text-sm font-medium text-gray-900">{{ $order->customer_name }}</span>
                            </div>
                            <div class="flex justify-between items-start py-2 border-b border-gray-100">
                                <span class="text-sm text-gray-600">Produk</span>
                                <span class="text-sm font-medium text-gray-900 text-right max-w-xs">{{ $order->product->product_title ?? 'N/A' }}</span>
                            </div>
                            @if($order->payment_method === 'dp')
                                @php
                                    $dpPercentage = $order->dp_percentage ?? 30.00;
                                    $dpAmount = $order->total_price * ($dpPercentage / 100);
                                    $remainingAmount = $order->total_price - $dpAmount;
                                @endphp
                                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                                    <span class="text-sm text-gray-600">Total Harga</span>
                                    <span class="text-sm font-medium text-gray-900">{{ $order->formatted_total_price }}</span>
                                </div>
                                <div class="flex justify-between items-center py-2.5 bg-blue-50 px-3 rounded border border-blue-100">
                                    <span class="text-sm text-blue-700 font-medium">DP ({{ number_format($dpPercentage, 0) }}%)</span>
                                    <span class="text-base font-bold text-blue-600">Rp{{ number_format($dpAmount, 0, ',', '.') }}</span>
                                </div>
                                <div class="flex justify-between items-center py-2">
                                    <span class="text-sm text-gray-600">Sisa Pembayaran</span>
                                    <span class="text-sm font-medium text-gray-900">Rp{{ number_format($remainingAmount, 0, ',', '.') }}</span>
                                </div>
                            @else
                                <div class="flex justify-between items-center pt-3 mt-2 bg-blue-50 px-4 py-3 rounded border border-blue-100">
                                    <span class="text-base font-semibold text-gray-900">Total Pembayaran</span>
                                    <span class="text-xl font-bold text-blue-600">{{ $order->formatted_total_price }}</span>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Upload Form Section -->
                <div class="border-t border-gray-200">
                    <form action="{{ route('orders.confirm', $order) }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <!-- Hidden Bank Selection (Hanya untuk Transfer Bank) -->
                        @if($order->payment_method === 'transfer')
                        <input type="hidden" name="bank_selected" value="bsi" id="bank_selected_input">
                        @endif

                        <div class="px-6 py-4 border-b border-gray-200 bg-blue-50">
                            <h2 class="text-lg font-semibold text-gray-900">
                                @if($order->payment_method === 'dp')
                                    Upload Bukti Pembayaran DP
                                @else
                                    Upload Bukti Transfer
                                @endif
                            </h2>
                        </div>

                        <div class="p-6 space-y-6">
                            <!-- Payment Type Selection for DP -->
                            @if($order->payment_method === 'dp')
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-3">Jenis Pembayaran</label>
                                <div class="space-y-2">
                                    <label class="flex items-center p-3 border border-gray-300 rounded-lg cursor-pointer hover:border-blue-500 hover:bg-blue-50 transition-colors">
                                        <input type="radio" name="payment_type" value="transfer" class="mr-3 text-blue-600" checked>
                                        <div>
                                            <span class="text-sm font-medium text-gray-900 block">Transfer Bank</span>
                                            <span class="text-xs text-gray-500">Upload bukti transfer</span>
                                        </div>
                                    </label>
                                    <label class="flex items-center p-3 border border-gray-300 rounded-lg cursor-pointer hover:border-blue-500 hover:bg-blue-50 transition-colors">
                                        <input type="radio" name="payment_type" value="cash" class="mr-3 text-blue-600">
                                        <div>
                                            <span class="text-sm font-medium text-gray-900 block">Tunai Langsung</span>
                                            <span class="text-xs text-gray-500">Upload foto kwitansi</span>
                                        </div>
                                    </label>
                                </div>
                            </div>
                            @endif

                            <!-- Upload Field -->
                            <div>
                                <label for="proof_file" class="block text-sm font-medium text-gray-700 mb-2">
                                    Pilih File Bukti Pembayaran
                                </label>
                                
                                <!-- Upload Area -->
                                <div id="drop_zone" class="relative border-2 border-dashed border-gray-300 rounded-lg p-8 text-center hover:border-blue-500 hover:bg-blue-50 transition-colors cursor-pointer">
                                    <input type="file" name="proof_file" id="proof_file" accept="image/*,application/pdf"
                                        class="absolute inset-0 w-full h-full opacity-0 cursor-pointer z-10" />
                                    
                                    <div class="pointer-events-none">
                                        <svg class="mx-auto h-12 w-12 text-gray-400 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                        </svg>
                                        <p class="text-sm font-medium text-gray-700 mb-1">
                                            Klik untuk memilih file atau drag & drop
                                        </p>
                                        <p class="text-xs text-gray-500">
                                            Format: JPG, PNG, atau PDF (Maksimal 5MB)
                                        </p>
                                    </div>
                                </div>

                                <!-- File Preview -->
                                <div id="file_preview" class="mt-4 hidden">
                                    <div class="relative bg-gray-50 border border-gray-200 rounded-lg p-4">
                                        <button type="button" id="remove_file" class="absolute top-2 right-2 bg-red-500 hover:bg-red-600 text-white rounded-full w-7 h-7 flex items-center justify-center transition-colors">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                            </svg>
                                        </button>
                                        
                                        <div class="pr-8">
                                            <p class="text-xs font-medium text-gray-700 mb-2">Pratinjau File</p>
                                            <div class="flex items-center justify-center min-h-[150px]">
                                                <img id="preview_image" class="max-h-64 rounded-lg shadow-sm hidden" alt="Preview">
                                                
                                                <div id="pdf_info" class="hidden text-center">
                                                    <div class="bg-white rounded-lg p-4 inline-block border border-gray-200">
                                                        <svg class="w-12 h-12 mx-auto text-red-500 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                                        </svg>
                                                        <p class="text-xs font-medium text-gray-700 mb-1" id="pdf_name"></p>
                                                        <p class="text-xs text-gray-500" id="pdf_size"></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                @error('proof_file')
                                    <p class="mt-2 text-xs text-red-600 flex items-center">
                                        <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                        </svg>
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>

                            <!-- Submit Button -->
                            <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-4 rounded-lg transition-colors focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                                Kirim Konfirmasi Pembayaran
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Warning Box -->
                <div class="border-t border-gray-200 p-6 bg-yellow-50">
                    <div class="flex items-start">
                        <svg class="h-5 w-5 text-yellow-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                        </svg>
                        <p class="text-xs sm:text-sm text-yellow-800">
                            <span class="font-semibold">Penting:</span> Pastikan nama pengirim dan jumlah transfer sesuai dengan data di atas. Verifikasi akan dilakukan maksimal dalam 1x24 jam setelah konfirmasi diterima.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Back Link -->
            <div class="mt-8 text-center">
                <a href="{{ route('all') }}" class="inline-flex items-center text-sm text-blue-600 hover:text-blue-800 font-medium">
                    <svg class="h-4 w-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" />
                    </svg>
                    Kembali ke Daftar Produk
                </a>
            </div>
        </div>
    </div>

    <!-- SweetAlert2 CDN -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        // Drag & Drop functionality
        const dropZone = document.getElementById('drop_zone');
        const fileInput = document.getElementById('proof_file');
        const previewContainer = document.getElementById('file_preview');
        const imagePreview = document.getElementById('preview_image');
        const pdfInfo = document.getElementById('pdf_info');
        const pdfName = document.getElementById('pdf_name');
        const pdfSize = document.getElementById('pdf_size');
        const removeFileBtn = document.getElementById('remove_file');

        // Prevent default drag behaviors
        ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
            dropZone.addEventListener(eventName, preventDefaults, false);
            document.body.addEventListener(eventName, preventDefaults, false);
        });

        function preventDefaults(e) {
            e.preventDefault();
            e.stopPropagation();
        }

        // Highlight drop zone
        ['dragenter', 'dragover'].forEach(eventName => {
            dropZone.addEventListener(eventName, () => {
                dropZone.classList.add('border-blue-500', 'bg-blue-50');
            }, false);
        });

        ['dragleave', 'drop'].forEach(eventName => {
            dropZone.addEventListener(eventName, () => {
                dropZone.classList.remove('border-blue-500', 'bg-blue-50');
            }, false);
        });

        // Handle dropped files
        dropZone.addEventListener('drop', (e) => {
            const dt = e.dataTransfer;
            const files = dt.files;
            if (files.length > 0) {
                fileInput.files = files;
                handleFile(files[0]);
            }
        }, false);

        // Handle file input change
        fileInput.addEventListener('change', (event) => {
            const file = event.target.files[0];
            if (file) {
                handleFile(file);
            }
        });

        function handleFile(file) {
            // Validate file size (5MB)
            const maxSize = 5 * 1024 * 1024;
            if (file.size > maxSize) {
                Swal.fire({
                    icon: 'error',
                    title: 'Ukuran File Terlalu Besar',
                    text: 'Maksimal ukuran file adalah 5MB. Silakan pilih file yang lebih kecil.',
                    confirmButtonColor: '#2563eb',
                    confirmButtonText: 'Mengerti',
                    position: 'center'
                });
                fileInput.value = '';
                return;
            }

            previewContainer.classList.remove('hidden');

            const fileType = file.type;
            const fileSizeKB = (file.size / 1024).toFixed(2);
            const fileSizeMB = (file.size / (1024 * 1024)).toFixed(2);
            const fileSize = file.size > 1024 * 1024 ? fileSizeMB + ' MB' : fileSizeKB + ' KB';

            // Reset previous state
            imagePreview.classList.add('hidden');
            pdfInfo.classList.add('hidden');

            if (fileType.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = (e) => {
                    imagePreview.src = e.target.result;
                    imagePreview.classList.remove('hidden');
                };
                reader.readAsDataURL(file);
            } else if (fileType === 'application/pdf') {
                pdfName.textContent = file.name;
                pdfSize.textContent = fileSize;
                pdfInfo.classList.remove('hidden');
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Format File Tidak Didukung',
                    text: 'Gunakan format JPG, PNG, atau PDF.',
                    confirmButtonColor: '#2563eb',
                    confirmButtonText: 'Mengerti',
                    position: 'center'
                });
                fileInput.value = '';
                previewContainer.classList.add('hidden');
            }
        }

        // Remove file
        removeFileBtn.addEventListener('click', () => {
            fileInput.value = '';
            previewContainer.classList.add('hidden');
            imagePreview.classList.add('hidden');
            pdfInfo.classList.add('hidden');
            dropZone.classList.remove('border-blue-500', 'bg-blue-50');
        });

        // Form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            const fileSelected = fileInput.files.length > 0;

            if (!fileSelected) {
                e.preventDefault();
                const message = '{{ $order->payment_method }}' === 'dp' 
                    ? 'Silakan upload bukti pembayaran DP terlebih dahulu.'
                    : 'Silakan upload bukti transfer terlebih dahulu.';
                Swal.fire({
                    icon: 'warning',
                    title: 'File Belum Dipilih',
                    text: message,
                    confirmButtonColor: '#2563eb',
                    confirmButtonText: 'Mengerti',
                    position: 'center'
                });
                return false;
            }
        });
    </script>
@endsection
