<footer class="bg-gray-800 text-white pb-20 md:pb-10 mt-0">
    <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4 py-4 sm:py-8 md:py-12">
        <!-- Footer Content Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 md:gap-8 mb-4 md:mb-8">
            <!-- Company Info -->
            <div class="text-center md:text-left">
                <h3 class="text-xl sm:text-2xl md:text-3xl font-bold mb-2 md:mb-4 bg-gradient-to-r from-blue-400 to-cyan-400 bg-clip-text text-transparent">
                    {{ $companyName }}
                </h3>
                <p class="text-gray-400 text-xs sm:text-sm md:text-base mb-2 md:mb-4 leading-relaxed">
                    {{ $companyDescription }}
                </p>
                <div class="flex justify-center md:justify-start space-x-3 md:space-x-4">
                    <a href="#" class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center rounded-lg bg-gray-700 text-white hover:bg-blue-600 transition-all duration-300 hover:scale-110 border border-gray-600" title="Facebook">
                        <i class="fab fa-facebook-f text-xs md:text-sm"></i>
                    </a>
                    <a href="#" class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center rounded-lg bg-gray-700 text-white hover:bg-blue-600 transition-all duration-300 hover:scale-110 border border-gray-600" title="Twitter">
                        <i class="fab fa-twitter text-xs md:text-sm"></i>
                    </a>
                    <a href="#" class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center rounded-lg bg-gray-700 text-white hover:bg-blue-600 transition-all duration-300 hover:scale-110 border border-gray-600" title="Instagram">
                        <i class="fab fa-instagram text-xs md:text-sm"></i>
                    </a>
                    <a href="#" class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center rounded-lg bg-gray-700 text-white hover:bg-blue-600 transition-all duration-300 hover:scale-110 border border-gray-600" title="LinkedIn">
                        <i class="fab fa-linkedin-in text-xs md:text-sm"></i>
                    </a>
                </div>
            </div>

            <!-- Quick Links and Services - 2 columns on mobile -->
            <div class="grid grid-cols-2 md:contents gap-4 md:gap-0">
                <!-- Quick Links -->
                <div class="text-center md:text-left">
                    <h4 class="text-base md:text-lg font-semibold mb-2 md:mb-4">Tautan Cepat</h4>
                    <ul class="space-y-1 md:space-y-2">
                        <li>
                            <a href="{{ route('index') }}" class="text-gray-400 hover:text-white transition-colors text-xs sm:text-sm md:text-base">
                                Beranda
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('all') }}" class="text-gray-400 hover:text-white transition-colors text-xs sm:text-sm md:text-base">
                                Katalog Produk
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('konsultasi') }}" class="text-gray-400 hover:text-white transition-colors text-xs sm:text-sm md:text-base">
                                Konsultasi
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('guest.contact') }}" class="text-gray-400 hover:text-white transition-colors text-xs sm:text-sm md:text-base">
                                Kontak
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Services -->
                <div class="text-center md:text-left">
                    <h4 class="text-base md:text-lg font-semibold mb-2 md:mb-4">Layanan</h4>
                    <ul class="space-y-1 md:space-y-2">
                        <li>
                            <span class="text-gray-400 text-xs sm:text-sm md:text-base">Custom Design</span>
                        </li>
                        <li>
                            <span class="text-gray-400 text-xs sm:text-sm md:text-base">Produksi Mesin</span>
                        </li>
                        <li>
                            <span class="text-gray-400 text-xs sm:text-sm md:text-base">Konsultasi Gratis</span>
                        </li>
                        <li>
                            <span class="text-gray-400 text-xs sm:text-sm md:text-base">After Sales Support</span>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Contact Info -->
            <div class="text-center md:text-left">
                <h4 class="text-base md:text-lg font-semibold mb-2 md:mb-4">Kontak</h4>
                <ul class="space-y-1 md:space-y-2">
                    @if($companyEmail)
                    <li class="flex items-start justify-center md:justify-start gap-2">
                        <i class="fas fa-envelope text-blue-400 mt-0.5 md:mt-1 text-xs md:text-sm"></i>
                        <a href="mailto:{{ $companyEmail }}" class="text-gray-400 hover:text-white transition-colors text-xs sm:text-sm md:text-base">
                            {{ $companyEmail }}
                        </a>
                    </li>
                    @endif
                    @if($companyPhone)
                    <li class="flex items-start justify-center md:justify-start gap-2">
                        <i class="fas fa-phone text-blue-400 mt-0.5 md:mt-1 text-xs md:text-sm"></i>
                        <a href="tel:{{ $companyPhone }}" class="text-gray-400 hover:text-white transition-colors text-xs sm:text-sm md:text-base">
                            {{ $companyPhone }}
                        </a>
                    </li>
                    @endif
                    @if($companyAddress)
                    <li class="flex items-start justify-center md:justify-start gap-2">
                        <i class="fas fa-map-marker-alt text-blue-400 mt-0.5 md:mt-1 text-xs md:text-sm"></i>
                        <span class="text-gray-400 text-xs sm:text-sm md:text-base">{{ $companyAddress }}</span>
                    </li>
                    @endif
                    @if($companyWebsite)
                    <li class="flex items-start justify-center md:justify-start gap-2">
                        <i class="fas fa-globe text-blue-400 mt-0.5 md:mt-1 text-xs md:text-sm"></i>
                        <a href="{{ $companyWebsite }}" target="_blank" rel="noopener noreferrer" class="text-gray-400 hover:text-white transition-colors text-xs sm:text-sm md:text-base">
                            {{ $companyWebsite }}
                        </a>
                    </li>
                    @endif
                </ul>
            </div>
        </div>

        <!-- Divider -->
        <div class="border-t border-gray-700 my-3 md:my-6"></div>

        <!-- Copyright -->
        <div class="text-center">
            <p class="text-gray-500 text-xs sm:text-sm md:text-base">
                &copy; {{ date('Y') }} {{ $companyName }}. Semua Hak Dilindungi.
            </p>
        </div>
    </div>
</footer>
