<nav class="bg-blue-600 text-white" x-data="{ 
    open: false,
    toggleMenu() {
        this.open = !this.open;
        if (this.open) {
            document.body.style.overflow = 'hidden';
        } else {
            document.body.style.overflow = '';
        }
    }
}" style="overflow: visible;">
    <div class="container mx-auto px-4 py-3 flex items-center justify-between" style="overflow: visible;">
        <!-- Burger Button (mobile & tablet only) -->
        <button @click="toggleMenu()" class="lg:hidden text-white focus:outline-none transition-transform duration-150 active:scale-95 z-50 relative">
            <i :class="open ? 'fas fa-times text-2xl' : 'fas fa-bars text-2xl'" class="transition-all duration-150"></i>
        </button>

        <!-- Menu Utama (desktop only, mulai lg) -->
        <div class="hidden lg:flex flex-1 justify-center">
            <ul class="flex space-x-6 navbar-menu">
                @foreach ($productCategories as $category)
                    <li class="relative" x-data="{ open: false }" @mouseenter="open = true" @mouseleave="open = false">
                        <a href="{{ route('all', ['category' => $category->id]) }}" class="nav-link relative pb-1 flex items-center text-sm font-medium hover:text-blue-200 transition-colors">
                            {{ $category->name }}
                            @if($category->children->count() > 0)
                                <i class="fas fa-chevron-down text-xs ml-1 transition-transform duration-200" :class="open ? 'rotate-180' : ''"></i>
                            @endif
                        </a>
                        
                        <!-- Dropdown Sub Categories -->
                        @if($category->children->count() > 0)
                            <div x-show="open" 
                                 x-transition:enter="transition ease-out duration-200"
                                 x-transition:enter-start="opacity-0 -translate-y-2"
                                 x-transition:enter-end="opacity-100 translate-y-0"
                                 x-transition:leave="transition ease-in duration-150"
                                 x-transition:leave-start="opacity-100 translate-y-0"
                                 x-transition:leave-end="opacity-0 -translate-y-2"
                                 x-cloak
                                 class="absolute top-full left-0 mt-2 w-64 bg-white rounded-lg shadow-xl border border-gray-200 py-2 z-[60]"
                                 style="display: none;">
                                <!-- Dropdown Header -->
                                <div class="px-4 py-2 border-b border-gray-100">
                                    <p class="text-xs font-semibold text-gray-500 uppercase tracking-wide">{{ $category->name }}</p>
                                </div>
                                
                                <!-- Sub Categories List -->
                                <div class="max-h-80 overflow-y-auto">
                                    @foreach($category->children as $subCategory)
                                        <a href="{{ route('all', ['category' => $subCategory->id]) }}" 
                                           class="block px-4 py-2.5 hover:bg-blue-50 transition-colors duration-150 group">
                                            <div class="flex items-center space-x-3">
                                                <!-- Sub Category Icon/Image -->
                                                <div class="flex-shrink-0 w-10 h-10 bg-gray-100 rounded overflow-hidden flex items-center justify-center">
                                                    @if($subCategory->image)
                                                        <img src="{{ asset('uploads/' . $subCategory->image) }}" 
                                                             alt="{{ $subCategory->name }}"
                                                             class="w-full h-full object-cover">
                                                    @else
                                                        <i class="fas fa-folder text-blue-600 text-sm"></i>
                                                    @endif
                                                </div>
                                                
                                                <!-- Sub Category Info -->
                                                <div class="flex-1 min-w-0">
                                                    <p class="text-sm font-medium text-gray-900 group-hover:text-blue-600 truncate transition-colors duration-150">
                                                        {{ $subCategory->name }}
                                                    </p>
                                                    <p class="text-xs text-gray-500 mt-0.5">
                                                        {{ $subCategory->products->count() }} produk
                                                    </p>
                                                </div>
                                                
                                                <!-- Arrow Icon -->
                                                <i class="fas fa-chevron-right text-xs text-gray-400 group-hover:text-blue-600 transition-colors duration-150"></i>
                                            </div>
                                        </a>
                                    @endforeach
                                </div>
                                
                                <!-- View All Link -->
                                <div class="px-4 py-2 border-t border-gray-100 bg-gray-50">
                                    <a href="{{ route('all', ['category' => $category->id]) }}" 
                                       class="text-xs font-semibold text-blue-600 hover:text-blue-700 flex items-center justify-center space-x-1 transition-colors duration-150">
                                        <span>Lihat Semua Sub Kategori</span>
                                        <i class="fas fa-arrow-right text-xs"></i>
                                    </a>
                                </div>
                            </div>
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>

        <!-- User Info & Actions (desktop only, mulai lg) -->
        <div class="hidden lg:flex items-center space-x-3">
            @if (Auth::check())
                <!-- Notification Bell -->
                @if (Auth::user()->user_type === 'admin')
                    <!-- Admin Notification Bell -->
                    <button id="notification-toggle-btn" class="notification-bell notification-icon relative text-white hover:text-blue-200 transition-colors duration-200">
                        <i class="fas fa-bell text-lg"></i>
                        <span id="notification-count" class="badge absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center hidden">0</span>
                    </button>
                @elseif (Auth::user()->user_type === 'supervisor')
                    <!-- Supervisor Notification Bell -->
                    <button id="notification-toggle-btn" class="notification-bell notification-icon relative text-white hover:text-blue-200 transition-colors duration-200">
                        <i class="fas fa-bell text-lg"></i>
                        <span id="notification-count" class="badge absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center hidden">0</span>
                    </button>
                @elseif (Auth::user()->user_type === 'teknisi')
                    <!-- Teknisi Notification Bell -->
                    <button onclick="notificationSystem.toggleBadge()" class="notification-icon relative text-white hover:text-blue-200 transition-colors duration-200 cursor-pointer">
                        <i class="fas fa-bell text-lg"></i>
                        <span id="notification-count" class="badge absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center hidden">0</span>
                    </button>
                @else
                    <!-- User Notification Bell -->
                    <button onclick="toggleUserNotifications()" class="notification-bell relative text-white hover:text-blue-200 transition-colors duration-200 cursor-pointer">
                        <i class="fas fa-bell text-lg"></i>
                        <span class="badge absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center" style="display: none;">0</span>
                    </button>
                @endif

                <!-- User Info & Dropdown -->
                <div class="relative" x-data="{ open: false }">
                    <button @click="open = !open" class="flex items-center gap-2 px-3 py-1.5 text-sm font-medium border border-white rounded-lg hover:bg-white hover:text-blue-600 transition-all duration-200">
                        @if(Auth::user()->photo && \Storage::disk('uploads')->exists('profiles/' . Auth::user()->photo))
                            <img src="{{ asset('uploads/profiles/' . Auth::user()->photo) }}" 
                                 alt="{{ Auth::user()->name }}" 
                                 class="w-6 h-6 rounded-full object-cover border border-white">
                        @else
                            <div class="w-6 h-6 rounded-full bg-white text-blue-600 flex items-center justify-center text-xs font-bold">
                                {{ strtoupper(substr(Auth::user()->name, 0, 1)) }}
                            </div>
                        @endif
                        <span class="text-sm">{{ Auth::user()->name ?? Auth::user()->email }}</span>
                        <i class="fas fa-chevron-down text-xs"></i>
                    </button>
                    
                    <div x-show="open" @click.away="open = false" x-transition x-cloak class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1 z-50 border border-gray-200" style="display: none;">
                        <!-- User Info -->
                        <div class="px-4 py-2 border-b border-gray-200">
                            <p class="text-sm font-semibold text-gray-900">{{ Auth::user()->name }}</p>
                            <p class="text-xs text-gray-500">{{ Auth::user()->email }}</p>
                        </div>
                        
                        @if (Auth::user()->user_type === 'admin')
                            <a href="{{ route('admin.dashboard') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <i class="fas fa-tachometer-alt mr-2"></i>Dashboard Admin
                            </a>
                        @elseif (Auth::user()->user_type === 'supervisor')
                            <a href="{{ route('supervisor.dashboard') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <i class="fas fa-tachometer-alt mr-2"></i>Dashboard Supervisor
                            </a>
                        @elseif (Auth::user()->user_type === 'teknisi')
                            <a href="{{ route('teknisi.dashboard') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <i class="fas fa-tachometer-alt mr-2"></i>Dashboard Teknisi
                            </a>
                        @else
                            <a href="{{ route('user.dashboard') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <i class="fas fa-tachometer-alt mr-2"></i>Dashboard User
                            </a>
                            <a href="{{ route('my.orders.index') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <i class="fas fa-shopping-bag mr-2"></i>Pesanan Saya
                            </a>
                        @endif
                        
                        <div class="border-t border-gray-200 my-1"></div>
                        
                        <!-- Edit Profile -->
                        <a href="{{ route('profile.edit') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                            <i class="fas fa-user-edit mr-2"></i>Edit Profil
                        </a>
                        
                        <div class="border-t border-gray-200 my-1"></div>
                        
                        <form action="{{ route('logout') }}" method="POST" class="block">
                            @csrf
                            <button type="submit" class="w-full text-left px-4 py-2 text-sm text-red-600 hover:bg-red-50">
                                <i class="fas fa-sign-out-alt mr-2"></i>Logout
                            </button>
                        </form>
                    </div>
                </div>
            @else
                <!-- Tombol Masuk & Daftar untuk guest -->
                <a href="{{ route('login') }}"
                    class="px-4 py-1.5 text-sm font-medium border border-white rounded-lg hover:bg-white hover:text-blue-600 transition-colors">
                    Masuk
                </a>
                <a href="{{ route('register') }}"
                    class="px-4 py-1.5 text-sm font-medium border border-white rounded-lg hover:bg-white hover:text-blue-600 transition-colors">
                    Daftar
                </a>
            @endif
        </div>
    </div>

    <!-- Mobile Menu (termasuk tablet) -->
    <div class="lg:hidden fixed inset-0 top-[64px] bg-blue-700 z-50 flex flex-col" x-show="open" x-cloak style="display: none;"
        x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 -translate-y-2"
        x-transition:enter-end="opacity-100 translate-y-0" x-transition:leave="transition ease-in duration-200"
        x-transition:leave-start="opacity-100 translate-y-0" x-transition:leave-end="opacity-0 -translate-y-2"
        @click.away="open = false; document.body.style.overflow = '';">
        <!-- Close Button Header -->
        <div class="flex items-center justify-between px-4 py-3 border-b border-blue-600 bg-blue-700 flex-shrink-0">
            <h3 class="text-sm font-semibold text-white">Menu</h3>
            <button @click="toggleMenu()" class="p-2 text-white hover:text-blue-200 hover:bg-blue-600 rounded-lg transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        
        <!-- Scrollable Container -->
        <div class="flex-1 overflow-y-auto overscroll-contain min-h-0" style="-webkit-overflow-scrolling: touch; overflow-x: hidden;">
            <!-- Categories Section -->
            <div class="px-4 py-4 border-b border-blue-600">
                <ul class="flex flex-col space-y-1">
            @foreach ($productCategories as $category)
                        <li x-data="{ open: false }">
                            @if($category->children->count() > 0)
                                <!-- Category with Sub Categories - Accordion -->
                                <button @click="open = !open" class="w-full flex items-center justify-between py-2.5 text-sm font-semibold text-white hover:text-blue-200 transition-colors">
                                    <span>{{ $category->name }}</span>
                                    <svg class="w-4 h-4 transition-transform duration-200" :class="open ? 'rotate-180' : ''" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                <div x-show="open" 
                                    x-transition:enter="transition ease-out duration-200"
                                    x-transition:enter-start="opacity-0 -translate-y-2"
                                    x-transition:enter-end="opacity-100 translate-y-0"
                                    x-transition:leave="transition ease-in duration-150"
                                    x-transition:leave-start="opacity-100 translate-y-0"
                                    x-transition:leave-end="opacity-0 -translate-y-2"
                                    class="ml-4 mt-1 space-y-1 border-l-2 border-blue-500 pl-3">
                                    <ul class="space-y-1">
                                        <!-- Link to parent category -->
                                        <li>
                                            <a href="{{ route('all', ['category' => $category->id]) }}" class="block py-1.5 text-xs text-blue-100 hover:text-white transition-colors font-medium">
                                                Semua {{ $category->name }}
                                            </a>
                                        </li>
                            @foreach($category->children as $subCategory)
                                <li>
                                                <a href="{{ route('all', ['category' => $subCategory->id]) }}" class="block py-1.5 text-xs text-blue-100 hover:text-white transition-colors">
                                        {{ $subCategory->name }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                                </div>
                            @else
                                <!-- Category without Sub Categories -->
                                <a href="{{ route('all', ['category' => $category->id]) }}" class="block py-2.5 text-sm font-semibold text-white hover:text-blue-200 transition-colors">
                                    {{ $category->name }}
                                </a>
                    @endif
                </li>
            @endforeach
        </ul>
            </div>

        <!-- User Info & Actions (mobile/tablet) -->
            <div class="flex flex-col space-y-2.5 px-4 py-4 pb-32">
            @if (Auth::check())
                <!-- User Info with Notification -->
                <div class="flex items-center justify-between py-2 border-b border-blue-600">
                    <div class="flex items-center gap-2">
                        @if(Auth::user()->photo && \Storage::disk('uploads')->exists('profiles/' . Auth::user()->photo))
                            <img src="{{ asset('uploads/profiles/' . Auth::user()->photo) }}" 
                                 alt="{{ Auth::user()->name }}" 
                                 class="w-8 h-8 rounded-full object-cover border border-white">
                        @else
                            <div class="w-8 h-8 rounded-full bg-white text-blue-600 flex items-center justify-center text-xs font-bold">
                                {{ strtoupper(substr(Auth::user()->name, 0, 1)) }}
                            </div>
                        @endif
                        <span class="text-sm font-medium text-white">{{ Auth::user()->name ?? Auth::user()->email }}</span>
                    </div>
                    @if (Auth::user()->user_type === 'admin')
                        <button id="notification-toggle-btn" type="button" class="notification-bell notification-icon relative text-white hover:text-blue-200 transition-colors duration-200 p-2 -mr-2" style="pointer-events: auto; touch-action: manipulation; z-index: 60; -webkit-tap-highlight-color: transparent;">
                            <i class="fas fa-bell text-lg"></i>
                            <span id="notification-count-mobile" class="badge absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center hidden">0</span>
                        </button>
                    @elseif (Auth::user()->user_type === 'supervisor')
                        <button id="notification-toggle-btn" class="notification-bell notification-icon relative text-white hover:text-blue-200 transition-colors duration-200">
                            <i class="fas fa-bell text-lg"></i>
                            <span id="notification-count" class="badge absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center hidden">0</span>
                        </button>
                    @elseif (Auth::user()->user_type === 'teknisi')
                        <button onclick="notificationSystem.toggleBadge()" class="notification-icon relative text-white hover:text-blue-200 transition-colors duration-200 cursor-pointer">
                            <i class="fas fa-bell text-lg"></i>
                            <span id="notification-count" class="badge absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center hidden">0</span>
                        </button>
                    @else
                        <button onclick="toggleUserNotifications()" class="notification-bell relative text-white hover:text-blue-200 transition-colors duration-200 cursor-pointer">
                            <i class="fas fa-bell text-lg"></i>
                            <span class="badge absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center" style="display: none;">0</span>
                        </button>
                    @endif
                </div>

                <!-- Dashboard Links -->
                @if (Auth::user()->user_type === 'admin')
                    <a href="{{ route('admin.dashboard') }}"
                        class="block text-center px-4 py-2.5 text-sm font-medium border border-white rounded-lg hover:bg-white hover:text-blue-600 transition-colors">
                        Dashboard Admin
                    </a>
                @elseif (Auth::user()->user_type === 'supervisor')
                    <a href="{{ route('supervisor.dashboard') }}"
                        class="block text-center px-4 py-2.5 text-sm font-medium border border-white rounded-lg hover:bg-white hover:text-blue-600 transition-colors">
                        Dashboard Supervisor
                    </a>
                @elseif (Auth::user()->user_type === 'teknisi')
                    <a href="{{ route('teknisi.dashboard') }}"
                        class="block text-center px-4 py-2.5 text-sm font-medium border border-white rounded-lg hover:bg-white hover:text-blue-600 transition-colors">
                        Dashboard Teknisi
                    </a>
                @else
                    <a href="{{ route('user.dashboard') }}"
                        class="block text-center px-4 py-2.5 text-sm font-medium border border-white rounded-lg hover:bg-white hover:text-blue-600 transition-colors">
                        Dashboard User
                    </a>
                    <a href="{{ route('my.orders.index') }}"
                        class="block text-center px-4 py-2.5 text-sm font-medium border border-white rounded-lg hover:bg-white hover:text-blue-600 transition-colors">
                        Pesanan Saya
                    </a>
                @endif

                <!-- Edit Profile -->
                <a href="{{ route('profile.edit') }}"
                    class="block text-center px-4 py-2.5 text-sm font-medium border border-white rounded-lg hover:bg-white hover:text-blue-600 transition-colors">
                    Edit Profil
                </a>

                <!-- Logout -->
                <form action="{{ route('logout') }}" method="POST" class="block">
                    @csrf
                    <button type="submit" class="w-full text-center px-4 py-2.5 text-sm font-medium border border-red-400 text-red-200 rounded-lg hover:bg-red-500 hover:text-white hover:border-red-500 transition-colors">
                        Logout
                    </button>
                </form>
            @else
                <!-- Tombol Masuk & Daftar untuk guest -->
                <a href="{{ route('login') }}"
                    class="block text-center px-4 py-2.5 text-sm font-medium border border-white rounded-lg hover:bg-white hover:text-blue-600 transition-colors">
                    Masuk
                </a>
                <a href="{{ route('register') }}"
                    class="block text-center px-4 py-2.5 text-sm font-medium border border-white rounded-lg hover:bg-white hover:text-blue-600 transition-colors">
                    Daftar
                </a>
            @endif
            </div>
            <!-- Extra padding untuk memastikan scroll sampai ke bawah -->
            <div class="h-16"></div>
        </div>
    </div>
</nav>
