@extends('layouts.supervisor')

@section('title', 'Dashboard Supervisor - POLJAM TECH')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Dashboard Supervisor</h1>
            <p class="text-gray-600 dark:text-gray-400 mt-1">Overview sistem dan pending approvals</p>
        </div>
        <div class="text-sm text-gray-500 dark:text-gray-400">
            {{ now()->format('d M Y, H:i') }}
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Pending Production Approvals -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center">
                <div class="p-3 bg-red-100 dark:bg-red-900/20 rounded-lg">
                    <i class="fas fa-cogs text-red-600 dark:text-red-400 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Pending Production</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $stats['pending_production_approvals'] }}</p>
                </div>
            </div>
        </div>

        <!-- Pending Purchase Approvals -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center">
                <div class="p-3 bg-orange-100 dark:bg-orange-900/20 rounded-lg">
                    <i class="fas fa-shopping-cart text-orange-600 dark:text-orange-400 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Pending Purchase</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $stats['pending_purchase_approvals'] }}</p>
                </div>
            </div>
        </div>

        <!-- Low Stock Items -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center">
                <div class="p-3 bg-yellow-100 dark:bg-yellow-900/20 rounded-lg">
                    <i class="fas fa-box-open text-yellow-600 dark:text-yellow-400 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Stok Rendah (≤ limit)</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $stats['low_stock_items'] ?? 0 }}</p>
                </div>
            </div>
        </div>

        <!-- Active Productions Today -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center">
                <div class="p-3 bg-blue-100 dark:bg-blue-900/20 rounded-lg">
                    <i class="fas fa-industry text-blue-600 dark:text-blue-400 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Produksi Aktif Hari Ini</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $stats['active_productions_today'] ?? 0 }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
        <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Quick Actions</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <a href="{{ route('supervisor.productions.index') }}" 
               class="flex items-center p-4 bg-red-50 dark:bg-red-900/20 rounded-lg hover:bg-red-100 dark:hover:bg-red-900/30 transition-colors">
                <i class="fas fa-cogs text-red-600 dark:text-red-400 text-xl mr-3"></i>
                <div>
                    <p class="font-medium text-gray-900 dark:text-white">Review Productions</p>
                    <p class="text-sm text-gray-600 dark:text-gray-400">{{ $stats['pending_production_approvals'] }} pending</p>
                </div>
            </a>
            
            <a href="{{ route('supervisor.purchases.index') }}" 
               class="flex items-center p-4 bg-orange-50 dark:bg-orange-900/20 rounded-lg hover:bg-orange-100 dark:hover:bg-orange-900/30 transition-colors">
                <i class="fas fa-shopping-cart text-orange-600 dark:text-orange-400 text-xl mr-3"></i>
                <div>
                    <p class="font-medium text-gray-900 dark:text-white">Review Purchases</p>
                    <p class="text-sm text-gray-600 dark:text-gray-400">{{ $stats['pending_purchase_approvals'] }} pending</p>
                </div>
            </a>
            
            <a href="{{ route('supervisor.approvals.index') }}" 
               class="flex items-center p-4 bg-yellow-50 dark:bg-yellow-900/20 rounded-lg hover:bg-yellow-100 dark:hover:bg-yellow-900/30 transition-colors">
                <i class="fas fa-clipboard-list text-yellow-600 dark:text-yellow-400 text-xl mr-3"></i>
                <div>
                    <p class="font-medium text-gray-900 dark:text-white">Order Approvals</p>
                    <p class="text-sm text-gray-600 dark:text-gray-400">{{ $stats['pending_orders'] }} pending</p>
                </div>
            </a>
        </div>
    </div>

    <!-- Recent Activities -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Recent Orders -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Recent Orders</h2>
                <a href="{{ route('supervisor.approvals.index') }}" class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 text-sm">Lihat semua</a>
            </div>
            <div class="space-y-3">
                @forelse($stats['recent_orders'] as $order)
                <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <div>
                        <p class="font-medium text-gray-900 dark:text-white">Order #{{ $order->id }}</p>
                        <p class="text-sm text-gray-600 dark:text-gray-400">{{ $order->product->product_title ?? 'N/A' }}</p>
                    </div>
                    <div class="text-right">
                        <p class="text-sm text-gray-600 dark:text-gray-400">{{ $order->quantity }} unit</p>
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                            @if($order->order_status === 'menunggu') bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-400
                            @elseif($order->order_status === 'dalam_proses') bg-blue-100 text-blue-800 dark:bg-blue-900/20 dark:text-blue-400
                            @elseif($order->order_status === 'selesai') bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-400
                            @else bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-400 @endif">
                            {{ ucfirst(str_replace('_', ' ', $order->order_status)) }}
                        </span>
                    </div>
                </div>
                @empty
                <p class="text-gray-500 dark:text-gray-400 text-center py-4">Tidak ada order terbaru</p>
                @endforelse
            </div>
        </div>

        <!-- Recent Productions -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Recent Productions</h2>
                <a href="{{ route('supervisor.productions.index') }}" class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 text-sm">Lihat semua</a>
            </div>
            <div class="space-y-3">
                @forelse($stats['recent_productions'] as $production)
                <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <div>
                        <p class="font-medium text-gray-900 dark:text-white">Production #{{ $production->id }}</p>
                        <p class="text-sm text-gray-600 dark:text-gray-400">{{ $production->product->product_title ?? 'N/A' }}</p>
                    </div>
                    <div class="text-right">
                        <p class="text-sm text-gray-600 dark:text-gray-400">{{ $production->quantity }} unit</p>
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                            @if($production->planning_status === 'planning') bg-blue-100 text-blue-800 dark:bg-blue-900/20 dark:text-blue-400
                            @elseif($production->planning_status === 'pending_approval') bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-400
                            @elseif($production->planning_status === 'approved') bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-400
                            @elseif($production->planning_status === 'rejected') bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-400
                            @else bg-gray-100 text-gray-800 dark:bg-gray-900/20 dark:text-gray-400 @endif">
                            {{ ucfirst(str_replace('_', ' ', $production->planning_status)) }}
                        </span>
                    </div>
                </div>
                @empty
                <p class="text-gray-500 dark:text-gray-400 text-center py-4">Tidak ada produksi terbaru</p>
                @endforelse
            </div>
        </div>
    </div>
</div>
@endsection