@extends('layouts.supervisor')

@section('title', 'Detail Pesanan Pembelian - Supervisor')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Detail Pesanan Pembelian</h1>
            <p class="text-gray-600 dark:text-gray-400 mt-1">Tinjau detail pesanan pembelian #{{ $purchase->id }}</p>
        </div>
        <div class="flex items-center space-x-3">
            <a href="{{ route('supervisor.purchases.index') }}" 
               class="flex items-center px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Kembali
            </a>
            @if($purchase->status === 'pending')
            <button type="button" onclick="approvePurchase({{ $purchase->id }})"
                    class="flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-lg transition-colors">
                <i class="fas fa-check mr-2"></i>
                Setujui
            </button>
            <button type="button" onclick="rejectPurchase({{ $purchase->id }})"
                    class="flex items-center px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-lg transition-colors">
                <i class="fas fa-times mr-2"></i>
                Tolak
            </button>
            @endif
        </div>
    </div>


    <!-- Purchase Info Card -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 overflow-hidden">
        <!-- Header Section -->
        <div class="bg-gradient-to-r from-orange-500 to-red-600 p-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <div class="w-16 h-16 bg-white/20 backdrop-blur-sm rounded-lg flex items-center justify-center text-white">
                        <i class="fas fa-shopping-cart text-3xl"></i>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold text-white">Pesanan Pembelian #{{ $purchase->id }}</h2>
                        <p class="text-orange-100 mt-1">
                            {{ $purchase->purchase_code ?? 'PO-' . $purchase->id }}
                        </p>
                    </div>
                </div>
                <div class="text-right">
                    <span class="inline-flex items-center px-4 py-2 text-sm font-semibold rounded-full
                        @if($purchase->status === 'approved') bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-400
                        @elseif($purchase->status === 'rejected') bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-400
                        @else bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-400 @endif">
                        @if($purchase->status === 'approved')
                            <i class="fas fa-check-circle mr-2"></i>Disetujui
                        @elseif($purchase->status === 'rejected')
                            <i class="fas fa-times-circle mr-2"></i>Ditolak
                        @else
                            <i class="fas fa-clock mr-2"></i>Menunggu Persetujuan
                        @endif
                    </span>
                </div>
            </div>
        </div>

        <!-- Info Grid -->
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-6">
                <!-- Supplier -->
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
                    <div class="flex items-center mb-2">
                        <div class="w-10 h-10 bg-green-100 dark:bg-green-900 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-store text-green-600 dark:text-green-400"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-medium text-gray-600 dark:text-gray-400">Pemasok</h3>
                            <p class="text-lg font-semibold text-gray-900 dark:text-white">
                                {{ $purchase->supplier_name ?? 'Tidak Ada' }}
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Tanggal Pembelian -->
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
                    <div class="flex items-center mb-2">
                        <div class="w-10 h-10 bg-blue-100 dark:bg-blue-900 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-calendar-alt text-blue-600 dark:text-blue-400"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-medium text-gray-600 dark:text-gray-400">Tanggal Pembelian</h3>
                            <p class="text-lg font-semibold text-gray-900 dark:text-white">
                                {{ $purchase->purchase_date ? \Carbon\Carbon::parse($purchase->purchase_date)->format('d/m/Y') : $purchase->created_at->format('d/m/Y') }}
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Tipe Pembelian -->
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
                    <div class="flex items-center mb-2">
                        <div class="w-10 h-10 bg-purple-100 dark:bg-purple-900 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas {{ $purchase->purchase_type === 'material' ? 'fa-boxes' : 'fa-cog' }} text-purple-600 dark:text-purple-400"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-medium text-gray-600 dark:text-gray-400">Tipe Pembelian</h3>
                            <span class="inline-block px-3 py-1 text-sm font-semibold rounded-full mt-1
                                {{ $purchase->purchase_type === 'material' ? 'bg-blue-100 text-blue-700 dark:bg-blue-900 dark:text-blue-300' : 'bg-green-100 text-green-700 dark:bg-green-900 dark:text-green-300' }}">
                                {{ $purchase->purchase_type === 'material' ? 'Material' : 'Suku Cadang' }}
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Total Amount -->
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
                    <div class="flex items-center mb-2">
                        <div class="w-10 h-10 bg-orange-100 dark:bg-orange-900 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-money-bill-wave text-orange-600 dark:text-orange-400"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-medium text-gray-600 dark:text-gray-400">Total Pembelian</h3>
                            <p class="text-lg font-bold text-emerald-600 dark:text-emerald-400">
                                Rp {{ number_format($purchase->total_amount, 0, ',', '.') }}
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Jumlah Item -->
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
                    <div class="flex items-center mb-2">
                        <div class="w-10 h-10 bg-indigo-100 dark:bg-indigo-900 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-list text-indigo-600 dark:text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-medium text-gray-600 dark:text-gray-400">Jumlah Item</h3>
                            <p class="text-lg font-semibold text-gray-900 dark:text-white">
                                {{ $purchase->purchaseItems->count() }} item
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Supervisor -->
                @if($purchase->approved_by && $purchase->supervisor)
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
                    <div class="flex items-center mb-2">
                        <div class="w-10 h-10 bg-teal-100 dark:bg-teal-900 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-user-check text-teal-600 dark:text-teal-400"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-medium text-gray-600 dark:text-gray-400">Disetujui Oleh</h3>
                            <p class="text-lg font-semibold text-gray-900 dark:text-white">
                                {{ $purchase->supervisor->name ?? '-' }}
                            </p>
                            @if($purchase->approved_at)
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                {{ \Carbon\Carbon::parse($purchase->approved_at)->format('d/m/Y H:i') }}
                            </p>
                            @endif
                        </div>
                    </div>
                </div>
                @endif
            </div>

            <!-- Supervisor Feedback -->
            @if($purchase->supervisor_feedback)
            <div class="bg-yellow-50 dark:bg-yellow-900/20 rounded-lg p-4 border border-yellow-200 dark:border-yellow-800 mb-6">
                <h4 class="text-md font-semibold text-gray-900 dark:text-white mb-2 flex items-center">
                    <i class="fas fa-comment text-yellow-600 mr-2"></i>
                    Umpan Balik Supervisor
                </h4>
                <p class="text-gray-700 dark:text-gray-300">{{ $purchase->supervisor_feedback }}</p>
            </div>
            @endif
        </div>
    </div>

    <!-- Items Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 bg-gray-50 dark:bg-gray-700">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-list mr-2 text-orange-600"></i>
                Daftar Item ({{ $purchase->purchaseItems->count() }} item)
            </h3>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">No</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Item</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Unit</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Jumlah</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Harga Satuan</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Total</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse($purchase->purchaseItems as $item)
                    @php
                        $itemData = null;
                        $imageUrl = asset('images/no-image.png');

                        if ($item->item_type === 'material' && $item->item_id) {
                            $itemData = $item->material;
                            if ($itemData && $itemData->image) {
                                $imageUrl = asset('uploads/materials/' . $itemData->image);
                            }
                        } elseif ($item->item_type === 'sparepart' && $item->item_id) {
                            $itemData = $item->sparepart;
                            if ($itemData && $itemData->image) {
                                $imageUrl = asset('uploads/spareparts/' . $itemData->image);
                            }
                        }
                    @endphp
                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                            {{ $loop->iteration }}
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <img src="{{ $imageUrl }}" alt="{{ $item->item_name }}"
                                    class="h-12 w-12 object-cover rounded-lg border border-gray-200 dark:border-gray-600"
                                    onerror="this.src='{{ asset('images/no-image.png') }}'">
                                <div class="ml-4">
                                    <p class="font-semibold text-gray-900 dark:text-white">{{ $item->item_name }}</p>
                                    <span class="inline-flex items-center px-2 py-0.5 text-xs font-semibold rounded-full mt-1
                                        {{ $item->item_type === 'material' ? 'bg-blue-100 text-blue-700 dark:bg-blue-900 dark:text-blue-300' : 'bg-green-100 text-green-700 dark:bg-green-900 dark:text-green-300' }}">
                                        {{ $item->item_type === 'material' ? 'Material' : 'Suku Cadang' }}
                                    </span>
                                    @if($itemData)
                                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                        @if($item->item_type === 'material')
                                            {{ $itemData->material_code ?? '-' }} | {{ $itemData->category ?? '-' }}
                                        @else
                                            {{ $itemData->part_code ?? '-' }} | {{ $itemData->brand ?? '-' }}
                                        @endif
                                    </p>
                                    @endif
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-700 dark:text-gray-300">
                            {{ $item->unit ?? '-' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-semibold text-gray-900 dark:text-white">
                            {{ number_format($item->quantity, 0, ',', '.') }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm text-gray-700 dark:text-gray-300">
                            Rp {{ number_format($item->unit_price, 0, ',', '.') }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-bold text-gray-900 dark:text-white">
                            Rp {{ number_format($item->total_price, 0, ',', '.') }}
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-6 py-8 text-center text-gray-500 dark:text-gray-400">
                            <i class="fas fa-inbox text-4xl mb-2 block"></i>
                            Tidak ada item
                        </td>
                    </tr>
                    @endforelse
                </tbody>
                <tfoot class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <td colspan="5" class="px-6 py-4 text-right text-sm font-bold text-gray-900 dark:text-white uppercase">
                            Total Pembelian:
                        </td>
                        <td class="px-6 py-4 text-right text-lg font-bold text-emerald-600 dark:text-emerald-400">
                            Rp {{ number_format($purchase->total_amount, 0, ',', '.') }}
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <!-- Notes Section -->
    @if($purchase->notes)
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3 flex items-center">
            <i class="fas fa-sticky-note text-yellow-600 mr-2"></i>
            Catatan Pembelian
        </h3>
        <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
            <p class="text-gray-700 dark:text-gray-300 whitespace-pre-line">{{ $purchase->notes }}</p>
        </div>
    </div>
    @endif
</div>

<!-- Modal Persetujuan -->
<div id="approvalModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-xl max-w-md w-full">
            <div class="p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Setujui Pesanan Pembelian</h3>
                <form id="approvalForm" method="POST">
                    @csrf
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Umpan Balik (Opsional)
                        </label>
                        <textarea name="feedback" rows="3" 
                                class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent dark:bg-gray-700 dark:text-white"
                                placeholder="Berikan umpan balik..."></textarea>
                    </div>
                    <div class="flex items-center justify-end space-x-3">
                        <button type="button" onclick="closeApprovalModal()"
                                class="px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                            Batal
                        </button>
                        <button type="submit"
                                class="px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-lg transition-colors">
                            <i class="fas fa-check mr-2"></i>
                            Setujui
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal Penolakan -->
<div id="rejectionModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-xl max-w-md w-full">
            <div class="p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Tolak Pesanan Pembelian</h3>
                <form id="rejectionForm" method="POST">
                    @csrf
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Alasan Penolakan <span class="text-red-500">*</span>
                        </label>
                        <textarea name="feedback" rows="3" required
                                class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-red-500 focus:border-transparent dark:bg-gray-700 dark:text-white"
                                placeholder="Berikan alasan mengapa pesanan pembelian ditolak..."></textarea>
                    </div>
                    <div class="flex items-center justify-end space-x-3">
                        <button type="button" onclick="closeRejectionModal()"
                                class="px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                            Batal
                        </button>
                        <button type="submit"
                                class="px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-lg transition-colors">
                            <i class="fas fa-times mr-2"></i>
                            Tolak
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function approvePurchase(purchaseId) {
    const form = document.getElementById('approvalForm');
    form.action = `/supervisor/purchases/${purchaseId}/approve`;
    document.getElementById('approvalModal').classList.remove('hidden');
}

function rejectPurchase(purchaseId) {
    const form = document.getElementById('rejectionForm');
    form.action = `/supervisor/purchases/${purchaseId}/reject`;
    document.getElementById('rejectionModal').classList.remove('hidden');
}

function closeApprovalModal() {
    document.getElementById('approvalModal').classList.add('hidden');
}

function closeRejectionModal() {
    document.getElementById('rejectionModal').classList.add('hidden');
}

// Tutup modal saat klik di luar
document.getElementById('approvalModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeApprovalModal();
    }
});

document.getElementById('rejectionModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeRejectionModal();
    }
});
</script>
@endsection

