@extends('layouts.supervisor')

@section('title', 'Laporan Produksi - Supervisor')

@section('content')
<div class="space-y-6">
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Laporan Produksi</h1>
            <p class="text-gray-600 dark:text-gray-400 mt-1">Ringkasan biaya bahan, sparepart, upah, dan status produksi</p>
        </div>
    </div>

    <form method="GET" class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-4">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm text-gray-600 dark:text-gray-300 mb-1">Tanggal Mulai</label>
                <input type="date" name="start_date" value="{{ request('start_date') }}" class="w-full px-3 py-2 border dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white">
            </div>
            <div>
                <label class="block text-sm text-gray-600 dark:text-gray-300 mb-1">Tanggal Selesai</label>
                <input type="date" name="end_date" value="{{ request('end_date') }}" class="w-full px-3 py-2 border dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white">
            </div>
            <div>
                <label class="block text-sm text-gray-600 dark:text-gray-300 mb-1">Status</label>
                <select name="status" class="w-full px-3 py-2 border dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white">
                    <option value="">Semua</option>
                    @foreach(['menunggu','dalam_proses','selesai','dibatalkan'] as $st)
                        <option value="{{ $st }}" @selected(request('status')===$st)>{{ ucfirst(str_replace('_',' ',$st)) }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-sm text-gray-600 dark:text-gray-300 mb-1">Produk</label>
                <select name="product_id" class="w-full px-3 py-2 border dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white">
                    <option value="">Semua</option>
                    @foreach($productList as $p)
                        <option value="{{ $p->id }}" @selected(request('product_id')==$p->id)>{{ $p->product_title }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="mt-4 flex items-center justify-end gap-3">
            <a href="{{ route('supervisor.reports.productions') }}" class="px-4 py-2 bg-gray-200 dark:bg-gray-700 text-gray-800 dark:text-gray-200 rounded">Reset</a>
            <button class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded">Terapkan</button>
        </div>
    </form>

    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div class="bg-white dark:bg-gray-800 p-4 rounded border dark:border-gray-700">
            <div class="text-sm text-gray-500 dark:text-gray-400">Total Produksi</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white">{{ number_format($totalProductions) }}</div>
        </div>
        <div class="bg-white dark:bg-gray-800 p-4 rounded border dark:border-gray-700">
            <div class="text-sm text-gray-500 dark:text-gray-400">Biaya Bahan</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white">Rp {{ number_format($totalMaterialCost,0,',','.') }}</div>
        </div>
        <div class="bg-white dark:bg-gray-800 p-4 rounded border dark:border-gray-700">
            <div class="text-sm text-gray-500 dark:text-gray-400">Biaya Sparepart</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white">Rp {{ number_format($totalSparepartCost,0,',','.') }}</div>
        </div>
        <div class="bg-white dark:bg-gray-800 p-4 rounded border dark:border-gray-700">
            <div class="text-sm text-gray-500 dark:text-gray-400">Upah (Labor)</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white">Rp {{ number_format($totalLaborCost,0,',','.') }}</div>
        </div>
    </div>

    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300">Prod ID</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300">Order</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300">Produk</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300">Teknisi</th>
                        <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300">Bahan</th>
                        <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300">Sparepart</th>
                        <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300">Labor</th>
                        <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300">Total</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300">Status</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300">Tanggal</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @forelse($productions as $prd)
                    @php
                        $total = ($prd->total_production_cost ?? 0) + ($prd->labor_cost ?? 0);
                    @endphp
                    <tr>
                        <td class="px-4 py-3 text-sm text-gray-900 dark:text-gray-100">#{{ $prd->id }}</td>
                        <td class="px-4 py-3 text-sm">#{{ $prd->order->id ?? '-' }}<div class="text-xs text-gray-500">{{ $prd->order->customer_name ?? '-' }}</div></td>
                        <td class="px-4 py-3 text-sm">{{ $prd->product->product_title ?? '-' }}</td>
                        <td class="px-4 py-3 text-sm">{{ $prd->teknisi->name ?? '-' }}</td>
                        <td class="px-4 py-3 text-sm text-right">Rp {{ number_format($prd->total_material_cost ?? 0,0,',','.') }}</td>
                        <td class="px-4 py-3 text-sm text-right">Rp {{ number_format($prd->total_sparepart_cost ?? 0,0,',','.') }}</td>
                        <td class="px-4 py-3 text-sm text-right">Rp {{ number_format($prd->labor_cost ?? 0,0,',','.') }}</td>
                        <td class="px-4 py-3 text-sm text-right font-semibold">Rp {{ number_format($total,0,',','.') }}</td>
                        <td class="px-4 py-3 text-sm">{{ ucfirst(str_replace('_',' ',$prd->status)) }}</td>
                        <td class="px-4 py-3 text-sm">{{ $prd->created_at?->format('d/m/Y') }}</td>
                    </tr>
                    <tr class="bg-gray-50/40 dark:bg-gray-900/30">
                        <td colspan="10" class="px-4 py-3">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <h4 class="text-xs font-semibold text-gray-700 dark:text-gray-300 mb-2">Bahan</h4>
                                    @if($prd->productionMaterials && $prd->productionMaterials->count())
                                    <div class="overflow-x-auto border border-gray-200 dark:border-gray-700 rounded">
                                        <table class="min-w-full text-xs">
                                            <thead class="bg-gray-100 dark:bg-gray-800">
                                                <tr>
                                                    <th class="px-2 py-2 text-left">Nama</th>
                                                    <th class="px-2 py-2 text-right">Qty</th>
                                                    <th class="px-2 py-2 text-left">Unit</th>
                                                    <th class="px-2 py-2 text-right">Harga</th>
                                                    <th class="px-2 py-2 text-right">Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($prd->productionMaterials as $pm)
                                                <tr class="border-t border-gray-200 dark:border-gray-700">
                                                    <td class="px-2 py-2">{{ $pm->material->name }}</td>
                                                    <td class="px-2 py-2 text-right">{{ rtrim(rtrim(number_format($pm->quantity, 2, ',', '.'), '0'), ',') }}</td>
                                                    <td class="px-2 py-2">{{ $pm->unit }}</td>
                                                    <td class="px-2 py-2 text-right">Rp {{ number_format($pm->unit_cost,0,',','.') }}</td>
                                                    <td class="px-2 py-2 text-right">Rp {{ number_format($pm->total_cost,0,',','.') }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    @else
                                        <p class="text-xs text-gray-500">Tidak ada bahan.</p>
                                    @endif
                                </div>
                                <div>
                                    <h4 class="text-xs font-semibold text-gray-700 dark:text-gray-300 mb-2">Sparepart</h4>
                                    @if($prd->productionSpareparts && $prd->productionSpareparts->count())
                                    <div class="overflow-x-auto border border-gray-200 dark:border-gray-700 rounded">
                                        <table class="min-w-full text-xs">
                                            <thead class="bg-gray-100 dark:bg-gray-800">
                                                <tr>
                                                    <th class="px-2 py-2 text-left">Nama</th>
                                                    <th class="px-2 py-2 text-right">Qty</th>
                                                    <th class="px-2 py-2 text-left">Unit</th>
                                                    <th class="px-2 py-2 text-right">Harga</th>
                                                    <th class="px-2 py-2 text-right">Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($prd->productionSpareparts as $ps)
                                                <tr class="border-t border-gray-200 dark:border-gray-700">
                                                    <td class="px-2 py-2">{{ $ps->sparepart->name }}</td>
                                                    <td class="px-2 py-2 text-right">{{ rtrim(rtrim(number_format($ps->quantity, 2, ',', '.'), '0'), ',') }}</td>
                                                    <td class="px-2 py-2">{{ $ps->unit }}</td>
                                                    <td class="px-2 py-2 text-right">Rp {{ number_format($ps->unit_cost,0,',','.') }}</td>
                                                    <td class="px-2 py-2 text-right">Rp {{ number_format($ps->total_cost,0,',','.') }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    @else
                                        <p class="text-xs text-gray-500">Tidak ada sparepart.</p>
                                    @endif
                                </div>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="10" class="px-4 py-6 text-center text-gray-500">Tidak ada data</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ $productions->links() }}</div>
    </div>
</div>
@endsection


