@extends('layouts.teknisi')

@section('title', 'Dashboard Teknisi - POLJAM TECH')

@section('content')
<!-- Page Header -->
<div class="mb-6 sm:mb-8">
    <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white mb-2">Dashboard</h1>
    <p class="text-gray-600 dark:text-gray-400">Selamat datang kembali, {{ Auth::user()->name }}! Berikut ringkasan aktivitas produksi Anda hari ini.</p>
        </div>

@include('teknisi.partials.dashboard-stats-cards')
@include('teknisi.partials.dashboard-status-summaries')
@include('teknisi.partials.dashboard-quick-stats')
@include('teknisi.partials.dashboard-charts')
@include('teknisi.partials.dashboard-recent-activities')
@endsection

@section('scripts')
<script>
// Real-time update untuk dashboard (opsional)
document.addEventListener('DOMContentLoaded', function() {
    // Auto-refresh setiap 30 detik untuk data real-time
    setInterval(function() {
        // Hanya refresh jika halaman masih aktif
        if (!document.hidden) {
            // Bisa ditambahkan AJAX call untuk update stats
            // Untuk sekarang, hanya refresh halaman jika diperlukan
        }
    }, 30000);
});
</script>
@endsection
