<!-- Navbar -->
<nav id="teknisiNavbar" class="bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700 fixed top-0 left-0 right-0 z-40 transition-all duration-300">
    <div class="px-3 sm:px-4 py-2.5 sm:py-3 flex items-center justify-between w-full">
        <!-- Left: Burger Button -->
        <button onclick="toggleSidebar()" class="text-gray-600 hover:text-gray-900 dark:text-gray-300 dark:hover:text-white transition-colors duration-200 p-1.5">
            <i class="fas fa-bars text-lg"></i>
        </button>

        <!-- Center: Search -->
        {{-- <div class="flex-1 max-w-md mx-8">
            <div class="relative">
                <input type="text" placeholder="Cari..."
                    class="w-full px-4 py-2 pl-10 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                <i class="fas fa-search absolute left-3 top-3 text-gray-400 dark:text-gray-500"></i>
            </div>
        </div> --}}

        <!-- Right: Icons & Profile -->
        <div class="flex items-center space-x-1.5 sm:space-x-3 flex-shrink-0">
            <!-- Light/Dark Mode Toggle -->
            <button onclick="toggleDarkMode()" class="text-gray-600 hover:text-gray-900 dark:text-gray-300 dark:hover:text-white transition-colors duration-200 p-1.5 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700" title="Toggle Dark Mode">
                <i id="darkModeIcon" class="fas fa-moon text-lg"></i>
            </button>

            <!-- Notification -->
            <button id="notification-toggle-btn" class="notification-icon text-gray-600 hover:text-gray-900 dark:text-gray-300 dark:hover:text-white relative transition-colors duration-200 p-1.5">
                <i class="fas fa-bell text-lg"></i>
                <span id="notification-count" class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center hidden">0</span>
            </button>

            <!-- Profile Dropdown -->
            <div class="relative">
                <button onclick="toggleProfileMenu()"
                    class="w-9 h-9 rounded-full overflow-hidden border-2 border-gray-300 dark:border-gray-600 hover:border-blue-500 dark:hover:border-blue-400 transition-colors duration-200">
                    @if(Auth::user()->photo && \Storage::disk('uploads')->exists('profiles/' . Auth::user()->photo))
                        <img src="{{ asset('uploads/profiles/' . Auth::user()->photo) }}" 
                             alt="{{ Auth::user()->name }}" 
                             class="w-full h-full object-cover">
                    @else
                        <div class="w-full h-full bg-gradient-to-br from-blue-500 to-purple-600 flex items-center justify-center text-white font-bold">
                            {{ strtoupper(substr(Auth::user()->name, 0, 1)) }}
                        </div>
                    @endif
                </button>
                <div id="profileMenu" class="hidden absolute right-0 mt-2 w-48 bg-white dark:bg-gray-700 rounded-lg border border-gray-200 dark:border-gray-600 py-2 transition-colors duration-300">
                    <div class="px-4 py-2 border-b border-gray-200 dark:border-gray-600">
                        <p class="text-sm font-semibold text-gray-900 dark:text-white">{{ Auth::user()->name }}</p>
                        <p class="text-xs text-gray-500 dark:text-gray-400">{{ Auth::user()->email }}</p>
                    </div>
                    <a href="{{ route('profile.edit') }}" class="block px-4 py-2 text-gray-800 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 transition-colors duration-200">
                        <i class="fas fa-user-edit mr-2"></i>Edit Profil
                    </a>
                    <!-- Tombol Log Out yang sudah difungsikan -->
                    <form method="POST" action="{{ route('logout') }}" class="block">
                        @csrf
                        <button type="submit"
                            class="w-full text-left px-4 py-2 text-gray-800 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 flex items-center transition-colors duration-200">
                            <i class="fas fa-sign-out-alt mr-2"></i>Log Out
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</nav>

<script>
// Dark Mode Toggle Functionality
function toggleDarkMode() {
    console.log('Dark mode toggle clicked');
    
    const html = document.documentElement;
    const darkModeIcon = document.getElementById('darkModeIcon');
    
    // Check current state
    const isDark = html.classList.contains('dark');
    console.log('Current dark mode state:', isDark);
    
    if (isDark) {
        // Switch to light mode
        html.classList.remove('dark');
        darkModeIcon.className = 'fas fa-moon text-xl';
        localStorage.setItem('darkMode', 'disabled');
        console.log('Switched to light mode');
    } else {
        // Switch to dark mode
        html.classList.add('dark');
        darkModeIcon.className = 'fas fa-sun text-xl';
        localStorage.setItem('darkMode', 'enabled');
        console.log('Switched to dark mode');
    }

    // Notify listeners (e.g., charts) that theme has changed
    // NO PAGE REFRESH NEEDED - charts will update automatically
    document.dispatchEvent(new CustomEvent('theme:toggle', { detail: { isDark: html.classList.contains('dark') } }));
}

// Initialize dark mode
function initDarkMode() {
    const savedMode = localStorage.getItem('darkMode');
    const html = document.documentElement;
    const darkModeIcon = document.getElementById('darkModeIcon');
    
    console.log('Saved dark mode preference:', savedMode);
    
    if (savedMode === 'enabled') {
        html.classList.add('dark');
        if (darkModeIcon) {
            darkModeIcon.className = 'fas fa-sun text-xl';
        }
        console.log('Dark mode initialized as enabled');
    } else {
        html.classList.remove('dark');
        if (darkModeIcon) {
            darkModeIcon.className = 'fas fa-moon text-xl';
        }
        console.log('Dark mode initialized as disabled');
    }
}

// Initialize when DOM is ready
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initDarkMode);
} else {
    initDarkMode();
}

// Profile Menu Toggle
function toggleProfileMenu() {
    const profileMenu = document.getElementById('profileMenu');
    if (profileMenu) {
        profileMenu.classList.toggle('hidden');
    }
}

// Close profile menu when clicking outside
document.addEventListener('click', function(event) {
    const profileMenu = document.getElementById('profileMenu');
    const profileButton = event.target.closest('button[onclick="toggleProfileMenu()"]');
    
    if (profileMenu && !profileButton && !profileMenu.contains(event.target)) {
        profileMenu.classList.add('hidden');
    }
});
</script>

