{{-- 
    Form Request Item Baru/Tambahan
    Untuk teknisi meminta bahan/sparepart yang tidak tersedia atau tambahan
    Variables: $production, $materials, $spareparts, $itemRequestsByProposal
--}}

@php
    $canRequestItem = $production->planning_status === 'approved' || $production->status === 'dalam_proses';
@endphp

<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border border-slate-200 dark:border-gray-700 overflow-hidden">
    <div class="px-4 py-3 bg-gradient-to-r from-amber-500 to-orange-500">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <div class="w-10 h-10 bg-white/20 rounded-lg flex items-center justify-center mr-3">
                    <i class="fas fa-plus-circle text-white text-lg"></i>
                </div>
                <div>
                    <h2 class="text-lg font-bold text-white">Request Item Tambahan</h2>
                    <p class="text-xs text-amber-100">Minta bahan/sparepart baru atau tambahan</p>
                </div>
            </div>
            @if($canRequestItem)
            <button type="button" onclick="openRequestItemModal()" class="px-3 py-1.5 bg-white/20 hover:bg-white/30 text-white text-xs font-medium rounded-lg transition-colors">
                <i class="fas fa-plus mr-1"></i> Request Baru
            </button>
            @endif
        </div>
    </div>

    <div class="p-4">
        {{-- Tabel Usulan berdasarkan Proposal Number --}}
        @if($itemRequestsByProposal && $itemRequestsByProposal->count() > 0)
            @foreach($itemRequestsByProposal as $proposalNum => $requests)
            <div class="mb-4 last:mb-0">
                <div class="flex items-center justify-between mb-2">
                    <h3 class="text-sm font-semibold text-slate-700 dark:text-gray-300">
                        <i class="fas fa-file-alt mr-1"></i> Usulan ke-{{ $proposalNum }}
                    </h3>
                    <button type="button" onclick="openProposalModal({{ $proposalNum }})" class="text-xs text-indigo-600 hover:text-indigo-800 dark:text-indigo-400">
                        <i class="fas fa-external-link-alt mr-1"></i> Detail & Cetak
                    </button>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-sm">
                        <thead class="bg-amber-50 dark:bg-amber-900/20">
                            <tr>
                                <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300">Tipe</th>
                                <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300">Nama Item</th>
                                <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300">Jumlah</th>
                                <th class="px-3 py-2 text-left text-xs font-semibold text-slate-600 dark:text-gray-300">Alasan</th>
                                <th class="px-3 py-2 text-center text-xs font-semibold text-slate-600 dark:text-gray-300">Status</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-200 dark:divide-gray-700">
                            @foreach($requests as $request)
                            <tr class="hover:bg-amber-50/50 dark:hover:bg-amber-900/10">
                                <td class="px-3 py-2">
                                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium {{ $request->item_type === 'material' ? 'bg-emerald-100 text-emerald-700' : 'bg-blue-100 text-blue-700' }}">
                                        {{ $request->item_type_label }}
                                    </span>
                                    @if($request->is_new_item)
                                    <span class="ml-1 inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium bg-purple-100 text-purple-700">
                                        Baru
                                    </span>
                                    @endif
                                </td>
                                <td class="px-3 py-2">
                                    <div class="font-medium text-slate-900 dark:text-white">{{ $request->item_name_display }}</div>
                                    @if($request->item_description)
                                    <div class="text-xs text-slate-500">{{ Str::limit($request->item_description, 50) }}</div>
                                    @endif
                                </td>
                                <td class="px-3 py-2 text-center">
                                    <span class="font-medium">{{ $request->quantity }}</span>
                                    <span class="text-slate-500">{{ $request->unit }}</span>
                                </td>
                                <td class="px-3 py-2 text-slate-600 dark:text-gray-400 text-xs">
                                    {{ Str::limit($request->reason, 80) }}
                                </td>
                                <td class="px-3 py-2 text-center">
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $request->status_badge_class }}">
                                        {{ $request->status_label }}
                                    </span>
                                    @if($request->admin_notes)
                                    <div class="mt-1 text-[10px] text-slate-500" title="{{ $request->admin_notes }}">
                                        <i class="fas fa-comment mr-1"></i>{{ Str::limit($request->admin_notes, 30) }}
                                    </div>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @endforeach
        @else
        <div class="text-center py-6">
            <div class="w-12 h-12 mx-auto mb-3 bg-amber-100 dark:bg-amber-900/30 rounded-full flex items-center justify-center">
                <i class="fas fa-inbox text-amber-500 dark:text-amber-400 text-xl"></i>
            </div>
            <p class="text-slate-500 dark:text-gray-400 text-sm">Belum ada request item tambahan.</p>
            @if($canRequestItem)
            <button type="button" onclick="openRequestItemModal()" class="mt-2 text-sm text-amber-600 hover:text-amber-800 dark:text-amber-400">
                <i class="fas fa-plus mr-1"></i> Buat Request Pertama
            </button>
            @endif
        </div>
        @endif
    </div>
</div>

{{-- Modal Request Item --}}
<div id="requestItemModal" class="fixed inset-0 z-50 hidden overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:p-0">
        <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75" onclick="closeRequestItemModal()"></div>
        
        <div class="relative inline-block w-full max-w-lg p-6 overflow-hidden text-left align-middle transition-all transform bg-white dark:bg-gray-800 shadow-xl rounded-2xl">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-bold text-gray-900 dark:text-white">
                    <i class="fas fa-plus-circle text-amber-500 mr-2"></i>Request Item Baru
                </h3>
                <button type="button" onclick="closeRequestItemModal()" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <form action="{{ route('teknisi.productions.request-item', $production) }}" method="POST" id="requestItemForm">
                @csrf
                
                <div class="space-y-4">
                    {{-- Tipe Item --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Tipe Item *</label>
                        <select name="item_type" id="requestItemType" required class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-amber-500 dark:bg-gray-700 dark:text-white" onchange="toggleItemTypeFields()">
                            <option value="">-- Pilih Tipe --</option>
                            <option value="material">Bahan (Material)</option>
                            <option value="sparepart">Sparepart</option>
                        </select>
                    </div>
                    
                    {{-- Pilih dari sistem atau item baru --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Sumber Item</label>
                        <div class="flex gap-4">
                            <label class="inline-flex items-center">
                                <input type="radio" name="item_source" value="existing" checked onchange="toggleItemSource()" class="text-amber-500 focus:ring-amber-500">
                                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Dari Sistem</span>
                            </label>
                            <label class="inline-flex items-center">
                                <input type="radio" name="item_source" value="new" onchange="toggleItemSource()" class="text-amber-500 focus:ring-amber-500">
                                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Item Baru</span>
                            </label>
                        </div>
                    </div>
                    
                    {{-- Select dari sistem --}}
                    <div id="existingItemFields">
                        <div id="materialSelectField" class="hidden">
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Pilih Bahan</label>
                            <select name="material_id" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-amber-500 dark:bg-gray-700 dark:text-white">
                                <option value="">-- Pilih Bahan --</option>
                                @foreach($materials as $material)
                                <option value="{{ $material->id }}" data-stock="{{ $material->stock }}" data-unit="{{ $material->unit }}">
                                    {{ $material->name }} (Stok: {{ $material->stock }} {{ $material->unit }})
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div id="sparepartSelectField" class="hidden">
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Pilih Sparepart</label>
                            <select name="sparepart_id" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-amber-500 dark:bg-gray-700 dark:text-white">
                                <option value="">-- Pilih Sparepart --</option>
                                @foreach($spareparts as $sparepart)
                                <option value="{{ $sparepart->id }}" data-stock="{{ $sparepart->stock }}" data-unit="{{ $sparepart->unit }}">
                                    {{ $sparepart->name }} (Stok: {{ $sparepart->stock }} {{ $sparepart->unit }})
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    {{-- Input item baru --}}
                    <div id="newItemFields" class="hidden space-y-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Nama Item Baru *</label>
                            <input type="text" name="item_name" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-amber-500 dark:bg-gray-700 dark:text-white" placeholder="Nama item yang dibutuhkan">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Deskripsi</label>
                            <textarea name="item_description" rows="2" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-amber-500 dark:bg-gray-700 dark:text-white" placeholder="Deskripsi detail item"></textarea>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Estimasi Harga</label>
                            <input type="number" name="estimated_price" min="0" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-amber-500 dark:bg-gray-700 dark:text-white" placeholder="0">
                        </div>
                    </div>
                    
                    {{-- Jumlah dan Satuan --}}
                    <div class="grid grid-cols-2 gap-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Jumlah *</label>
                            <input type="number" name="quantity" required min="0.01" step="0.01" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-amber-500 dark:bg-gray-700 dark:text-white" placeholder="0">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Satuan *</label>
                            <input type="text" name="unit" required class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-amber-500 dark:bg-gray-700 dark:text-white" placeholder="pcs, kg, meter, dll">
                        </div>
                    </div>
                    
                    {{-- Usulan ke-berapa --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Usulan Ke-</label>
                        <select name="proposal_number" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-amber-500 dark:bg-gray-700 dark:text-white">
                            <option value="1">Usulan Pertama</option>
                            <option value="2">Usulan Kedua</option>
                            <option value="3">Usulan Ketiga</option>
                        </select>
                    </div>
                    
                    {{-- Alasan --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Alasan Permintaan *</label>
                        <textarea name="reason" required rows="3" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-amber-500 dark:bg-gray-700 dark:text-white" placeholder="Jelaskan mengapa item ini dibutuhkan..."></textarea>
                    </div>
                </div>
                
                <div class="mt-6 flex justify-end gap-3">
                    <button type="button" onclick="closeRequestItemModal()" class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200 dark:bg-gray-700 dark:text-gray-300 dark:hover:bg-gray-600">
                        Batal
                    </button>
                    <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-amber-500 rounded-lg hover:bg-amber-600">
                        <i class="fas fa-paper-plane mr-1"></i> Kirim Request
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- Modal Detail Usulan dengan Cetak PDF --}}
<div id="proposalDetailModal" class="fixed inset-0 z-50 hidden overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:p-0">
        <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75" onclick="closeProposalModal()"></div>
        
        <div class="relative inline-block w-full max-w-2xl p-6 overflow-hidden text-left align-middle transition-all transform bg-white dark:bg-gray-800 shadow-xl rounded-2xl">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-bold text-gray-900 dark:text-white">
                    <i class="fas fa-file-alt text-indigo-500 mr-2"></i>Detail Usulan ke-<span id="proposalNumber">1</span>
                </h3>
                <div class="flex gap-2">
                    <button type="button" onclick="printProposal()" class="px-3 py-1.5 text-sm font-medium text-white bg-indigo-500 rounded-lg hover:bg-indigo-600">
                        <i class="fas fa-print mr-1"></i> Cetak PDF
                    </button>
                    <button type="button" onclick="closeProposalModal()" class="text-gray-400 hover:text-gray-600">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            
            <div id="proposalContent">
                {{-- Content will be loaded dynamically --}}
            </div>
        </div>
    </div>
</div>

<script>
function openRequestItemModal() {
    document.getElementById('requestItemModal').classList.remove('hidden');
}

function closeRequestItemModal() {
    document.getElementById('requestItemModal').classList.add('hidden');
    document.getElementById('requestItemForm').reset();
}

function toggleItemTypeFields() {
    const type = document.getElementById('requestItemType').value;
    document.getElementById('materialSelectField').classList.toggle('hidden', type !== 'material');
    document.getElementById('sparepartSelectField').classList.toggle('hidden', type !== 'sparepart');
}

function toggleItemSource() {
    const source = document.querySelector('input[name="item_source"]:checked').value;
    document.getElementById('existingItemFields').classList.toggle('hidden', source === 'new');
    document.getElementById('newItemFields').classList.toggle('hidden', source === 'existing');
}

function openProposalModal(proposalNum) {
    document.getElementById('proposalNumber').textContent = proposalNum;
    document.getElementById('proposalDetailModal').classList.remove('hidden');
    // Load content via AJAX or use existing data
}

function closeProposalModal() {
    document.getElementById('proposalDetailModal').classList.add('hidden');
}

function printProposal() {
    window.print(); // Simple print, can be enhanced with PDF generation
}
</script>

