@extends('layouts.teknisi')

@section('title', 'Detail Laporan Produksi #' . $production->id . ' - Teknisi')

@section('content')
<div class="space-y-6">
    <!-- Header Laporan Resmi -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border-2 border-gray-300 dark:border-gray-600 shadow-lg p-6 mb-6">
        <div class="text-center border-b-2 border-gray-300 dark:border-gray-600 pb-4 mb-4">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">LAPORAN PRODUKSI</h1>
            <p class="text-sm text-gray-600 dark:text-gray-400">POLJAM TECH</p>
        </div>
        <div class="grid grid-cols-2 gap-4 text-sm">
            <div>
                <span class="font-semibold text-gray-700 dark:text-gray-300">Nomor Laporan:</span>
                <span class="text-gray-900 dark:text-white">PROD-{{ str_pad($production->id, 6, '0', STR_PAD_LEFT) }}</span>
            </div>
            <div class="text-right">
                <span class="font-semibold text-gray-700 dark:text-gray-300">Tanggal Laporan:</span>
                <span class="text-gray-900 dark:text-white">{{ now()->format('d M Y, H:i') }}</span>
            </div>
        </div>
    </div>

    <!-- Header Navigation -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-xl font-bold text-gray-800 dark:text-white">Detail Produksi</h2>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    Produksi #{{ $production->id }} - {{ $production->product->product_title ?? 'N/A' }}
                </p>
            </div>
            <div class="flex items-center gap-2">
                <a href="{{ route('teknisi.reports.productions') }}" 
                   class="inline-flex items-center justify-center px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                    <i class="fas fa-arrow-left mr-2 text-xs"></i>
                    Kembali
                </a>
                <button onclick="window.print()" class="inline-flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                    <i class="fas fa-print mr-2 text-xs"></i>
                    Cetak
                </button>
            </div>
        </div>
    </div>

    <!-- Info Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
        <!-- Order Info -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Order ID</p>
                    <h2 class="text-xl font-bold text-blue-600 dark:text-blue-400">#{{ $production->order->id ?? 'N/A' }}</h2>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">{{ $production->order->customer_name ?? 'N/A' }}</p>
                </div>
                <div class="p-2.5 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-shopping-cart text-blue-600 dark:text-blue-400 text-lg"></i>
                </div>
            </div>
        </div>

        <!-- Product Info -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div class="flex-1 min-w-0">
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Produk</p>
                    <h2 class="text-sm font-bold text-indigo-600 dark:text-indigo-400 truncate">{{ $production->product->product_title ?? 'N/A' }}</h2>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Qty: {{ $production->quantity ?? 1 }} unit</p>
                </div>
                <div class="p-2.5 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg ml-2">
                    <i class="fas fa-box text-indigo-600 dark:text-indigo-400 text-lg"></i>
                </div>
            </div>
        </div>

        <!-- Status Info -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Status</p>
                    @php
                        $statusColors = [
                            'menunggu' => 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300',
                            'dalam_proses' => 'bg-blue-100 text-blue-800 dark:bg-blue-900/30 dark:text-blue-300',
                            'selesai' => 'bg-emerald-100 text-emerald-800 dark:bg-emerald-900/30 dark:text-emerald-300',
                            'dibatalkan' => 'bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-300',
                        ];
                        $statusIcons = [
                            'menunggu' => 'fa-pause',
                            'dalam_proses' => 'fa-cogs',
                            'selesai' => 'fa-check-circle',
                            'dibatalkan' => 'fa-times-circle',
                        ];
                        $status = $production->status;
                        $color = $statusColors[$status] ?? $statusColors['menunggu'];
                        $icon = $statusIcons[$status] ?? 'fa-circle';
                    @endphp
                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-md text-xs font-semibold {{ $color }}">
                        <i class="fas {{ $icon }}"></i>
                        {{ ucfirst(str_replace('_',' ',$status)) }}
                    </span>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">{{ $production->created_at?->format('d M Y') }}</p>
                </div>
                <div class="p-2.5 bg-purple-100 dark:bg-purple-900/40 rounded-lg ml-2">
                    <i class="fas fa-tasks text-purple-600 dark:text-purple-400 text-lg"></i>
                </div>
            </div>
        </div>

        <!-- Total Cost -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Biaya</p>
                    <h2 class="text-xl font-bold text-red-600 dark:text-red-400">Rp {{ number_format($totalCost,0,',','.') }}</h2>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Semua komponen</p>
                </div>
                <div class="p-2.5 bg-red-100 dark:bg-red-900/40 rounded-lg">
                    <i class="fas fa-calculator text-red-600 dark:text-red-400 text-lg"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Informasi Personil & Approval -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 mb-4">
        <!-- Personil -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <div class="flex items-center">
                    <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg mr-2">
                        <i class="fas fa-users text-indigo-600 dark:text-indigo-400 text-sm"></i>
                    </div>
                    <h3 class="text-base font-semibold text-gray-800 dark:text-white">Personil yang Terlibat</h3>
                </div>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    <div class="flex items-center justify-between">
                        <div>
                            <div class="text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Teknisi Bertanggung Jawab</div>
                            <div class="text-sm font-semibold text-gray-900 dark:text-white">{{ $production->teknisi->name ?? 'N/A' }}</div>
                        </div>
                        <div class="text-xs text-gray-500 dark:text-gray-400">
                            ID: {{ $production->teknisi_id ?? 'N/A' }}
                        </div>
                    </div>
                    @if($production->supervisor)
                    <div class="flex items-center justify-between pt-3 border-t border-gray-200 dark:border-gray-600">
                        <div>
                            <div class="text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Supervisor</div>
                            <div class="text-sm font-semibold text-gray-900 dark:text-white">{{ $production->supervisor->name ?? 'N/A' }}</div>
                        </div>
                        <div class="text-xs text-gray-500 dark:text-gray-400">
                            @if($production->approved_at)
                                Approved: {{ $production->approved_at->format('d M Y') }}
                            @endif
                        </div>
                    </div>
                    @endif
                    @if($production->completionApprover)
                    <div class="flex items-center justify-between pt-3 border-t border-gray-200 dark:border-gray-600">
                        <div>
                            <div class="text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Completion Approver</div>
                            <div class="text-sm font-semibold text-gray-900 dark:text-white">{{ $production->completionApprover->name ?? 'N/A' }}</div>
                        </div>
                        <div class="text-xs text-gray-500 dark:text-gray-400">
                            @if($production->completion_approved_at)
                                Approved: {{ $production->completion_approved_at->format('d M Y') }}
                            @endif
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Status Approval -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <div class="flex items-center">
                    <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                        <i class="fas fa-check-circle text-green-600 dark:text-green-400 text-sm"></i>
                    </div>
                    <h3 class="text-base font-semibold text-gray-800 dark:text-white">Status Approval</h3>
                </div>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    <div>
                        <div class="text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Planning Status</div>
                        @php
                            $planningStatusColors = [
                                'planning' => 'bg-blue-100 text-blue-800 dark:bg-blue-900/30 dark:text-blue-300',
                                'pending_approval' => 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-300',
                                'approved' => 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-300',
                                'rejected' => 'bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-300',
                            ];
                            $planningStatus = $production->planning_status ?? 'planning';
                            $planningColor = $planningStatusColors[$planningStatus] ?? $planningStatusColors['planning'];
                        @endphp
                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-md text-xs font-semibold {{ $planningColor }}">
                            {{ ucfirst(str_replace('_',' ',$planningStatus)) }}
                        </span>
                        @if($production->approved_at)
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                Approved: {{ $production->approved_at->format('d M Y, H:i') }}
                            </div>
                        @endif
                    </div>
                    @if($production->completion_status)
                    <div>
                        <div class="text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Completion Status</div>
                        @php
                            $completionStatusColors = [
                                'pending_approval' => 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-300',
                                'approved' => 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-300',
                                'rejected' => 'bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-300',
                            ];
                            $completionStatus = $production->completion_status;
                            $completionColor = $completionStatusColors[$completionStatus] ?? $completionStatusColors['pending_approval'];
                        @endphp
                        <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-md text-xs font-semibold {{ $completionColor }}">
                            {{ ucfirst(str_replace('_',' ',$completionStatus)) }}
                        </span>
                        @if($production->completion_approved_at)
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                Approved: {{ $production->completion_approved_at->format('d M Y, H:i') }}
                            </div>
                        @endif
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Cost Breakdown -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 mb-4">
        <!-- Materials Cost -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                            <i class="fas fa-box-open text-green-600 dark:text-green-400 text-sm"></i>
                        </div>
                        <h3 class="text-base font-semibold text-gray-800 dark:text-white">Biaya Bahan</h3>
                    </div>
                    <span class="text-xs px-2 py-1 rounded-full {{ $production->materials_status === 'received' ? 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-300' : 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-300' }}">
                        {{ ucfirst(str_replace('_', ' ', $production->materials_status ?? 'pending')) }}
                    </span>
                </div>
            </div>
            <div class="p-6">
                <div class="text-2xl font-bold text-green-600 dark:text-green-400 mb-4">
                    Rp {{ number_format($materialTotal,0,',','.') }}
                </div>
                @if($production->materials_received_at)
                <div class="text-xs text-gray-500 dark:text-gray-400 mb-3">
                    <i class="fas fa-check-circle mr-1"></i>
                    Diterima: {{ $production->materials_received_at->format('d M Y, H:i') }}
                    @if($production->materialsReceiver)
                        oleh {{ $production->materialsReceiver->name }}
                    @endif
                </div>
                @endif
                <div class="space-y-2">
                    @forelse($production->productionMaterials as $pm)
                    <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                        <div class="flex-1 min-w-0">
                            <div class="text-sm font-medium text-gray-900 dark:text-white truncate">{{ $pm->material->name }}</div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">
                                {{ rtrim(rtrim(number_format($pm->quantity, 2, ',', '.'), '0'), ',') }} {{ $pm->unit }} × Rp {{ number_format($pm->unit_cost,0,',','.') }}
                            </div>
                        </div>
                        <div class="text-sm font-semibold text-green-700 dark:text-green-300 ml-2">
                            Rp {{ number_format($pm->total_cost,0,',','.') }}
                        </div>
                    </div>
                    @empty
                    <div class="text-center py-4 text-gray-500 dark:text-gray-400">
                        <i class="fas fa-box-open text-2xl mb-2"></i>
                        <p class="text-sm">Tidak ada bahan baku</p>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Spareparts Cost -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                            <i class="fas fa-cogs text-blue-600 dark:text-blue-400 text-sm"></i>
                        </div>
                        <h3 class="text-base font-semibold text-gray-800 dark:text-white">Biaya Sparepart</h3>
                    </div>
                    <span class="text-xs px-2 py-1 rounded-full {{ $production->spareparts_status === 'received' ? 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-300' : 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-300' }}">
                        {{ ucfirst(str_replace('_', ' ', $production->spareparts_status ?? 'pending')) }}
                    </span>
                </div>
            </div>
            <div class="p-6">
                <div class="text-2xl font-bold text-blue-600 dark:text-blue-400 mb-4">
                    Rp {{ number_format($sparepartTotal,0,',','.') }}
                </div>
                @if($production->spareparts_received_at)
                <div class="text-xs text-gray-500 dark:text-gray-400 mb-3">
                    <i class="fas fa-check-circle mr-1"></i>
                    Diterima: {{ $production->spareparts_received_at->format('d M Y, H:i') }}
                    @if($production->sparepartsReceiver)
                        oleh {{ $production->sparepartsReceiver->name }}
                    @endif
                </div>
                @endif
                <div class="space-y-2">
                    @forelse($production->productionSpareparts as $ps)
                    <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                        <div class="flex-1 min-w-0">
                            <div class="text-sm font-medium text-gray-900 dark:text-white truncate">{{ $ps->sparepart->name }}</div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">
                                {{ rtrim(rtrim(number_format($ps->quantity, 2, ',', '.'), '0'), ',') }} {{ $ps->unit }} × Rp {{ number_format($ps->unit_cost,0,',','.') }}
                            </div>
                        </div>
                        <div class="text-sm font-semibold text-blue-700 dark:text-blue-300 ml-2">
                            Rp {{ number_format($ps->total_cost,0,',','.') }}
                        </div>
                    </div>
                    @empty
                    <div class="text-center py-4 text-gray-500 dark:text-gray-400">
                        <i class="fas fa-cogs text-2xl mb-2"></i>
                        <p class="text-sm">Tidak ada sparepart</p>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Labor Cost -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <div class="flex items-center">
                    <div class="p-2 bg-purple-100 dark:bg-purple-900/40 rounded-lg mr-2">
                        <i class="fas fa-user-tie text-purple-600 dark:text-purple-400 text-sm"></i>
                    </div>
                    <h3 class="text-base font-semibold text-gray-800 dark:text-white">Upah Labor</h3>
                </div>
            </div>
            <div class="p-6">
                <div class="text-2xl font-bold text-purple-600 dark:text-purple-400 mb-4">
                    Rp {{ number_format($laborTotal,0,',','.') }}
                </div>
                <div class="space-y-3">
                    <div class="p-4 bg-purple-50 dark:bg-purple-900/20 rounded-lg border border-purple-200 dark:border-purple-800">
                        <div class="text-sm text-gray-600 dark:text-gray-400 mb-2">Informasi Labor</div>
                        <div class="text-sm font-medium text-gray-900 dark:text-white">
                            Biaya tenaga kerja untuk produksi ini
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Total Summary -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border-2 border-gray-300 dark:border-gray-600 p-6 mb-4 shadow-md">
        <div class="flex items-center justify-between flex-wrap gap-4">
            <div class="flex items-center gap-4">
                <div class="p-3 bg-red-100 dark:bg-red-900/40 rounded-lg">
                    <i class="fas fa-calculator text-red-600 dark:text-red-400 text-xl"></i>
                </div>
                <div>
                    <div class="text-sm font-medium text-gray-600 dark:text-gray-400 mb-1">Total Biaya Produksi</div>
                    <div class="text-3xl font-bold text-gray-900 dark:text-white">Rp {{ number_format($totalCost,0,',','.') }}</div>
                </div>
            </div>
            <div class="grid grid-cols-3 gap-4 text-sm">
                <div>
                    <div class="text-xs text-gray-600 dark:text-gray-400 mb-1">Bahan</div>
                    <div class="text-lg font-bold text-green-600 dark:text-green-400">Rp {{ number_format($materialTotal,0,',','.') }}</div>
                </div>
                <div>
                    <div class="text-xs text-gray-600 dark:text-gray-400 mb-1">Sparepart</div>
                    <div class="text-lg font-bold text-blue-600 dark:text-blue-400">Rp {{ number_format($sparepartTotal,0,',','.') }}</div>
                </div>
                <div>
                    <div class="text-xs text-gray-600 dark:text-gray-400 mb-1">Labor</div>
                    <div class="text-lg font-bold text-purple-600 dark:text-purple-400">Rp {{ number_format($laborTotal,0,',','.') }}</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Timeline & Durasi -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 mb-4">
        <!-- Production Timeline -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <div class="flex items-center">
                    <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg mr-2">
                        <i class="fas fa-clock text-indigo-600 dark:text-indigo-400 text-sm"></i>
                    </div>
                    <h3 class="text-base font-semibold text-gray-800 dark:text-white">Timeline Produksi</h3>
                </div>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-10 h-10 bg-blue-100 dark:bg-blue-900/30 rounded-full flex items-center justify-center">
                            <i class="fas fa-calendar-plus text-blue-600 dark:text-blue-400"></i>
                        </div>
                        <div class="flex-1">
                            <div class="text-sm font-medium text-gray-900 dark:text-white">Ditugaskan</div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">
                                {{ $production->assigned_at ? $production->assigned_at->format('d M Y, H:i') : 'N/A' }}
                            </div>
                        </div>
                    </div>
                    @if($production->actual_start_date)
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-10 h-10 bg-green-100 dark:bg-green-900/30 rounded-full flex items-center justify-center">
                            <i class="fas fa-play text-green-600 dark:text-green-400"></i>
                        </div>
                        <div class="flex-1">
                            <div class="text-sm font-medium text-gray-900 dark:text-white">Mulai Produksi</div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">
                                {{ $production->actual_start_date->format('d M Y, H:i') }}
                            </div>
                        </div>
                    </div>
                    @endif
                    @if($production->estimated_completion_date)
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-10 h-10 bg-yellow-100 dark:bg-yellow-900/30 rounded-full flex items-center justify-center">
                            <i class="fas fa-calendar-check text-yellow-600 dark:text-yellow-400"></i>
                        </div>
                        <div class="flex-1">
                            <div class="text-sm font-medium text-gray-900 dark:text-white">Estimasi Selesai</div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">
                                {{ $production->estimated_completion_date->format('d M Y') }}
                            </div>
                        </div>
                    </div>
                    @endif
                    @if($production->completed_at)
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-10 h-10 bg-emerald-100 dark:bg-emerald-900/30 rounded-full flex items-center justify-center">
                            <i class="fas fa-check-double text-emerald-600 dark:text-emerald-400"></i>
                        </div>
                        <div class="flex-1">
                            <div class="text-sm font-medium text-gray-900 dark:text-white">Selesai</div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">
                                {{ $production->completed_at->format('d M Y, H:i') }}
                            </div>
                        </div>
                    </div>
                    @endif
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-10 h-10 bg-indigo-100 dark:bg-indigo-900/30 rounded-full flex items-center justify-center">
                            <i class="fas fa-play text-indigo-600 dark:text-indigo-400"></i>
                        </div>
                        <div class="flex-1">
                            <div class="text-sm font-medium text-gray-900 dark:text-white">Dibuat</div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">
                                {{ $production->created_at->format('d M Y, H:i') }}
                            </div>
                        </div>
                    </div>
                    @if($production->updated_at && $production->updated_at != $production->created_at)
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-10 h-10 bg-purple-100 dark:bg-purple-900/30 rounded-full flex items-center justify-center">
                            <i class="fas fa-edit text-purple-600 dark:text-purple-400"></i>
                        </div>
                        <div class="flex-1">
                            <div class="text-sm font-medium text-gray-900 dark:text-white">Terakhir Diupdate</div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">
                                {{ $production->updated_at->format('d M Y, H:i') }}
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Durasi & Informasi -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <div class="flex items-center">
                    <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg mr-2">
                        <i class="fas fa-info-circle text-indigo-600 dark:text-indigo-400 text-sm"></i>
                    </div>
                    <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Produksi</h3>
                </div>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    @if($production->estimated_duration_days)
                    <div>
                        <div class="text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Durasi Estimasi</div>
                        <div class="text-sm font-semibold text-gray-900 dark:text-white">{{ $production->estimated_duration_days }} hari</div>
                    </div>
                    @endif
                    @if($actualDurationFormatted)
                    <div>
                        <div class="text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Durasi Aktual</div>
                        <div class="text-sm font-semibold text-gray-900 dark:text-white">
                            {{ $actualDurationFormatted }}
                        </div>
                        @if($actualDuration && $actualDuration < 1 && $actualDuration > 0)
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                (sekitar {{ number_format($actualDuration * 24, 1, ',', '.') }} jam)
                            </div>
                        @elseif($actualDuration && $actualDuration >= 1)
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                ({{ number_format($actualDuration, 1, ',', '.') }} hari)
                            </div>
                        @endif
                    </div>
                    @endif
                    @if($production->completion_notes)
                    <div>
                        <div class="text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Catatan Penyelesaian</div>
                        <div class="text-sm text-gray-900 dark:text-white p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                            {{ $production->completion_notes }}
                        </div>
                    </div>
                    @endif
                    @if($production->supervisor_feedback)
                    <div>
                        <div class="text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Feedback Supervisor</div>
                        <div class="text-sm text-gray-900 dark:text-white p-3 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-800">
                            {{ $production->supervisor_feedback }}
                        </div>
                    </div>
                    @endif
                    @if($production->notes)
                    <div>
                        <div class="text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Catatan</div>
                        <div class="text-sm text-gray-900 dark:text-white p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                            {{ $production->notes }}
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Footer Laporan -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border-2 border-gray-300 dark:border-gray-600 shadow-lg p-6 mt-6">
        <div class="grid grid-cols-2 gap-8">
            <div class="text-center">
                <div class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-8">Teknisi yang Bertanggung Jawab</div>
                <div class="border-t-2 border-gray-300 dark:border-gray-600 pt-2">
                    <div class="text-sm font-bold text-gray-900 dark:text-white">{{ $production->teknisi->name ?? 'N/A' }}</div>
                    <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">ID: {{ $production->teknisi_id ?? 'N/A' }}</div>
                </div>
            </div>
            <div class="text-center">
                <div class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-8">Tanggal Laporan</div>
                <div class="border-t-2 border-gray-300 dark:border-gray-600 pt-2">
                    <div class="text-sm font-bold text-gray-900 dark:text-white">{{ now()->format('d M Y') }}</div>
                    <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">{{ now()->format('H:i') }} WIB</div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    @media print {
        .no-print {
            display: none !important;
        }
        body {
            background: white !important;
        }
        .bg-white, .bg-gray-800 {
            background: white !important;
            color: black !important;
        }
        .border-gray-200, .border-gray-300, .border-gray-600, .border-gray-700 {
            border-color: #000 !important;
        }
    }
</style>
@endpush
@endsection
