@extends('layouts.main')

@section('title', 'Detail Penawaran Produk')

@section('content')
<div class="min-h-screen py-6 sm:py-8">
    <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4">
        <!-- Header -->
        <div class="mb-6 sm:mb-8">
            <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                <div>
                    <h1 class="text-2xl sm:text-3xl font-bold text-gray-900">Detail Penawaran Produk</h1>
                    <p class="mt-1 text-sm sm:text-base text-gray-600">ID: #{{ $inquiry->id }}</p>
                </div>
                <div class="flex gap-2 sm:gap-3">
                    <a href="{{ route('user.inquiries.index') }}" 
                        class="inline-flex items-center px-3 sm:px-4 py-2 text-sm text-blue-600 hover:text-blue-800 font-medium">
                        <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" />
                        </svg>
                        Kembali
                    </a>
                    <a href="{{ route('all') }}" 
                        class="inline-flex items-center px-3 sm:px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                        Lihat Produk
                    </a>
                </div>
            </div>
        </div>

        <!-- Inquiry Details -->
        <div class="bg-white rounded-lg border border-gray-200 p-4 sm:p-6 lg:p-8">
            <!-- Status Badge -->
            <div class="mb-6">
                @if($inquiry->status === 'converted_to_order')
                    <span class="inline-flex items-center px-3 py-1.5 rounded-full text-xs sm:text-sm font-medium bg-purple-100 text-purple-800">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                        </svg>
                        Penawaran Telah Diubah Menjadi Pesanan
                    </span>
                @elseif($inquiry->status === 'customer_accepted')
                    <span class="inline-flex items-center px-3 py-1.5 rounded-full text-xs sm:text-sm font-medium bg-green-100 text-green-800">
                        <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.707a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 10-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        Penawaran Telah Anda Setujui
                    </span>
                @elseif($inquiry->status === 'customer_counter')
                    <span class="inline-flex items-center px-3 py-1.5 rounded-full text-xs sm:text-sm font-medium bg-blue-100 text-blue-800">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                        </svg>
                        Menunggu Konfirmasi Admin
                    </span>
                @elseif($inquiry->admin_replied_at)
                    <span class="inline-flex items-center px-3 py-1.5 rounded-full text-xs sm:text-sm font-medium bg-green-100 text-green-800">
                        <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.707a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 10-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        Sudah Dibalas oleh Admin
                    </span>
                @elseif($inquiry->is_read)
                    <span class="inline-flex items-center px-3 py-1.5 rounded-full text-xs sm:text-sm font-medium bg-green-100 text-green-800">
                        <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.707a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 10-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        Penawaran Sudah Dibaca oleh Admin
                    </span>
                @else
                    <span class="inline-flex items-center px-3 py-1.5 rounded-full text-xs sm:text-sm font-medium bg-yellow-100 text-yellow-800">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Menunggu Respons Admin
                    </span>
                @endif
            </div>

            <!-- Product Information -->
            @if($inquiry->product)
                <div class="bg-gray-50 rounded-lg p-4 sm:p-6 mb-6 sm:mb-8 border border-gray-200">
                    <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-3 sm:mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                        </svg>
                        Produk yang Ditanyakan
                    </h3>
                    <div class="flex flex-col md:flex-row gap-4 sm:gap-6">
                        @if($inquiry->product->product_image)
                            <div class="w-full md:w-48 flex-shrink-0">
                                <div class="w-full border border-gray-300 rounded-lg overflow-hidden bg-white p-2">
                                    <img src="{{ asset('uploads/products/' . $inquiry->product->product_image) }}" 
                                        alt="{{ $inquiry->product->product_title }}"
                                        class="w-full h-auto max-h-64 md:max-h-48 object-contain">
                                </div>
                            </div>
                        @endif
                        <div class="flex-1 min-w-0">
                            <h4 class="text-lg sm:text-xl font-semibold text-gray-900 mb-2 break-words">{{ $inquiry->product->product_title }}</h4>
                            <p class="text-sm sm:text-base text-gray-600 mb-2 line-clamp-3">{{ $inquiry->product->product_description ?? 'Tidak ada deskripsi' }}</p>
                            <div class="flex flex-col sm:flex-row sm:items-center gap-2 sm:gap-4 text-xs sm:text-sm text-gray-500">
                                <span class="flex items-center">
                                    <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                    </svg>
                                    ID: {{ $inquiry->product->id }}
                                </span>
                                @if($inquiry->product->price)
                                    <span class="flex items-center">
                                        <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                        {{ $inquiry->product->formatted_price ?? 'Harga tersedia' }}
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Inquiry Information -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 sm:gap-8 mb-6 sm:mb-8">
                <div class="bg-gray-50 rounded-lg p-4 sm:p-5 border border-gray-200">
                    <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                        Informasi Pengirim
                    </h3>
                    <div class="space-y-3">
                        <div class="flex items-center">
                            <svg class="w-4 h-4 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            <span class="text-sm text-gray-600">Nama:</span>
                            <span class="ml-2 text-sm font-medium text-gray-900 break-words">{{ $inquiry->name }}</span>
                        </div>
                        <div class="flex items-center">
                            <svg class="w-4 h-4 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                            <span class="text-sm text-gray-600">Email:</span>
                            <span class="ml-2 text-sm font-medium text-gray-900 break-all">{{ $inquiry->email }}</span>
                        </div>
                        <div class="flex items-center">
                            <svg class="w-4 h-4 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                            </svg>
                            <span class="text-sm text-gray-600">Telepon:</span>
                            <span class="ml-2 text-sm font-medium text-gray-900 break-words">{{ $inquiry->phone }}</span>
                        </div>
                    </div>
                </div>
                
                <div class="bg-gray-50 rounded-lg p-4 sm:p-5 border border-gray-200">
                    <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        Informasi Penawaran
                    </h3>
                    <div class="space-y-3">
                        <div class="flex items-center">
                            <svg class="w-4 h-4 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                            <span class="text-sm text-gray-600">Tanggal:</span>
                            <span class="ml-2 text-sm font-medium text-gray-900">{{ $inquiry->created_at->format('d M Y H:i') }}</span>
                        </div>
                        <div class="flex items-center">
                            <svg class="w-4 h-4 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span class="text-sm text-gray-600">Status:</span>
                            <span class="ml-2 text-sm font-medium text-gray-900">
                                @if($inquiry->is_read)
                                    Dibaca {{ $inquiry->updated_at->format('d M Y H:i') }}
                                @else
                                    Belum Dibaca
                                @endif
                            </span>
                        </div>
                        <div class="flex items-center">
                            <svg class="w-4 h-4 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span class="text-sm text-gray-600">Tipe:</span>
                            <span class="ml-2 text-sm font-medium text-gray-900">Penawaran Produk</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Message Content -->
            <div class="border-t border-gray-200 pt-6">
                <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-4 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                    Isi Penawaran/Pertanyaan
                </h3>
                @php
                    $raw = $inquiry->message ?? '';
                    $lines = preg_split("/(\r\n|\n|\r)/", $raw);
                    $type = null;
                    $addons = [];
                    $hasAddonsLine = false;
                    if (!empty($lines)) {
                        $first = $lines[0] ?? '';
                        $second = $lines[1] ?? '';
                        if (substr($first, 0, 14) === '[REQUEST_TYPE]') {
                            $type = trim(substr($first, 14));
                        }
                        if (substr($second, 0, 8) === '[ADDONS]') {
                            $hasAddonsLine = true;
                            $matches = [];
                            if (preg_match('/^\[ADDONS\]\s*(\[[\s\S]*\])$/', $second, $matches)) {
                                $decoded = json_decode($matches[1], true);
                                if (is_array($decoded)) {
                                    $addons = $decoded;
                                }
                            }
                        }
                    }
                    $startIdx = 0;
                    if ($type) {
                        $startIdx++;
                    }
                    if ($hasAddonsLine) {
                        $startIdx++;
                    }
                    if (!empty($lines) && isset($lines[$startIdx]) && trim($lines[$startIdx]) === '') {
                        $startIdx++;
                    }
                    $plain = implode("\n", array_slice($lines, $startIdx));
                    $badgeText = $type === 'custom_addon' ? 'Custom Add-on' : ($type === 'custom_new' ? 'Custom Baru' : ($type ? 'Katalog' : null));
                    $badgeCls = $type === 'custom_addon' ? 'bg-yellow-100 text-yellow-800' : ($type === 'custom_new' ? 'bg-red-100 text-red-800' : 'bg-blue-100 text-blue-800');
                @endphp
                <div class="bg-gray-50 rounded-lg p-4 sm:p-6 space-y-3 sm:space-y-4">
                    @if($badgeText)
                        <div>
                            <span class="inline-flex items-center px-2 sm:px-3 py-1 text-xs sm:text-sm font-semibold rounded-full {{ $badgeCls }}">
                                <svg class="w-3 h-3 mr-1.5 sm:mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                </svg>
                                {{ $badgeText }}
                            </span>
                        </div>
                    @endif
                    
                    @if(!empty($addons))
                        <div class="bg-white rounded-lg p-3 sm:p-4 border border-gray-200">
                            <div class="font-semibold text-sm sm:text-base text-gray-900 mb-2 sm:mb-3 flex items-center">
                                <svg class="w-4 h-4 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                </svg>
                                Spesifikasi Tambahan
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-2 sm:gap-3">
                                @foreach($addons as $addon)
                                    <div class="flex items-start">
                                        <div class="flex-1 min-w-0">
                                            <div class="text-xs sm:text-sm font-medium text-gray-700 break-words">
                                                {{ is_array($addon) ? ($addon['name'] ?? '-') : '-' }}
                                            </div>
                                            <div class="text-xs sm:text-sm text-gray-600 mt-1 break-words">
                                                {{ is_array($addon) ? ($addon['value'] ?? '-') : '-' }}
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                    
                    @if($plain)
                        <div>
                            <div class="font-semibold text-sm sm:text-base text-gray-900 mb-2 flex items-center">
                                <svg class="w-4 h-4 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                                </svg>
                                Pesan
                            </div>
                            <p class="text-sm sm:text-base text-gray-800 whitespace-pre-wrap bg-white rounded-lg p-3 sm:p-4 border border-gray-200 break-words leading-relaxed">{{ $plain }}</p>
                        </div>
                    @else
                        <div>
                            <p class="text-sm sm:text-base text-gray-800 whitespace-pre-wrap bg-white rounded-lg p-3 sm:p-4 border border-gray-200 break-words leading-relaxed">{{ $inquiry->message }}</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Admin Reply -->
            @if($inquiry->admin_reply)
                <div class="border-t border-gray-200 pt-6 mt-6">
                    <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"></path>
                        </svg>
                        Balasan Admin
                    </h3>
                    <div class="bg-blue-50 rounded-lg p-4 sm:p-6 border-l-4 border-blue-500 border border-gray-200">
                        <p class="text-sm sm:text-base text-gray-800 whitespace-pre-wrap break-words leading-relaxed mb-4">{{ $inquiry->admin_reply }}</p>
                        @if($inquiry->admin_replied_at)
                        <div class="flex items-start text-xs sm:text-sm text-gray-600 bg-white rounded p-2 border border-gray-200">
                            <svg class="w-4 h-4 mr-2 mt-0.5 text-blue-600 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                            </svg>
                            <span>Balasan dikirim pada {{ $inquiry->admin_replied_at->format('d M Y H:i') }}
                            @if($inquiry->reply_method)
                                melalui {{ ucfirst($inquiry->reply_method) }}
                            @endif</span>
                        </div>
                        @endif
                    </div>
                </div>
            @endif

            <!-- Final Offer Price -->
            @if($inquiry->final_offer_price)
                <div class="border-t border-gray-200 pt-4 sm:pt-6 mt-4 sm:mt-6">
                    <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-3 sm:mb-4">Penawaran Harga Final</h3>
                    <div class="bg-emerald-50 rounded-lg p-4 sm:p-6 border-l-4 border-emerald-500">
                        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3 sm:gap-4 mb-3 sm:mb-4">
                            <div class="flex-1">
                                <p class="text-xs sm:text-sm text-gray-600 mb-1">Harga Final</p>
                                <p class="text-2xl sm:text-3xl font-bold text-emerald-700">
                                    Rp {{ number_format($inquiry->final_offer_price, 0, ',', '.') }}
                                </p>
                            </div>
                            @if($inquiry->validity_until)
                            <div class="text-left sm:text-right">
                                <p class="text-xs sm:text-sm text-gray-600 mb-1">Berlaku Hingga</p>
                                <p class="text-xs sm:text-sm font-semibold text-gray-900">
                                    {{ $inquiry->validity_until->format('d M Y') }}
                                </p>
                            </div>
                            @endif
                        </div>
                        @if($inquiry->admin_final_notes)
                        <div class="mt-3 sm:mt-4 pt-3 sm:pt-4 border-t border-emerald-200">
                            <p class="text-xs sm:text-sm font-medium text-gray-700 mb-2">Catatan:</p>
                            <p class="text-xs sm:text-sm text-gray-800 whitespace-pre-wrap break-words">{{ $inquiry->admin_final_notes }}</p>
                        </div>
                        @endif
                        <div class="mt-4 flex flex-col sm:flex-row gap-2 sm:gap-3">
                            @if($inquiry->status === 'converted_to_order' || !is_null($inquiry->order_id))
                                {{-- Sudah di-convert ke order, tidak bisa setujui lagi --}}
                                <div class="w-full sm:w-auto inline-flex items-center justify-center px-4 py-2 text-sm bg-purple-600 text-white rounded-lg">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                                    </svg>
                                    Penawaran Telah Diubah Menjadi Pesanan
                                </div>
                                @if($inquiry->order_id)
                                    <a href="{{ route('my.orders.show', $inquiry->order_id) }}" 
                                        class="w-full sm:w-auto inline-flex items-center justify-center px-4 py-2 text-sm bg-purple-700 hover:bg-purple-800 text-white rounded-lg transition-colors">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                                        </svg>
                                        Lihat Detail Pesanan #{{ $inquiry->order_id }}
                                    </a>
                                @endif
                            @elseif($inquiry->status === 'customer_accepted')
                                {{-- Sudah disetujui, menunggu admin buat order --}}
                                <div class="w-full sm:w-auto inline-flex items-center justify-center px-4 py-2 text-sm bg-green-600 text-white rounded-lg">
                                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.707a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 10-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                                    </svg>
                                    Penawaran Telah Disetujui
                                </div>
                            @else
                                {{-- Belum disetujui, bisa setujui atau ajukan revisi --}}
                                <form method="POST" action="{{ route('guest.inquiry.accept', $inquiry) }}" class="inline w-full sm:w-auto">
                                    @csrf
                                    <button type="submit" 
                                        class="w-full sm:w-auto inline-flex items-center justify-center px-4 py-2 text-sm bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg transition-colors">
                                        <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.707a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 10-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                                        </svg>
                                        Terima Penawaran
                                    </button>
                                </form>
                                <button onclick="openCounterModal()" class="w-full sm:w-auto inline-flex items-center justify-center px-4 py-2 text-sm bg-yellow-500 hover:bg-yellow-600 text-white rounded-lg">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                                    </svg>
                                    Ajukan Revisi
                                </button>
                            @endif
                        </div>
                        @if($inquiry->tracking_code)
                        <div class="mt-3 space-y-2">
                            <div class="text-xs sm:text-sm">
                                <p class="text-gray-600 mb-1">Tracking Code: <span class="font-mono font-semibold text-blue-600">{{ $inquiry->tracking_code }}</span></p>
                                <a href="{{ route('guest.inquiry.track', $inquiry->tracking_code) }}" target="_blank" class="inline-flex items-center text-blue-600 hover:text-blue-800 text-xs sm:text-sm">
                                    <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                                    </svg>
                                    Buka di tab baru untuk tracking tanpa login
                                </a>
                            </div>
                            @if($inquiry->final_offer_price)
                            <div class="text-xs sm:text-sm">
                                <a href="{{ route('admin.print.quotation.offer.preview', $inquiry) }}" target="_blank" class="inline-flex items-center text-blue-600 hover:text-blue-800">
                                    <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                    </svg>
                                    Lihat Dokumen Penawaran
                                </a>
                            </div>
                            @endif
                        </div>
                        @endif
                    </div>
                </div>
            @endif

            <!-- Actions -->
            <div class="mt-6 sm:mt-8 flex flex-col sm:flex-row sm:justify-between sm:items-center gap-3 sm:gap-4">
                <div class="text-xs sm:text-sm text-gray-500 flex items-start sm:items-center">
                    <svg class="w-4 h-4 mr-1.5 mt-0.5 sm:mt-0 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                    </svg>
                    <span>Admin akan merespons melalui email atau telepon yang Anda berikan</span>
                </div>
                <div class="flex gap-2 sm:gap-3">
                    <a href="{{ route('all') }}" 
                        class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                        Lihat Produk Lain
                    </a>
                </div>
            </div>
        </div>

        <!-- Related Information -->
        <div class="mt-6 sm:mt-8 grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
            <!-- Quick Actions -->
            <div class="bg-white rounded-lg border border-gray-200 p-4 sm:p-6">
                <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-4 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                    Aksi Cepat
                </h3>
                <div class="space-y-3">
                    <a href="{{ route('all') }}" 
                        class="flex items-center p-3 border border-gray-200 rounded-lg hover:border-blue-500 hover:bg-blue-50 transition-colors">
                        <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3 flex-shrink-0">
                            <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="text-sm font-semibold text-gray-900 mb-1">Lihat Produk Lain</h3>
                            <p class="text-xs text-gray-600">Jelajahi katalog produk kami</p>
                        </div>
                    </a>
                    <a href="{{ route('guest.contact') }}" 
                        class="flex items-center p-3 border border-gray-200 rounded-lg hover:border-blue-500 hover:bg-blue-50 transition-colors">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3 flex-shrink-0">
                            <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="text-sm font-semibold text-gray-900 mb-1">Kirim Pesan Umum</h3>
                            <p class="text-xs text-gray-600">Hubungi admin untuk pertanyaan umum</p>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Inquiry Tips -->
            <div class="bg-blue-50 rounded-lg border border-blue-200 p-4 sm:p-6">
                <h3 class="text-base sm:text-lg font-semibold text-blue-900 mb-4 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                    </svg>
                    Tips Penawaran
                </h3>
                <div class="space-y-2.5 text-sm sm:text-base text-blue-800">
                    <div class="flex items-start">
                        <svg class="w-5 h-5 mr-2 mt-0.5 text-blue-600 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.707a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 10-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        <span>Admin akan merespons penawaran dalam 1-2 hari kerja</span>
                    </div>
                    <div class="flex items-start">
                        <svg class="w-5 h-5 mr-2 mt-0.5 text-blue-600 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.707a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 10-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        <span>Sertakan detail kebutuhan untuk penawaran yang tepat</span>
                    </div>
                    <div class="flex items-start">
                        <svg class="w-5 h-5 mr-2 mt-0.5 text-blue-600 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.707a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 10-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        <span>Mention budget dan timeline jika ada</span>
                    </div>
                    <div class="flex items-start">
                        <svg class="w-5 h-5 mr-2 mt-0.5 text-blue-600 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.707a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 10-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        <span>Periksa email secara berkala untuk respons admin</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Counter Modal -->
<div id="counterModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg border border-gray-200 max-w-md w-full">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold text-gray-900">Ajukan Revisi Harga</h3>
                    <button onclick="closeCounterModal()" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
                <form method="POST" action="{{ route('guest.inquiry.counter', $inquiry) }}">
                    @csrf
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Harga yang Anda ajukan</label>
                            <input type="number" step="0.01" name="counter_price" class="w-full px-3 py-2 border border-gray-300 rounded-md" required placeholder="0">
                            <p class="text-xs text-gray-500 mt-1">Jika supervisor memberi koridor harga, pastikan tawaran Anda berada di dalamnya.</p>
                        </div>
                        <div class="flex justify-end gap-2">
                            <button type="button" onclick="closeCounterModal()" class="px-4 py-2 text-sm bg-gray-200 hover:bg-gray-300 text-gray-800 rounded-lg transition-colors">Batal</button>
                            <button type="submit" class="px-4 py-2 text-sm bg-blue-600 hover:bg-blue-700 text-white rounded-lg transition-colors">Kirim</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function openCounterModal(){ document.getElementById('counterModal').classList.remove('hidden'); }
function closeCounterModal(){ document.getElementById('counterModal').classList.add('hidden'); }

// Mark inquiry notification as viewed when page loads (only if admin has replied)
document.addEventListener('DOMContentLoaded', function() {
    const inquiryId = {{ $inquiry->id }};
    const hasAdminReply = {{ ($inquiry->admin_reply || $inquiry->final_offer_price) ? 'true' : 'false' }};
    
    if (window.userNotificationSystem && hasAdminReply) {
        // Mark as viewed immediately
        window.userNotificationSystem.markNotificationAsViewed('inquiry', inquiryId);
        
        // Force badge update after a short delay to ensure it's updated
        setTimeout(function() {
            if (window.userNotificationSystem) {
                window.userNotificationSystem.fetchNotifications();
            }
        }, 300);
    }
});
</script>
@endpush
@endsection
