<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pesanan Belum Siap - Order #{{ $order->id }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen py-8 sm:py-12">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="text-center mb-10">
                <div class="w-20 h-20 mx-auto mb-5 bg-yellow-50 rounded-full flex items-center justify-center border-2 border-yellow-100">
                    <svg class="w-10 h-10 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                    </svg>
                </div>
                <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-3 leading-tight">
                    Pesanan Belum Siap untuk Konfirmasi
                </h1>
                <p class="text-sm sm:text-base text-gray-600 leading-relaxed max-w-2xl mx-auto">
                    Pesanan ini belum diserahkan atau belum siap untuk dikonfirmasi. Silakan tunggu hingga admin menyelesaikan proses serah terima.
                </p>
                <div class="mt-4 inline-flex items-center px-4 py-2 bg-blue-50 border border-blue-100 rounded-lg">
                    <span class="text-xs sm:text-sm text-blue-700 font-medium">Order ID: #{{ $order->id }}</span>
                </div>
            </div>

            <!-- Info Card -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm mb-6">
                <div class="px-6 py-4 border-b border-gray-200 bg-yellow-50">
                    <h2 class="text-base font-semibold text-gray-900 flex items-center">
                        <svg class="w-5 h-5 mr-2.5 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Status Pesanan
                    </h2>
                </div>
                <div class="p-6">
                    <!-- Product Info -->
                    @if($order->product)
                    <div class="flex items-start gap-4 mb-6 pb-6 border-b border-gray-100">
                        @php
                            $productImage = $order->product->product_image 
                                ? asset('uploads/products/' . $order->product->product_image)
                                : asset('images/no-image.png');
                        @endphp
                        <div class="flex-shrink-0">
                            <img src="{{ $productImage }}" alt="{{ $order->product->product_title }}" 
                                 class="w-20 h-20 sm:w-24 sm:h-24 object-contain rounded-lg border border-gray-200 bg-gray-50 p-2">
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="font-semibold text-gray-900 text-base mb-2 leading-tight">{{ $order->product->product_title ?? 'Produk' }}</h3>
                            <div class="space-y-1.5 text-sm">
                                <div class="flex items-center text-gray-600">
                                    <svg class="w-4 h-4 mr-2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                    </svg>
                                    <span>Jumlah: <strong class="text-gray-900">{{ $order->quantity }}</strong> unit</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Status Details -->
                    <div class="space-y-4">
                        <div class="flex items-center justify-between py-2.5 px-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                            <div class="flex items-center">
                                <svg class="w-5 h-5 mr-2.5 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span class="text-sm font-medium text-gray-900">Status Serah Terima</span>
                            </div>
                            <span class="text-sm font-semibold text-yellow-700">
                                @if($order->handover_status)
                                    {{ ucfirst(str_replace('_', ' ', $order->handover_status)) }}
                                @else
                                    Belum Diserahkan
                                @endif
                            </span>
                        </div>

                        @if($order->production_status)
                        <div class="flex items-center justify-between py-2.5 px-4 bg-gray-50 border border-gray-200 rounded-lg">
                            <div class="flex items-center">
                                <svg class="w-5 h-5 mr-2.5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path>
                                </svg>
                                <span class="text-sm font-medium text-gray-900">Status Produksi</span>
                            </div>
                            <span class="text-sm text-gray-700 font-medium">{{ ucfirst(str_replace('_', ' ', $order->production_status)) }}</span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Message Card -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm mb-6">
                <div class="px-6 py-4 border-b border-gray-200 bg-blue-50">
                    <h2 class="text-base font-semibold text-gray-900 flex items-center">
                        <svg class="w-5 h-5 mr-2.5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Informasi
                    </h2>
                </div>
                <div class="p-6">
                    <div class="text-center">
                        <p class="text-sm sm:text-base text-gray-700 leading-relaxed mb-4">
                            Pesanan #{{ $order->id }} belum siap untuk dikonfirmasi. 
                            Admin akan mengirimkan link konfirmasi setelah proses serah terima selesai.
                        </p>
                        <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 text-left">
                            <p class="text-xs font-medium text-gray-700 mb-2">Langkah selanjutnya:</p>
                            <ul class="text-xs text-gray-600 space-y-1.5 list-disc list-inside">
                                <li>Tunggu hingga admin menyelesaikan proses produksi</li>
                                <li>Admin akan melakukan serah terima produk</li>
                                <li>Setelah serah terima, Anda akan menerima link konfirmasi</li>
                                <li>Gunakan link tersebut untuk mengkonfirmasi penerimaan produk</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Close Button -->
            <div class="text-center">
                <button onclick="closePage()" 
                        class="inline-flex items-center justify-center px-8 py-3 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium rounded-lg transition-colors focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                    Tutup Halaman
                </button>
            </div>
        </div>
    </div>

    <script>
        function closePage() {
            if (window.opener || window.history.length <= 1) {
                window.close();
            } else {
                window.location.href = '{{ route("index") }}';
            }
        }
    </script>
</body>
</html>

