<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Konfirmasi Penerimaan - Order #<?php echo e($order->id); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen py-8 sm:py-12">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header Section -->
            <div class="text-center mb-10">
                <div class="w-20 h-20 mx-auto mb-5 bg-blue-50 rounded-full flex items-center justify-center border-2 border-blue-100">
                    <svg class="w-10 h-10 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-3 leading-tight">
                    Konfirmasi Penerimaan Produk
                </h1>
                <p class="text-sm sm:text-base text-gray-600 leading-relaxed max-w-2xl mx-auto">
                    Terima kasih telah melakukan transaksi dengan kami. Silakan konfirmasi bahwa Anda telah menerima produk dengan baik dan berikan penilaian Anda.
                </p>
                <div class="mt-4 inline-flex items-center px-4 py-2 bg-blue-50 border border-blue-100 rounded-lg">
                    <span class="text-xs sm:text-sm text-blue-700 font-medium">Order ID: #<?php echo e($order->id); ?></span>
                </div>
            </div>

            <!-- Alert Messages -->
            <?php if($errors->any()): ?>
                <div class="mb-6 p-4 bg-red-50 border-l-4 border-red-500 rounded-lg">
                    <div class="flex items-start">
                        <svg class="h-5 w-5 text-red-500 mr-3 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                        </svg>
                        <div class="flex-1">
                            <p class="text-sm font-semibold text-red-800 mb-2">Terjadi kesalahan:</p>
                            <ul class="text-xs sm:text-sm text-red-700 space-y-1.5">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="flex items-start">
                                        <span class="mr-2">•</span>
                                        <span><?php echo e($error); ?></span>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Order Summary Card -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm mb-6 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-blue-50">
                    <h2 class="text-base font-semibold text-gray-900 flex items-center">
                        <svg class="w-5 h-5 mr-2.5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                        </svg>
                        Informasi Pesanan
                    </h2>
                </div>
                <div class="p-6">
                    <!-- Product Info -->
                    <div class="flex items-start gap-4 mb-6 pb-6 border-b border-gray-100">
                        <?php
                            $productImage = $order->product->product_image 
                                ? asset('uploads/products/' . $order->product->product_image)
                                : asset('images/no-image.png');
                        ?>
                        <div class="flex-shrink-0">
                            <img src="<?php echo e($productImage); ?>" alt="<?php echo e($order->product->product_title); ?>" 
                                 class="w-24 h-24 sm:w-28 sm:h-28 object-contain rounded-lg border border-gray-200 bg-gray-50 p-2">
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="font-semibold text-gray-900 text-base mb-2 leading-tight"><?php echo e($order->product->product_title ?? 'Produk'); ?></h3>
                            <div class="space-y-1.5 text-sm">
                                <div class="flex items-center text-gray-600">
                                    <svg class="w-4 h-4 mr-2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                    </svg>
                                    <span>Jumlah: <strong class="text-gray-900"><?php echo e($order->quantity); ?></strong> unit</span>
                                </div>
                                <div class="flex items-center">
                                    <svg class="w-4 h-4 mr-2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <span class="text-blue-600 font-semibold text-base"><?php echo e($order->formatted_total_price ?? 'Rp ' . number_format($order->total_price, 0, ',', '.')); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Handover Photos -->
                    <?php if($order->handover_photos && count($order->handover_photos) > 0): ?>
                    <div class="mb-6 pb-6 border-b border-gray-100">
                        <p class="text-sm font-medium text-gray-700 mb-3 flex items-center">
                            <svg class="w-4 h-4 mr-2 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                            Foto Produk yang Diterima
                        </p>
                        <div class="grid grid-cols-3 sm:grid-cols-4 gap-3">
                            <?php $__currentLoopData = $order->handover_photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(asset('uploads/' . $photo)); ?>" target="_blank" class="group relative block">
                                <div class="aspect-square rounded-lg border-2 border-gray-200 overflow-hidden bg-gray-50 group-hover:border-blue-500 transition-colors">
                                    <img src="<?php echo e(asset('uploads/' . $photo)); ?>" alt="Produk" 
                                         class="w-full h-full object-cover"
                                         onerror="this.src='<?php echo e(asset('images/no-image.png')); ?>'">
                                </div>
                                <div class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-10 transition-opacity rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white opacity-0 group-hover:opacity-100 transition-opacity" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                    </svg>
                                </div>
                            </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <p class="text-xs text-gray-500 mt-2">Klik foto untuk melihat ukuran penuh</p>
                    </div>
                    <?php endif; ?>

                    <!-- Admin Notes -->
                    <?php if($order->handover_notes): ?>
                    <div>
                        <p class="text-sm font-medium text-gray-700 mb-2.5 flex items-center">
                            <svg class="w-4 h-4 mr-2 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            Catatan dari Admin
                        </p>
                        <div class="bg-blue-50 border border-blue-100 rounded-lg p-4">
                            <p class="text-sm text-gray-700 leading-relaxed"><?php echo e($order->handover_notes); ?></p>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Confirmation Form Card -->
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm">
                <div class="px-6 py-4 border-b border-gray-200 bg-blue-50">
                    <h2 class="text-base font-semibold text-gray-900 flex items-center">
                        <svg class="w-5 h-5 mr-2.5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Formulir Konfirmasi
                    </h2>
                </div>
                <form action="<?php echo e(route('user.orders.confirm-delivery.submit', $order)); ?>" method="POST" class="p-6" id="confirmationForm">
                    <?php echo csrf_field(); ?>
                    
                    <!-- Rating Section -->
                    <div class="mb-8">
                        <label class="block text-sm font-semibold text-gray-900 mb-3">
                            Berikan Penilaian Anda
                            <span class="text-red-500 ml-1">*</span>
                        </label>
                        <div class="flex gap-2 mb-3" id="ratingStars" role="radiogroup" aria-label="Rating">
                            <?php for($i = 1; $i <= 5; $i++): ?>
                            <button type="button" onclick="setRating(<?php echo e($i); ?>)" 
                                    class="rating-star text-4xl text-gray-200 hover:text-yellow-400 transition-all duration-200 focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-offset-2 rounded-lg p-1" 
                                    data-rating="<?php echo e($i); ?>"
                                    aria-label="Rating <?php echo e($i); ?> bintang"
                                    aria-pressed="false">
                                <svg class="w-10 h-10" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                            </button>
                            <?php endfor; ?>
                        </div>
                        <input type="hidden" name="rating" id="ratingInput" value="" required>
                        <div class="flex items-center gap-2 text-xs text-gray-500">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>Klik bintang untuk memberikan penilaian (1 = Sangat Buruk, 5 = Sangat Baik)</span>
                        </div>
                        <p id="ratingError" class="text-xs text-red-600 mt-2 hidden">Silakan pilih rating terlebih dahulu</p>
                    </div>

                    <!-- Feedback Section -->
                    <div class="mb-8">
                        <label for="feedback" class="block text-sm font-semibold text-gray-900 mb-2.5">
                            Ulasan & Saran (Opsional)
                        </label>
                        <textarea name="feedback" id="feedback" rows="5" 
                                  class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all text-sm resize-none"
                                  placeholder="Bagikan pengalaman Anda dengan produk dan layanan kami. Ulasan Anda sangat membantu kami untuk terus meningkatkan kualitas layanan..."></textarea>
                        <p class="text-xs text-gray-500 mt-2">Maksimal 2000 karakter</p>
                    </div>

                    <!-- Agreement Section -->
                    <div class="mb-8 p-5 bg-blue-50 border border-blue-200 rounded-lg">
                        <label class="flex items-start gap-3 cursor-pointer group">
                            <input type="checkbox" required 
                                   class="mt-1 w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500 cursor-pointer"
                                   id="agreementCheckbox">
                            <span class="text-sm text-gray-700 leading-relaxed flex-1">
                                <strong class="font-semibold text-gray-900">Saya menyatakan bahwa:</strong>
                                <ul class="mt-2 space-y-1.5 text-gray-600 list-disc list-inside ml-2">
                                    <li>Produk telah diterima dalam kondisi baik dan sesuai dengan pesanan</li>
                                    <li>Tidak ada kerusakan atau ketidaksesuaian yang ditemukan</li>
                                    <li>Dengan mengkonfirmasi, proses transaksi akan dinyatakan selesai</li>
                                </ul>
                            </span>
                        </label>
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" 
                            id="submitButton"
                            class="w-full bg-blue-600 hover:bg-blue-700 active:bg-blue-800 text-white font-semibold py-3.5 px-6 rounded-lg transition-all duration-200 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 flex items-center justify-center shadow-sm hover:shadow-md disabled:opacity-50 disabled:cursor-not-allowed">
                        <svg class="w-5 h-5 mr-2.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        Konfirmasi Penerimaan Produk
                    </button>
                </form>
            </div>

            <!-- Help Section -->
            <div class="mt-8 text-center">
                <div class="inline-flex items-center gap-2 text-sm text-gray-600 mb-3">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <span>Ada pertanyaan atau masalah dengan pesanan Anda?</span>
                </div>
                <a href="<?php echo e(route('guest.contact')); ?>" 
                   class="inline-flex items-center text-sm text-blue-600 hover:text-blue-800 font-medium transition-colors">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                    Hubungi Tim Support Kami
                </a>
            </div>
        </div>
    </div>

    <script>
        function setRating(rating) {
            const ratingInput = document.getElementById('ratingInput');
            const ratingError = document.getElementById('ratingError');
            const submitButton = document.getElementById('submitButton');
            
            ratingInput.value = rating;
            ratingError.classList.add('hidden');
            
            document.querySelectorAll('.rating-star').forEach((star, index) => {
                const starIndex = index + 1;
                const starButton = star;
                
                if (starIndex <= rating) {
                    starButton.classList.remove('text-gray-200');
                    starButton.classList.add('text-yellow-400');
                    starButton.setAttribute('aria-pressed', 'true');
                } else {
                    starButton.classList.remove('text-yellow-400');
                    starButton.classList.add('text-gray-200');
                    starButton.setAttribute('aria-pressed', 'false');
                }
            });
            
            // Enable submit button
            submitButton.disabled = false;
        }

        // Form validation and modern confirmation
        document.getElementById('confirmationForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const rating = document.getElementById('ratingInput').value;
            const agreement = document.getElementById('agreementCheckbox').checked;
            const ratingError = document.getElementById('ratingError');
            const submitButton = document.getElementById('submitButton');
            
            // Validation
            if (!rating) {
                ratingError.classList.remove('hidden');
                document.getElementById('ratingStars').scrollIntoView({ behavior: 'smooth', block: 'center' });
                Swal.fire({
                    icon: 'warning',
                    title: 'Rating Belum Dipilih',
                    text: 'Silakan pilih rating terlebih dahulu sebelum melanjutkan.',
                    confirmButtonColor: '#3b82f6',
                    confirmButtonText: 'Mengerti'
                });
                return false;
            }
            
            if (!agreement) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Perhatian',
                    text: 'Silakan centang pernyataan konfirmasi terlebih dahulu.',
                    confirmButtonColor: '#3b82f6',
                    confirmButtonText: 'Mengerti'
                });
                return false;
            }
            
            // Modern confirmation dialog
            Swal.fire({
                title: 'Konfirmasi Penerimaan',
                html: `
                    <div class="text-left space-y-3">
                        <p class="text-gray-700">Apakah Anda yakin ingin mengkonfirmasi penerimaan produk ini?</p>
                        <div class="bg-blue-50 border border-blue-200 rounded-lg p-3">
                            <p class="text-sm font-semibold text-gray-900 mb-1">Detail Konfirmasi:</p>
                            <ul class="text-xs text-gray-700 space-y-1 list-disc list-inside">
                                <li>Rating: <strong>${rating} bintang</strong></li>
                                <li>Produk telah diterima dengan baik</li>
                                <li>Proses transaksi akan dinyatakan selesai</li>
                            </ul>
                        </div>
                        <p class="text-xs text-gray-500">Tindakan ini tidak dapat dibatalkan.</p>
                    </div>
                `,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#2563eb',
                cancelButtonColor: '#6b7280',
                confirmButtonText: 'Ya, Konfirmasi',
                cancelButtonText: 'Batal',
                reverseButtons: true,
                focusConfirm: false,
                allowOutsideClick: false,
                customClass: {
                    popup: 'rounded-xl',
                    confirmButton: 'px-6 py-2.5 rounded-lg font-semibold',
                    cancelButton: 'px-6 py-2.5 rounded-lg font-semibold'
                },
                didOpen: () => {
                    // Add custom styling
                    const popup = Swal.getPopup();
                    if (popup) {
                        popup.style.fontFamily = '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif';
                    }
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    // Show loading state
                    Swal.fire({
                        title: 'Memproses...',
                        html: 'Mohon tunggu, sedang memproses konfirmasi penerimaan Anda.',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });
                    
                    // Disable submit button
                    submitButton.disabled = true;
                    submitButton.innerHTML = `
                        <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-white inline" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        Memproses...
                    `;
                    
                    // Submit the form normally (will redirect on success)
                    const form = document.getElementById('confirmationForm');
                    
                    // Create a hidden input to track that we've confirmed
                    const confirmedInput = document.createElement('input');
                    confirmedInput.type = 'hidden';
                    confirmedInput.name = 'confirmed';
                    confirmedInput.value = '1';
                    form.appendChild(confirmedInput);
                    
                    // Submit form - will redirect to success page on success
                    form.submit();
                }
            });
        });

        // Disable submit button initially
        document.getElementById('submitButton').disabled = true;
    </script>
</body>
</html>
<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/user/orders/confirm-delivery.blade.php ENDPATH**/ ?>