

<?php $__env->startSection('title', 'Tambah Pembayaran'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="<?php echo e(route('admin.receivables.index')); ?>"
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Tambah Pembayaran</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    <?php echo e($receivable->receivable_number); ?>

                </p>
            </div>
        </div>
    </div>

    <!-- Success/Error Messages -->
    <?php if(session('error')): ?>
        <div class="mb-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg text-sm">
            <i class="fas fa-exclamation-circle mr-2"></i><?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="mb-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg text-sm">
            <div class="font-medium mb-2">Terdapat kesalahan:</div>
            <ul class="list-disc list-inside space-y-1 text-xs">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <!-- Form Pembayaran -->
        <div class="lg:col-span-2">
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
                <div class="p-5">
                    <div class="flex items-center mb-4">
                        <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                            <i class="fas fa-credit-card text-green-600 dark:text-green-400 text-sm"></i>
                        </div>
                        <h3 class="text-base font-semibold text-gray-800 dark:text-white">Form Pembayaran</h3>
                    </div>

                    <form method="POST" action="<?php echo e(route('admin.receivables.store-payment', $receivable)); ?>">
                        <?php echo csrf_field(); ?>
                        
                        <!-- Informasi Piutang -->
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                            <div class="text-center p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-800">
                                <div class="text-xl font-bold text-blue-600 dark:text-blue-400">Rp <?php echo e(number_format($receivable->total_amount, 0, ',', '.')); ?></div>
                                <div class="text-xs text-blue-600 dark:text-blue-400 mt-1">Total Tagihan</div>
                            </div>
                            <div class="text-center p-4 bg-green-50 dark:bg-green-900/20 rounded-lg border border-green-200 dark:border-green-800">
                                <div class="text-xl font-bold text-green-600 dark:text-green-400">Rp <?php echo e(number_format($receivable->paid_amount, 0, ',', '.')); ?></div>
                                <div class="text-xs text-green-600 dark:text-green-400 mt-1">Sudah Dibayar</div>
                            </div>
                            <div class="text-center p-4 bg-red-50 dark:bg-red-900/20 rounded-lg border border-red-200 dark:border-red-800">
                                <div class="text-xl font-bold text-red-600 dark:text-red-400">Rp <?php echo e(number_format($receivable->remaining_amount, 0, ',', '.')); ?></div>
                                <div class="text-xs text-red-600 dark:text-red-400 mt-1">Sisa Tagihan</div>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                            <div>
                                <label for="amount" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    Jumlah Pembayaran <span class="text-red-500">*</span>
                                </label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 dark:text-gray-400 text-sm">Rp</span>
                                    </div>
                                    <input type="number" 
                                           class="w-full pl-10 pr-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition-colors duration-200 bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="amount" 
                                           name="amount" 
                                           value="<?php echo e(old('amount')); ?>" 
                                           min="1" 
                                           max="<?php echo e($receivable->remaining_amount); ?>" 
                                           step="1"
                                           required>
                                </div>
                                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="mt-1 text-xs text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                                    Maksimal: Rp <?php echo e(number_format($receivable->remaining_amount, 0, ',', '.')); ?>

                                </p>
                            </div>
                            
                            <div>
                                <label for="payment_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tanggal Pembayaran</label>
                                <input type="date" 
                                       class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition-colors duration-200 bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm <?php $__errorArgs = ['payment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="payment_date" 
                                       name="payment_date" 
                                       value="<?php echo e(old('payment_date', date('Y-m-d'))); ?>"
                                       max="<?php echo e(date('Y-m-d')); ?>">
                                <?php $__errorArgs = ['payment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="mt-1 text-xs text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="mt-5">
                            <label for="notes" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Catatan Pembayaran</label>
                            <textarea class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition-colors duration-200 bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm resize-none <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="notes" 
                                      name="notes" 
                                      rows="3" 
                                      placeholder="Masukkan catatan pembayaran (opsional)..."><?php echo e(old('notes')); ?></textarea>
                            <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Tombol Aksi Cepat -->
                        <div class="mt-5">
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">Jumlah Cepat:</label>
                            <div class="flex flex-wrap gap-2">
                                <?php
                                    $order = $receivable->order;
                                    $isDpOrder = $order && $order->payment_method === 'dp';
                                    $dpPercentage = $order ? ($order->dp_percentage ?? 30.00) : 30.00;
                                    $dpAmount = $receivable->total_amount * ($dpPercentage / 100);
                                ?>
                                
                                <?php if($isDpOrder && $receivable->paid_amount == 0): ?>
                                    <button type="button" class="px-3 py-1.5 text-xs font-medium text-orange-600 dark:text-orange-400 bg-orange-50 dark:bg-orange-900/20 border border-orange-300 dark:border-orange-700 rounded-lg hover:bg-orange-100 dark:hover:bg-orange-900/30 transition duration-200" 
                                            onclick="setAmount(<?php echo e(round($dpAmount)); ?>)"
                                            title="DP yang harus dibayar: <?php echo e(number_format($dpPercentage, 0)); ?>%">
                                        DP (<?php echo e(number_format($dpPercentage, 0)); ?>%)
                                    </button>
                                    <div class="w-full text-xs text-gray-500 dark:text-gray-400 mt-1">
                                        <i class="fas fa-info-circle mr-1"></i>
                                        DP yang harus dibayar: <strong>Rp <?php echo e(number_format($dpAmount, 0, ',', '.')); ?></strong>
                                    </div>
                                <?php endif; ?>
                                
                                <button type="button" class="px-3 py-1.5 text-xs font-medium text-blue-600 dark:text-blue-400 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg hover:bg-blue-100 dark:hover:bg-blue-900/30 transition duration-200" 
                                        onclick="setAmount(<?php echo e(round($receivable->remaining_amount * 0.25)); ?>)">
                                    25%
                                </button>
                                <button type="button" class="px-3 py-1.5 text-xs font-medium text-blue-600 dark:text-blue-400 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg hover:bg-blue-100 dark:hover:bg-blue-900/30 transition duration-200" 
                                        onclick="setAmount(<?php echo e(round($receivable->remaining_amount * 0.5)); ?>)">
                                    50%
                                </button>
                                <button type="button" class="px-3 py-1.5 text-xs font-medium text-blue-600 dark:text-blue-400 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg hover:bg-blue-100 dark:hover:bg-blue-900/30 transition duration-200" 
                                        onclick="setAmount(<?php echo e(round($receivable->remaining_amount * 0.75)); ?>)">
                                    75%
                                </button>
                                <button type="button" class="px-3 py-1.5 text-xs font-medium text-green-600 dark:text-green-400 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg hover:bg-green-100 dark:hover:bg-green-900/30 transition duration-200" 
                                        onclick="setAmount(<?php echo e($receivable->remaining_amount); ?>)">
                                    Lunas
                                </button>
                            </div>
                        </div>

                        <div class="mt-6 flex justify-end space-x-3 pt-6 border-t border-gray-200 dark:border-gray-700">
                            <a href="<?php echo e(route('admin.receivables.index')); ?>" 
                               class="px-6 py-2.5 text-gray-600 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200 font-medium text-sm">
                                Batal
                            </a>
                            <button type="submit" class="px-6 py-2.5 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 flex items-center space-x-2 text-sm">
                                <i class="fas fa-save"></i>
                                <span>Simpan Pembayaran</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-4">
            <!-- Informasi Customer -->
            <?php if($receivable->order): ?>
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
                <div class="flex items-center mb-3">
                    <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                        <i class="fas fa-user text-blue-600 dark:text-blue-400 text-sm"></i>
                    </div>
                    <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Customer</h3>
                </div>
                <div class="space-y-2">
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Nama:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($receivable->order->customer_name ?? '-'); ?></span>
                    </div>
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Email:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($receivable->order->customer_email ?? '-'); ?></span>
                    </div>
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Telepon:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($receivable->order->phone_number ?? '-'); ?></span>
                    </div>
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Alamat:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e(Str::limit($receivable->order->address ?? '-', 30)); ?></span>
                    </div>
                </div>
            </div>

            <!-- Informasi Produk -->
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
                <div class="flex items-center mb-3">
                    <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                        <i class="fas fa-box text-green-600 dark:text-green-400 text-sm"></i>
                    </div>
                    <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Produk</h3>
                </div>
                <div class="space-y-2">
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Produk:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($receivable->order->product->product_title ?? '-'); ?></span>
                    </div>
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Quantity:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($receivable->order->quantity ?? '-'); ?> unit</span>
                    </div>
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Harga:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100">Rp <?php echo e(number_format($receivable->order->price ?? 0, 0, ',', '.')); ?></span>
                    </div>
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-16 flex-shrink-0">Total:</span>
                        <span class="text-xs font-semibold text-gray-900 dark:text-white">Rp <?php echo e(number_format($receivable->total_amount, 0, ',', '.')); ?></span>
                    </div>
                    <?php
                        $isDpOrder = $order && $order->payment_method === 'dp';
                        $dpPercentage = $order ? ($order->dp_percentage ?? 30.00) : 30.00;
                        $dpAmount = $receivable->total_amount * ($dpPercentage / 100);
                    ?>
                    <?php if($isDpOrder): ?>
                        <div class="pt-2 mt-2 border-t border-gray-200 dark:border-gray-700">
                            <div class="flex items-center justify-between mb-1">
                                <span class="text-xs font-medium text-orange-600 dark:text-orange-400">DP:</span>
                                <span class="text-xs font-semibold text-orange-600 dark:text-orange-400"><?php echo e(number_format($dpPercentage, 0)); ?>%</span>
                            </div>
                            <div class="text-sm font-bold text-orange-600 dark:text-orange-400">
                                Rp <?php echo e(number_format($dpAmount, 0, ',', '.')); ?>

                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Status Piutang -->
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
                <div class="flex items-center mb-3">
                    <div class="p-2 bg-purple-100 dark:bg-purple-900/40 rounded-lg mr-2">
                        <i class="fas fa-info-circle text-purple-600 dark:text-purple-400 text-sm"></i>
                    </div>
                    <h3 class="text-base font-semibold text-gray-800 dark:text-white">Status Piutang</h3>
                </div>
                <div class="space-y-2">
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Status:</span>
                        <div>
                            <?php if($receivable->payment_status == 'pending'): ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-yellow-100 dark:bg-yellow-900/40 text-yellow-700 dark:text-yellow-300">
                                    <?php echo e($receivable->payment_status_label ?? 'Belum Bayar'); ?>

                                </span>
                            <?php elseif($receivable->payment_status == 'partial'): ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300">
                                    <?php echo e($receivable->payment_status_label ?? 'Bayar Sebagian'); ?>

                                </span>
                            <?php elseif($receivable->payment_status == 'paid'): ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300">
                                    <?php echo e($receivable->payment_status_label ?? 'Lunas'); ?>

                                </span>
                            <?php elseif($receivable->payment_status == 'overdue'): ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300">
                                    <?php echo e($receivable->payment_status_label ?? 'Jatuh Tempo'); ?>

                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <?php if($receivable->due_date): ?>
                        <div class="flex items-start">
                            <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Jatuh Tempo:</span>
                            <div>
                                <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($receivable->due_date->format('d/m/Y')); ?></span>
                                <?php if($receivable->isOverdue()): ?>
                                    <span class="ml-2 inline-flex items-center px-1.5 py-0.5 rounded text-xs font-medium bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300">
                                        Terlambat
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script>
        function setAmount(amount) {
            document.getElementById('amount').value = Math.round(amount);
        }
        
        // Format input amount
        document.getElementById('amount').addEventListener('input', function() {
            let value = parseInt(this.value);
            if (value > <?php echo e($receivable->remaining_amount); ?>) {
                this.value = <?php echo e($receivable->remaining_amount); ?>;
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/receivables/create-payment.blade.php ENDPATH**/ ?>