<!-- Sidebar -->
<aside id="sidebar"
    class="fixed left-0 top-0 h-full w-60 bg-slate-900 dark:bg-gray-900 text-gray-300 dark:text-gray-200 transition-all duration-300 z-50 shadow-xl overflow-y-auto scrollbar-hide transform -translate-x-full lg:translate-x-0">

    <style>
        .scrollbar-hide::-webkit-scrollbar { display: none; }
        .scrollbar-hide { -ms-overflow-style: none; scrollbar-width: none; }
        @media (max-width: 1023px) {
            #sidebar { box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25); }
        }
        /* Ensure logo gradient is not overridden by parent text color */
        #sidebar h3.bg-clip-text {
            color: transparent !important;
            background-image: linear-gradient(to right, #60a5fa, #22d3ee) !important;
            -webkit-background-clip: text !important;
            background-clip: text !important;
        }
        /* Badge notification styles - override Tailwind hidden class */
        #sidebar-productions-badge,
        #sidebar-quotations-badge {
            align-items: center;
            justify-content: center;
            min-width: 20px;
            height: 20px;
            padding: 0 6px;
            background-color: #ef4444;
            color: white;
            font-size: 11px;
            font-weight: bold;
            border-radius: 10px;
            line-height: 1;
            animation: pulse 2s infinite;
            box-shadow: 0 2px 4px rgba(239, 68, 68, 0.3);
        }
        /* Explicitly hide with !important when hidden class is present */
        #sidebar-productions-badge.hidden,
        #sidebar-quotations-badge.hidden {
            display: none !important;
            visibility: hidden !important;
        }
        /* Explicitly show with !important when hidden class is NOT present */
        #sidebar-productions-badge:not(.hidden),
        #sidebar-quotations-badge:not(.hidden) {
            display: inline-flex !important;
            visibility: visible !important;
            opacity: 1 !important;
        }
        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.8;
            }
        }
    </style>

    <div class="p-6">
        <div class="flex items-center justify-between mb-8 pb-4 border-b border-slate-700 dark:border-gray-700">
            <!-- Logo -->
            <a href="<?php echo e(url('/')); ?>" class="flex-shrink-0">
                <h3 class="text-2xl font-extrabold bg-gradient-to-r from-blue-400 to-cyan-400 bg-clip-text text-transparent leading-tight whitespace-nowrap">POLJAM TECH</h3>
            </a>
            <!-- Close button for mobile -->
            <button onclick="toggleSidebar()"
                class="lg:hidden text-gray-400 hover:text-white transition-colors duration-200">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
        
        <nav>
            <ul class="space-y-1">
                <!-- Dashboard -->
                <li>
                    <a href="<?php echo e(route('supervisor.dashboard')); ?>"
                        class="flex items-center px-4 py-3 rounded-lg transition group relative <?php echo e(request()->routeIs('supervisor.dashboard') ? 'bg-slate-800 dark:bg-gray-800' : 'hover:bg-slate-800 dark:hover:bg-gray-800'); ?>">
                        <div class="absolute left-0 w-1 h-8 rounded-r bg-gradient-to-b from-blue-500 to-purple-600 transition <?php echo e(request()->routeIs('supervisor.dashboard') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>"></div>
                        <i class="fas fa-home mr-3 text-lg transition <?php echo e(request()->routeIs('supervisor.dashboard') ? 'text-blue-400' : 'group-hover:text-blue-400'); ?>"></i>
                        <span class="transition <?php echo e(request()->routeIs('supervisor.dashboard') ? 'text-white dark:text-white' : 'group-hover:text-white dark:group-hover:text-white'); ?>">Dashboard</span>
                    </a>
                </li>

                <!-- Ringkasan Approval -->
                <li>
                    <a href="<?php echo e(route('supervisor.approvals.index')); ?>"
                        class="flex items-center px-4 py-3 rounded-lg transition group relative <?php echo e(request()->routeIs('supervisor.approvals.index') ? 'bg-slate-800 dark:bg-gray-800' : 'hover:bg-slate-800 dark:hover:bg-gray-800'); ?>">
                        <div class="absolute left-0 w-1 h-8 rounded-r bg-gradient-to-b from-blue-500 to-purple-600 transition <?php echo e(request()->routeIs('supervisor.approvals.index') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>"></div>
                        <i class="fas fa-clipboard-list mr-3 text-lg transition <?php echo e(request()->routeIs('supervisor.approvals.index') ? 'text-blue-400' : 'group-hover:text-blue-400'); ?>"></i>
                        <span class="transition <?php echo e(request()->routeIs('supervisor.approvals.index') ? 'text-white dark:text-white' : 'group-hover:text-white dark:group-hover:text-white'); ?>">Ringkasan Persetujuan</span>
                    </a>
                </li>

                <!-- Persetujuan -->
                <li>
                    <div class="dropdown">
                        <button onclick="toggleDropdown('approvalDropdown', 'approvalIcon')"
                            class="flex items-center justify-between w-full px-4 py-3 rounded-lg transition group relative <?php echo e(request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'bg-slate-800 dark:bg-gray-800' : 'hover:bg-slate-800 dark:hover:bg-gray-800'); ?>">
                            <div class="absolute left-0 w-1 h-8 rounded-r bg-gradient-to-b from-blue-500 to-purple-600 transition <?php echo e(request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>"></div>
                            <span class="flex items-center">
                                <i class="fas fa-check-circle mr-3 text-lg transition <?php echo e(request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'text-blue-400' : 'group-hover:text-blue-400'); ?>"></i>
                                <span class="transition <?php echo e(request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'text-white dark:text-white' : 'group-hover:text-white dark:group-hover:text-white'); ?>">Persetujuan</span>
                            </span>
                            <i id="approvalIcon" class="fas fa-chevron-right text-xs transition-transform duration-300 <?php echo e(request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'rotate-90 text-blue-400' : ''); ?>"></i>
                        </button>
                        <ul id="approvalDropdown" class="ml-4 mt-1 space-y-1 border-l-2 border-slate-700 dark:border-gray-700 pl-4 <?php echo e(request()->routeIs('supervisor.approvals.*') || request()->routeIs('supervisor.productions.*') || request()->routeIs('supervisor.purchases.*') ? 'block' : 'hidden'); ?>">
                            <li>
                                <a href="<?php echo e(route('supervisor.productions.index')); ?>"
                                    class="flex items-center px-4 py-2 rounded-lg transition text-sm <?php echo e(request()->routeIs('supervisor.productions.*') ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white' : 'hover:bg-slate-800 dark:hover:bg-gray-800 hover:text-white dark:hover:text-white'); ?>">
                                    <i class="fas fa-caret-right text-xs mr-2 transition <?php echo e(request()->routeIs('supervisor.productions.*') ? 'text-white rotate-90' : 'text-slate-600'); ?>"></i>
                                    <span class="flex-1">Persetujuan Produksi</span>
                                    <span id="sidebar-productions-badge" class="hidden bg-red-500 text-white text-xs font-bold px-2 py-0.5 rounded-full min-w-[20px] text-center"></span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.purchases.index')); ?>"
                                    class="flex items-center px-4 py-2 rounded-lg transition text-sm <?php echo e(request()->routeIs('supervisor.purchases.*') ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white' : 'hover:bg-slate-800 dark:hover:bg-gray-800 hover:text-white dark:hover:text-white'); ?>">
                                    <i class="fas fa-caret-right text-xs mr-2 transition <?php echo e(request()->routeIs('supervisor.purchases.*') ? 'text-white rotate-90' : 'text-slate-600'); ?>"></i>
                                    Persetujuan Pembelian
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <!-- Review Penawaran Harga -->
                <li>
                    <a href="<?php echo e(route('supervisor.quotations.index')); ?>"
                        class="flex items-center px-4 py-3 rounded-lg transition group relative <?php echo e(request()->routeIs('supervisor.quotations.*') ? 'bg-slate-800 dark:bg-gray-800' : 'hover:bg-slate-800 dark:hover:bg-gray-800'); ?>">
                        <div class="absolute left-0 w-1 h-8 rounded-r bg-gradient-to-b from-blue-500 to-purple-600 transition <?php echo e(request()->routeIs('supervisor.quotations.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>"></div>
                        <i class="fas fa-handshake mr-3 text-lg transition <?php echo e(request()->routeIs('supervisor.quotations.*') ? 'text-blue-400' : 'group-hover:text-blue-400'); ?>"></i>
                        <span class="flex-1 transition <?php echo e(request()->routeIs('supervisor.quotations.*') ? 'text-white dark:text-white' : 'group-hover:text-white dark:group-hover:text-white'); ?>">Review Penawaran</span>
                        <span id="sidebar-quotations-badge" class="hidden bg-red-500 text-white text-xs font-bold px-2 py-0.5 rounded-full min-w-[20px] text-center"></span>
                    </a>
                </li>

                <!-- Monitoring -->
                <li>
                    <div class="dropdown">
                        <button onclick="toggleDropdown('monitoringDropdown', 'monitoringIcon')"
                            class="flex items-center justify-between w-full px-4 py-3 rounded-lg transition group relative <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'bg-slate-800 dark:bg-gray-800' : 'hover:bg-slate-800 dark:hover:bg-gray-800'); ?>">
                            <div class="absolute left-0 w-1 h-8 rounded-r bg-gradient-to-b from-blue-500 to-purple-600 transition <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>"></div>
                            <span class="flex items-center">
                                <i class="fas fa-eye mr-3 text-lg transition <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'text-blue-400' : 'group-hover:text-blue-400'); ?>"></i>
                                <span class="transition <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'text-white dark:text-white' : 'group-hover:text-white dark:group-hover:text-white'); ?>">Monitoring</span>
                            </span>
                            <i id="monitoringIcon" class="fas fa-chevron-right text-xs transition-transform duration-300 <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'rotate-90 text-blue-400' : ''); ?>"></i>
                        </button>
                        <ul id="monitoringDropdown" class="ml-4 mt-1 space-y-1 border-l-2 border-slate-700 dark:border-gray-700 pl-4 <?php echo e(request()->routeIs('supervisor.monitoring.*') ? 'block' : 'hidden'); ?>">
                            <li>
                                <a href="<?php echo e(route('supervisor.monitoring.orders')); ?>"
                                    class="flex items-center px-4 py-2 rounded-lg transition text-sm <?php echo e(request()->routeIs('supervisor.monitoring.orders') && !request()->has('status') ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white' : 'hover:bg-slate-800 dark:hover:bg-gray-800 hover:text-white dark:hover:text-white'); ?>">
                                    <i class="fas fa-caret-right text-xs mr-2 transition <?php echo e(request()->routeIs('supervisor.monitoring.orders') && !request()->has('status') ? 'text-white rotate-90' : 'text-slate-600'); ?>"></i>
                                    Semua Pesanan
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.monitoring.productions')); ?>"
                                    class="flex items-center px-4 py-2 rounded-lg transition text-sm <?php echo e(request()->routeIs('supervisor.monitoring.productions') ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white' : 'hover:bg-slate-800 dark:hover:bg-gray-800 hover:text-white dark:hover:text-white'); ?>">
                                    <i class="fas fa-caret-right text-xs mr-2 transition <?php echo e(request()->routeIs('supervisor.monitoring.productions') ? 'text-white rotate-90' : 'text-slate-600'); ?>"></i>
                                    Semua Produksi
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.monitoring.sales')); ?>"
                                    class="flex items-center px-4 py-2 rounded-lg transition text-sm <?php echo e(request()->routeIs('supervisor.monitoring.sales') ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white' : 'hover:bg-slate-800 dark:hover:bg-gray-800 hover:text-white dark:hover:text-white'); ?>">
                                    <i class="fas fa-caret-right text-xs mr-2 transition <?php echo e(request()->routeIs('supervisor.monitoring.sales') ? 'text-white rotate-90' : 'text-slate-600'); ?>"></i>
                                    Semua Penjualan
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.monitoring.purchases')); ?>"
                                    class="flex items-center px-4 py-2 rounded-lg transition text-sm <?php echo e(request()->routeIs('supervisor.monitoring.purchases') ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white' : 'hover:bg-slate-800 dark:hover:bg-gray-800 hover:text-white dark:hover:text-white'); ?>">
                                    <i class="fas fa-caret-right text-xs mr-2 transition <?php echo e(request()->routeIs('supervisor.monitoring.purchases') ? 'text-white rotate-90' : 'text-slate-600'); ?>"></i>
                                    Semua Pembelian
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <!-- Laporan -->
                <li>
                    <div class="dropdown">
                        <button onclick="toggleDropdown('reportsDropdown', 'reportsIcon')"
                            class="flex items-center justify-between w-full px-4 py-3 rounded-lg transition group relative <?php echo e(request()->routeIs('supervisor.reports.*') ? 'bg-slate-800 dark:bg-gray-800' : 'hover:bg-slate-800 dark:hover:bg-gray-800'); ?>">
                            <div class="absolute left-0 w-1 h-8 rounded-r bg-gradient-to-b from-blue-500 to-purple-600 transition <?php echo e(request()->routeIs('supervisor.reports.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>"></div>
                            <span class="flex items-center">
                                <i class="fas fa-file-alt mr-3 text-lg transition <?php echo e(request()->routeIs('supervisor.reports.*') ? 'text-blue-400' : 'group-hover:text-blue-400'); ?>"></i>
                                <span class="transition <?php echo e(request()->routeIs('supervisor.reports.*') ? 'text-white dark:text-white' : 'group-hover:text-white dark:group-hover:text-white'); ?>">Laporan</span>
                            </span>
                            <i id="reportsIcon" class="fas fa-chevron-right text-xs transition-transform duration-300 <?php echo e(request()->routeIs('supervisor.reports.*') ? 'rotate-90 text-blue-400' : ''); ?>"></i>
                        </button>
                        <ul id="reportsDropdown" class="ml-4 mt-1 space-y-1 border-l-2 border-slate-700 dark:border-gray-700 pl-4 <?php echo e(request()->routeIs('supervisor.reports.*') ? 'block' : 'hidden'); ?>">
                            <li>
                                <a href="<?php echo e(route('supervisor.reports.sales')); ?>"
                                    class="flex items-center px-4 py-2 rounded-lg transition text-sm <?php echo e(request()->routeIs('supervisor.reports.sales*') ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white' : 'hover:bg-slate-800 dark:hover:bg-gray-800 hover:text-white dark:hover:text-white'); ?>">
                                    <i class="fas fa-caret-right text-xs mr-2 transition <?php echo e(request()->routeIs('supervisor.reports.sales*') ? 'text-white rotate-90' : 'text-slate-600'); ?>"></i>
                                    Lap. Penjualan
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.reports.purchases')); ?>"
                                    class="flex items-center px-4 py-2 rounded-lg transition text-sm <?php echo e(request()->routeIs('supervisor.reports.purchases*') ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white' : 'hover:bg-slate-800 dark:hover:bg-gray-800 hover:text-white dark:hover:text-white'); ?>">
                                    <i class="fas fa-caret-right text-xs mr-2 transition <?php echo e(request()->routeIs('supervisor.reports.purchases*') ? 'text-white rotate-90' : 'text-slate-600'); ?>"></i>
                                    Lap. Pembelian
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.reports.productions')); ?>"
                                    class="flex items-center px-4 py-2 rounded-lg transition text-sm <?php echo e(request()->routeIs('supervisor.reports.productions*') ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white' : 'hover:bg-slate-800 dark:hover:bg-gray-800 hover:text-white dark:hover:text-white'); ?>">
                                    <i class="fas fa-caret-right text-xs mr-2 transition <?php echo e(request()->routeIs('supervisor.reports.productions*') ? 'text-white rotate-90' : 'text-slate-600'); ?>"></i>
                                    Lap. Produksi
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.reports.stock-limit')); ?>"
                                    class="flex items-center px-4 py-2 rounded-lg transition text-sm <?php echo e(request()->routeIs('supervisor.reports.stock-limit*') ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white' : 'hover:bg-slate-800 dark:hover:bg-gray-800 hover:text-white dark:hover:text-white'); ?>">
                                    <i class="fas fa-caret-right text-xs mr-2 transition <?php echo e(request()->routeIs('supervisor.reports.stock-limit*') ? 'text-white rotate-90' : 'text-slate-600'); ?>"></i>
                                    Lap. Barang Limit
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('supervisor.reports.damaged-items')); ?>"
                                    class="flex items-center px-4 py-2 rounded-lg transition text-sm <?php echo e(request()->routeIs('supervisor.reports.damaged-items*') ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white' : 'hover:bg-slate-800 dark:hover:bg-gray-800 hover:text-white dark:hover:text-white'); ?>">
                                    <i class="fas fa-caret-right text-xs mr-2 transition <?php echo e(request()->routeIs('supervisor.reports.damaged-items*') ? 'text-white rotate-90' : 'text-slate-600'); ?>"></i>
                                    Lap. Barang Rusak
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>
            </ul>
        </nav>
    </div>
</aside>

<!-- Mobile Overlay -->
<div id="sidebarOverlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden lg:hidden"></div>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const mainContent = document.getElementById('mainContent');
    
    if (sidebar.classList.contains('-translate-x-full')) {
        sidebar.classList.remove('-translate-x-full');
        overlay.classList.remove('hidden');
        document.body.style.overflow = 'hidden';
    } else {
        sidebar.classList.add('-translate-x-full');
        overlay.classList.add('hidden');
        document.body.style.overflow = 'auto';
    }
}

document.getElementById('sidebarOverlay').addEventListener('click', function() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    
    sidebar.classList.add('-translate-x-full');
    overlay.classList.add('hidden');
    document.body.style.overflow = 'auto';
});

function toggleDropdown(dropdownId, iconId) {
    const dropdown = document.getElementById(dropdownId);
    const icon = document.getElementById(iconId);
    
    if (dropdown.classList.contains('hidden')) {
        dropdown.classList.remove('hidden');
        icon.classList.add('rotate-90');
    } else {
        dropdown.classList.add('hidden');
        icon.classList.remove('rotate-90');
    }
}
</script>
<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/partials/sidebar.blade.php ENDPATH**/ ?>