<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pesanan Anda Telah Dibuat - POLJAM TECH</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f8f9fa;
        }
        .container {
            background-color: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #e9ecef;
        }
        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #2563eb;
            margin-bottom: 10px;
        }
        .order-info {
            background-color: #f0fdf4;
            padding: 20px;
            border-radius: 8px;
            border-left: 4px solid #10b981;
            margin: 20px 0;
        }
        .product-info {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e9ecef;
            text-align: center;
            color: #6b7280;
            font-size: 14px;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background-color: #2563eb;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="logo">POLJAM TECH</div>
            <p>Konfirmasi Pesanan</p>
        </div>

        <p>Halo <strong><?php echo e($inquiry->name); ?></strong>,</p>

        <p>Terima kasih telah menyetujui penawaran kami. Kami telah membuat pesanan untuk Anda berdasarkan penawaran yang Anda setujui.</p>

        <div class="order-info">
            <h3 style="margin-top: 0; color: #10b981;">📦 Detail Pesanan</h3>
            <p><strong>Order ID:</strong> #<?php echo e($order->id); ?></p>
            <p><strong>Produk:</strong> <?php echo e($inquiry->product->product_title ?? 'Produk'); ?></p>
            <p><strong>Quantity:</strong> <?php echo e($order->quantity); ?> unit</p>
            <p><strong>Harga Satuan:</strong> Rp <?php echo e(number_format($order->price, 0, ',', '.')); ?></p>
            <p><strong>Total Harga:</strong> <strong style="color: #10b981; font-size: 18px;">Rp <?php echo e(number_format($order->total_price, 0, ',', '.')); ?></strong></p>
            <p><strong>Metode Pembayaran:</strong> <?php echo e(ucfirst($order->payment_method)); ?></p>
            <p><strong>Status:</strong> <?php echo e(ucfirst($order->order_status)); ?></p>
        </div>

        <div class="product-info">
            <h4 style="margin-top: 0;">Alamat Pengiriman:</h4>
            <p><?php echo e($order->address); ?></p>
        </div>

        <p>Tim kami akan segera menghubungi Anda untuk konfirmasi dan proses selanjutnya.</p>

        <p>Jika ada pertanyaan, silakan hubungi kami melalui:</p>
        <ul>
            <li>Email: <?php echo e(config('mail.from.address')); ?></li>
            <li>Telepon: (sesuai yang tertera di website)</li>
        </ul>

        <div style="text-align: center; margin-top: 30px;">
            <p style="color: #6b7280; font-size: 14px;">
                Tracking Code Penawaran: <strong><?php echo e($inquiry->tracking_code); ?></strong>
            </p>
        </div>

        <div class="footer">
            <p>Terima kasih telah mempercayai <strong>POLJAM TECH</strong></p>
            <p style="font-size: 12px; color: #9ca3af;">Email ini dikirim otomatis oleh sistem.</p>
        </div>
    </div>
</body>
</html>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/emails/inquiry-converted-to-order.blade.php ENDPATH**/ ?>