

<?php $__env->startSection('title', 'Detail Produksi - Admin'); ?>

<?php $__env->startSection('content'); ?>
<?php
    $orderQty = $production->quantity ?? $production->order->quantity ?? 1;
    $materialTotal = $production->total_material_cost ?? 0;
    $sparepartTotal = $production->total_sparepart_cost ?? 0;
    $directTotal = $materialTotal + $sparepartTotal;
    $laborTotal = $production->labor_cost ?? 0;
    $actualTotal = $directTotal + $laborTotal;
    $totalCost = $actualTotal;
?>

<div class="space-y-4">
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="<?php echo e(route('admin.productions.index')); ?>" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Detail Produksi #<?php echo e($production->id); ?></h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    Order #<?php echo e($production->order->id ?? 'N/A'); ?>  <?php echo e($production->order->customer_name ?? 'N/A'); ?>

                </p>
            </div>
        </div>
    </div>

    <!-- Notifications -->
    <?php if(session('success')): ?>
    <div class="bg-green-50 dark:bg-green-900/30 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 px-4 py-3 rounded-lg flex items-center gap-3">
        <i class="fas fa-check-circle text-green-500"></i>
        <span><?php echo e(session('success')); ?></span>
    </div>
    <?php endif; ?>

    <?php if(session('info')): ?>
    <div class="bg-blue-50 dark:bg-blue-900/30 border border-blue-200 dark:border-blue-800 text-blue-800 dark:text-blue-200 px-4 py-3 rounded-lg flex items-center gap-3">
        <i class="fas fa-info-circle text-blue-500"></i>
        <span><?php echo e(session('info')); ?></span>
    </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
    <div class="bg-red-50 dark:bg-red-900/30 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg">
        <ul class="list-disc list-inside text-sm">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
    </div>
    <?php endif; ?>

    
    
    
    <?php if(!$production->teknisi_id && !in_array($production->status, ['selesai', 'dibatalkan'])): ?>
    <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-5 mb-6">
        <div class="flex items-start gap-4">
            <div class="flex-shrink-0">
                <div class="w-10 h-10 bg-blue-100 dark:bg-blue-900/40 rounded-lg flex items-center justify-center">
                    <i class="fas fa-user-plus text-blue-600 dark:text-blue-400 text-lg"></i>
                </div>
            </div>
            <div class="flex-1">
                <h3 class="text-base font-semibold text-gray-900 dark:text-white mb-1">
                    Tugaskan ke Teknisi
                </h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    Pilih teknisi yang akan mengerjakan produksi ini.
                </p>
                <form action="<?php echo e(route('admin.productions.assign-teknisi', $production)); ?>" method="POST" class="flex flex-wrap items-end gap-3">
                    <?php echo csrf_field(); ?>
                    <div class="flex-1 min-w-[200px]">
                        <label for="teknisi_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Pilih Teknisi</label>
                        <select name="teknisi_id" id="teknisi_id" required
                            class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200">
                            <option value="">-- Pilih Teknisi --</option>
                            <?php $__currentLoopData = \App\Models\User::where('user_type', 'teknisi')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teknisi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($teknisi->id); ?>"><?php echo e($teknisi->name); ?> (<?php echo e($teknisi->email); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white font-medium px-6 py-2.5 rounded-lg transition-colors duration-200 flex items-center gap-2">
                        <i class="fas fa-paper-plane"></i>
                        <span>Tugaskan</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
    <?php elseif($production->teknisi_id && !in_array($production->status, ['selesai', 'dibatalkan'])): ?>
    <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg p-5 mb-6">
        <div class="flex items-center justify-between flex-wrap gap-4">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-green-100 dark:bg-green-900/40 rounded-lg flex items-center justify-center">
                    <i class="fas fa-user-check text-green-600 dark:text-green-400 text-lg"></i>
                </div>
                <div>
                    <h3 class="text-base font-semibold text-gray-900 dark:text-white">
                        Sudah Ditugaskan
                    </h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400">
                        Teknisi: <span class="font-medium text-gray-900 dark:text-white"><?php echo e($production->teknisi->name ?? 'N/A'); ?></span>
                        <?php if($production->assigned_at): ?>
                            <span class="text-gray-500 dark:text-gray-400 ml-2">(<?php echo e($production->assigned_at->format('d M Y H:i')); ?>)</span>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
            <form action="<?php echo e(route('admin.productions.unassign-teknisi', $production)); ?>" method="POST" class="inline" onsubmit="return confirm('Yakin ingin membatalkan penugasan teknisi ini?')">
                <?php echo csrf_field(); ?>
                <button type="submit" class="bg-red-500 hover:bg-red-600 text-white font-medium px-4 py-2 rounded-lg transition-colors duration-200 flex items-center gap-2">
                    <i class="fas fa-user-times"></i>
                    <span>Batalkan</span>
                </button>
            </form>
        </div>
    </div>
    <?php endif; ?>

    <!-- Info Cards Row -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <!-- Info Produksi -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-industry text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Info Produksi</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Qty:</span>
                    <span class="font-semibold text-gray-900 dark:text-white"><?php echo e($orderQty); ?> unit</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Teknisi:</span>
                    <span class="font-medium text-gray-900 dark:text-white text-xs truncate"><?php echo e($production->teknisi->name ?? 'Belum ditugaskan'); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Status:</span>
                    <?php
                        $statusConfig = [
                            'menunggu' => ['bg' => 'bg-gray-100 dark:bg-gray-700/50', 'text' => 'text-gray-700 dark:text-gray-300', 'label' => 'Menunggu'],
                            'dalam_proses' => ['bg' => 'bg-yellow-100 dark:bg-yellow-900/40', 'text' => 'text-yellow-700 dark:text-yellow-300', 'label' => 'Dalam Proses'],
                            'selesai' => ['bg' => 'bg-green-100 dark:bg-green-900/40', 'text' => 'text-green-700 dark:text-green-300', 'label' => 'Selesai'],
                            'dibatalkan' => ['bg' => 'bg-red-100 dark:bg-red-900/40', 'text' => 'text-red-700 dark:text-red-300', 'label' => 'Dibatalkan'],
                        ];
                        $status = $statusConfig[$production->status] ?? $statusConfig['menunggu'];
                    ?>
                    <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md <?php echo e($status['bg']); ?> <?php echo e($status['text']); ?>">
                        <?php echo e($status['label']); ?>

                    </span>
                </div>
            </div>
        </div>

        <!-- Info Order -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-emerald-100 dark:bg-emerald-900/40 rounded-lg">
                    <i class="fas fa-shopping-cart text-emerald-600 dark:text-emerald-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Info Pesanan</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Order ID:</span>
                    <span class="font-medium text-gray-900 dark:text-white">#<?php echo e($production->order->id ?? 'N/A'); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Produk:</span>
                    <span class="font-medium text-gray-900 dark:text-white text-xs truncate" title="<?php echo e($production->product->product_title ?? 'N/A'); ?>"><?php echo e(Str::limit($production->product->product_title ?? 'N/A', 15)); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Harga:</span>
                    <span class="font-semibold text-emerald-600 dark:text-emerald-400">Rp <?php echo e(number_format($production->order->price ?? 0, 0, ',', '.')); ?></span>
                </div>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-purple-100 dark:bg-purple-900/40 rounded-lg">
                    <i class="fas fa-chart-pie text-purple-600 dark:text-purple-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Ringkasan</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Bahan:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e($production->productionMaterials->count()); ?> item</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Sparepart:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e($production->productionSpareparts->count()); ?> item</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Total:</span>
                    <span class="font-bold text-indigo-600 dark:text-indigo-400">Rp <?php echo e(number_format($totalCost, 0, ',', '.')); ?></span>
                </div>
            </div>
        </div>

        <!-- Payment Info -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-orange-100 dark:bg-orange-900/40 rounded-lg">
                    <i class="fas fa-credit-card text-orange-600 dark:text-orange-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Pembayaran</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Metode:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e(strtoupper($production->order->payment_method ?? 'N/A')); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Status:</span>
                    <?php
                        $paymentStatus = $production->order->status ?? 'menunggu';
                        $paymentStatusConfig = [
                            'selesai' => ['bg' => 'bg-green-100 dark:bg-green-900/40', 'text' => 'text-green-700 dark:text-green-300', 'label' => 'Lunas'],
                            'diproses' => ['bg' => 'bg-blue-100 dark:bg-blue-900/40', 'text' => 'text-blue-700 dark:text-blue-300', 'label' => 'Diproses'],
                            'menunggu_verifikasi' => ['bg' => 'bg-yellow-100 dark:bg-yellow-900/40', 'text' => 'text-yellow-700 dark:text-yellow-300', 'label' => 'Verifikasi'],
                        ];
                        $paymentStatusStyle = $paymentStatusConfig[$paymentStatus] ?? ['bg' => 'bg-gray-100 dark:bg-gray-700/50', 'text' => 'text-gray-700 dark:text-gray-300', 'label' => ucfirst($paymentStatus)];
                    ?>
                    <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md <?php echo e($paymentStatusStyle['bg']); ?> <?php echo e($paymentStatusStyle['text']); ?>">
                        <?php echo e($paymentStatusStyle['label']); ?>

                    </span>
                </div>
                <?php if($production->submitted_at): ?>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Diajukan:</span>
                    <span class="font-medium text-gray-900 dark:text-white text-xs"><?php echo e($production->submitted_at->format('d/m/Y')); ?></span>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Timeline Progress -->
    <?php echo $__env->make('admin.master.productions.partials.timeline', ['production' => $production], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    
    
    
    <?php
        $itemRequests = $production->itemRequests ?? collect();
        $pendingRequests = $itemRequests->where('status', 'pending');
    ?>
    
    <?php if($pendingRequests->count() > 0): ?>
    <div class="bg-orange-50 dark:bg-orange-900/20 border border-orange-200 dark:border-orange-800 rounded-lg overflow-hidden mb-6">
        <div class="px-5 py-4 bg-orange-500 dark:bg-orange-600 text-white flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="p-2 bg-white/20 rounded-lg flex items-center justify-center">
                    <i class="fas fa-bell text-white text-sm"></i>
                </div>
                <div>
                    <h3 class="text-base font-semibold">Request Item Menunggu Persetujuan</h3>
                    <p class="text-xs text-orange-100"><?php echo e($pendingRequests->count()); ?> request baru dari teknisi perlu ditinjau</p>
                </div>
            </div>
            <span class="px-3 py-1 bg-white/20 rounded-md text-xs font-semibold animate-pulse"><?php echo e($pendingRequests->count()); ?> Pending</span>
        </div>

        <div class="p-5">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-orange-100 dark:bg-orange-900/30 border-b border-orange-200 dark:border-orange-800">
                        <tr>
                            <th class="px-4 py-3.5 text-left text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Item</th>
                            <th class="px-4 py-3.5 text-center text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Tipe</th>
                            <th class="px-4 py-3.5 text-center text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Jumlah</th>
                            <th class="px-4 py-3.5 text-left text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Alasan</th>
                            <th class="px-4 py-3.5 text-left text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Diminta Oleh</th>
                            <th class="px-4 py-3.5 text-center text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-orange-200 dark:divide-orange-800 bg-white dark:bg-gray-800">
                        <?php $__currentLoopData = $pendingRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-orange-50/50 dark:hover:bg-orange-900/20 transition-colors duration-200">
                            <td class="px-4 py-3.5">
                                <div class="font-medium text-gray-900 dark:text-white text-sm"><?php echo e($request->item_name_display); ?></div>
                                <?php if($request->is_new_item): ?>
                                <span class="text-xs text-blue-600 dark:text-blue-400"><i class="fas fa-star mr-0.5"></i>Item Baru</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3.5 text-center">
                                <?php if($request->item_type === 'material'): ?>
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-emerald-100 dark:bg-emerald-900/40 text-emerald-700 dark:text-emerald-300">
                                    <i class="fas fa-cube text-xs"></i> Bahan
                                </span>
                                <?php else: ?>
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300">
                                    <i class="fas fa-cog text-xs"></i> Sparepart
                                </span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3.5 text-center font-medium text-gray-900 dark:text-white text-sm"><?php echo e($request->quantity); ?> <?php echo e($request->unit); ?></td>
                            <td class="px-4 py-3.5 text-sm text-gray-600 dark:text-gray-400"><?php echo e(Str::limit($request->reason, 50)); ?></td>
                            <td class="px-4 py-3.5">
                                <div class="text-sm">
                                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e($request->requester->name ?? 'N/A'); ?></span>
                                    <br><span class="text-xs text-gray-500 dark:text-gray-400"><?php echo e($request->created_at->format('d/m/Y H:i')); ?></span>
                                </div>
                            </td>
                            <td class="px-4 py-3.5 text-center">
                                <div class="flex items-center justify-center gap-2 flex-wrap">
                                    <form action="<?php echo e(route('admin.productions.item-requests.reject', [$production, $request])); ?>" method="POST" class="inline" onsubmit="return confirm('Yakin ingin menolak request ini?')">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="w-9 h-9 bg-red-500 hover:bg-red-600 text-white rounded-lg flex items-center justify-center transition-colors duration-200" title="Tolak Request">
                                            <i class="fas fa-times text-base"></i>
                                        </button>
                                    </form>
                                    <a href="<?php echo e(route('admin.transaksi.purchases.create', [
                                        'from_item_request' => $request->id,
                                        'item_type' => $request->item_type,
                                        'item_name' => $request->item_name_display,
                                        'quantity' => $request->quantity,
                                        'unit' => $request->unit,
                                        'estimated_price' => $request->estimated_price,
                                        'material_id' => $request->material_id,
                                        'sparepart_id' => $request->sparepart_id,
                                    ])); ?>" 
                                       class="w-9 h-9 bg-blue-500 hover:bg-blue-600 text-white rounded-lg flex items-center justify-center transition-colors duration-200 shadow-md hover:shadow-lg" 
                                       title="Setujui & Buat Pembelian (akan auto-approve)">
                                        <i class="fas fa-shopping-cart text-base"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>

    
    
    
    <?php
        $itemRequests = $production->itemRequests ?? collect();
        $proposalGroups = $itemRequests->groupBy('proposal_number')->sortKeys();
        $nonPendingRequests = $itemRequests->where('status', '!=', 'pending');
    ?>
    
    <?php if($proposalGroups->count() > 0): ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 mb-6 overflow-hidden">
        <div class="px-5 py-4 border-b border-gray-200 dark:border-gray-700 bg-gradient-to-r from-indigo-600 to-indigo-700">
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="p-2 bg-white/20 rounded-lg">
                        <i class="fas fa-list-ol text-white text-sm"></i>
                    </div>
                    <div>
                        <h3 class="text-base font-semibold text-white">Usulan Bahan & Sparepart</h3>
                        <p class="text-xs text-indigo-100">
                            Dikelompokkan berdasarkan usulan pertama, kedua, ketiga
                            <?php if($pendingRequests->count() > 0): ?>
                             <span class="text-orange-200">Item pending juga ada di notifikasi di atas</span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
                <?php if($itemRequests->count() > 0): ?>
                <div class="flex items-center gap-2">
                    <?php
                        $statusCounts = [
                            'pending' => $itemRequests->where('status', 'pending')->count(),
                            'approved' => $itemRequests->where('status', 'approved')->count(),
                            'purchased' => $itemRequests->where('status', 'purchased')->count(),
                            'received' => $itemRequests->where('status', 'received')->count(),
                        ];
                    ?>
                    <div class="flex items-center gap-1.5 px-3 py-1 bg-white/10 rounded-md text-xs">
                        <span class="text-indigo-100">Total:</span>
                        <span class="font-semibold text-white"><?php echo e($itemRequests->count()); ?> item</span>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="p-5 space-y-6">
            <?php $__currentLoopData = $proposalGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proposalNumber => $requests): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="border border-gray-200 dark:border-gray-700 rounded-lg overflow-hidden">
                <div class="px-4 py-3 bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-700">
                    <h4 class="text-sm font-semibold text-gray-900 dark:text-white flex items-center gap-2">
                        <span class="w-6 h-6 rounded-full bg-indigo-100 dark:bg-indigo-900/40 text-indigo-700 dark:text-indigo-300 flex items-center justify-center text-xs font-bold">
                            <?php echo e($proposalNumber ?? '1'); ?>

                        </span>
                        Usulan <?php echo e($proposalNumber == 1 ? 'Pertama' : ($proposalNumber == 2 ? 'Kedua' : ($proposalNumber == 3 ? 'Ketiga' : 'Ke-' . $proposalNumber))); ?>

                        <span class="ml-auto text-xs font-normal text-gray-500">
                            <?php echo e($requests->count()); ?> item
                        </span>
                    </h4>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 dark:bg-gray-700/50">
                            <tr class="text-xs uppercase">
                                <th class="px-4 py-2 text-left font-semibold text-gray-600 dark:text-gray-300">Item</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Tipe</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Jumlah</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Satuan</th>
                                <th class="px-4 py-2 text-left font-semibold text-gray-600 dark:text-gray-300">Alasan</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Status</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200 dark:divide-gray-700 bg-white dark:bg-gray-800">
                            <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/30 <?php echo e($request->status === 'pending' ? 'bg-orange-50/30 dark:bg-orange-900/10' : ''); ?>">
                                <td class="px-4 py-3">
                                    <div class="font-medium text-gray-900 dark:text-white text-sm flex items-center gap-2">
                                        <?php echo e($request->item_name_display); ?>

                                        <?php if($request->status === 'pending'): ?>
                                        <span class="px-1.5 py-0.5 bg-orange-100 dark:bg-orange-900/40 text-orange-700 dark:text-orange-300 text-[10px] font-medium rounded" title="Juga ada di notifikasi di atas">
                                            <i class="fas fa-bell mr-0.5"></i>Pending
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($request->is_new_item): ?>
                                    <span class="text-xs text-blue-600 dark:text-blue-400"><i class="fas fa-star mr-0.5"></i>Item Baru</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-center">
                                    <?php if($request->item_type === 'material'): ?>
                                    <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded-full bg-emerald-100 text-emerald-700">
                                        <i class="fas fa-cube"></i> Bahan
                                    </span>
                                    <?php else: ?>
                                    <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded-full bg-blue-100 text-blue-700">
                                        <i class="fas fa-cog"></i> Sparepart
                                    </span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-center font-medium text-gray-900 dark:text-white"><?php echo e($request->quantity); ?></td>
                                <td class="px-4 py-3 text-center text-gray-600 dark:text-gray-400"><?php echo e($request->unit); ?></td>
                                <td class="px-4 py-3 text-sm text-gray-600 dark:text-gray-400"><?php echo e(Str::limit($request->reason, 50)); ?></td>
                                <td class="px-4 py-3 text-center">
                                    <span class="inline-flex items-center gap-1 px-2 py-1 text-xs font-medium rounded-full <?php echo e($request->status_badge_class); ?>">
                                        <?php if($request->status === 'pending'): ?>
                                        <i class="fas fa-clock text-[10px]"></i>
                                        <?php elseif($request->status === 'approved'): ?>
                                        <i class="fas fa-check-circle text-[10px]"></i>
                                        <?php elseif($request->status === 'rejected'): ?>
                                        <i class="fas fa-times-circle text-[10px]"></i>
                                        <?php elseif($request->status === 'purchased'): ?>
                                        <i class="fas fa-shopping-cart text-[10px]"></i>
                                        <?php elseif($request->status === 'sent'): ?>
                                        <i class="fas fa-paper-plane text-[10px]"></i>
                                        <?php elseif($request->status === 'received'): ?>
                                        <i class="fas fa-check-double text-[10px]"></i>
                                        <?php endif; ?>
                                        <?php echo e($request->status_label); ?>

                                    </span>
                                </td>
                                <td class="px-4 py-3 text-center">
                                    <div class="flex items-center justify-center gap-1">
                                        <?php if($request->status === 'pending'): ?>
                                        <form action="<?php echo e(route('admin.productions.item-requests.reject', [$production, $request])); ?>" method="POST" class="inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="w-8 h-8 bg-red-500 hover:bg-red-600 text-white rounded-lg flex items-center justify-center transition-colors" title="Tolak">
                                                <i class="fas fa-times text-xs"></i>
                                            </button>
                                        </form>
                                        <a href="<?php echo e(route('admin.transaksi.purchases.create', [
                                            'from_item_request' => $request->id,
                                            'item_type' => $request->item_type,
                                            'item_name' => $request->item_name_display,
                                            'quantity' => $request->quantity,
                                            'unit' => $request->unit,
                                            'estimated_price' => $request->estimated_price,
                                            'material_id' => $request->material_id,
                                            'sparepart_id' => $request->sparepart_id,
                                        ])); ?>" 
                                           class="w-8 h-8 bg-blue-500 hover:bg-blue-600 text-white rounded-lg flex items-center justify-center transition-colors" 
                                           title="Setujui & Buat Pembelian">
                                            <i class="fas fa-shopping-cart text-xs"></i>
                                        </a>
                                        <?php elseif($request->status === 'approved' && !$request->purchase_id): ?>
                                        <a href="<?php echo e(route('admin.transaksi.purchases.create', [
                                            'from_item_request' => $request->id,
                                            'item_type' => $request->item_type,
                                            'item_name' => $request->item_name_display,
                                            'quantity' => $request->quantity,
                                            'unit' => $request->unit,
                                            'estimated_price' => $request->estimated_price,
                                            'material_id' => $request->material_id,
                                            'sparepart_id' => $request->sparepart_id,
                                        ])); ?>" 
                                           class="w-8 h-8 bg-blue-500 hover:bg-blue-600 text-white rounded-lg flex items-center justify-center transition-colors" 
                                           title="Buat Pembelian">
                                            <i class="fas fa-shopping-cart text-xs"></i>
                                        </a>
                                        <?php elseif($request->status === 'purchased' && $request->purchase_id): ?>
                                        <form action="<?php echo e(route('admin.productions.send-item-request', [$production, $request])); ?>" method="POST" class="inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="px-3 py-1.5 bg-green-500 hover:bg-green-600 text-white text-xs font-medium rounded-lg transition-colors flex items-center gap-1" title="Kirim Item ke Teknisi">
                                                <i class="fas fa-paper-plane text-xs"></i>
                                                <span>Kirim</span>
                                            </button>
                                        </form>
                                        <?php elseif($request->status === 'sent'): ?>
                                        <span class="px-3 py-1.5 bg-indigo-100 dark:bg-indigo-900/40 text-indigo-700 dark:text-indigo-300 text-xs font-medium rounded-lg flex items-center gap-1" title="Item sudah dikirim, menunggu konfirmasi teknisi">
                                            <i class="fas fa-hourglass-half text-xs animate-pulse"></i>
                                            <span>Menunggu Konfirmasi</span>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    
    
    
    <?php
        $hasUnsentMaterials = $production->productionMaterials->where('is_admin_suggested', true)->whereNull('sent_to_teknisi_at')->count() > 0;
        $hasUnsentSpareparts = $production->productionSpareparts->where('is_admin_suggested', true)->whereNull('sent_to_teknisi_at')->count() > 0;
        $hasUnsentItems = $hasUnsentMaterials || $hasUnsentSpareparts;
    ?>
    
    <?php if(!in_array($production->status, ['selesai', 'dibatalkan']) && (!$production->teknisi_id || $production->planning_status === 'planning')): ?>
    <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-5 mb-6">
        <div class="flex items-start gap-3 mb-4">
            <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                <i class="fas fa-info-circle text-blue-600 dark:text-blue-400 text-sm"></i>
            </div>
            <div class="flex-1">
                <h3 class="text-base font-semibold text-gray-900 dark:text-white mb-1">Input Bahan & Sparepart Suggested</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400">Admin bisa input bahan dan sparepart sebagai "suggested" untuk teknisi.</p>
            </div>
        </div>

        <form action="<?php echo e(route('admin.productions.suggest-materials-spareparts', $production)); ?>" method="POST" class="space-y-4">
            <?php echo csrf_field(); ?>
            
            <!-- Materials Section -->
            <div class="mb-4">
                <h4 class="text-sm font-semibold text-gray-800 dark:text-white mb-3">Bahan Suggested</h4>
                <div id="suggestedMaterialsContainer" class="space-y-3">
                    <div class="suggested-material-row bg-white dark:bg-gray-800 p-3 rounded-lg border border-gray-200 dark:border-gray-600">
                        <div class="grid grid-cols-1 md:grid-cols-5 gap-3">
                            <div>
                                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Bahan</label>
                                <select name="production_materials[0][material_id]" class="suggested-material-select w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white">
                                    <option value="">-- Pilih Bahan --</option>
                                    <?php $__currentLoopData = \App\Models\Material::where('is_active', true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $material): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($material->id); ?>" data-price="<?php echo e($material->price); ?>" data-unit="<?php echo e($material->unit); ?>"><?php echo e($material->name); ?> (Stock: <?php echo e($material->stock); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Qty</label>
                                <input type="number" name="production_materials[0][quantity]" min="0" step="0.01" class="w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" value="0">
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Unit</label>
                                <input type="text" name="production_materials[0][unit]" class="suggested-material-unit w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" placeholder="kg">
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Harga/Unit</label>
                                <input type="number" name="production_materials[0][unit_cost]" min="0" class="suggested-material-cost w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" placeholder="0">
                            </div>
                            <div class="flex items-end">
                                <button type="button" onclick="this.closest('.suggested-material-row').remove()" class="w-full bg-red-500 hover:bg-red-600 text-white text-xs font-semibold px-3 py-2 rounded-lg">
                                    <i class="fas fa-trash mr-1"></i>Hapus
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" id="addSuggestedMaterialBtn" class="mt-2 bg-blue-500 hover:bg-blue-600 text-white text-xs font-semibold px-4 py-2 rounded-lg">
                    <i class="fas fa-plus mr-1"></i>Tambah Bahan
                </button>
            </div>

            <!-- Spareparts Section -->
            <div class="mb-4">
                <h4 class="text-sm font-semibold text-gray-800 dark:text-white mb-3">Sparepart Suggested</h4>
                <div id="suggestedSparepartsContainer" class="space-y-3">
                    <div class="suggested-sparepart-row bg-white dark:bg-gray-800 p-3 rounded-lg border border-gray-200 dark:border-gray-600">
                        <div class="grid grid-cols-1 md:grid-cols-5 gap-3">
                            <div>
                                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Sparepart</label>
                                <select name="production_spareparts[0][sparepart_id]" class="suggested-sparepart-select w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white">
                                    <option value="">-- Pilih Sparepart --</option>
                                    <?php $__currentLoopData = \App\Models\Sparepart::where('is_active', true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sparepart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($sparepart->id); ?>" data-price="<?php echo e($sparepart->price); ?>" data-unit="<?php echo e($sparepart->unit); ?>"><?php echo e($sparepart->name); ?> (Stock: <?php echo e($sparepart->stock); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Qty</label>
                                <input type="number" name="production_spareparts[0][quantity]" min="0" step="0.01" class="w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" value="0">
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Unit</label>
                                <input type="text" name="production_spareparts[0][unit]" class="suggested-sparepart-unit w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" placeholder="pcs">
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Harga/Unit</label>
                                <input type="number" name="production_spareparts[0][unit_cost]" min="0" class="suggested-sparepart-cost w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" placeholder="0">
                            </div>
                            <div class="flex items-end">
                                <button type="button" onclick="this.closest('.suggested-sparepart-row').remove()" class="w-full bg-red-500 hover:bg-red-600 text-white text-xs font-semibold px-3 py-2 rounded-lg">
                                    <i class="fas fa-trash mr-1"></i>Hapus
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" id="addSuggestedSparepartBtn" class="mt-2 bg-purple-500 hover:bg-purple-600 text-white text-xs font-semibold px-4 py-2 rounded-lg">
                    <i class="fas fa-plus mr-1"></i>Tambah Sparepart
                </button>
            </div>

            <div class="flex items-center justify-end gap-3 pt-4 border-t border-blue-200 dark:border-blue-800">
                <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white font-medium px-6 py-2 rounded-lg transition-colors duration-200">
                    <i class="fas fa-save mr-2"></i>Simpan sebagai Suggested
                </button>
            </div>
        </form>
        
        <?php if($production->teknisi_id && $hasUnsentItems): ?>
        <div class="mt-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg p-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg">
                        <i class="fas fa-paper-plane text-green-600 dark:text-green-400 text-sm"></i>
                    </div>
                    <p class="text-sm font-semibold text-gray-900 dark:text-white">Ada item yang belum dikirim ke teknisi</p>
                </div>
                <form action="<?php echo e(route('admin.productions.send-to-teknisi', $production)); ?>" method="POST" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="bg-green-500 hover:bg-green-600 text-white font-medium px-6 py-2 rounded-lg transition-colors duration-200">
                        <i class="fas fa-paper-plane mr-2"></i>Kirim ke Teknisi
                    </button>
                </form>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <!-- Tabel Bahan & Sparepart -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 mb-6">
        <div class="px-5 py-4 border-b border-gray-200 dark:border-gray-700">
            <div class="flex items-center gap-3">
                <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg">
                    <i class="fas fa-boxes text-indigo-600 dark:text-indigo-400 text-sm"></i>
                </div>
                <div>
                    <h3 class="text-base font-semibold text-gray-900 dark:text-white">Daftar Bahan & Sparepart</h3>
                    <p class="text-xs text-gray-500 dark:text-gray-400"><?php echo e($production->productionMaterials->count() + $production->productionSpareparts->count()); ?> item  <?php echo e($orderQty); ?> unit produk</p>
                </div>
            </div>
        </div>

        <?php
            $allItems = collect();
            $orderQty = $production->quantity ?? $production->order->quantity ?? 1;
            
            foreach($production->productionMaterials as $pm) {
                $totalNeeded = $pm->quantity * $orderQty;
                $currentStock = $pm->material->stock ?? 0;
                $stockStatus = 'available';
                $stockStatusLabel = 'Tersedia/Jumlah Mencukupi';
                $stockStatusClass = 'bg-green-100 text-green-700';
                $stockStatusIcon = 'check-circle';
                
                if ($currentStock < $totalNeeded) {
                    if ($currentStock == 0) {
                        $stockStatus = 'pending_purchase';
                        $stockStatusLabel = 'Perlu Pembelian';
                        $stockStatusClass = 'bg-red-100 text-red-700';
                        $stockStatusIcon = 'times-circle';
                    } else {
                        $stockStatus = 'insufficient';
                        $stockStatusLabel = 'Perlu Pembelian (Kurang)';
                        $stockStatusClass = 'bg-amber-100 text-amber-700';
                        $stockStatusIcon = 'exclamation-triangle';
                    }
                }
                
                $allItems->push([
                    'id' => $pm->id,
                    'item_id' => $pm->material_id,
                    'type' => 'material',
                    'name' => $pm->material->name ?? 'N/A',
                    'quantity' => $pm->quantity,
                    'unit' => $pm->unit,
                    'unit_cost' => $pm->unit_cost,
                    'total_cost' => $pm->total_cost,
                    'stock' => $currentStock,
                    'total_needed' => $totalNeeded,
                    'stock_ok' => $currentStock >= $totalNeeded,
                    'stock_status' => $stockStatus,
                    'stock_status_label' => $stockStatusLabel,
                    'stock_status_class' => $stockStatusClass,
                    'stock_status_icon' => $stockStatusIcon,
                    'is_received' => $pm->is_received ?? false,
                ]);
            }
            foreach($production->productionSpareparts as $ps) {
                $totalNeeded = $ps->quantity * $orderQty;
                $currentStock = $ps->sparepart->stock ?? 0;
                $stockStatus = 'available';
                $stockStatusLabel = 'Tersedia/Jumlah Mencukupi';
                $stockStatusClass = 'bg-green-100 text-green-700';
                $stockStatusIcon = 'check-circle';
                
                if ($currentStock < $totalNeeded) {
                    if ($currentStock == 0) {
                        $stockStatus = 'pending_purchase';
                        $stockStatusLabel = 'Perlu Pembelian';
                        $stockStatusClass = 'bg-red-100 text-red-700';
                        $stockStatusIcon = 'times-circle';
                    } else {
                        $stockStatus = 'insufficient';
                        $stockStatusLabel = 'Perlu Pembelian (Kurang)';
                        $stockStatusClass = 'bg-amber-100 text-amber-700';
                        $stockStatusIcon = 'exclamation-triangle';
                    }
                }
                
                $allItems->push([
                    'id' => $ps->id,
                    'item_id' => $ps->sparepart_id,
                    'type' => 'sparepart',
                    'name' => $ps->sparepart->name ?? 'N/A',
                    'quantity' => $ps->quantity,
                    'unit' => $ps->unit,
                    'unit_cost' => $ps->unit_cost,
                    'total_cost' => $ps->total_cost,
                    'stock' => $currentStock,
                    'total_needed' => $totalNeeded,
                    'stock_ok' => $currentStock >= $totalNeeded,
                    'stock_status' => $stockStatus,
                    'stock_status_label' => $stockStatusLabel,
                    'stock_status_class' => $stockStatusClass,
                    'stock_status_icon' => $stockStatusIcon,
                    'is_received' => $ps->is_received ?? false,
                ]);
            }
            $receivedCount = $allItems->where('is_received', true)->count();
            $totalItems = $allItems->count();
        ?>
        
        <?php if($allItems->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-600">
                    <tr>
                        <th class="px-4 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Nama Item</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Tipe</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Jumlah</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Satuan</th>
                        <th class="px-4 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Harga/Unit</th>
                        <th class="px-4 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Total</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Stok</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Status Ketersediaan</th>
                        <?php if($production->planning_status === 'approved'): ?>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase">Diterima</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__currentLoopData = $allItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-blue-50/50 dark:hover:bg-gray-700/80 transition-colors duration-200">
                        <td class="px-4 py-3.5">
                            <span class="font-medium text-gray-900 dark:text-white text-sm"><?php echo e($item['name']); ?></span>
                        </td>
                        <td class="px-4 py-3.5 text-center">
                            <?php if($item['type'] === 'material'): ?>
                            <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-emerald-100 dark:bg-emerald-900/40 text-emerald-700 dark:text-emerald-300">
                                <i class="fas fa-cube text-xs"></i> Bahan
                            </span>
                            <?php else: ?>
                            <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300">
                                <i class="fas fa-cog text-xs"></i> Sparepart
                            </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3.5 text-center font-medium text-gray-900 dark:text-white text-sm"><?php echo e($item['quantity']); ?></td>
                        <td class="px-4 py-3.5 text-center text-gray-600 dark:text-gray-400 text-sm"><?php echo e($item['unit']); ?></td>
                        <td class="px-4 py-3.5 text-right text-gray-600 dark:text-gray-400 text-sm">Rp <?php echo e(number_format($item['unit_cost'], 0, ',', '.')); ?></td>
                        <td class="px-4 py-3.5 text-right font-semibold text-gray-900 dark:text-white text-sm">Rp <?php echo e(number_format($item['total_cost'], 0, ',', '.')); ?></td>
                        <td class="px-4 py-3.5 text-center">
                            <div class="flex flex-col items-center gap-1">
                                <span class="text-sm font-medium text-gray-900 dark:text-white"><?php echo e($item['stock']); ?></span>
                                <span class="text-xs text-gray-500">Butuh: <?php echo e($item['total_needed']); ?></span>
                            </div>
                        </td>
                        <td class="px-4 py-3.5 text-center">
                            <span class="inline-flex items-center gap-1 px-2.5 py-1 text-xs font-semibold rounded-md <?php echo e($item['stock_status_class']); ?>">
                                <i class="fas fa-<?php echo e($item['stock_status_icon']); ?> text-xs"></i>
                                <?php echo e($item['stock_status_label']); ?>

                            </span>
                            <?php if($item['stock_status'] !== 'available'): ?>
                            <div class="mt-1 text-[10px] text-gray-500">
                                <?php if($item['stock_status'] === 'insufficient'): ?>
                                Kurang: <?php echo e($item['total_needed'] - $item['stock']); ?> <?php echo e($item['unit']); ?>

                                <?php else: ?>
                                Stok: 0
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                        </td>
                        <?php if($production->planning_status === 'approved'): ?>
                        <td class="px-4 py-3.5 text-center">
                            <?php if($item['is_received']): ?>
                            <span class="inline-flex items-center gap-1 px-2.5 py-1 text-xs font-medium rounded-md bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300">
                                <i class="fas fa-check-circle text-xs"></i> Ya
                            </span>
                            <?php else: ?>
                            <span class="inline-flex items-center gap-1 px-2.5 py-1 text-xs font-medium rounded-md bg-amber-100 dark:bg-amber-900/40 text-amber-700 dark:text-amber-300">
                                <i class="fas fa-clock text-xs"></i> Belum
                            </span>
                            <?php endif; ?>
                        </td>
                        <?php endif; ?>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot class="bg-gray-50 dark:bg-gray-700/50 border-t border-gray-200 dark:border-gray-600">
                    <tr>
                        <td colspan="5" class="px-4 py-3.5">
                            <div class="flex flex-wrap items-center gap-3 text-sm">
                                <span class="inline-flex items-center gap-1.5 text-emerald-700 dark:text-emerald-300">
                                    <i class="fas fa-cube text-xs"></i> Bahan: Rp <?php echo e(number_format($materialTotal, 0, ',', '.')); ?>

                                </span>
                                <span class="inline-flex items-center gap-1.5 text-blue-700 dark:text-blue-300">
                                    <i class="fas fa-cog text-xs"></i> Sparepart: Rp <?php echo e(number_format($sparepartTotal, 0, ',', '.')); ?>

                                </span>
                                <?php
                                    $insufficientStock = $allItems->filter(fn($i) => !$i['stock_ok'])->count();
                                ?>
                                <?php if($insufficientStock > 0): ?>
                                <span class="inline-flex items-center gap-1.5 text-red-600 dark:text-red-400 font-medium">
                                    <i class="fas fa-exclamation-triangle text-xs"></i> <?php echo e($insufficientStock); ?> item perlu pembelian
                                </span>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="px-4 py-3.5 text-right font-bold text-gray-900 dark:text-white">
                            Total: Rp <?php echo e(number_format($directTotal, 0, ',', '.')); ?>

                        </td>
                        <td></td>
                        <td></td>
                        <?php if($production->planning_status === 'approved'): ?>
                        <td class="px-4 py-3.5 text-center">
                            <span class="inline-flex items-center gap-1 px-2.5 py-1 text-xs font-semibold rounded-md <?php echo e($receivedCount == $totalItems ? 'bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300' : 'bg-amber-100 dark:bg-amber-900/40 text-amber-700 dark:text-amber-300'); ?>">
                                <?php echo e($receivedCount); ?>/<?php echo e($totalItems); ?>

                            </span>
                        </td>
                        <?php endif; ?>
                    </tr>
                </tfoot>
                </table>
            </div>
        <?php else: ?>
        <div class="p-12 text-center">
            <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-inbox text-2xl text-gray-400 dark:text-gray-500"></i>
            </div>
            <p class="text-gray-500 dark:text-gray-400 font-medium">Belum ada bahan atau sparepart ditambahkan</p>
            <p class="text-sm text-gray-400 dark:text-gray-500 mt-1">Teknisi akan menginput bahan dan sparepart setelah ditugaskan</p>
        </div>
        <?php endif; ?>
    </div>

    <!-- Cost Summary -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
        <?php if($laborTotal > 0): ?>
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="p-2 bg-orange-100 dark:bg-orange-900/40 rounded-lg">
                        <i class="fas fa-users text-orange-600 dark:text-orange-400 text-sm"></i>
                    </div>
                    <div>
                        <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Biaya Tenaga Kerja</h3>
                        <p class="text-xs text-gray-500 dark:text-gray-400">Upah untuk <?php echo e($orderQty); ?> unit</p>
                    </div>
                </div>
                <div class="text-right">
                    <p class="text-lg font-bold text-orange-600 dark:text-orange-400">Rp <?php echo e(number_format($laborTotal, 0, ',', '.')); ?></p>
                    <p class="text-xs text-gray-500 dark:text-gray-400">Per unit: Rp <?php echo e(number_format($laborTotal / max($orderQty, 1), 0, ',', '.')); ?></p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Total Cost Summary -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg">
                        <i class="fas fa-calculator text-indigo-600 dark:text-indigo-400 text-sm"></i>
                    </div>
                    <div>
                        <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Total Biaya Produksi</h3>
                        <p class="text-xs text-gray-500 dark:text-gray-400">
                            Langsung: Rp <?php echo e(number_format($directTotal, 0, ',', '.')); ?>

                            <?php if($laborTotal > 0): ?>
                                 Labor: Rp <?php echo e(number_format($laborTotal, 0, ',', '.')); ?>

                            <?php endif; ?>
                        </p>
                    </div>
                </div>
                <div class="text-right">
                    <p class="text-lg font-bold text-indigo-600 dark:text-indigo-400">Rp <?php echo e(number_format($actualTotal, 0, ',', '.')); ?></p>
                    <p class="text-xs text-gray-500 dark:text-gray-400">Per unit: Rp <?php echo e(number_format($actualTotal / max($orderQty, 1), 0, ',', '.')); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Catatan Produksi (Inline Edit) -->
    <?php if(!in_array($production->status, ['selesai', 'dibatalkan'])): ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-base font-semibold text-gray-800 dark:text-white flex items-center gap-2">
                <i class="fas fa-sticky-note text-amber-600 dark:text-amber-400"></i> Catatan Produksi
            </h3>
            <button type="button" onclick="toggleNotesEdit()" id="editNotesBtn"
                class="inline-flex items-center px-3 py-1.5 text-sm font-medium rounded-md bg-blue-500 hover:bg-blue-600 text-white transition-colors duration-200">
                <i class="fas fa-edit mr-1.5"></i>
                <span id="editNotesBtnText"><?php echo e($production->notes ? 'Edit Catatan' : 'Tambah Catatan'); ?></span>
            </button>
        </div>

        <!-- Display Notes -->
        <div id="notesDisplay" class="<?php echo e($production->notes ? '' : 'hidden'); ?>">
            <?php if($production->notes): ?>
                <div class="bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-800 rounded-lg p-4">
                    <p class="text-sm text-amber-800 dark:text-amber-200 whitespace-pre-wrap"><?php echo e($production->notes); ?></p>
                </div>
            <?php else: ?>
                <p class="text-sm text-gray-500 dark:text-gray-400 italic">Belum ada catatan</p>
            <?php endif; ?>
        </div>

        <!-- Edit Form -->
        <form id="notesEditForm" action="<?php echo e(route('admin.productions.update', $production->id)); ?>" method="POST" class="hidden">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="space-y-3">
                <textarea name="notes" id="notesInput" rows="4"
                    class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200"
                    placeholder="Tambahkan catatan untuk teknisi..."><?php echo e($production->notes ?? ''); ?></textarea>
                <div class="flex items-center gap-2">
                    <button type="submit"
                        class="inline-flex items-center px-4 py-2 text-sm font-medium rounded-md bg-blue-500 hover:bg-blue-600 text-white transition-colors duration-200">
                        <i class="fas fa-save mr-1.5"></i> Simpan
                    </button>
                    <button type="button" onclick="cancelNotesEdit()"
                        class="inline-flex items-center px-4 py-2 text-sm font-medium rounded-md bg-gray-200 hover:bg-gray-300 dark:bg-gray-600 dark:hover:bg-gray-700 text-gray-700 dark:text-gray-300 transition-colors duration-200">
                        <i class="fas fa-times mr-1.5"></i> Batal
                    </button>
                </div>
            </div>
        </form>
    </div>
    <?php else: ?>
        <?php if($production->notes): ?>
        <div class="bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-800 rounded-lg p-4">
            <h3 class="text-sm font-semibold text-amber-800 dark:text-amber-200 mb-2 flex items-center gap-2">
                <i class="fas fa-sticky-note text-amber-600 dark:text-amber-400"></i> Catatan Produksi
            </h3>
            <p class="text-sm text-amber-700 dark:text-amber-300 whitespace-pre-wrap"><?php echo e($production->notes); ?></p>
        </div>
        <?php endif; ?>
    <?php endif; ?>


    <script>
        // Toggle Notes Edit
        function toggleNotesEdit() {
            const display = document.getElementById('notesDisplay');
            const form = document.getElementById('notesEditForm');
            const btn = document.getElementById('editNotesBtn');
            const btnText = document.getElementById('editNotesBtnText');
            
            if (display && form && btn) {
                display.classList.add('hidden');
                form.classList.remove('hidden');
                btn.classList.add('hidden');
                const textarea = document.getElementById('notesInput');
                if (textarea) {
                    textarea.focus();
                    // Set cursor to end
                    textarea.setSelectionRange(textarea.value.length, textarea.value.length);
                }
            }
        }

        function cancelNotesEdit() {
            const display = document.getElementById('notesDisplay');
            const form = document.getElementById('notesEditForm');
            const btn = document.getElementById('editNotesBtn');
            
            if (display && form && btn) {
                display.classList.remove('hidden');
                form.classList.add('hidden');
                btn.classList.remove('hidden');
                // Reset textarea to original value
                const originalNotes = <?php echo json_encode($production->notes ?? '', 15, 512) ?>;
                const textarea = document.getElementById('notesInput');
                if (textarea) {
                    textarea.value = originalNotes;
                }
            }
        }

        // Update notes display after successful save (if redirected back)
        document.addEventListener('DOMContentLoaded', function() {
            <?php if(session('success') && str_contains(session('success'), 'Catatan')): ?>
                // If notes were just updated, refresh the display
                const notesDisplay = document.getElementById('notesDisplay');
                const notesInput = document.getElementById('notesInput');
                if (notesDisplay && notesInput) {
                    const newNotes = notesInput.value;
                    if (newNotes.trim()) {
                        notesDisplay.innerHTML = `
                            <div class="bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-800 rounded-lg p-4">
                                <p class="text-sm text-amber-800 dark:text-amber-200 whitespace-pre-wrap">${newNotes}</p>
                            </div>
                        `;
                        notesDisplay.classList.remove('hidden');
                        // Update button text
                        const btnText = document.getElementById('editNotesBtnText');
                        if (btnText) btnText.textContent = 'Edit Catatan';
                    } else {
                        notesDisplay.innerHTML = '<p class="text-sm text-gray-500 dark:text-gray-400 italic">Belum ada catatan</p>';
                        notesDisplay.classList.remove('hidden');
                        // Update button text
                        const btnText = document.getElementById('editNotesBtnText');
                        if (btnText) btnText.textContent = 'Tambah Catatan';
                    }
                }
            <?php endif; ?>
        });

        let suggestedMaterialIndex = 1;
        let suggestedSparepartIndex = 1;

        document.addEventListener('change', function(e) {
            if (e.target.classList.contains('suggested-material-select')) {
                const row = e.target.closest('.suggested-material-row');
                const selectedOption = e.target.options[e.target.selectedIndex];
                if (selectedOption && selectedOption.value) {
                    const unitInput = row.querySelector('.suggested-material-unit');
                    const costInput = row.querySelector('.suggested-material-cost');
                    if (unitInput) unitInput.value = selectedOption.dataset.unit || '';
                    if (costInput) costInput.value = selectedOption.dataset.price || '';
                }
            }
            if (e.target.classList.contains('suggested-sparepart-select')) {
                const row = e.target.closest('.suggested-sparepart-row');
                const selectedOption = e.target.options[e.target.selectedIndex];
                if (selectedOption && selectedOption.value) {
                    const unitInput = row.querySelector('.suggested-sparepart-unit');
                    const costInput = row.querySelector('.suggested-sparepart-cost');
                    if (unitInput) unitInput.value = selectedOption.dataset.unit || '';
                    if (costInput) costInput.value = selectedOption.dataset.price || '';
                }
            }
        });

        document.getElementById('addSuggestedMaterialBtn')?.addEventListener('click', function() {
            const container = document.getElementById('suggestedMaterialsContainer');
            const row = document.createElement('div');
            row.className = 'suggested-material-row bg-white dark:bg-gray-700 p-3 rounded-lg border border-gray-200 dark:border-gray-600';
            row.innerHTML = `
                <div class="grid grid-cols-1 md:grid-cols-5 gap-3">
                    <div>
                        <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Bahan</label>
                        <select name="production_materials[${suggestedMaterialIndex}][material_id]" class="suggested-material-select w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white">
                            <option value="">-- Pilih Bahan --</option>
                            <?php $__currentLoopData = \App\Models\Material::where('is_active', true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $material): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($material->id); ?>" data-price="<?php echo e($material->price); ?>" data-unit="<?php echo e($material->unit); ?>"><?php echo e($material->name); ?> (Stock: <?php echo e($material->stock); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                    <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Qty</label>
                    <input type="number" name="production_materials[${suggestedMaterialIndex}][quantity]" min="0" step="0.01" class="w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" value="0">
                    </div>
                    <div>
                        <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Unit</label>
                    <input type="text" name="production_materials[${suggestedMaterialIndex}][unit]" class="suggested-material-unit w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" placeholder="kg">
                    </div>
                    <div>
                    <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Harga/Unit</label>
                    <input type="number" name="production_materials[${suggestedMaterialIndex}][unit_cost]" min="0" class="suggested-material-cost w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" placeholder="0">
                    </div>
                    <div class="flex items-end">
                    <button type="button" onclick="this.closest('.suggested-material-row').remove()" class="w-full bg-red-500 hover:bg-red-600 text-white text-xs font-semibold px-3 py-2 rounded-lg">
                            <i class="fas fa-trash mr-1"></i>Hapus
                        </button>
                    </div>
                </div>
            `;
            container.appendChild(row);
            suggestedMaterialIndex++;
        });

        document.getElementById('addSuggestedSparepartBtn')?.addEventListener('click', function() {
            const container = document.getElementById('suggestedSparepartsContainer');
            const row = document.createElement('div');
            row.className = 'suggested-sparepart-row bg-white dark:bg-gray-700 p-3 rounded-lg border border-gray-200 dark:border-gray-600';
            row.innerHTML = `
                <div class="grid grid-cols-1 md:grid-cols-5 gap-3">
                    <div>
                        <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Sparepart</label>
                        <select name="production_spareparts[${suggestedSparepartIndex}][sparepart_id]" class="suggested-sparepart-select w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white">
                            <option value="">-- Pilih Sparepart --</option>
                            <?php $__currentLoopData = \App\Models\Sparepart::where('is_active', true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sparepart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($sparepart->id); ?>" data-price="<?php echo e($sparepart->price); ?>" data-unit="<?php echo e($sparepart->unit); ?>"><?php echo e($sparepart->name); ?> (Stock: <?php echo e($sparepart->stock); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                    <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Qty</label>
                    <input type="number" name="production_spareparts[${suggestedSparepartIndex}][quantity]" min="0" step="0.01" class="w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" value="0">
                    </div>
                    <div>
                        <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Unit</label>
                    <input type="text" name="production_spareparts[${suggestedSparepartIndex}][unit]" class="suggested-sparepart-unit w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" placeholder="pcs">
                    </div>
                    <div>
                    <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Harga/Unit</label>
                    <input type="number" name="production_spareparts[${suggestedSparepartIndex}][unit_cost]" min="0" class="suggested-sparepart-cost w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-white" placeholder="0">
                    </div>
                    <div class="flex items-end">
                    <button type="button" onclick="this.closest('.suggested-sparepart-row').remove()" class="w-full bg-red-500 hover:bg-red-600 text-white text-xs font-semibold px-3 py-2 rounded-lg">
                            <i class="fas fa-trash mr-1"></i>Hapus
                        </button>
                    </div>
                </div>
            `;
            container.appendChild(row);
            suggestedSparepartIndex++;
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/master/productions/show.blade.php ENDPATH**/ ?>