

<?php $__env->startSection('title', 'Detail Stock Opname'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="<?php echo e(route('admin.backoffice.stock-opname.index')); ?>"
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Detail Stock Opname</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    <?php echo e($stockOpname->opname_number); ?>

                </p>
            </div>
        </div>
        <div class="flex items-center space-x-2">
            <?php if($stockOpname->status === 'draft'): ?>
                <a href="<?php echo e(route('admin.backoffice.stock-opname.edit', $stockOpname->id)); ?>"
                    class="inline-flex items-center justify-center w-9 h-9 text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded transition-colors duration-200"
                    title="Edit">
                    <i class="fas fa-edit text-base"></i>
                </a>
                <button onclick="confirmApprove(<?php echo e($stockOpname->id); ?>, '<?php echo e($stockOpname->opname_number); ?>')"
                    class="inline-flex items-center justify-center w-9 h-9 text-green-600 dark:text-green-400 hover:text-green-700 dark:hover:text-green-300 hover:bg-green-50 dark:hover:bg-green-900/20 rounded transition-colors duration-200"
                    title="Approve">
                    <i class="fas fa-check-circle text-base"></i>
                </button>
                <button onclick="confirmDelete(<?php echo e($stockOpname->id); ?>, '<?php echo e($stockOpname->opname_number); ?>')"
                    class="inline-flex items-center justify-center w-9 h-9 text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 hover:bg-red-50 dark:hover:bg-red-900/20 rounded transition-colors duration-200"
                    title="Hapus">
                    <i class="fas fa-trash text-base"></i>
                </button>
            <?php endif; ?>
            <button onclick="window.print()"
                class="inline-flex items-center justify-center w-9 h-9 text-purple-600 dark:text-purple-400 hover:text-purple-700 dark:hover:text-purple-300 hover:bg-purple-50 dark:hover:bg-purple-900/20 rounded transition-colors duration-200"
                title="Print">
                <i class="fas fa-print text-base"></i>
            </button>
        </div>
    </div>

    <!-- Success/Error Messages -->
    <?php if(session('success')): ?>
        <div class="mb-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 px-4 py-3 rounded-lg text-sm">
            <i class="fas fa-check-circle mr-2"></i><?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="mb-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg text-sm">
            <i class="fas fa-exclamation-circle mr-2"></i><?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <!-- Hidden Forms -->
    <form id="approve-form-<?php echo e($stockOpname->id); ?>" action="<?php echo e(route('admin.backoffice.stock-opname.approve', $stockOpname->id)); ?>" method="POST" class="hidden">
        <?php echo csrf_field(); ?>
    </form>

    <form id="delete-form-<?php echo e($stockOpname->id); ?>" action="<?php echo e(route('admin.backoffice.stock-opname.destroy', $stockOpname->id)); ?>" method="POST" class="hidden">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
    </form>

    <!-- Main Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 mb-4">
        <!-- Informasi Stock Opname -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                    <i class="fas fa-info-circle text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Stock Opname</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">No. Opname:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100 font-semibold"><?php echo e($stockOpname->opname_number); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Tanggal:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($stockOpname->opname_date->format('d M Y')); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Status:</span>
                    <?php if($stockOpname->status === 'draft'): ?>
                        <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-yellow-100 dark:bg-yellow-900/40 text-yellow-700 dark:text-yellow-300">
                            <i class="fas fa-clock mr-1 text-xs"></i>Draft
                        </span>
                    <?php else: ?>
                        <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300">
                            <i class="fas fa-check-circle mr-1 text-xs"></i>Selesai
                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Ringkasan -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-purple-100 dark:bg-purple-900/40 rounded-lg mr-2">
                    <i class="fas fa-chart-bar text-purple-600 dark:text-purple-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Ringkasan</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Total Item:</span>
                    <span class="text-xs font-semibold text-gray-900 dark:text-gray-100"><?php echo e($stockOpname->items->count()); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Surplus:</span>
                    <span class="text-xs font-semibold text-green-600 dark:text-green-400">
                        <?php echo e($stockOpname->items->filter(function ($item) {
                                return $item->physical_qty > $item->system_qty;
                            })->count()); ?>

                    </span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Defisit:</span>
                    <span class="text-xs font-semibold text-red-600 dark:text-red-400">
                        <?php echo e($stockOpname->items->filter(function ($item) {
                                return $item->physical_qty < $item->system_qty;
                            })->count()); ?>

                    </span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Sesuai:</span>
                    <span class="text-xs font-semibold text-gray-900 dark:text-gray-100">
                        <?php echo e($stockOpname->items->filter(function ($item) {
                                return $item->physical_qty == $item->system_qty;
                            })->count()); ?>

                    </span>
                </div>
            </div>
        </div>

        <!-- Informasi Sistem -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center mb-3">
                <div class="p-2 bg-gray-100 dark:bg-gray-700 rounded-lg mr-2">
                    <i class="fas fa-user text-gray-600 dark:text-gray-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Informasi Sistem</h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Dibuat:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($stockOpname->created_at->format('d M Y H:i')); ?></span>
                </div>
                <div class="flex items-start">
                    <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Oleh:</span>
                    <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($stockOpname->creator->name ?? 'N/A'); ?></span>
                </div>
                <?php if($stockOpname->approved_by): ?>
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Disetujui:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($stockOpname->approver->name ?? 'N/A'); ?></span>
                    </div>
                    <div class="flex items-start">
                        <span class="text-xs font-medium text-gray-600 dark:text-gray-400 w-20 flex-shrink-0">Tanggal:</span>
                        <span class="text-xs text-gray-900 dark:text-gray-100"><?php echo e($stockOpname->approved_at->format('d M Y H:i')); ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Catatan -->
    <?php if($stockOpname->notes): ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-4 transition-colors duration-300">
        <div class="flex items-center mb-2">
            <div class="p-2 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg mr-2">
                <i class="fas fa-sticky-note text-yellow-600 dark:text-yellow-400 text-sm"></i>
            </div>
            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Catatan</h3>
        </div>
        <p class="text-sm text-gray-700 dark:text-gray-300"><?php echo e($stockOpname->notes); ?></p>
    </div>
    <?php endif; ?>

    <!-- Items Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="p-4 border-b border-gray-200 dark:border-gray-700">
            <h3 class="text-base font-semibold text-gray-800 dark:text-white flex items-center">
                <i class="fas fa-list-ul mr-2 text-blue-600 dark:text-blue-400"></i>
                Detail Item Stock Opname
            </h3>
        </div>
        <div class="overflow-x-auto custom-scrollbar">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-200">No</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-200">Tipe</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-200">Kode</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-200">Nama Item</th>
                        <th class="px-4 py-3 text-center text-xs font-semibold text-gray-700 dark:text-gray-200">Unit</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold text-gray-700 dark:text-gray-200">Stok Sistem</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold text-gray-700 dark:text-gray-200">Stok Fisik</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold text-gray-700 dark:text-gray-200">Selisih</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-200">Alasan</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-600">
                    <?php $__empty_1 = true; $__currentLoopData = $stockOpname->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $difference = $item->physical_qty - $item->system_qty;
                            $diffClass =
                                $difference > 0
                                    ? 'text-green-600 dark:text-green-300 bg-green-50 dark:bg-green-900/40'
                                    : ($difference < 0
                                        ? 'text-red-600 dark:text-red-300 bg-red-50 dark:bg-red-900/40'
                                        : 'text-gray-600 dark:text-gray-200 bg-gray-100 dark:bg-gray-700');
                        ?>
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <td class="px-4 py-3 text-xs text-gray-700 dark:text-gray-300"><?php echo e($index + 1); ?></td>
                            <td class="px-4 py-3">
                                <?php
                                    $isMaterial = str_contains($item->itemable_type, 'Material');
                                    $bgClass = $isMaterial
                                        ? 'bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300'
                                        : 'bg-purple-100 dark:bg-purple-900/40 text-purple-700 dark:text-purple-300';
                                    $icon = $isMaterial ? 'fas fa-box' : 'fas fa-cog';
                                    $label = $isMaterial ? 'Material' : 'Sparepart';
                                ?>

                                <span class="px-2 py-1 rounded text-xs font-semibold <?php echo e($bgClass); ?>">
                                    <i class="<?php echo e($icon); ?> mr-1 text-xs"></i><?php echo e($label); ?>

                                </span>
                            </td>
                            <td class="px-4 py-3 text-xs font-mono text-gray-700 dark:text-gray-300"><?php echo e($item->item_code); ?></td>
                            <td class="px-4 py-3 text-xs font-medium text-gray-800 dark:text-gray-200"><?php echo e($item->item_name); ?></td>
                            <td class="px-4 py-3 text-xs text-center text-gray-700 dark:text-gray-300">
                                <span class="bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded"><?php echo e($item->unit); ?></span>
                            </td>
                            <td class="px-4 py-3 text-xs text-right font-medium text-gray-800 dark:text-gray-200">
                                <?php echo e(number_format($item->system_qty, 0)); ?>

                            </td>
                            <td class="px-4 py-3 text-xs text-right font-medium text-gray-800 dark:text-gray-200">
                                <?php echo e(number_format($item->physical_qty, 0)); ?>

                            </td>
                            <td class="px-4 py-3 text-xs text-right font-semibold <?php echo e($diffClass); ?> rounded px-2 py-1">
                                <?php if($difference > 0): ?>
                                    <i class="fas fa-arrow-up mr-1 text-xs"></i>+<?php echo e(number_format($difference, 0)); ?>

                                <?php elseif($difference < 0): ?>
                                    <i class="fas fa-arrow-down mr-1 text-xs"></i><?php echo e(number_format($difference, 0)); ?>

                                <?php else: ?>
                                    <i class="fas fa-equals mr-1 text-xs"></i><?php echo e(number_format($difference, 0)); ?>

                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3 text-xs text-gray-700 dark:text-gray-300">
                                <?php echo e($item->reason ?: '-'); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="px-4 py-8 text-center text-gray-500 dark:text-gray-400">
                                <i class="fas fa-inbox text-3xl mb-2 opacity-50"></i>
                                <p class="text-xs">Tidak ada item</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Print Styles -->
    <style>
        @media print {
            .no-print {
                display: none !important;
            }

            body {
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }

            .container {
                max-width: 100% !important;
            }

            .shadow-lg {
                box-shadow: none !important;
            }
        }
    </style>

    <script>
        function confirmApprove(id, opnameNumber) {
            Swal.fire({
                title: 'Approve Stock Opname?',
                text: `Approve ${opnameNumber}? Stok sistem akan diupdate sesuai stok fisik!`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#10b981',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Ya, Approve!',
                cancelButtonText: 'Batal',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('approve-form-' + id).submit();
                }
            });
        }

        function confirmDelete(id, opnameNumber) {
            Swal.fire({
                title: 'Yakin ingin menghapus?',
                text: `Hapus ${opnameNumber}?`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#e3342f',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/backoffice/stock-opname/show.blade.php ENDPATH**/ ?>