<?php
    $user = Auth::user();
    $userType = $user->user_type;
    
    // Tentukan layout berdasarkan role
    if ($userType === 'admin') {
        $layout = 'layouts.admin';
    } elseif ($userType === 'supervisor') {
        $layout = 'layouts.supervisor';
    } elseif ($userType === 'teknisi') {
        $layout = 'layouts.teknisi';
    } else {
        $layout = 'layouts.main';
    }
?>



<?php $__env->startSection('title', 'Edit Profile - POLJAM TECH'); ?>

<?php $__env->startSection('content'); ?>

    <!-- Notifikasi -->
    <?php if(session('status') === 'profile-updated'): ?>
        <div x-data="{ show: true }" x-show="show" x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
            x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            x-init="setTimeout(() => show = false, 4000)"
            class="fixed top-6 left-1/2 transform -translate-x-1/2 z-50 w-[90%] sm:w-[500px] bg-green-500 text-white rounded-lg px-6 py-4 flex items-center justify-between space-x-3 shadow-lg">
            <div class="flex items-center space-x-3">
                <i class="fas fa-check-circle text-lg"></i>
                <div class="flex-1 font-medium text-sm">
                    Profile berhasil diperbarui!
                </div>
            </div>
            <button @click="show = false" class="hover:bg-white/20 rounded-full p-1 transition duration-200">
                <i class="fas fa-times"></i>
            </button>
        </div>
    <?php endif; ?>

    <?php if(session('status') === 'password-updated'): ?>
        <div x-data="{ show: true }" x-show="show" x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
            x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            x-init="setTimeout(() => show = false, 4000)"
            class="fixed top-6 left-1/2 transform -translate-x-1/2 z-50 w-[90%] sm:w-[500px] bg-green-500 text-white rounded-lg px-6 py-4 flex items-center justify-between space-x-3 shadow-lg">
            <div class="flex items-center space-x-3">
                <i class="fas fa-check-circle text-lg"></i>
                <div class="flex-1 font-medium text-sm">
                    Password berhasil diperbarui!
                </div>
            </div>
            <button @click="show = false" class="hover:bg-white/20 rounded-full p-1 transition duration-200">
                <i class="fas fa-times"></i>
            </button>
        </div>
    <?php endif; ?>

    <?php if($errors->any() && !$errors->has('current_password') && !$errors->has('password') && !$errors->has('password_confirmation')): ?>
        <div x-data="{ show: true }" x-show="show" x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
            x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            x-init="setTimeout(() => show = false, 5000)"
            class="fixed top-6 left-1/2 transform -translate-x-1/2 z-50 w-[90%] sm:w-[500px] bg-red-500 text-white rounded-lg px-6 py-4 flex items-center justify-between space-x-3 shadow-lg">
            <div class="flex items-center space-x-3">
                <i class="fas fa-exclamation-circle text-lg"></i>
                <div class="flex-1 font-medium text-sm">
                    <?php echo e($errors->first()); ?>

                </div>
            </div>
            <button @click="show = false" class="hover:bg-white/20 rounded-full p-1 transition duration-200">
                <i class="fas fa-times"></i>
            </button>
        </div>
    <?php endif; ?>

    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center gap-3">
            <!--<div class="p-2 bg-blue-100 dark:bg-blue-900/30 rounded-lg">-->
            <!--    <i class="fas fa-user-edit text-blue-600 dark:text-blue-400"></i>-->
            <!--</div>-->
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Edit Profile</h1>
                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Kelola informasi profil dan foto Anda</p>
            </div>
        </div>
    </div>

    <form method="post" action="<?php echo e(route('profile.update')); ?>" enctype="multipart/form-data" id="profileForm">
        <?php echo csrf_field(); ?>
        <?php echo method_field('patch'); ?>
        
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
            <!-- Left Column - Photo Upload -->
            <div class="lg:col-span-1">
                <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6 lg:sticky lg:top-6">
                    <div class="flex items-center gap-2 mb-6 pb-4 border-b border-gray-200 dark:border-gray-700">
                        <i class="fas fa-image text-blue-600 dark:text-blue-400"></i>
                        <h2 class="text-lg font-semibold text-gray-900 dark:text-white">Foto Profil</h2>
                    </div>
                    
                    <!-- Photo Preview -->
                    <div class="mb-6">
                        <div class="relative w-48 h-48 mx-auto group">
                            <?php if($user->photo && \Storage::disk('uploads')->exists('profiles/' . $user->photo)): ?>
                                <img id="photoPreview" 
                                     src="<?php echo e(asset('uploads/profiles/' . $user->photo)); ?>" 
                                     alt="Profile Photo" 
                                     class="w-full h-full rounded-lg object-cover border-2 border-gray-200 dark:border-gray-700 shadow-lg transition-all duration-300 group-hover:border-blue-400 dark:group-hover:border-blue-600">
                            <?php else: ?>
                                <div id="defaultAvatar" class="w-full h-full rounded-lg bg-gradient-to-br from-blue-500 via-purple-500 to-pink-500 border-2 border-gray-200 dark:border-gray-700 shadow-lg flex items-center justify-center transition-all duration-300 group-hover:border-blue-400 dark:group-hover:border-blue-600">
                                    <span class="text-white text-6xl font-bold drop-shadow-lg"><?php echo e(strtoupper(substr($user->name, 0, 1))); ?></span>
                                </div>
                                <img id="photoPreview" 
                                     src="" 
                                     alt="Profile Photo" 
                                     class="hidden w-full h-full rounded-lg object-cover border-2 border-gray-200 dark:border-gray-700 shadow-lg">
                            <?php endif; ?>
                            <div class="absolute inset-0 rounded-lg bg-black bg-opacity-0 group-hover:bg-opacity-40 transition-all duration-300 flex items-center justify-center cursor-pointer" id="photoOverlay">
                                <div class="opacity-0 group-hover:opacity-100 transition-opacity duration-300 text-center">
                                    <i class="fas fa-camera text-white text-2xl mb-2 block"></i>
                                    <span class="text-white text-sm font-medium">Klik untuk mengubah</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Upload Button -->
                    <label for="photo" class="block w-full mb-3">
                        <div class="w-full bg-blue-600 hover:bg-blue-700 text-white font-medium py-2.5 px-4 rounded-lg cursor-pointer text-center transition-colors duration-200 flex items-center justify-center">
                            <i class="fas fa-upload mr-2"></i>
                            <span>Unggah Foto</span>
                        </div>
                        <input type="file" id="photo" name="photo" accept="image/*" class="hidden" onchange="previewPhoto(this)">
                    </label>

                    <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-3">
                        <p class="text-xs text-blue-800 dark:text-blue-200 flex items-center">
                            <i class="fas fa-info-circle mr-2"></i>
                            Format: JPG, PNG, GIF (Max: 2MB)
                        </p>
                    </div>
                </div>
            </div>

            <!-- Right Column - Profile Information -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Informasi Dasar -->
                <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
                    <div class="flex items-center gap-3 mb-6 pb-4 border-b border-gray-200 dark:border-gray-700">
                        <div class="p-2 bg-blue-100 dark:bg-blue-900/30 rounded-lg">
                            <i class="fas fa-user-edit text-blue-600 dark:text-blue-400"></i>
                        </div>
                        <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Informasi Dasar</h2>
                    </div>

                    <div class="space-y-6">
                        <!-- Name -->
                        <div>
                            <label for="name" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                                <i class="fas fa-user mr-2 text-blue-600 dark:text-blue-400"></i>
                                Nama Lengkap <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <i class="fas fa-user absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                                <input type="text" 
                                       id="name" 
                                       name="name" 
                                       value="<?php echo e(old('name', $user->name)); ?>" 
                                       required 
                                       autofocus
                                       class="w-full pl-10 pr-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                            </div>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 dark:text-red-400 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-2"></i>
                                    <?php echo e($message); ?>

                                </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Email -->
                        <div>
                            <label for="email" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                                <i class="fas fa-envelope mr-2 text-blue-600 dark:text-blue-400"></i>
                                Alamat Email <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <i class="fas fa-envelope absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                                <input type="email" 
                                       id="email" 
                                       name="email" 
                                       value="<?php echo e(old('email', $user->email)); ?>" 
                                       required
                                       class="w-full pl-10 pr-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                            </div>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 dark:text-red-400 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-2"></i>
                                    <?php echo e($message); ?>

                                </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <?php if($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail()): ?>
                                <div class="mt-3 p-4 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg">
                                    <p class="text-sm text-yellow-800 dark:text-yellow-200 flex items-center">
                                        <i class="fas fa-exclamation-triangle mr-2 text-yellow-600 dark:text-yellow-400"></i>
                                        Email Anda belum terverifikasi.
                                        <button form="send-verification" class="text-blue-600 dark:text-blue-400 hover:underline font-semibold ml-1">
                                            Klik di sini untuk mengirim ulang email verifikasi.
                                        </button>
                                    </p>

                                    <?php if(session('status') === 'verification-link-sent'): ?>
                                        <p class="mt-2 text-sm text-green-600 dark:text-green-400 flex items-center">
                                            <i class="fas fa-check-circle mr-2"></i>
                                            Link verifikasi baru telah dikirim ke email Anda.
                                        </p>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Role (Read Only) -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                                <i class="fas fa-user-tag mr-2 text-blue-600 dark:text-blue-400"></i>
                                Role
                            </label>
                            <div class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-300">
                                <?php if($userType === 'admin'): ?>
                                    <span class="inline-flex items-center">
                                        <i class="fas fa-user-shield mr-2 text-blue-600"></i>
                                        <span class="font-semibold">Administrator</span>
                                    </span>
                                <?php elseif($userType === 'supervisor'): ?>
                                    <span class="inline-flex items-center">
                                        <i class="fas fa-user-tie mr-2 text-purple-600"></i>
                                        <span class="font-semibold">Supervisor</span>
                                    </span>
                                <?php elseif($userType === 'teknisi'): ?>
                                    <span class="inline-flex items-center">
                                        <i class="fas fa-user-cog mr-2 text-green-600"></i>
                                        <span class="font-semibold">Teknisi</span>
                                    </span>
                                <?php else: ?>
                                    <span class="inline-flex items-center">
                                        <i class="fas fa-user mr-2 text-gray-600"></i>
                                        <span class="font-semibold">User</span>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Informasi Kontak -->
                <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
                    <div class="flex items-center gap-3 mb-6 pb-4 border-b border-gray-200 dark:border-gray-700">
                        <div class="p-2 bg-green-100 dark:bg-green-900/30 rounded-lg">
                            <i class="fas fa-address-card text-green-600 dark:text-green-400"></i>
                        </div>
                        <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Informasi Kontak</h2>
                    </div>

                    <div class="space-y-6">
                        <!-- Phone -->
                        <div>
                            <label for="phone" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                                <i class="fas fa-phone mr-2 text-green-600 dark:text-green-400"></i>
                                Nomor Telepon
                                <span class="text-xs font-normal text-gray-500 dark:text-gray-400 ml-2">(Opsional)</span>
                            </label>
                            <div class="relative">
                                <i class="fas fa-phone absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                                <input type="tel" 
                                       id="phone" 
                                       name="phone" 
                                       value="<?php echo e(old('phone', $user->phone)); ?>" 
                                       placeholder="+6281234567890 atau 081234567890"
                                       class="w-full pl-10 pr-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                            </div>
                            <p class="mt-2 text-xs text-gray-500 dark:text-gray-400 flex items-center">
                                <i class="fas fa-info-circle mr-1"></i>
                                Format: +6281234567890 atau 081234567890
                            </p>
                            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 dark:text-red-400 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-2"></i>
                                    <?php echo e($message); ?>

                                </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Address -->
                        <div>
                            <label for="address" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                                <i class="fas fa-map-marker-alt mr-2 text-green-600 dark:text-green-400"></i>
                                Alamat Lengkap
                                <span class="text-xs font-normal text-gray-500 dark:text-gray-400 ml-2">(Opsional)</span>
                            </label>
                            <div class="relative">
                                <i class="fas fa-map-marker-alt absolute left-3 top-3 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                                <textarea id="address" 
                                          name="address" 
                                          rows="4"
                                          placeholder="Jalan, RT/RW, Kelurahan, Kecamatan, Kota, Provinsi"
                                          class="w-full pl-10 pr-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 dark:bg-gray-700 dark:text-white transition-colors duration-200 resize-none"><?php echo e(old('address', $user->address)); ?></textarea>
                            </div>
                            <p class="mt-2 text-xs text-gray-500 dark:text-gray-400 flex items-center">
                                <i class="fas fa-info-circle mr-1"></i>
                                Alamat lengkap untuk pengiriman
                            </p>
                            <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 dark:text-red-400 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-2"></i>
                                    <?php echo e($message); ?>

                                </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Postal Code -->
                        <div>
                            <label for="postal_code" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                                <i class="fas fa-mail-bulk mr-2 text-green-600 dark:text-green-400"></i>
                                Kode Pos
                                <span class="text-xs font-normal text-gray-500 dark:text-gray-400 ml-2">(Opsional)</span>
                            </label>
                            <div class="relative">
                                <i class="fas fa-mail-bulk absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                                <input type="text" 
                                       id="postal_code" 
                                       name="postal_code" 
                                       value="<?php echo e(old('postal_code', $user->postal_code)); ?>" 
                                       placeholder="12345"
                                       maxlength="5"
                                       pattern="[0-9]{5}"
                                       class="w-full pl-10 pr-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                            </div>
                            <p class="mt-2 text-xs text-gray-500 dark:text-gray-400 flex items-center">
                                <i class="fas fa-info-circle mr-1"></i>
                                Kode pos 5 digit
                            </p>
                            <?php $__errorArgs = ['postal_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 dark:text-red-400 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-2"></i>
                                    <?php echo e($message); ?>

                                </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="flex items-center justify-end gap-3 pt-4">
                    <button type="submit" 
                            class="px-6 py-2.5 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 flex items-center">
                        <i class="fas fa-save mr-2"></i>
                        Simpan Perubahan
                    </button>
                </div>
            </div>
        </div>
    </form>

    <!-- Verification Form (Hidden) -->
    <form id="send-verification" method="post" action="<?php echo e(route('verification.send')); ?>" class="hidden">
        <?php echo csrf_field(); ?>
    </form>

    <!-- Change Password Section -->
    <div class="mt-6 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
        <?php echo $__env->make('profile.partials.update-password-form-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <!-- Delete Account Section -->
    <div class="mt-6 bg-white dark:bg-gray-800 rounded-lg border-2 border-red-200 dark:border-red-800 p-6">
        <?php echo $__env->make('profile.partials.delete-user-form-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <script>
        // Handle profile form submission with loading state
        document.getElementById('profileForm')?.addEventListener('submit', function(e) {
            const form = this;
            const submitBtn = form.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            
            // Show loading state
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Menyimpan...';
            submitBtn.classList.add('opacity-75', 'cursor-not-allowed');
        });
        
        // Handle password form submission with loading state
        document.querySelector('form[action="<?php echo e(route('password.update')); ?>"]')?.addEventListener('submit', function(e) {
            const form = this;
            const submitBtn = document.getElementById('passwordSubmitBtn');
            if (submitBtn) {
                const originalText = submitBtn.innerHTML;
                
                // Show loading state
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Menyimpan...';
            }
        });
        
        function previewPhoto(input) {
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    const preview = document.getElementById('photoPreview');
                    const defaultAvatar = document.getElementById('defaultAvatar');
                    
                    // Hide default avatar if exists
                    if (defaultAvatar) {
                        defaultAvatar.classList.add('hidden');
                    }
                    
                    // Show and update preview image
                    preview.classList.remove('hidden');
                    preview.src = e.target.result;
                }
                
                reader.readAsDataURL(input.files[0]);
            }
        }

        // Photo overlay hover effect
        const photoOverlay = document.getElementById('photoOverlay');
        if (photoOverlay) {
            photoOverlay.addEventListener('click', function() {
                document.getElementById('photo').click();
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/profile/edit.blade.php ENDPATH**/ ?>