

<?php $__env->startSection('title', 'Pengaturan Sistem'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Pengaturan Sistem</h1>
        <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">Kelola pengaturan aplikasi, perusahaan, email, pembayaran,
            dan sistem</p>
    </div>

    <!-- Notifikasi Modern -->
    <?php if (isset($component)) { $__componentOriginal08a8786da7acaa0d17ad66b17276ca17 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal08a8786da7acaa0d17ad66b17276ca17 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin-notification','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-notification'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal08a8786da7acaa0d17ad66b17276ca17)): ?>
<?php $attributes = $__attributesOriginal08a8786da7acaa0d17ad66b17276ca17; ?>
<?php unset($__attributesOriginal08a8786da7acaa0d17ad66b17276ca17); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal08a8786da7acaa0d17ad66b17276ca17)): ?>
<?php $component = $__componentOriginal08a8786da7acaa0d17ad66b17276ca17; ?>
<?php unset($__componentOriginal08a8786da7acaa0d17ad66b17276ca17); ?>
<?php endif; ?>

    <!-- Tab Navigation -->
    <div class="mb-6">
        <div class="border-b border-gray-200 dark:border-gray-700">
            <nav class="-mb-px flex space-x-8 overflow-x-auto">
                <button onclick="switchTab('company')" id="tab-company"
                    class="tab-button py-2 px-1 border-b-2 font-medium text-sm transition-colors duration-200 border-blue-500 text-blue-600 dark:text-blue-400 whitespace-nowrap">
                    <i class="fas fa-building mr-2"></i>Informasi Perusahaan
                </button>
                <button onclick="switchTab('email')" id="tab-email"
                    class="tab-button py-2 px-1 border-b-2 font-medium text-sm transition-colors duration-200 border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300 whitespace-nowrap">
                    <i class="fas fa-envelope mr-2"></i>Pengaturan Email
                </button>
                <button onclick="switchTab('payment')" id="tab-payment"
                    class="tab-button py-2 px-1 border-b-2 font-medium text-sm transition-colors duration-200 border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300 whitespace-nowrap">
                    <i class="fas fa-credit-card mr-2"></i>Pembayaran
                </button>
                <button onclick="switchTab('system')" id="tab-system"
                    class="tab-button py-2 px-1 border-b-2 font-medium text-sm transition-colors duration-200 border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300 whitespace-nowrap">
                    <i class="fas fa-cog mr-2"></i>Sistem
                </button>
                <button onclick="switchTab('maintenance')" id="tab-maintenance"
                    class="tab-button py-2 px-1 border-b-2 font-medium text-sm transition-colors duration-200 border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300 whitespace-nowrap">
                    <i class="fas fa-tools mr-2"></i>Pemeliharaan
                </button>
            </nav>
        </div>
    </div>

    <!-- Tab Content -->
    <!-- Company Information Tab -->
    <div id="content-company" class="tab-content">
        <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="group" value="company">

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white mb-4 flex items-center">
                    <i class="fas fa-building mr-2 text-blue-600 dark:text-blue-400"></i>
                    Informasi Perusahaan
                </h2>

                <div class="space-y-4">
                    <!-- Company Logo -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Logo Perusahaan
                        </label>
                        <?php if(isset($companySettings['company_logo']) && $companySettings['company_logo']): ?>
                            <div class="mb-3">
                                <img src="<?php echo e(asset('uploads/' . $companySettings['company_logo'])); ?>" alt="Company Logo"
                                    class="h-20 w-auto rounded-lg border border-gray-200 dark:border-gray-600">
                            </div>
                        <?php endif; ?>
                        <input type="file" name="company_logo" accept="image/*"
                            class="block w-full text-sm text-gray-500 dark:text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 dark:file:bg-blue-900/40 dark:file:text-blue-300">
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Format: JPG, PNG, GIF, WEBP. Maksimal 2MB
                        </p>
                    </div>

                    <!-- Company Name -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Nama Perusahaan <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="company_name" value="<?php echo e($companySettings['company_name'] ?? ''); ?>"
                            class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <!-- Company Address -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Alamat Perusahaan
                        </label>
                        <textarea name="company_address" rows="3"
                            class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white"><?php echo e($companySettings['company_address'] ?? ''); ?></textarea>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Company Phone -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Telepon
                            </label>
                            <input type="text" name="company_phone" value="<?php echo e($companySettings['company_phone'] ?? ''); ?>"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- Company Email -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Email
                            </label>
                            <input type="email" name="company_email" value="<?php echo e($companySettings['company_email'] ?? ''); ?>"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <!-- Company Website -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Website
                        </label>
                        <input type="url" name="company_website" value="<?php echo e($companySettings['company_website'] ?? ''); ?>"
                            placeholder="https://example.com"
                            class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <!-- Company Description -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Deskripsi Perusahaan
                        </label>
                        <textarea name="company_description" rows="4"
                            class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white"><?php echo e($companySettings['company_description'] ?? ''); ?></textarea>
                    </div>
                </div>

                <div class="mt-6 flex justify-end">
                    <button type="submit"
                        class="px-6 py-2 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-save mr-2"></i>Simpan Perubahan
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Email Settings Tab -->
    <div id="content-email" class="tab-content hidden">
        <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="group" value="email">

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white mb-4 flex items-center">
                    <i class="fas fa-envelope mr-2 text-green-600 dark:text-green-400"></i>
                    Pengaturan Email
                </h2>

                <div class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- From Name -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Nama Pengirim
                            </label>
                            <input type="text" name="mail_from_name"
                                value="<?php echo e($emailSettings['mail_from_name'] ?? env('MAIL_FROM_NAME', 'POLJAM TECH')); ?>"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- From Address -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Email Pengirim
                            </label>
                            <input type="email" name="mail_from_address"
                                value="<?php echo e($emailSettings['mail_from_address'] ?? env('MAIL_FROM_ADDRESS', '')); ?>"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- SMTP Host -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                SMTP Host
                            </label>
                            <input type="text" name="mail_host"
                                value="<?php echo e($emailSettings['mail_host'] ?? env('MAIL_HOST', '')); ?>"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- SMTP Port -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                SMTP Port
                            </label>
                            <input type="number" name="mail_port"
                                value="<?php echo e($emailSettings['mail_port'] ?? env('MAIL_PORT', '587')); ?>"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- SMTP Username -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                SMTP Username
                            </label>
                            <input type="text" name="mail_username"
                                value="<?php echo e($emailSettings['mail_username'] ?? env('MAIL_USERNAME', '')); ?>"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- SMTP Password -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                SMTP Password
                            </label>
                            <input type="password" name="mail_password"
                                value="<?php echo e($emailSettings['mail_password'] ?? ''); ?>"
                                placeholder="Kosongkan jika tidak ingin mengubah"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <!-- Encryption -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Enkripsi
                        </label>
                        <select name="mail_encryption"
                            class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                            <option value="">Tidak Ada</option>
                            <option value="tls"
                                <?php echo e(($emailSettings['mail_encryption'] ?? env('MAIL_ENCRYPTION', '')) === 'tls' ? 'selected' : ''); ?>>
                                TLS</option>
                            <option value="ssl"
                                <?php echo e(($emailSettings['mail_encryption'] ?? env('MAIL_ENCRYPTION', '')) === 'ssl' ? 'selected' : ''); ?>>
                                SSL</option>
                        </select>
                    </div>
                </div>

                <div class="mt-6 flex justify-end">
                    <button type="submit"
                        class="px-6 py-2 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-save mr-2"></i>Simpan Perubahan
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Payment Settings Tab -->
    <div id="content-payment" class="tab-content hidden">
        <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="group" value="payment">

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white mb-4 flex items-center">
                    <i class="fas fa-credit-card mr-2 text-purple-600 dark:text-purple-400"></i>
                    Pengaturan Pembayaran
                </h2>

                <div class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Midtrans Server Key -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Midtrans Server Key
                            </label>
                            <input type="text" name="midtrans_server_key"
                                value="<?php echo e($paymentSettings['midtrans_server_key'] ?? env('MIDTRANS_SERVER_KEY', '')); ?>"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- Midtrans Client Key -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Midtrans Client Key
                            </label>
                            <input type="text" name="midtrans_client_key"
                                value="<?php echo e($paymentSettings['midtrans_client_key'] ?? env('MIDTRANS_CLIENT_KEY', '')); ?>"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <!-- Production Mode -->
                    <div>
                        <label class="flex items-center">
                            <input type="checkbox" name="midtrans_is_production" value="1"
                                <?php echo e(($paymentSettings['midtrans_is_production'] ?? '0') === '1' ? 'checked' : ''); ?>

                                class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                            <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Mode Production (Aktifkan untuk
                                transaksi real)</span>
                        </label>
                    </div>

                    <div class="border-t border-gray-200 dark:border-gray-700 pt-4 mt-4">
                        <h3 class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-3">Metode Pembayaran</h3>

                        <div class="space-y-2">
                            <label class="flex items-center">
                                <input type="checkbox" name="payment_method_bank_transfer" value="1"
                                    <?php echo e(($paymentSettings['payment_method_bank_transfer'] ?? '1') === '1' ? 'checked' : ''); ?>

                                    class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Transfer Bank</span>
                            </label>

                            <label class="flex items-center">
                                <input type="checkbox" name="payment_method_credit_card" value="1"
                                    <?php echo e(($paymentSettings['payment_method_credit_card'] ?? '1') === '1' ? 'checked' : ''); ?>

                                    class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Kartu Kredit</span>
                            </label>

                            <label class="flex items-center">
                                <input type="checkbox" name="payment_method_ewallet" value="1"
                                    <?php echo e(($paymentSettings['payment_method_ewallet'] ?? '1') === '1' ? 'checked' : ''); ?>

                                    class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">E-Wallet</span>
                            </label>
                        </div>
                    </div>
                </div>

                <div class="mt-6 flex justify-end">
                    <button type="submit"
                        class="px-6 py-2 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-save mr-2"></i>Simpan Perubahan
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- System Settings Tab -->
    <div id="content-system" class="tab-content hidden">
        <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="group" value="system">

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white mb-4 flex items-center">
                    <i class="fas fa-cog mr-2 text-indigo-600 dark:text-indigo-400"></i>
                    Pengaturan Sistem
                </h2>

                <div class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Timezone -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Timezone
                            </label>
                            <select name="timezone"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                                <option value="Asia/Jakarta"
                                    <?php echo e(($systemSettings['timezone'] ?? 'Asia/Jakarta') === 'Asia/Jakarta' ? 'selected' : ''); ?>>
                                    Asia/Jakarta (WIB)</option>
                                <option value="Asia/Makassar"
                                    <?php echo e(($systemSettings['timezone'] ?? '') === 'Asia/Makassar' ? 'selected' : ''); ?>>
                                    Asia/Makassar (WITA)</option>
                                <option value="Asia/Jayapura"
                                    <?php echo e(($systemSettings['timezone'] ?? '') === 'Asia/Jayapura' ? 'selected' : ''); ?>>
                                    Asia/Jayapura (WIT)</option>
                            </select>
                        </div>

                        <!-- Currency -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Mata Uang
                            </label>
                            <input type="text" name="currency" value="<?php echo e($systemSettings['currency'] ?? 'IDR'); ?>"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Currency Symbol -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Simbol Mata Uang
                            </label>
                            <input type="text" name="currency_symbol"
                                value="<?php echo e($systemSettings['currency_symbol'] ?? 'Rp'); ?>"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        </div>

                        <!-- Items Per Page -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Item Per Halaman
                            </label>
                            <input type="number" name="items_per_page"
                                value="<?php echo e($systemSettings['items_per_page'] ?? '10'); ?>" min="5" max="100"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                                Jumlah item yang ditampilkan per halaman di semua menu admin (5-100). Default: 10
                            </p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Date Format -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Format Tanggal
                            </label>
                            <select name="date_format"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                                <option value="d/m/Y"
                                    <?php echo e(($systemSettings['date_format'] ?? 'd/m/Y') === 'd/m/Y' ? 'selected' : ''); ?>>
                                    DD/MM/YYYY</option>
                                <option value="Y-m-d"
                                    <?php echo e(($systemSettings['date_format'] ?? '') === 'Y-m-d' ? 'selected' : ''); ?>>YYYY-MM-DD
                                </option>
                                <option value="d-m-Y"
                                    <?php echo e(($systemSettings['date_format'] ?? '') === 'd-m-Y' ? 'selected' : ''); ?>>DD-MM-YYYY
                                </option>
                            </select>
                        </div>

                        <!-- Time Format -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Format Waktu
                            </label>
                            <select name="time_format"
                                class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                                <option value="H:i"
                                    <?php echo e(($systemSettings['time_format'] ?? 'H:i') === 'H:i' ? 'selected' : ''); ?>>24 Jam
                                    (HH:MM)</option>
                                <option value="h:i A"
                                    <?php echo e(($systemSettings['time_format'] ?? '') === 'h:i A' ? 'selected' : ''); ?>>12 Jam
                                    (HH:MM AM/PM)</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="mt-6 flex justify-end">
                    <button type="submit"
                        class="px-6 py-2 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-save mr-2"></i>Simpan Perubahan
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Maintenance Mode Tab -->
    <div id="content-maintenance" class="tab-content hidden">
        <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="group" value="maintenance">

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white mb-4 flex items-center">
                    <i class="fas fa-tools mr-2 text-orange-600 dark:text-orange-400"></i>
                    Mode Pemeliharaan
                </h2>

                <?php if(isset($maintenanceSettings['maintenance_mode']) && $maintenanceSettings['maintenance_mode'] === '1'): ?>
                    <div
                        class="mb-4 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 text-yellow-800 dark:text-yellow-200 px-4 py-3 rounded-lg text-sm">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        <strong>Mode pemeliharaan sedang AKTIF!</strong> Situs akan menampilkan halaman maintenance untuk
                        semua pengunjung.
                    </div>
                <?php endif; ?>

                <div class="space-y-4">
                    <!-- Maintenance Mode Toggle -->
                    <div>
                        <label class="flex items-center">
                            <input type="checkbox" name="maintenance_mode" value="1"
                                <?php echo e(($maintenanceSettings['maintenance_mode'] ?? '0') === '1' ? 'checked' : ''); ?>

                                class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                            <span class="ml-2 text-sm font-medium text-gray-700 dark:text-gray-300">Aktifkan Mode
                                Pemeliharaan</span>
                        </label>
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                            Ketika diaktifkan, semua pengunjung (kecuali admin) akan melihat halaman maintenance.
                        </p>
                    </div>

                    <!-- Maintenance Message -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Pesan Pemeliharaan
                        </label>
                        <textarea name="maintenance_message" rows="4"
                            class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white"><?php echo e($maintenanceSettings['maintenance_message'] ?? 'Sistem sedang dalam pemeliharaan. Silakan coba lagi nanti.'); ?></textarea>
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                            Pesan ini akan ditampilkan kepada pengunjung saat mode pemeliharaan aktif.
                        </p>
                    </div>

                    <!-- Maintenance Secret (bypass) -->
                    <?php if(!empty($maintenanceSettings['maintenance_secret'])): ?>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Bypass Secret
                            </label>
                            <div class="flex items-center gap-2">
                                <input id="maintenance-secret-input" type="text" readonly
                                    value="<?php echo e(url('/') . '?secret=' . $maintenanceSettings['maintenance_secret']); ?>"
                                    class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700 text-sm text-gray-800 dark:text-white">
                                <button type="button" onclick="copyMaintenanceSecret()"
                                    class="px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white rounded-lg text-sm">
                                    <i class="fas fa-copy mr-1"></i>Salin
                                </button>
                            </div>
                            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                                Gunakan link ini untuk mengakses situs saat maintenance aktif. Link mengandung secret yang
                                hanya untuk admin.
                            </p>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="mt-6 flex justify-end">
                    <button type="submit"
                        class="px-6 py-2 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-save mr-2"></i>Simpan Perubahan
                    </button>
                </div>
            </div>
        </form>
    </div>

    <script>
        function switchTab(tabName) {
            // Hide all tab contents
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.add('hidden');
            });

            // Remove active class from all tabs
            document.querySelectorAll('.tab-button').forEach(button => {
                button.classList.remove('border-blue-500', 'text-blue-600', 'dark:text-blue-400');
                button.classList.add('border-transparent', 'text-gray-500', 'dark:text-gray-400');
            });

            // Show selected tab content
            document.getElementById('content-' + tabName).classList.remove('hidden');

            // Add active class to selected tab
            const activeTab = document.getElementById('tab-' + tabName);
            activeTab.classList.remove('border-transparent', 'text-gray-500', 'dark:text-gray-400');
            activeTab.classList.add('border-blue-500', 'text-blue-600', 'dark:text-blue-400');
        }

        function copyMaintenanceSecret() {
            const input = document.getElementById('maintenance-secret-input');
            if (!input) return;
            input.select();
            input.setSelectionRange(0, 99999);
            try {
                document.execCommand('copy');
                // Small visual feedback
                const original = event?.target?.innerHTML;
                event.target.innerHTML = '<i class="fas fa-check mr-1"></i>Disalin';
                setTimeout(() => {
                    if (event && event.target) event.target.innerHTML = original
                }, 1500);
            } catch (e) {
                alert('Gagal menyalin. Silakan salin secara manual.');
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/settings/index.blade.php ENDPATH**/ ?>