

<?php $__env->startSection('title', 'Stock Bahan - Teknisi'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800 dark:text-white mb-4">Stock Bahan</h1>
        <p class="text-gray-600 dark:text-gray-400 mb-4">Daftar bahan yang tersedia untuk produksi</p>

        <!-- Filter Section -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <form method="GET" action="<?php echo e(route('teknisi.materials.index')); ?>" id="filterForm" class="flex flex-col sm:flex-row items-end gap-3">
                <!-- Search Bar -->
                <div class="relative flex-1 w-full sm:w-auto">
                    <input type="text" name="search" id="searchInput" value="<?php echo e(request('search')); ?>" placeholder="Cari bahan..."
                        class="form-input-search" />
                    <i class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                    <?php if(request('search')): ?>
                        <button type="button" onclick="clearSearch()"
                            class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 hover:text-gray-600 dark:hover:text-gray-300">
                            <i class="fas fa-times"></i>
                        </button>
                    <?php endif; ?>
                </div>

                <!-- Stock Status Filter -->
                <div class="relative w-full sm:w-auto">
                    <select name="stock_status" id="stockStatusFilter" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Status Stok</option>
                        <option value="low" <?php echo e(request('stock_status') === 'low' ? 'selected' : ''); ?>>Stok Rendah (≤ 10)</option>
                        <option value="medium" <?php echo e(request('stock_status') === 'medium' ? 'selected' : ''); ?>>Stok Sedang (11-50)</option>
                        <option value="safe" <?php echo e(request('stock_status') === 'safe' ? 'selected' : ''); ?>>Stok Aman (> 50)</option>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <!-- Category Filter -->
                <?php if($categories->count() > 0): ?>
                <div class="relative w-full sm:w-auto">
                    <select name="category" id="categoryFilter" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Kategori</option>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category); ?>" <?php echo e(request('category') === $category ? 'selected' : ''); ?>><?php echo e($category); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>
                <?php endif; ?>
            </form>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg">
                    <i class="fas fa-cube text-indigo-600 dark:text-indigo-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Total Bahan</p>
                    <p class="text-lg font-semibold text-gray-900 dark:text-white"><?php echo e($materials->total()); ?></p>
                </div>
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg">
                    <i class="fas fa-check-circle text-green-600 dark:text-green-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Stok Aman</p>
                    <p class="text-lg font-semibold text-gray-900 dark:text-white"><?php echo e($materials->getCollection()->filter(fn($m)=>($m->stock ?? 0) > 50)->count()); ?></p>
                </div>
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <div class="p-2 bg-yellow-100 dark:bg-yellow-900/40 rounded-lg">
                    <i class="fas fa-exclamation-triangle text-yellow-600 dark:text-yellow-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Stok Rendah</p>
                    <p class="text-lg font-semibold text-gray-900 dark:text-white"><?php echo e($materials->getCollection()->filter(fn($m)=>($m->stock ?? 0) <= 10)->count()); ?></p>
                </div>
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-dollar-sign text-blue-600 dark:text-blue-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Nilai Persediaan</p>
                    <p class="text-lg font-semibold text-gray-900 dark:text-white">
                        Rp <?php echo e(number_format($materials->getCollection()->sum(fn($m)=>($m->stock ?? 0) * ($m->price ?? 0)), 0, ',', '.')); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Active Filters Info -->
    <?php if(request('search') || request('stock_status') || request('category')): ?>
        <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4">
            <div class="flex flex-wrap items-center gap-2">
                <span class="text-sm font-medium text-blue-800 dark:text-blue-200">Filter Aktif:</span>
                
                <?php if(request('search')): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-200">
                        <i class="fas fa-search mr-1"></i>
                        Pencarian: "<?php echo e(request('search')); ?>"
                        <button onclick="clearFilter('search')" class="ml-2 hover:text-blue-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                <?php endif; ?>
                
                <?php if(request('stock_status')): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-200">
                        <i class="fas fa-box mr-1"></i>
                        Stok: <?php echo e(request('stock_status') === 'low' ? 'Rendah' : (request('stock_status') === 'medium' ? 'Sedang' : 'Aman')); ?>

                        <button onclick="clearFilter('stock_status')" class="ml-2 hover:text-green-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                <?php endif; ?>
                
                <?php if(request('category')): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800 dark:bg-purple-800 dark:text-purple-200">
                        <i class="fas fa-tags mr-1"></i>
                        Kategori: <?php echo e(request('category')); ?>

                        <button onclick="clearFilter('category')" class="ml-2 hover:text-purple-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                <?php endif; ?>
                
                <button onclick="clearAllFilters()" 
                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200 hover:bg-red-200 dark:hover:bg-red-700 transition-colors">
                    <i class="fas fa-times-circle mr-1"></i>
                    Hapus Semua Filter
                </button>
            </div>
        </div>
    <?php endif; ?>

    <!-- Table Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-600">
                    <tr>
                        <th class="w-16 px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">No</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Gambar</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Kode</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Nama</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Kategori</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Stock</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Unit</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Harga</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Supplier</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Status</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">Diupdate</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $materials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $material): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-indigo-50/50 dark:hover:bg-gray-700/80 transition-colors duration-200">
                            <td class="px-4 py-4 text-sm text-gray-900 dark:text-gray-100 text-center align-middle"><?php echo e($materials->firstItem() + $loop->index); ?></td>
                            <td class="px-6 py-4 text-center align-middle">
                                <?php
                                    $imgPath = null;
                                    if ($material->image) {
                                        $imgPath = asset('uploads/materials/' . $material->image);
                                    } else {
                                        $imgPath = asset('images/no-image.png');
                                    }
                                ?>
                                <img src="<?php echo e($imgPath); ?>" alt="<?php echo e($material->name); ?>"
                                    class="w-14 h-14 object-contain rounded mx-auto" style="background: transparent;">
                            </td>
                            <td class="px-6 py-4 text-xs font-medium text-gray-500 dark:text-gray-400 align-middle"><?php echo e($material->material_code ?? '-'); ?></td>
                            <td class="px-6 py-4 text-sm font-medium text-gray-900 dark:text-gray-100 align-middle"><?php echo e($material->name); ?></td>
                            <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300 align-middle"><?php echo e($material->category ?? '-'); ?></td>
                            <td class="px-6 py-4 text-center align-middle">
                                <span class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md <?php echo e($material->stock <= 10 ? 'bg-red-100 dark:bg-red-900/40 text-red-800 dark:text-red-300' : ($material->stock <= 50 ? 'bg-yellow-100 dark:bg-yellow-900/40 text-yellow-800 dark:text-yellow-300' : 'bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-300')); ?>">
                                    <?php echo e($material->stock); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300 text-center align-middle"><?php echo e($material->unit); ?></td>
                            <td class="px-6 py-4 text-sm font-semibold text-gray-900 dark:text-gray-100 text-center align-middle">Rp <?php echo e(number_format($material->price, 0, ',', '.')); ?></td>
                            <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300 align-middle"><?php echo e($material->supplier ?? '-'); ?></td>
                            <td class="px-6 py-4 text-center align-middle">
                                <?php
                                    $badge = match(true){
                                        $material->stock <= 10 => 'bg-rose-100 text-rose-800 dark:bg-rose-900/40 dark:text-rose-200',
                                        $material->stock <= 50 => 'bg-amber-100 text-amber-800 dark:bg-amber-900/40 dark:text-amber-200',
                                        default => 'bg-emerald-100 text-emerald-800 dark:bg-emerald-900/40 dark:text-emerald-200'
                                    };
                                    $label = $material->stock <= 10 ? 'Rendah' : ($material->stock <= 50 ? 'Sedang' : 'Aman');
                                ?>
                                <span class="px-2.5 py-1 rounded-full text-xs font-medium <?php echo e($badge); ?>"><?php echo e($label); ?></span>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300 text-center align-middle"><?php echo e($material->updated_at?->format('d/m/Y H:i') ?? '-'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="11" class="px-6 py-12 text-center text-gray-500 dark:text-gray-400">
                                <i class="fas fa-box text-4xl mb-3 block text-gray-400 dark:text-gray-500"></i>
                                <p>Belum ada bahan yang tersedia</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <?php if($materials->hasPages()): ?>
        <div class="mt-6 flex justify-center">
            <?php echo e($materials->onEachSide(4)->links()); ?>

        </div>
    <?php endif; ?>

    <script>
        // Submit filter dengan parameter yang bersih
        function submitFilter() {
            const params = new URLSearchParams();
            
            // Ambil nilai dari setiap input/select
            const search = document.getElementById('searchInput')?.value?.trim() || '';
            const stockStatus = document.getElementById('stockStatusFilter')?.value || '';
            const category = document.getElementById('categoryFilter')?.value || '';
            
            // Hanya tambahkan parameter yang memiliki nilai
            if (search) {
                params.append('search', search);
            }
            if (stockStatus) {
                params.append('stock_status', stockStatus);
            }
            if (category) {
                params.append('category', category);
            }
            
            // Redirect dengan parameter yang bersih
            const url = '<?php echo e(route("teknisi.materials.index")); ?>' + (params.toString() ? '?' + params.toString() : '');
            window.location.href = url;
        }

        // Clear search only
        function clearSearch() {
            const url = new URL(window.location);
            url.searchParams.delete('search');
            window.location.href = url.toString();
        }

        // Clear individual filter
        function clearFilter(filterName) {
            const url = new URL(window.location);
            url.searchParams.delete(filterName);
            window.location.href = url.toString();
        }

        // Clear all filters
        function clearAllFilters() {
            window.location.href = '<?php echo e(route("teknisi.materials.index")); ?>';
        }

        // Submit form search dengan Enter
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            if (searchInput) {
                searchInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                        submitFilter();
                    }
                });
            }
        });
    </script>

    <style>
        /* Konsisten Style untuk semua Index Pages */
        .form-input-search,
        .form-select {
            height: 40px !important;
            min-height: 40px !important;
            max-height: 40px !important;
            box-sizing: border-box !important;
            line-height: 1.5 !important;
            padding: 0 2.5rem 0 2.5rem !important;
            margin: 0 !important;
        }
        
        .form-input-search {
            width: 100%;
            padding-left: 2.5rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            transition: all 0.2s;
        }
        
        .dark .form-input-search {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-input-search:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
        
        .form-select {
            width: 100%;
            padding-left: 1rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            transition: all 0.2s;
        }
        
        .dark .form-select {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }
        
        .form-select:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.teknisi', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/teknisi/materials/index.blade.php ENDPATH**/ ?>