

<?php $__env->startSection('title', 'Clear Cache - POLJAM TECH'); ?>

<?php $__env->startSection('content'); ?>
    <div class="flex items-center justify-center min-h-[calc(100vh-200px)]">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 shadow-lg max-w-2xl w-full mx-4 p-8">
            <div class="text-center mb-8">
                <div class="inline-flex items-center justify-center w-16 h-16 bg-blue-100 dark:bg-blue-900/40 rounded-full mb-4">
                    <i class="fas fa-broom text-3xl text-blue-600 dark:text-blue-400"></i>
                </div>
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white mb-2">Clear Cache Laravel</h1>
                <p class="text-gray-600 dark:text-gray-400">POLJAM TECH - Admin Cache Management</p>
            </div>

            <?php if(auth()->check()): ?>
                <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4 mb-6">
                    <p class="text-sm text-blue-800 dark:text-blue-300">
                        <i class="fas fa-user-circle mr-2"></i>
                        <strong>Login sebagai:</strong> <?php echo e(auth()->user()->email); ?> (<?php echo e(auth()->user()->user_type); ?>)
                    </p>
                </div>
            <?php endif; ?>

            <div class="bg-gray-50 dark:bg-gray-700/50 rounded-lg p-6 mb-6">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white mb-4">Hasil Clear Cache:</h2>
                
                <?php if(count($results) > 0): ?>
                    <div class="space-y-3 mb-4">
                        <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-center justify-between p-3 bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700">
                                <span class="text-sm font-medium text-gray-700 dark:text-gray-300"><?php echo e($result); ?></span>
                                <span class="text-green-600 dark:text-green-400">
                                    <i class="fas fa-check-circle"></i>
                                </span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>

                <?php if(count($errors) > 0): ?>
                    <div class="space-y-3">
                        <h3 class="text-sm font-semibold text-red-600 dark:text-red-400 mb-2">Error:</h3>
                        <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-center justify-between p-3 bg-red-50 dark:bg-red-900/20 rounded-lg border border-red-200 dark:border-red-800">
                                <span class="text-sm font-medium text-red-700 dark:text-red-300"><?php echo e($error); ?></span>
                                <span class="text-red-600 dark:text-red-400">
                                    <i class="fas fa-exclamation-circle"></i>
                                </span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>

                <?php if(count($results) === 0 && count($errors) === 0): ?>
                    <p class="text-gray-500 dark:text-gray-400 text-sm">Tidak ada operasi yang dilakukan.</p>
                <?php endif; ?>
            </div>

            <?php if(!$hasError && count($results) > 0): ?>
                <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-4 mb-6">
                    <p class="text-sm text-yellow-800 dark:text-yellow-300">
                        <i class="fas fa-info-circle mr-2"></i>
                        <strong>Peringatan Keamanan:</strong> Halaman ini hanya bisa diakses oleh admin yang sudah login.
                    </p>
                </div>
            <?php endif; ?>

            <div class="flex flex-col sm:flex-row gap-3 justify-center">
                <a href="<?php echo e(route('admin.clear-cache')); ?>" class="inline-flex items-center justify-center px-6 py-3 bg-blue-500 hover:bg-blue-600 text-white font-medium rounded-lg transition-colors duration-200">
                    <i class="fas fa-redo mr-2"></i>
                    Clear Cache Lagi
                </a>
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="inline-flex items-center justify-center px-6 py-3 bg-gray-500 hover:bg-gray-600 text-white font-medium rounded-lg transition-colors duration-200">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Kembali ke Dashboard
                </a>
            </div>

            <p class="text-center text-gray-500 dark:text-gray-400 text-xs mt-6">
                Waktu: <?php echo e(now()->format('d M Y H:i:s')); ?>

            </p>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/clear-cache.blade.php ENDPATH**/ ?>