<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bukti Pembelian - <?php echo e($purchase->purchase_code); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            font-size: 11px;
            line-height: 1.5;
            color: #000;
            background: #fff;
            margin: 0;
            padding: 0;
        }
        
        .page {
            width: 210mm;
            min-height: 297mm;
            margin: 0 auto;
            padding: 15mm;
            background: #fff;
            box-sizing: border-box;
        }
        
        .header {
            border-bottom: 3px solid #1e40af;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        
        .company-info {
            text-align: center;
            margin-bottom: 15px;
        }
        
        .company-name {
            font-size: 20px;
            font-weight: bold;
            color: #1e40af;
            margin-bottom: 5px;
        }
        
        .company-address {
            font-size: 10px;
            color: #666;
            line-height: 1.4;
        }
        
        .document-title {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            margin: 15px 0;
            color: #1e40af;
        }
        
        .document-info {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }
        
        .info-row {
            display: table-row;
        }
        
        .info-label {
            display: table-cell;
            font-weight: bold;
            width: 35%;
            padding: 5px 0;
            color: #333;
        }
        
        .info-value {
            display: table-cell;
            padding: 5px 0;
            color: #000;
        }
        
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 10px;
        }
        
        .items-table th {
            background-color: #1e40af;
            color: #fff;
            padding: 8px 5px;
            text-align: left;
            font-weight: bold;
            border: 1px solid #1e3a8a;
        }
        
        .items-table td {
            padding: 7px 5px;
            border: 1px solid #ddd;
            vertical-align: top;
        }
        
        .items-table tbody tr:nth-child(even) {
            background-color: #f9fafb;
        }
        
        .items-table tbody tr:hover {
            background-color: #f3f4f6;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .total-row {
            background-color: #f0f9ff;
            font-weight: bold;
        }
        
        .total-row td {
            border-top: 2px solid #1e40af;
            padding: 10px 5px;
            font-size: 11px;
        }
        
        .notes-section {
            margin-top: 20px;
            padding: 10px;
            background-color: #fffbeb;
            border-left: 4px solid #f59e0b;
        }
        
        .notes-title {
            font-weight: bold;
            margin-bottom: 5px;
            color: #92400e;
        }
        
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #ddd;
            font-size: 9px;
            color: #666;
            text-align: center;
        }
        
        .badge {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
        }
        
        .badge-material {
            background-color: #dcfce7;
            color: #166534;
        }
        
        .badge-sparepart {
            background-color: #dbeafe;
            color: #1e40af;
        }
        
        .page-break {
            page-break-after: always;
        }
        
        @media screen {
            body {
                background: #f5f5f5;
                padding: 20px;
            }
            
            .page {
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
            }
        }
        
        @media print {
            body {
                background: #fff;
                padding: 0;
            }
            
            .page {
                margin: 0;
                padding: 15mm;
                box-shadow: none;
            }
            
            .no-print {
                display: none;
            }
            
            @page {
                size: A4;
                margin: 0;
            }
        }
    </style>
</head>
<body>
    <div class="page">
    <!-- Header -->
    <div class="header">
        <div class="company-info">
            <div class="company-name">POLJAM TECH</div>
            <div class="company-address">
                Jl. Contoh No. 123, Kota Contoh, Provinsi Contoh<br>
                Telp: (021) 1234-5678 | Email: info@poljamtech.com
            </div>
        </div>
        <div class="document-title">BUKTI PEMBELIAN</div>
    </div>

    <!-- Document Information -->
    <div class="document-info">
        <div class="info-row">
            <div class="info-label">Kode Pembelian:</div>
            <div class="info-value"><strong><?php echo e($purchase->purchase_code); ?></strong></div>
        </div>
        <div class="info-row">
            <div class="info-label">Tanggal Pembelian:</div>
            <div class="info-value"><?php echo e(\Carbon\Carbon::parse($purchase->purchase_date)->format('d F Y')); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Supplier:</div>
            <div class="info-value"><?php echo e($purchase->supplier_name ?? 'Tidak disebutkan'); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Tipe Pembelian:</div>
            <div class="info-value">
                <span class="badge <?php echo e($purchase->purchase_type === 'material' ? 'badge-material' : 'badge-sparepart'); ?>">
                    <?php echo e($purchase->purchase_type === 'material' ? 'Material' : 'Sparepart'); ?>

                </span>
            </div>
        </div>
    </div>

    <!-- Items Table -->
    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 5%;">No</th>
                <th style="width: 40%;">Nama Item</th>
                <th style="width: 10%;" class="text-center">Unit</th>
                <th style="width: 10%;" class="text-right">Qty</th>
                <th style="width: 17.5%;" class="text-right">Harga Satuan</th>
                <th style="width: 17.5%;" class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $purchase->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $itemData = null;
                    if ($item->item_type === 'material' && $item->item_id) {
                        $itemData = \App\Models\Material::find($item->item_id);
                    } elseif ($item->item_type === 'sparepart' && $item->item_id) {
                        $itemData = \App\Models\Sparepart::find($item->item_id);
                    }
                ?>
                <tr>
                    <td class="text-center"><?php echo e($loop->iteration); ?></td>
                    <td>
                        <strong><?php echo e($item->item_name); ?></strong>
                        <br>
                        <span class="badge <?php echo e($item->item_type === 'material' ? 'badge-material' : 'badge-sparepart'); ?>">
                            <?php echo e(ucfirst($item->item_type)); ?>

                        </span>
                        <?php if($itemData): ?>
                            <br>
                            <span style="color: #666; font-size: 9px;">
                                <?php if($item->item_type === 'material'): ?>
                                    Kode: <?php echo e($itemData->material_code ?? '-'); ?>

                                    <?php if($itemData->category): ?> | Kategori: <?php echo e($itemData->category); ?> <?php endif; ?>
                                <?php else: ?>
                                    Kode: <?php echo e($itemData->part_code ?? '-'); ?>

                                    <?php if($itemData->brand): ?> | Brand: <?php echo e($itemData->brand); ?> <?php endif; ?>
                                <?php endif; ?>
                            </span>
                        <?php endif; ?>
                    </td>
                    <td class="text-center"><?php echo e($item->unit ?? '-'); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->quantity, 0, ',', '.')); ?></td>
                    <td class="text-right">Rp <?php echo e(number_format($item->unit_price, 0, ',', '.')); ?></td>
                    <td class="text-right"><strong>Rp <?php echo e(number_format($item->total_price, 0, ',', '.')); ?></strong></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="5" class="text-right" style="font-size: 12px;">TOTAL PEMBELIAN:</td>
                <td class="text-right" style="font-size: 13px; color: #1e40af;">Rp <?php echo e(number_format($purchase->total_amount, 0, ',', '.')); ?></td>
            </tr>
        </tfoot>
    </table>

    <!-- Notes Section -->
    <?php if($purchase->notes): ?>
        <div class="notes-section">
            <div class="notes-title">Catatan Pembelian:</div>
            <div><?php echo e($purchase->notes); ?></div>
        </div>
    <?php endif; ?>

    <!-- Footer -->
    <div class="footer">
        <div style="margin-bottom: 10px;">
            <strong>Dokumen ini adalah bukti resmi pencatatan pembelian barang</strong>
        </div>
        <div>
            Dicetak pada: <?php echo e(now()->format('d F Y, H:i')); ?> WIB
        </div>
        <div style="margin-top: 5px;">
            Dibuat: <?php echo e(\Carbon\Carbon::parse($purchase->created_at)->format('d F Y, H:i')); ?> WIB | 
            Diperbarui: <?php echo e(\Carbon\Carbon::parse($purchase->updated_at)->format('d F Y, H:i')); ?> WIB
        </div>
    </div>
    </div>
</body>
</html>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/transaksi/purchases/pdf.blade.php ENDPATH**/ ?>