

<?php $__env->startSection('title', 'Track Penawaran - ' . $inquiry->tracking_code); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen py-4 sm:py-6 md:py-8">
    <div class="w-full max-w-[1200px] mx-auto px-3 sm:px-4 lg:px-8">
        <!-- Header -->
        <div class="mb-4 sm:mb-6 md:mb-8">
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3 sm:gap-4">
                <div>
                    <h1 class="text-xl sm:text-2xl md:text-3xl font-bold text-gray-900">Track Penawaran Produk</h1>
                    <p class="mt-1 sm:mt-2 text-sm sm:text-base text-gray-600">Tracking Code: <span class="font-mono font-semibold text-blue-600"><?php echo e($inquiry->tracking_code); ?></span></p>
                </div>
                <a href="<?php echo e(route('all')); ?>" 
                    class="inline-flex items-center justify-center px-3 sm:px-4 py-2 text-sm sm:text-base bg-gray-200 hover:bg-gray-300 text-gray-800 rounded-lg transition-colors">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Lihat Produk
                </a>
            </div>
        </div>

        <!-- Inquiry Details -->
        <div class="bg-white rounded-xl shadow-lg p-4 sm:p-6 md:p-8">
            <!-- Status Badge -->
            <div class="mb-4 sm:mb-6" id="statusBadge">
                <?php if($inquiry->status === 'converted_to_order'): ?>
                    <span class="inline-flex items-center px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-medium bg-purple-100 text-purple-800">
                        <i class="fas fa-shopping-cart mr-1.5 sm:mr-2 text-xs sm:text-sm"></i>
                        <span class="whitespace-nowrap">Penawaran Telah Diubah Menjadi Pesanan</span>
                    </span>
                <?php elseif($inquiry->status === 'customer_accepted'): ?>
                    <span class="inline-flex items-center px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-medium bg-green-100 text-green-800">
                        <i class="fas fa-check-circle mr-1.5 sm:mr-2 text-xs sm:text-sm"></i>
                        <span class="whitespace-nowrap">Penawaran Telah Anda Setujui</span>
                    </span>
                <?php elseif($inquiry->status === 'customer_counter'): ?>
                    <span class="inline-flex items-center px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-medium bg-blue-100 text-blue-800">
                        <i class="fas fa-exchange-alt mr-1.5 sm:mr-2 text-xs sm:text-sm"></i>
                        <span class="whitespace-nowrap">Menunggu Konfirmasi Admin</span>
                    </span>
                <?php elseif($inquiry->status === 'sent_to_customer' && $inquiry->final_offer_price): ?>
                    <span class="inline-flex items-center px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-medium bg-teal-100 text-teal-800">
                        <i class="fas fa-paper-plane mr-1.5 sm:mr-2 text-xs sm:text-sm"></i>
                        <span class="whitespace-nowrap">Penawaran Final Telah Dikirim - Silakan Review</span>
                    </span>
                <?php elseif($inquiry->admin_replied_at): ?>
                    <span class="inline-flex items-center px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-medium bg-green-100 text-green-800">
                        <i class="fas fa-check-circle mr-1.5 sm:mr-2 text-xs sm:text-sm"></i>
                        <span class="whitespace-nowrap">Sudah Dibalas oleh Admin</span>
                    </span>
                <?php else: ?>
                    <span class="inline-flex items-center px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-medium bg-yellow-100 text-yellow-800">
                        <i class="fas fa-clock mr-1.5 sm:mr-2 text-xs sm:text-sm"></i>
                        <span class="whitespace-nowrap">Menunggu Respons Admin</span>
                    </span>
                <?php endif; ?>
            </div>

            <!-- Product Information -->
            <div class="mb-6 sm:mb-8">
                <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-3 sm:mb-4">Produk yang Ditanyakan</h3>
                <div class="bg-gray-50 rounded-lg p-4 sm:p-6 border border-gray-300">
                    <div class="flex flex-col md:flex-row gap-4 sm:gap-6">
                        <?php if($inquiry->product->product_image): ?>
                            <div class="w-full md:w-48 flex-shrink-0">
                                <div class="w-full border border-gray-400 rounded-lg overflow-hidden bg-white p-2">
                                    <img src="<?php echo e(asset('uploads/products/' . $inquiry->product->product_image)); ?>" 
                                         alt="<?php echo e($inquiry->product->product_title); ?>" 
                                         class="w-full h-auto max-h-64 md:max-h-48 object-contain">
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="flex-1 min-w-0">
                            <h4 class="text-lg sm:text-xl font-semibold text-gray-900 mb-2 break-words"><?php echo e($inquiry->product->product_title); ?></h4>
                            <p class="text-sm sm:text-base text-gray-600">Kategori: <?php echo e($inquiry->product->category->category_name ?? 'N/A'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Inquiry Information -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6 mb-6 sm:mb-8">
                <div>
                    <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-3 sm:mb-4">Informasi Pengirim</h3>
                    <div class="space-y-2 sm:space-y-3">
                        <div class="flex items-start sm:items-center">
                            <i class="fas fa-user text-gray-400 w-4 sm:w-5 mr-2 sm:mr-3 mt-0.5 sm:mt-0 flex-shrink-0"></i>
                            <div class="flex-1 min-w-0">
                                <span class="text-gray-600 text-sm sm:text-base">Nama:</span>
                                <span class="ml-2 font-medium text-gray-900 text-sm sm:text-base break-words"><?php echo e($inquiry->name); ?></span>
                            </div>
                        </div>
                        <div class="flex items-start sm:items-center">
                            <i class="fas fa-envelope text-gray-400 w-4 sm:w-5 mr-2 sm:mr-3 mt-0.5 sm:mt-0 flex-shrink-0"></i>
                            <div class="flex-1 min-w-0">
                                <span class="text-gray-600 text-sm sm:text-base">Email:</span>
                                <span class="ml-2 font-medium text-gray-900 text-sm sm:text-base break-all"><?php echo e($inquiry->email); ?></span>
                            </div>
                        </div>
                        <div class="flex items-start sm:items-center">
                            <i class="fas fa-phone text-gray-400 w-4 sm:w-5 mr-2 sm:mr-3 mt-0.5 sm:mt-0 flex-shrink-0"></i>
                            <div class="flex-1 min-w-0">
                                <span class="text-gray-600 text-sm sm:text-base">Telepon:</span>
                                <span class="ml-2 font-medium text-gray-900 text-sm sm:text-base break-words"><?php echo e($inquiry->phone); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div>
                    <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-3 sm:mb-4">Informasi Penawaran</h3>
                    <div class="space-y-2 sm:space-y-3">
                        <div class="flex items-start sm:items-center">
                            <i class="fas fa-calendar text-gray-400 w-4 sm:w-5 mr-2 sm:mr-3 mt-0.5 sm:mt-0 flex-shrink-0"></i>
                            <div class="flex-1 min-w-0">
                                <span class="text-gray-600 text-sm sm:text-base">Tanggal:</span>
                                <span class="ml-2 font-medium text-gray-900 text-sm sm:text-base"><?php echo e($inquiry->created_at->format('d M Y H:i')); ?></span>
                            </div>
                        </div>
                        <?php if($inquiry->admin_replied_at): ?>
                            <div class="flex items-start sm:items-center">
                                <i class="fas fa-reply text-gray-400 w-4 sm:w-5 mr-2 sm:mr-3 mt-0.5 sm:mt-0 flex-shrink-0"></i>
                                <div class="flex-1 min-w-0">
                                    <span class="text-gray-600 text-sm sm:text-base">Dibalas:</span>
                                    <span class="ml-2 font-medium text-gray-900 text-sm sm:text-base"><?php echo e($inquiry->admin_replied_at->format('d M Y H:i')); ?></span>
                                </div>
                            </div>
                            <div class="flex items-start sm:items-center">
                                <i class="fas fa-paper-plane text-gray-400 w-4 sm:w-5 mr-2 sm:mr-3 mt-0.5 sm:mt-0 flex-shrink-0"></i>
                                <div class="flex-1 min-w-0">
                                    <span class="text-gray-600 text-sm sm:text-base">Metode:</span>
                                    <span class="ml-2 font-medium text-gray-900 text-sm sm:text-base"><?php echo e(ucfirst($inquiry->reply_method)); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="border-t border-gray-200 pt-4 sm:pt-6 mb-4 sm:mb-6">
                <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-3 sm:mb-4">Pesan Penawaran</h3>
                <?php
                    $raw = $inquiry->message ?? '';
                    $lines = preg_split("/(\r\n|\n|\r)/", $raw);
                    $type = null; $addons = []; $hasAddonsLine = false;
                    if (!empty($lines)) {
                        $first = $lines[0] ?? '';
                        $second = $lines[1] ?? '';
                        if (substr($first, 0, 14) === '[REQUEST_TYPE]') { $type = trim(substr($first, 14)); }
                        if (substr($second, 0, 8) === '[ADDONS]') {
                            $hasAddonsLine = true;
                            $matches = [];
                            if (preg_match('/^\[ADDONS\]\s*(\[[\s\S]*\])$/', $second, $matches)) {
                                $decoded = json_decode($matches[1], true);
                                if (is_array($decoded)) { $addons = $decoded; }
                            }
                        }
                    }
                    $startIdx = 0; if ($type) { $startIdx++; } if ($hasAddonsLine) { $startIdx++; }
                    if (!empty($lines) && isset($lines[$startIdx]) && trim($lines[$startIdx]) === '') { $startIdx++; }
                    $plain = implode("\n", array_slice($lines, $startIdx));
                    $badgeText = $type === 'custom_addon' ? 'Custom Add-on' : ($type === 'custom_new' ? 'Custom Baru' : ($type ? 'Katalog' : null));
                    $badgeCls = $type === 'custom_addon' ? 'bg-yellow-100 text-yellow-800' : ($type === 'custom_new' ? 'bg-red-100 text-red-800' : 'bg-blue-100 text-blue-800');
                ?>
                <div class="bg-gray-50 rounded-lg p-4 sm:p-6 space-y-3 sm:space-y-4">
                    <?php if($badgeText): ?>
                        <div>
                            <span class="inline-flex items-center px-2 sm:px-3 py-1 text-xs sm:text-sm font-semibold rounded-full <?php echo e($badgeCls); ?>">
                                <i class="fas fa-tag mr-1.5 sm:mr-2 text-xs sm:text-sm"></i>
                                <?php echo e($badgeText); ?>

                            </span>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty($addons)): ?>
                        <?php
                            $preview = collect($addons)->map(function($a){
                                $name = is_array($a) ? ($a['name'] ?? '') : '';
                                $value = is_array($a) ? ($a['value'] ?? '') : '';
                                return trim(($name ?: '-') . ': ' . ($value ?: '-'));
                            })->implode("\n");
                        ?>
                        <div class="bg-white rounded-lg p-3 sm:p-4 border border-gray-200">
                            <div class="font-semibold text-sm sm:text-base text-gray-900 mb-2 sm:mb-3 flex items-center">
                                <i class="fas fa-tools mr-2 text-blue-600 text-xs sm:text-sm"></i>
                                Spesifikasi Tambahan
                            </div>
                            <pre class="text-xs sm:text-sm whitespace-pre-wrap break-words"><?php echo e($preview); ?></pre>
                        </div>
                    <?php endif; ?>
                    <div class="prose max-w-none">
                        <p class="text-sm sm:text-base text-gray-800 whitespace-pre-wrap bg-white rounded-lg p-3 sm:p-4 border border-gray-200 break-words"><?php echo e($plain); ?></p>
                    </div>
                </div>
            </div>

            <!-- Admin Reply -->
            <?php if($inquiry->admin_reply): ?>
                <div class="border-t border-gray-200 pt-4 sm:pt-6 mt-4 sm:mt-6">
                    <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-3 sm:mb-4">Balasan Admin</h3>
                    <div class="bg-blue-50 rounded-lg p-4 sm:p-6 border-l-4 border-blue-500">
                        <div class="prose max-w-none">
                            <p class="text-sm sm:text-base text-gray-800 whitespace-pre-wrap break-words"><?php echo e($inquiry->admin_reply); ?></p>
                        </div>
                        <div class="mt-3 sm:mt-4 text-xs sm:text-sm text-gray-600">
                            <i class="fas fa-info-circle mr-1"></i>
                            Balasan dikirim melalui <?php echo e(ucfirst($inquiry->reply_method)); ?> pada <?php echo e($inquiry->admin_replied_at->format('d M Y H:i')); ?>

                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($inquiry->final_offer_price): ?>
            <div class="mt-4 sm:mt-6 border-t border-gray-200 pt-4 sm:pt-6" id="finalOfferSection">
                <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-3 sm:mb-4">Penawaran Harga Final</h3>
                <div class="bg-green-50 rounded-lg p-4 sm:p-6 border-l-4 border-green-500">
                    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3 sm:gap-4">
                        <div class="flex-1">
                            <div class="text-xs sm:text-sm text-gray-600">Harga Penawaran</div>
                            <div class="text-xl sm:text-2xl font-bold text-gray-900">Rp <?php echo e(number_format($inquiry->final_offer_price,0,',','.')); ?></div>
                            <div class="text-xs sm:text-sm text-gray-600 mt-1">Berlaku hingga: <?php echo e($inquiry->validity_until ? \Carbon\Carbon::parse($inquiry->validity_until)->format('d M Y') : '-'); ?></div>
                        </div>
                        <div class="flex flex-col sm:flex-row gap-2 sm:gap-2" id="actionButtons">
                            <?php if($inquiry->status === 'converted_to_order' || !is_null($inquiry->order_id)): ?>
                                
                                <div class="w-full sm:w-auto inline-flex items-center justify-center px-3 sm:px-4 py-2 text-sm sm:text-base bg-purple-600 text-white rounded-lg">
                                    <i class="fas fa-shopping-cart mr-1"></i> Penawaran Telah Diubah Menjadi Pesanan
                                </div>
                            <?php elseif($inquiry->status === 'customer_accepted'): ?>
                                
                                <div class="w-full sm:w-auto inline-flex items-center justify-center px-3 sm:px-4 py-2 text-sm sm:text-base bg-green-600 text-white rounded-lg">
                                    <i class="fas fa-check-circle mr-1"></i> Penawaran Telah Disetujui
                                </div>
                            <?php elseif($inquiry->status === 'sent_to_customer' || ($inquiry->final_offer_price && !in_array($inquiry->status, ['customer_accepted', 'converted_to_order']))): ?>
                                
                                <form method="POST" action="<?php echo e(route('guest.inquiry.accept', $inquiry)); ?>" id="acceptForm" class="inline w-full sm:w-auto">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" id="acceptBtn" class="w-full sm:w-auto inline-flex items-center justify-center px-3 sm:px-4 py-2 text-sm sm:text-base bg-green-600 hover:bg-green-700 text-white rounded-lg transition-all disabled:opacity-50 disabled:cursor-not-allowed">
                                        <span id="acceptBtnText"><i class="fas fa-check mr-1"></i> Setuju</span>
                                        <span id="acceptBtnLoading" class="hidden"><i class="fas fa-spinner fa-spin mr-1"></i> Memproses...</span>
                                    </button>
                                </form>
                                <button onclick="openCounterModal()" class="w-full sm:w-auto inline-flex items-center justify-center px-3 sm:px-4 py-2 text-sm sm:text-base bg-yellow-500 hover:bg-yellow-600 text-white rounded-lg"><i class="fas fa-exchange-alt mr-1"></i> Ajukan Revisi</button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="mt-3 text-xs sm:text-sm">
                    <a href="<?php echo e(route('admin.print.quotation.offer.preview', $inquiry)); ?>" target="_blank" class="text-blue-600 hover:underline"><i class="fas fa-file-pdf mr-1"></i>Lihat Dokumen Penawaran</a>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Actions -->
        <div class="mt-6 sm:mt-8 flex flex-col sm:flex-row justify-center gap-2 sm:gap-4">
            <a href="<?php echo e(route('product_details', $inquiry->product->id)); ?>" 
                class="w-full sm:w-auto inline-flex items-center justify-center px-4 sm:px-6 py-2 sm:py-3 text-sm sm:text-base bg-green-600 hover:bg-green-700 text-white rounded-lg transition-colors">
                <i class="fas fa-eye mr-2"></i>
                Lihat Produk
            </a>
            <a href="<?php echo e(route('all')); ?>" 
                class="w-full sm:w-auto inline-flex items-center justify-center px-4 sm:px-6 py-2 sm:py-3 text-sm sm:text-base bg-blue-600 hover:bg-blue-700 text-white rounded-lg transition-colors">
                <i class="fas fa-search mr-2"></i>
                Lihat Produk Lain
            </a>
        </div>

        <!-- Tips -->
        <div class="mt-6 sm:mt-8 bg-blue-50 border border-blue-200 rounded-xl p-4 sm:p-6">
            <h3 class="text-base sm:text-lg font-semibold text-blue-900 mb-2 sm:mb-3">
                <i class="fas fa-lightbulb mr-2 text-sm sm:text-base"></i>
                Tips Tracking Penawaran
            </h3>
            <ul class="space-y-2 text-blue-800 text-xs sm:text-sm">
                <li class="flex items-start">
                    <i class="fas fa-check-circle mr-2 mt-0.5 sm:mt-1 text-blue-600 flex-shrink-0 text-xs sm:text-sm"></i>
                    <span>Simpan tracking code ini untuk memeriksa status penawaran Anda</span>
                </li>
                <li class="flex items-start">
                    <i class="fas fa-check-circle mr-2 mt-0.5 sm:mt-1 text-blue-600 flex-shrink-0 text-xs sm:text-sm"></i>
                    <span>Admin biasanya merespons dalam 1-2 hari kerja</span>
                </li>
                <li class="flex items-start">
                    <i class="fas fa-check-circle mr-2 mt-0.5 sm:mt-1 text-blue-600 flex-shrink-0 text-xs sm:text-sm"></i>
                    <span>Jika belum ada balasan, periksa email atau WhatsApp Anda</span>
                </li>
                <li class="flex items-start">
                    <i class="fas fa-check-circle mr-2 mt-0.5 sm:mt-1 text-blue-600 flex-shrink-0 text-xs sm:text-sm"></i>
                    <span>Anda bisa kirim penawaran baru untuk produk lain</span>
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- Counter Modal -->
<div id="counterModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg shadow-xl max-w-md w-full">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-xl font-bold text-gray-900">Ajukan Revisi Harga</h3>
                    <button onclick="closeCounterModal()" class="text-gray-400 hover:text-gray-600"><i class="fas fa-times"></i></button>
                </div>
                <form method="POST" action="<?php echo e(route('guest.inquiry.counter', $inquiry)); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Harga yang Anda ajukan</label>
                            <input type="number" step="0.01" name="counter_price" class="w-full px-3 py-2 border border-gray-300 rounded-md" required placeholder="0">
                            <p class="text-xs text-gray-500 mt-1">Jika supervisor memberi koridor harga, pastikan tawaran Anda berada di dalamnya.</p>
                        </div>
                        <div class="flex justify-end gap-2">
                            <button type="button" onclick="closeCounterModal()" class="px-4 py-2 bg-gray-200 rounded-lg">Batal</button>
                            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg">Kirim</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function openCounterModal(){ document.getElementById('counterModal').classList.remove('hidden'); }
function closeCounterModal(){ document.getElementById('counterModal').classList.add('hidden'); }

// Handle Accept Form Submission
document.addEventListener('DOMContentLoaded', function() {
    const acceptForm = document.getElementById('acceptForm');
    if (acceptForm) {
        acceptForm.addEventListener('submit', function(e) {
            const acceptBtn = document.getElementById('acceptBtn');
            const acceptBtnText = document.getElementById('acceptBtnText');
            const acceptBtnLoading = document.getElementById('acceptBtnLoading');
            
            // Show loading state
            acceptBtn.disabled = true;
            acceptBtnText.classList.add('hidden');
            acceptBtnLoading.classList.remove('hidden');
            
            // Form akan tetap submit secara normal
            // Flash message akan ditangani di bawah
        });
    }
});

// Display Flash Messages dengan SweetAlert2
<?php if(session('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'Berhasil!',
        text: '<?php echo e(session('success')); ?>',
        timer: 2500,
        timerProgressBar: true,
        showConfirmButton: true,
        confirmButtonText: 'OK',
        position: 'top-end',
        toast: true
    }).then(() => {
        // Reload halaman untuk mendapatkan data terbaru (status sudah di-update di server)
        <?php if(str_contains(session('success'), 'setujui')): ?>
            window.location.reload();
        <?php endif; ?>
    });
<?php endif; ?>

<?php if(session('error')): ?>
    Swal.fire({
        icon: 'error',
        title: 'Error!',
        text: '<?php echo e(session('error')); ?>',
        timer: 3000,
        timerProgressBar: true,
        showConfirmButton: true,
        confirmButtonText: 'OK',
        position: 'top-end',
        toast: true
    }).then(() => {
        // Re-enable button jika error
        const acceptBtn = document.getElementById('acceptBtn');
        const acceptBtnText = document.getElementById('acceptBtnText');
        const acceptBtnLoading = document.getElementById('acceptBtnLoading');
        if (acceptBtn && acceptBtnText && acceptBtnLoading) {
            acceptBtn.disabled = false;
            acceptBtnText.classList.remove('hidden');
            acceptBtnLoading.classList.add('hidden');
        }
    });
<?php endif; ?>

// Fallback: Re-enable button jika halaman reload tanpa flash message (misalnya network error)
window.addEventListener('load', function() {
    const acceptBtn = document.getElementById('acceptBtn');
    const acceptBtnText = document.getElementById('acceptBtnText');
    const acceptBtnLoading = document.getElementById('acceptBtnLoading');
    if (acceptBtn && acceptBtn.disabled && acceptBtnText && acceptBtnLoading) {
        // Jika button masih disabled setelah reload, enable kembali
        setTimeout(() => {
            acceptBtn.disabled = false;
            acceptBtnText.classList.remove('hidden');
            acceptBtnLoading.classList.add('hidden');
        }, 1000);
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/guest/inquiry/track.blade.php ENDPATH**/ ?>