

<?php $__env->startSection('title', 'Monitoring Orders - Supervisor'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Monitoring Orders</h1>
            <p class="text-gray-600 dark:text-gray-400 mt-1">Semua pesanan customer</p>
        </div>
        <div class="bg-blue-100 dark:bg-blue-900/20 px-4 py-2 rounded-lg">
            <span class="text-blue-800 dark:text-blue-200 font-medium">Total: <?php echo e($orders->total()); ?> Orders</span>
        </div>
    </div>

    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
                <i class="fas fa-clipboard-list mr-2 text-green-400"></i>Data Pesanan
            </h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Order ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Customer</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Produk</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Quantity</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Total</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Order Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Payment Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Production</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Tanggal</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900 dark:text-gray-100">
                            #<?php echo e($order->id); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-gray-100">
                            <div>
                                <p class="font-medium"><?php echo e($order->customer_name ?? $order->user->name ?? '-'); ?></p>
                                <p class="text-xs text-gray-500 dark:text-gray-400"><?php echo e($order->customer_email ?? $order->user->email ?? '-'); ?></p>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-gray-100">
                            <?php echo e($order->product->product_title ?? '-'); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-gray-900 dark:text-gray-100">
                            <?php echo e(number_format($order->quantity, 0, ',', '.')); ?> unit
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right font-semibold text-gray-900 dark:text-gray-100">
                            Rp <?php echo e(number_format($order->total_price, 0, ',', '.')); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                <?php if($order->order_status === 'diterima'): ?> bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-400
                                <?php elseif($order->order_status === 'menunggu'): ?> bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-400
                                <?php elseif($order->order_status === 'ditolak'): ?> bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-400
                                <?php else: ?> bg-gray-100 text-gray-800 dark:bg-gray-900/20 dark:text-gray-400 <?php endif; ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $order->order_status ?? '-'))); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                <?php if($order->status === 'selesai'): ?> bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-400
                                <?php elseif($order->status === 'diproses'): ?> bg-blue-100 text-blue-800 dark:bg-blue-900/20 dark:text-blue-400
                                <?php elseif($order->status === 'gagal' || $order->status === 'dibatalkan'): ?> bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-400
                                <?php else: ?> bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-400 <?php endif; ?>">
                                <?php echo e(ucfirst($order->status ?? '-')); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                <?php if($order->production_status === 'selesai'): ?> bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-400
                                <?php elseif($order->production_status === 'dalam_proses'): ?> bg-blue-100 text-blue-800 dark:bg-blue-900/20 dark:text-blue-400
                                <?php elseif($order->production_status === 'dibatalkan'): ?> bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-400
                                <?php else: ?> bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-400 <?php endif; ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $order->production_status ?? 'menunggu'))); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-gray-100">
                            <?php echo e($order->created_at->format('d/m/Y')); ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="9" class="px-6 py-8 text-center text-gray-500 dark:text-gray-400">
                            <i class="fas fa-inbox text-4xl mb-2 block"></i>
                            Tidak ada data pesanan
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="px-6 py-4 border-t border-gray-200 dark:border-gray-700">
            <?php echo e($orders->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.supervisor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/monitoring/orders.blade.php ENDPATH**/ ?>