

<?php $__env->startSection('title', 'Dashboard Supervisor - POLJAM TECH'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Dashboard Supervisor</h1>
            <p class="text-gray-600 dark:text-gray-400 mt-1">Overview sistem dan pending approvals</p>
        </div>
        <div class="text-sm text-gray-500 dark:text-gray-400">
            <?php echo e(now()->format('d M Y, H:i')); ?>

        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Pending Production Approvals -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center">
                <div class="p-3 bg-red-100 dark:bg-red-900/20 rounded-lg">
                    <i class="fas fa-cogs text-red-600 dark:text-red-400 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Pending Production</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo e($stats['pending_production_approvals']); ?></p>
                </div>
            </div>
        </div>

        <!-- Pending Purchase Approvals -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center">
                <div class="p-3 bg-orange-100 dark:bg-orange-900/20 rounded-lg">
                    <i class="fas fa-shopping-cart text-orange-600 dark:text-orange-400 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Pending Purchase</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo e($stats['pending_purchase_approvals']); ?></p>
                </div>
            </div>
        </div>

        <!-- Low Stock Items -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center">
                <div class="p-3 bg-yellow-100 dark:bg-yellow-900/20 rounded-lg">
                    <i class="fas fa-box-open text-yellow-600 dark:text-yellow-400 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Stok Rendah (≤ limit)</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo e($stats['low_stock_items'] ?? 0); ?></p>
                </div>
            </div>
        </div>

        <!-- Active Productions Today -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center">
                <div class="p-3 bg-blue-100 dark:bg-blue-900/20 rounded-lg">
                    <i class="fas fa-industry text-blue-600 dark:text-blue-400 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Produksi Aktif Hari Ini</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo e($stats['active_productions_today'] ?? 0); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
        <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Quick Actions</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <a href="<?php echo e(route('supervisor.productions.index')); ?>" 
               class="flex items-center p-4 bg-red-50 dark:bg-red-900/20 rounded-lg hover:bg-red-100 dark:hover:bg-red-900/30 transition-colors">
                <i class="fas fa-cogs text-red-600 dark:text-red-400 text-xl mr-3"></i>
                <div>
                    <p class="font-medium text-gray-900 dark:text-white">Review Productions</p>
                    <p class="text-sm text-gray-600 dark:text-gray-400"><?php echo e($stats['pending_production_approvals']); ?> pending</p>
                </div>
            </a>
            
            <a href="<?php echo e(route('supervisor.purchases.index')); ?>" 
               class="flex items-center p-4 bg-orange-50 dark:bg-orange-900/20 rounded-lg hover:bg-orange-100 dark:hover:bg-orange-900/30 transition-colors">
                <i class="fas fa-shopping-cart text-orange-600 dark:text-orange-400 text-xl mr-3"></i>
                <div>
                    <p class="font-medium text-gray-900 dark:text-white">Review Purchases</p>
                    <p class="text-sm text-gray-600 dark:text-gray-400"><?php echo e($stats['pending_purchase_approvals']); ?> pending</p>
                </div>
            </a>
            
            <a href="<?php echo e(route('supervisor.approvals.index')); ?>" 
               class="flex items-center p-4 bg-yellow-50 dark:bg-yellow-900/20 rounded-lg hover:bg-yellow-100 dark:hover:bg-yellow-900/30 transition-colors">
                <i class="fas fa-clipboard-list text-yellow-600 dark:text-yellow-400 text-xl mr-3"></i>
                <div>
                    <p class="font-medium text-gray-900 dark:text-white">Order Approvals</p>
                    <p class="text-sm text-gray-600 dark:text-gray-400"><?php echo e($stats['pending_orders']); ?> pending</p>
                </div>
            </a>
        </div>
    </div>

    <!-- Recent Activities -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Recent Orders -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Recent Orders</h2>
                <a href="<?php echo e(route('supervisor.approvals.index')); ?>" class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 text-sm">Lihat semua</a>
            </div>
            <div class="space-y-3">
                <?php $__empty_1 = true; $__currentLoopData = $stats['recent_orders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <div>
                        <p class="font-medium text-gray-900 dark:text-white">Order #<?php echo e($order->id); ?></p>
                        <p class="text-sm text-gray-600 dark:text-gray-400"><?php echo e($order->product->product_title ?? 'N/A'); ?></p>
                    </div>
                    <div class="text-right">
                        <p class="text-sm text-gray-600 dark:text-gray-400"><?php echo e($order->quantity); ?> unit</p>
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                            <?php if($order->order_status === 'menunggu'): ?> bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-400
                            <?php elseif($order->order_status === 'dalam_proses'): ?> bg-blue-100 text-blue-800 dark:bg-blue-900/20 dark:text-blue-400
                            <?php elseif($order->order_status === 'selesai'): ?> bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-400
                            <?php else: ?> bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-400 <?php endif; ?>">
                            <?php echo e(ucfirst(str_replace('_', ' ', $order->order_status))); ?>

                        </span>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="text-gray-500 dark:text-gray-400 text-center py-4">Tidak ada order terbaru</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Recent Productions -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Recent Productions</h2>
                <a href="<?php echo e(route('supervisor.productions.index')); ?>" class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 text-sm">Lihat semua</a>
            </div>
            <div class="space-y-3">
                <?php $__empty_1 = true; $__currentLoopData = $stats['recent_productions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $production): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <div>
                        <p class="font-medium text-gray-900 dark:text-white">Production #<?php echo e($production->id); ?></p>
                        <p class="text-sm text-gray-600 dark:text-gray-400"><?php echo e($production->product->product_title ?? 'N/A'); ?></p>
                    </div>
                    <div class="text-right">
                        <p class="text-sm text-gray-600 dark:text-gray-400"><?php echo e($production->quantity); ?> unit</p>
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                            <?php if($production->planning_status === 'planning'): ?> bg-blue-100 text-blue-800 dark:bg-blue-900/20 dark:text-blue-400
                            <?php elseif($production->planning_status === 'pending_approval'): ?> bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-400
                            <?php elseif($production->planning_status === 'approved'): ?> bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-400
                            <?php elseif($production->planning_status === 'rejected'): ?> bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-400
                            <?php else: ?> bg-gray-100 text-gray-800 dark:bg-gray-900/20 dark:text-gray-400 <?php endif; ?>">
                            <?php echo e(ucfirst(str_replace('_', ' ', $production->planning_status))); ?>

                        </span>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="text-gray-500 dark:text-gray-400 text-center py-4">Tidak ada produksi terbaru</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.supervisor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/dashboard.blade.php ENDPATH**/ ?>