

<?php $__env->startSection('title', 'Hero Section'); ?>

<?php $__env->startSection('content'); ?>

    <!-- Notifikasi Modern -->
    <?php if (isset($component)) { $__componentOriginal08a8786da7acaa0d17ad66b17276ca17 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal08a8786da7acaa0d17ad66b17276ca17 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin-notification','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-notification'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal08a8786da7acaa0d17ad66b17276ca17)): ?>
<?php $attributes = $__attributesOriginal08a8786da7acaa0d17ad66b17276ca17; ?>
<?php unset($__attributesOriginal08a8786da7acaa0d17ad66b17276ca17); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal08a8786da7acaa0d17ad66b17276ca17)): ?>
<?php $component = $__componentOriginal08a8786da7acaa0d17ad66b17276ca17; ?>
<?php unset($__componentOriginal08a8786da7acaa0d17ad66b17276ca17); ?>
<?php endif; ?>

    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800 dark:text-white mb-4">Daftar Hero Banner</h1>

        <!-- Filter Section -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <form method="GET" action="<?php echo e(route('admin.heroes.index')); ?>" id="filterForm"
                class="flex flex-col sm:flex-row items-end gap-3">
                <!-- Search Bar -->
                <div class="relative flex-1 w-full sm:w-auto">
                    <input type="text" name="search" id="searchInput" value="<?php echo e(request('search')); ?>"
                        placeholder="Cari hero..." class="form-input-search" />
                    <i
                        class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                    <?php if(request('search')): ?>
                        <button type="button" onclick="clearSearch()"
                            class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 hover:text-gray-600 dark:hover:text-gray-300">
                            <i class="fas fa-times"></i>
                        </button>
                    <?php endif; ?>
                </div>

                <!-- Filter Status -->
                <div class="relative w-full sm:w-auto">
                    <select name="status" id="statusFilter" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Status</option>
                        <option value="1" <?php echo e(request('status') === '1' ? 'selected' : ''); ?>>Aktif</option>
                        <option value="0" <?php echo e(request('status') === '0' ? 'selected' : ''); ?>>Nonaktif</option>
                    </select>
                    <i
                        class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-center gap-2 w-full sm:w-auto">
                    <button id="bulkDeleteBtn" onclick="confirmBulkDelete()" disabled class="action-btn-danger">
                        <i class="fas fa-trash mr-2"></i>
                        <span>Hapus Terpilih</span>
                    </button>
                    <a href="<?php echo e(route('admin.heroes.create')); ?>" class="action-btn-primary">
                        <i class="fas fa-plus mr-2"></i>
                        <span>Tambah Hero</span>
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Active Filters Info -->
    <?php if(request('search') || request()->filled('status')): ?>
        <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4">
            <div class="flex flex-wrap items-center gap-2">
                <span class="text-sm font-medium text-blue-800 dark:text-blue-200">Filter Aktif:</span>

                <?php if(request('search')): ?>
                    <span
                        class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-200">
                        <i class="fas fa-search mr-1"></i>
                        Pencarian: "<?php echo e(request('search')); ?>"
                        <button onclick="clearFilter('search')" class="ml-2 hover:text-blue-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                <?php endif; ?>

                <?php if(request()->filled('status')): ?>
                    <span
                        class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium <?php echo e(request('status') === '1' ? 'bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-200' : 'bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200'); ?>">
                        <?php if(request('status') === '1'): ?>
                            <i class="fas fa-check-circle mr-1"></i>
                        <?php else: ?>
                            <i class="fas fa-times-circle mr-1"></i>
                        <?php endif; ?>
                        Status: <?php echo e(request('status') === '1' ? 'Aktif' : 'Nonaktif'); ?>

                        <button onclick="clearFilter('status')" class="ml-2 hover:opacity-75">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                <?php endif; ?>

                <button onclick="clearAllFilters()"
                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200 hover:bg-red-200 dark:hover:bg-red-700 transition-colors">
                    <i class="fas fa-times-circle mr-1"></i>
                    Hapus Semua Filter
                </button>
            </div>
        </div>
    <?php endif; ?>

    <!-- Table Container -->
    <div
        class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-600">
                    <tr>
                        <th class="w-12 px-4 py-3.5 text-center">
                            <input type="checkbox" id="selectAll" onchange="toggleSelectAll(this)"
                                class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                        </th>
                        <th
                            class="w-16 px-4 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            No
                        </th>
                        <th
                            class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Gambar</th>
                        <th
                            class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Judul</th>
                        <th
                            class="px-6 py-3.5 text-left text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Subtitle</th>
                        <th
                            class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Urutan</th>
                        <th
                            class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Status</th>
                        <th
                            class="px-6 py-3.5 text-center text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-300">
                            Aksi</th>
                    </tr>
                </thead>

                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $heroes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hero): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr
                            class="hover:bg-blue-50/50 dark:hover:bg-gray-700/80 transition-colors duration-200 cursor-pointer">
                            <!-- Checkbox -->
                            <td class="px-4 py-4 text-center align-middle">
                                <input type="checkbox" name="hero_ids[]" value="<?php echo e($hero->id); ?>"
                                    onchange="updateBulkDeleteButton()"
                                    class="hero-checkbox w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                            </td>

                            <!-- No -->
                            <td class="px-4 py-4 text-sm text-gray-900 dark:text-gray-100 text-center align-middle">
                                <?php echo e($loop->iteration + $heroes->firstItem() - 1); ?>

                            </td>

                            <!-- Gambar -->
                            <td class="px-6 py-4 text-center align-middle">
                                <?php if($hero->image): ?>
                                    <div class="flex justify-center">
                                        <img src="<?php echo e(asset('uploads/' . $hero->image)); ?>" alt="Gambar Hero"
                                            class="h-20 w-32 object-contain rounded" style="background: transparent;"
                                            onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                        <!-- Fallback jika gambar gagal dimuat -->
                                        <div class="h-20 w-32 bg-gray-100 dark:bg-gray-600 rounded flex items-center justify-center mx-auto"
                                            style="display: none;">
                                            <i class="fas fa-image text-gray-400 dark:text-gray-500 text-lg"></i>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="flex justify-center">
                                        <div
                                            class="h-20 w-32 bg-gray-100 dark:bg-gray-600 rounded flex items-center justify-center">
                                            <i class="fas fa-image text-gray-400 dark:text-gray-500 text-lg"></i>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </td>

                            <!-- Judul -->
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100 font-medium align-middle">
                                <?php echo e($hero->title); ?>

                            </td>

                            <!-- Subtitle -->
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100 align-middle">
                                <?php echo e($hero->subtitle ?? '-'); ?>

                            </td>

                            <!-- Urutan -->
                            <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100 text-center align-middle">
                                <?php echo e($hero->order); ?>

                            </td>

                            <!-- Status -->
                            <td class="px-6 py-4 align-middle">
                                <?php if($hero->is_active): ?>
                                    <span
                                        class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-green-100 dark:bg-green-900/40 text-green-800 dark:text-green-200">
                                        Aktif
                                    </span>
                                <?php else: ?>
                                    <span
                                        class="inline-flex items-center px-2.5 py-1 text-xs font-medium rounded-md bg-red-100 dark:bg-red-900/40 text-red-800 dark:text-red-200">
                                        Nonaktif
                                    </span>
                                <?php endif; ?>
                            </td>

                            <!-- Aksi -->
                            <td class="px-6 py-4 text-center align-middle">
                                <div class="flex justify-center items-center space-x-3">
                                    <!-- Tombol Edit -->
                                    <a href="<?php echo e(route('admin.heroes.edit', $hero->id)); ?>"
                                        class="inline-flex items-center justify-center w-9 h-9 text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded transition-colors duration-200"
                                        title="Edit">
                                        <i class="fas fa-edit text-base"></i>
                                    </a>

                                    <!-- Tombol Hapus -->
                                    <button onclick="confirmDelete(<?php echo e($hero->id); ?>)"
                                        class="inline-flex items-center justify-center w-9 h-9 text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 hover:bg-red-50 dark:hover:bg-red-900/20 rounded transition-colors duration-200"
                                        title="Hapus">
                                        <i class="fas fa-trash text-base"></i>
                                    </button>
                                </div>

                                <!-- Form Hapus Tersembunyi -->
                                <form id="delete-form-<?php echo e($hero->id); ?>"
                                    action="<?php echo e(route('admin.heroes.destroy', $hero->id)); ?>" method="POST"
                                    class="hidden">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div
                                        class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-4">
                                        <i class="fas fa-inbox text-2xl text-gray-400 dark:text-gray-500"></i>
                                    </div>
                                    <p class="text-gray-500 dark:text-gray-400 text-lg font-medium">Belum ada data hero</p>
                                    <p class="text-gray-400 dark:text-gray-500 text-sm mt-1">Mulai dengan menambahkan hero
                                        pertama</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <?php if($heroes->hasPages()): ?>
        <div class="mt-6 flex justify-center">
            <?php echo e($heroes->onEachSide(1)->links()); ?>

        </div>
    <?php endif; ?>

    <!-- Form Bulk Delete Tersembunyi -->
    <form id="bulkDeleteForm" action="<?php echo e(route('admin.heroes.bulkDestroy')); ?>" method="POST" class="hidden">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <input type="hidden" name="ids" id="bulkDeleteIds">
    </form>

    <style>
        /* Konsisten Style untuk semua Index Pages */
        .form-input-search,
        .form-select {
            height: 40px !important;
            min-height: 40px !important;
            max-height: 40px !important;
            box-sizing: border-box !important;
            line-height: 1.5 !important;
            padding: 0 2.5rem 0 2.5rem !important;
            margin: 0 !important;
        }

        .form-input-search {
            width: 100%;
            padding-left: 2.5rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            transition: all 0.2s;
        }

        .dark .form-input-search {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }

        .form-input-search:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }

        .form-select {
            width: 100%;
            padding-left: 1rem !important;
            padding-right: 2.5rem !important;
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background-color: white;
            color: rgb(17 24 39);
            font-size: 0.875rem;
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            transition: all 0.2s;
        }

        .dark .form-select {
            border-color: rgb(75 85 99);
            background-color: rgb(55 65 81);
            color: white;
        }

        .form-select:focus {
            outline: none;
            ring: 2px;
            ring-color: rgb(59 130 246);
        }

        .action-btn-primary,
        .action-btn-danger {
            height: 40px !important;
            min-height: 40px !important;
            max-height: 40px !important;
            box-sizing: border-box !important;
            padding: 0 1rem !important;
            margin: 0 !important;
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center !important;
            font-weight: 500;
            border-radius: 0.5rem;
            transition: all 0.2s;
            white-space: nowrap;
        }

        .action-btn-primary {
            background-color: rgb(59 130 246);
            color: white;
        }

        .action-btn-primary:hover {
            background-color: rgb(37 99 235);
        }

        .action-btn-danger {
            background-color: rgb(239 68 68);
            color: white;
        }

        .action-btn-danger:hover:not(:disabled) {
            background-color: rgb(220 38 38);
        }

        .action-btn-danger:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
    </style>

    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Yakin ingin menghapus?',
                text: "Data ini akan dihapus secara permanen!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc2626',
                cancelButtonColor: '#6b7280',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal',
                reverseButtons: true,
                customClass: {
                    popup: 'rounded-lg',
                    confirmButton: 'px-4 py-2 rounded-md font-medium',
                    cancelButton: 'px-4 py-2 rounded-md font-medium'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }

        function toggleSelectAll(checkbox) {
            const checkboxes = document.querySelectorAll('.hero-checkbox');
            checkboxes.forEach(cb => {
                cb.checked = checkbox.checked;
            });
            updateBulkDeleteButton();
        }

        function updateBulkDeleteButton() {
            const checkboxes = document.querySelectorAll('.hero-checkbox:checked');
            const bulkDeleteBtn = document.getElementById('bulkDeleteBtn');

            if (checkboxes.length > 0) {
                bulkDeleteBtn.disabled = false;
            } else {
                bulkDeleteBtn.disabled = true;
                document.getElementById('selectAll').checked = false;
            }
        }

        function confirmBulkDelete() {
            const checkboxes = document.querySelectorAll('.hero-checkbox:checked');
            const ids = Array.from(checkboxes).map(cb => cb.value);

            if (ids.length === 0) {
                return;
            }

            Swal.fire({
                title: 'Yakin ingin menghapus?',
                text: `Anda akan menghapus ${ids.length} hero secara permanen!`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc2626',
                cancelButtonColor: '#6b7280',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal',
                reverseButtons: true,
                customClass: {
                    popup: 'rounded-lg',
                    confirmButton: 'px-4 py-2 rounded-md font-medium',
                    cancelButton: 'px-4 py-2 rounded-md font-medium'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('bulkDeleteIds').value = JSON.stringify(ids);
                    document.getElementById('bulkDeleteForm').submit();
                }
            });
        }

        // Submit filter dengan parameter yang bersih
        function submitFilter() {
            const params = new URLSearchParams();

            // Ambil nilai dari setiap input/select
            const search = document.getElementById('searchInput')?.value?.trim() || '';
            const status = document.getElementById('statusFilter')?.value || '';

            // Hanya tambahkan parameter yang memiliki nilai
            if (search) {
                params.append('search', search);
            }
            if (status) {
                params.append('status', status);
            }

            // Redirect dengan parameter yang bersih
            const url = '<?php echo e(route('admin.heroes.index')); ?>' + (params.toString() ? '?' + params.toString() : '');
            window.location.href = url;
        }

        // Clear search only
        function clearSearch() {
            const url = new URL(window.location);
            url.searchParams.delete('search');
            window.location.href = url.toString();
        }

        // Clear individual filter
        function clearFilter(filterName) {
            const url = new URL(window.location);
            url.searchParams.delete(filterName);
            window.location.href = url.toString();
        }

        // Clear all filters
        function clearAllFilters() {
            window.location.href = '<?php echo e(route('admin.heroes.index')); ?>';
        }

        // Submit form search dengan Enter
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            if (searchInput) {
                searchInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                        submitFilter();
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/heroes/index.blade.php ENDPATH**/ ?>