

<?php $__env->startSection('title', 'History Produksi - Teknisi'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Breadcrumb -->
    <nav class="mb-4">
        <ol class="flex items-center space-x-2 text-sm">
            <li>
                <a href="<?php echo e(route('teknisi.productions.index')); ?>" 
                   class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white transition-colors">
                    <i class="fas fa-industry mr-1"></i>Produksi Aktif
                </a>
            </li>
            <li class="text-gray-500 dark:text-gray-400">
                <i class="fas fa-chevron-right text-xs"></i>
            </li>
            <li class="text-gray-900 dark:text-white font-semibold">
                History Produksi
            </li>
        </ol>
    </nav>

    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white">History Produksi</h1>
            <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">Riwayat produksi yang sudah selesai</p>
        </div>
        <a href="<?php echo e(route('teknisi.productions.index')); ?>" 
           class="inline-flex items-center gap-2 px-4 py-2 bg-gray-600 hover:bg-gray-700 dark:bg-gray-700 dark:hover:bg-gray-600 text-white rounded-lg text-sm font-medium transition-colors duration-200">
            <i class="fas fa-arrow-left"></i>
            <span>Kembali ke Produksi Aktif</span>
        </a>
    </div>

    
    <?php
        $totalHistory = $productions->total();
        $thisMonth = $productions->where('end_date', '>=', now()->startOfMonth())->count();
        $totalCost = $productions->sum(function($p) {
            $materialTotal = $p->total_material_cost ?? 0;
            $sparepartTotal = $p->total_sparepart_cost ?? 0;
            $directTotal = $materialTotal + $sparepartTotal;
            $laborTotal = $p->labor_cost ?? 0;
            return $directTotal + $laborTotal;
        });
    ?>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide">Total History</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1"><?php echo e($totalHistory); ?></p>
                </div>
                <div class="p-3 bg-green-100 dark:bg-green-900/40 rounded-lg">
                    <i class="fas fa-check-circle text-green-600 dark:text-green-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide">Selesai Bulan Ini</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1"><?php echo e($thisMonth); ?></p>
                </div>
                <div class="p-3 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-calendar-alt text-blue-600 dark:text-blue-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide">Total Biaya</p>
                    <p class="text-lg font-bold text-indigo-600 dark:text-indigo-400 mt-1">Rp <?php echo e(number_format($totalCost, 0, ',', '.')); ?></p>
                </div>
                <div class="p-3 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg">
                    <i class="fas fa-dollar-sign text-indigo-600 dark:text-indigo-400 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <?php if($productions->count() > 0): ?>
    <!-- Table Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-600">
                    <tr>
                        <th class="px-4 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Produk</th>
                        <th class="px-4 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Customer</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Qty</th>
                        <th class="px-4 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Tanggal Selesai</th>
                        <th class="px-4 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Biaya Langsung</th>
                        <th class="px-4 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Biaya Labor</th>
                        <th class="px-4 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Total Aktual</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__currentLoopData = $productions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $production): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $materialTotal = $production->total_material_cost ?? 0;
                        $sparepartTotal = $production->total_sparepart_cost ?? 0;
                        $directTotal = $materialTotal + $sparepartTotal;
                        $laborTotal = $production->labor_cost ?? 0;
                        $actualTotal = $directTotal + $laborTotal;
                    ?>
                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors duration-200">
                        <td class="px-4 py-3.5">
                            <div class="flex items-center gap-3">
                                <span class="inline-flex items-center px-2 py-0.5 rounded-md text-xs font-medium bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300">
                                    <i class="fas fa-check-circle mr-1"></i> Selesai
                                </span>
                                <div>
                                    <div class="text-sm font-semibold text-gray-900 dark:text-white">
                                        <?php echo e($production->product->product_title ?? 'N/A'); ?>

                                    </div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                        ID: #<?php echo e($production->id); ?>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td class="px-4 py-3.5">
                            <div class="text-sm text-gray-900 dark:text-white"><?php echo e($production->order->customer_name ?? 'N/A'); ?></div>
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                Order #<?php echo e($production->order->id ?? 'N/A'); ?>

                            </div>
                        </td>
                        <td class="px-4 py-3.5 text-center">
                            <span class="inline-flex items-center px-2.5 py-1 rounded-md text-sm font-medium bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300">
                                <?php echo e($production->quantity); ?> unit
                            </span>
                        </td>
                        <td class="px-4 py-3.5">
                            <div class="text-sm text-gray-900 dark:text-white">
                                <?php echo e($production->end_date ? $production->end_date->format('d M Y') : 'N/A'); ?>

                            </div>
                            <?php if($production->start_date): ?>
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                Mulai: <?php echo e($production->start_date->format('d M Y')); ?>

                            </div>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3.5 text-right">
                            <div class="text-sm font-semibold text-gray-900 dark:text-white">
                                Rp <?php echo e(number_format($directTotal, 0, ',', '.')); ?>

                            </div>
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                Bahan: Rp <?php echo e(number_format($materialTotal, 0, ',', '.')); ?>

                            </div>
                            <div class="text-xs text-gray-500 dark:text-gray-400">
                                Sparepart: Rp <?php echo e(number_format($sparepartTotal, 0, ',', '.')); ?>

                            </div>
                        </td>
                        <td class="px-4 py-3.5 text-right">
                            <?php if($laborTotal > 0): ?>
                                <div class="text-sm font-semibold text-amber-600 dark:text-amber-400">
                                    Rp <?php echo e(number_format($laborTotal, 0, ',', '.')); ?>

                                </div>
                                <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                    /unit: Rp <?php echo e(number_format($laborTotal / max($production->quantity, 1), 0, ',', '.')); ?>

                                </div>
                            <?php else: ?>
                                <span class="text-sm text-gray-400 dark:text-gray-500 italic">-</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3.5 text-right">
                            <div class="text-base font-bold text-indigo-600 dark:text-indigo-400">
                                Rp <?php echo e(number_format($actualTotal, 0, ',', '.')); ?>

                            </div>
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                /unit: Rp <?php echo e(number_format($actualTotal / max($production->quantity, 1), 0, ',', '.')); ?>

                            </div>
                        </td>
                        <td class="px-4 py-3.5 text-center">
                            <a href="<?php echo e(route('teknisi.productions.history.show', $production)); ?>" 
                               class="inline-flex items-center gap-2 px-3 py-1.5 bg-blue-500 hover:bg-blue-600 text-white text-sm font-medium rounded-lg transition-colors duration-200">
                                <i class="fas fa-eye"></i>
                                <span>Detail</span>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="mt-4">
        <?php echo e($productions->links()); ?>

    </div>
    <?php else: ?>
    <!-- Empty State -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700">
        <div class="text-center py-16">
            <div class="mx-auto w-20 h-20 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-6">
                <i class="fas fa-history text-3xl text-gray-400 dark:text-gray-500"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Belum Ada History</h3>
            <p class="text-sm text-gray-600 dark:text-gray-400 max-w-md mx-auto mb-4">
                Anda belum menyelesaikan produksi apapun. History akan muncul setelah produksi selesai.
            </p>
            <a href="<?php echo e(route('teknisi.productions.index')); ?>" 
               class="inline-flex items-center gap-2 px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white rounded-lg text-sm font-medium transition-colors duration-200">
                <i class="fas fa-arrow-left"></i>
                <span>Kembali ke Produksi Aktif</span>
            </a>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.teknisi', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/teknisi/productions/history.blade.php ENDPATH**/ ?>