<!-- Sidebar -->
<aside id="sidebar"
    class="fixed left-0 top-0 h-full w-64 bg-slate-900 dark:bg-gray-900 text-gray-300 dark:text-gray-200 z-50 shadow-2xl overflow-y-auto scrollbar-hide transform -translate-x-full border-r border-slate-800 dark:border-gray-800">

    <!-- Style untuk menyembunyikan scrollbar -->
    <style>
        .scrollbar-hide::-webkit-scrollbar {
            display: none;
        }

        .scrollbar-hide {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }

        /* Mobile sidebar improvements */
        @media (max-width: 1023px) {
            #sidebar {
                box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            }
        }

        /* Badge notification styles - override Tailwind hidden class */
        #sidebar-orders-badge,
        #sidebar-inquiry-badge,
        #sidebar-transaksi-badge,
        #sidebar-productions-badge,
        #sidebar-contacts-badge {
            align-items: center;
            justify-content: center;
            min-width: 20px;
            height: 20px;
            padding: 0 6px;
            background-color: #ef4444;
            color: white;
            font-size: 11px;
            font-weight: bold;
            border-radius: 10px;
            line-height: 1;
            animation: pulse 2s infinite;
            box-shadow: 0 2px 4px rgba(239, 68, 68, 0.3);
        }

        /* Explicitly hide with !important when hidden class is present */
        #sidebar-orders-badge.hidden,
        #sidebar-inquiry-badge.hidden,
        #sidebar-transaksi-badge.hidden,
        #sidebar-productions-badge.hidden,
        #sidebar-contacts-badge.hidden {
            display: none !important;
            visibility: hidden !important;
        }

        /* Explicitly show with !important when hidden class is NOT present */
        #sidebar-orders-badge:not(.hidden),
        #sidebar-inquiry-badge:not(.hidden),
        #sidebar-transaksi-badge:not(.hidden),
        #sidebar-productions-badge:not(.hidden),
        #sidebar-contacts-badge:not(.hidden) {
            display: inline-flex !important;
            visibility: visible !important;
            opacity: 1 !important;
        }

        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.8;
            }
        }

        /* Ensure logo gradient is not overridden by parent text color */
        #sidebar h3.bg-clip-text {
            color: transparent !important;
            background-image: linear-gradient(to right, #60a5fa, #22d3ee) !important;
            -webkit-background-clip: text !important;
            background-clip: text !important;
        }
    </style>

    <div class="p-5">
        <div class="flex items-center justify-between mb-6 pb-4 border-b border-slate-800 dark:border-gray-700">
            <!-- Logo -->
            <a href="<?php echo e(url('/')); ?>" class="flex-shrink-0 group">
                <h3 class="text-2xl font-extrabold bg-gradient-to-r from-blue-400 to-cyan-400 bg-clip-text text-transparent leading-tight whitespace-nowrap group-hover:from-blue-300 group-hover:to-cyan-300 transition-all duration-200 tracking-tight">POLJAM TECH</h3>
            </a>
            <!-- Close button for mobile -->
            <button onclick="toggleSidebar()"
                class="lg:hidden text-gray-400 hover:text-white transition-colors duration-200 p-1 rounded-lg hover:bg-slate-800">
                <i class="fas fa-times text-lg"></i>
            </button>
        </div>
        <nav>
            <ul class="space-y-0.5">
                <!-- Dashboard -->
                <li>
                    <a href="<?php echo e(route('admin.dashboard')); ?>"
                        class="flex items-center px-4 py-2.5 rounded-lg transition-all duration-200 group relative <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                        <div
                            class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200 <?php echo e(request()->routeIs('admin.dashboard') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                        </div>
                        <i
                            class="fas fa-home mr-3 text-base transition-colors duration-200 <?php echo e(request()->routeIs('admin.dashboard') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                        <span
                            class="text-sm font-medium transition-colors duration-200 <?php echo e(request()->routeIs('admin.dashboard') ? 'text-white' : 'group-hover:text-white'); ?>">Dashboard</span>
                    </a>
                </li>

                <!-- Kategori -->
                <li>
                    <a href="<?php echo e(route('admin.categories.index')); ?>"
                        class="flex items-center px-4 py-2.5 rounded-lg transition-all duration-200 group relative <?php echo e(request()->routeIs('admin.categories.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                        <div
                            class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200 <?php echo e(request()->routeIs('admin.categories.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                        </div>
                        <i
                            class="fas fa-tags mr-3 text-base transition-colors duration-200 <?php echo e(request()->routeIs('admin.categories.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                        <span
                            class="text-sm font-medium transition-colors duration-200 <?php echo e(request()->routeIs('admin.categories.*') ? 'text-white' : 'group-hover:text-white'); ?>">Kategori</span>
                    </a>
                </li>

                <!-- Hero Banner -->
                <li>
                    <a href="<?php echo e(route('admin.heroes.index')); ?>"
                        class="flex items-center px-4 py-2.5 rounded-lg transition-all duration-200 group relative <?php echo e(request()->routeIs('admin.heroes.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                        <div
                            class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200 <?php echo e(request()->routeIs('admin.heroes.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                        </div>
                        <i
                            class="fas fa-images mr-3 text-base transition-colors duration-200 <?php echo e(request()->routeIs('admin.heroes.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                        <span
                            class="text-sm font-medium transition-colors duration-200 <?php echo e(request()->routeIs('admin.heroes.*') ? 'text-white' : 'group-hover:text-white'); ?>">Hero Banner</span>
                    </a>
                </li>

                <!-- Master -->
                <li>
                    <div class="dropdown">
                        <button onclick="toggleDropdown('produkDropdown', 'produkIcon')"
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-lg transition-all duration-200 group relative
                            <?php echo e(request()->routeIs('admin.master.products.*') || request()->routeIs('admin.master.materials.*') || request()->routeIs('admin.master.spareparts.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                            <div
                                class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200
                                <?php echo e(request()->routeIs('admin.master.products.*') || request()->routeIs('admin.master.materials.*') || request()->routeIs('admin.master.spareparts.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                            </div>
                            <span class="flex items-center">
                                <i
                                    class="fas fa-box mr-3 text-base transition-colors duration-200
                                <?php echo e(request()->routeIs('admin.master.products.*') || request()->routeIs('admin.master.materials.*') || request()->routeIs('admin.master.spareparts.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>">
                                </i>
                                <span
                                    class="text-sm font-medium transition-colors duration-200
                                    <?php echo e(request()->routeIs('admin.master.products.*') || request()->routeIs('admin.master.materials.*') || request()->routeIs('admin.master.spareparts.*') ? 'text-white' : 'group-hover:text-white'); ?>">
                                    Master
                                </span>
                            </span>
                            <i id="produkIcon"
                                class="fas fa-chevron-right text-xs transition-transform duration-300
                                <?php echo e(request()->routeIs('admin.master.products.*') || request()->routeIs('admin.master.materials.*') || request()->routeIs('admin.master.spareparts.*') ? 'rotate-90 text-white' : 'text-gray-500'); ?>">
                            </i>
                        </button>
                        <ul id="produkDropdown"
                            class="ml-4 mt-1 space-y-0.5 border-l-2 border-slate-800 dark:border-gray-700 pl-4
                            <?php echo e(request()->routeIs('admin.master.products.*') || request()->routeIs('admin.master.materials.*') || request()->routeIs('admin.master.spareparts.*') ? 'block' : 'hidden'); ?>">
                            <li>
                                <a href="<?php echo e(route('admin.master.products.index')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.master.products.*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('admin.master.products.*') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Produk Jasa
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.master.materials.index')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.master.materials.*') || request()->routeIs('admin.master.spareparts.*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('admin.master.materials.*') || request()->routeIs('admin.master.spareparts.*') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Barang
                                </a>
                            </li>
                            
                        </ul>
                    </div>
                </li>

                <!-- Produksi (Top-level menu) -->
                <li>
                    <a href="<?php echo e(route('admin.productions.index')); ?>"
                        class="flex items-center px-4 py-2.5 rounded-lg transition-all duration-200 group relative <?php echo e(request()->routeIs('admin.productions.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                        <div
                            class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200 <?php echo e(request()->routeIs('admin.productions.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                        </div>
                        <i
                            class="fas fa-industry mr-3 text-base transition-colors duration-200 <?php echo e(request()->routeIs('admin.productions.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                        <span
                            class="flex-1 text-sm font-medium transition-colors duration-200 <?php echo e(request()->routeIs('admin.productions.*') ? 'text-white' : 'group-hover:text-white'); ?>">Produksi</span>
                        <span id="sidebar-productions-badge" class="hidden bg-red-500 text-white text-xs font-bold px-1.5 py-0.5 rounded-full min-w-[20px] text-center ml-2"></span>
                    </a>
                </li>

                <!-- Transaksi -->
                <li>
                    <div class="dropdown">
                        <button onclick="toggleDropdown('transaksiDropdown', 'transaksiIcon')"
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-lg transition-all duration-200 group relative
                            <?php echo e(request()->routeIs('admin.master.orders.*') || request()->routeIs('admin.transaksi.sales.*') || request()->routeIs('admin.transaksi.purchases.*') || request()->routeIs('admin.product-inquiries.*') || request()->routeIs('admin.handover.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                            <div
                                class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200
                                <?php echo e(request()->routeIs('admin.master.orders.*') || request()->routeIs('admin.transaksi.sales.*') || request()->routeIs('admin.transaksi.purchases.*') || request()->routeIs('admin.product-inquiries.*') || request()->routeIs('admin.handover.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                            </div>
                            <span class="flex items-center">
                                <i
                                    class="fas fa-exchange-alt mr-3 text-base transition-colors duration-200
                                    <?php echo e(request()->routeIs('admin.master.orders.*') || request()->routeIs('admin.transaksi.sales.*') || request()->routeIs('admin.transaksi.purchases.*') || request()->routeIs('admin.product-inquiries.*') || request()->routeIs('admin.handover.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>">
                                </i>
                            <span
                                class="text-sm font-medium transition-colors duration-200
                                <?php echo e(request()->routeIs('admin.master.orders.*') || request()->routeIs('admin.transaksi.sales.*') || request()->routeIs('admin.transaksi.purchases.*') || request()->routeIs('admin.product-inquiries.*') || request()->routeIs('admin.handover.*') ? 'text-white' : 'group-hover:text-white'); ?>">
                                    Transaksi
                                </span>
                            </span>
                            <div class="flex items-center">
                                <span id="sidebar-transaksi-badge" class="badge ml-2 bg-red-500 text-white text-xs font-bold px-1.5 py-0.5 rounded-full min-w-[20px] text-center hidden">0</span>
                                <i id="transaksiIcon"
                                    class="fas fa-chevron-right text-xs transition-transform duration-300 ml-1
                                    <?php echo e(request()->routeIs('admin.master.orders.*') || request()->routeIs('admin.transaksi.sales.*') || request()->routeIs('admin.transaksi.purchases.*') || request()->routeIs('admin.product-inquiries.*') || request()->routeIs('admin.handover.*') ? 'rotate-90 text-white' : 'text-gray-500'); ?>">
                                </i>
                            </div>
                        </button>
                        <ul id="transaksiDropdown"
                            class="ml-4 mt-1 space-y-0.5 border-l-2 border-slate-800 dark:border-gray-700 pl-4
                            <?php echo e(request()->routeIs('admin.master.orders.*') || request()->routeIs('admin.transaksi.sales.*') || request()->routeIs('admin.transaksi.purchases.*') || request()->routeIs('admin.product-inquiries.*') || request()->routeIs('admin.handover.*') ? 'block' : 'hidden'); ?>">
                            <li>
                                <a href="<?php echo e(route('admin.master.orders.index')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.master.orders.*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                        <?php echo e(request()->routeIs('admin.master.orders.*') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    <span class="flex-1">Pesanan</span>
                                    <span id="sidebar-orders-badge" class="badge ml-auto bg-red-500 text-white text-xs font-bold px-1.5 py-0.5 rounded-full min-w-[20px] text-center hidden">0</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.transaksi.sales.index')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.transaksi.sales.*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                        <?php echo e(request()->routeIs('admin.transaksi.sales.*') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Penjualan
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.product-inquiries.index')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.product-inquiries.*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                        <?php echo e(request()->routeIs('admin.product-inquiries.*') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    <span class="flex-1">Penawaran</span>
                                    <span id="sidebar-inquiry-badge" class="badge ml-auto bg-red-500 text-white text-xs font-bold px-1.5 py-0.5 rounded-full min-w-[20px] text-center hidden">0</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.transaksi.purchases.index')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.transaksi.purchases.*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                        <?php echo e(request()->routeIs('admin.transaksi.purchases.*') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Pembelian
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.handover.index')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.handover.*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                        <?php echo e(request()->routeIs('admin.handover.*') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Serah Terima
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <!-- Back Office -->
                <li>
                    <div class="dropdown">
                        <button onclick="toggleDropdown('backofficeDropdown', 'backofficeIcon')"
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-lg transition-all duration-200 group relative
                            <?php echo e(request()->routeIs('admin.backoffice.income.*') ||
                            request()->routeIs('admin.backoffice.expense.*') ||
                            request()->routeIs('admin.backoffice.stock-opname.*') ||
                            request()->routeIs('admin.receivables.*')
                                ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20'
                                : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">

                            <div
                                class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200
                                <?php echo e(request()->routeIs('admin.backoffice.income.*') ||
                                request()->routeIs('admin.backoffice.expense.*') ||
                                request()->routeIs('admin.backoffice.stock-opname.*') ||
                                request()->routeIs('admin.receivables.*')
                                    ? 'opacity-100'
                                    : 'opacity-0 group-hover:opacity-100'); ?>">
                            </div>

                            <span class="flex items-center">
                                <i
                                    class="fas fa-briefcase mr-3 text-base transition-colors duration-200
                                    <?php echo e(request()->routeIs('admin.backoffice.income.*') ||
                                    request()->routeIs('admin.backoffice.expense.*') ||
                                    request()->routeIs('admin.backoffice.stock-opname.*') ||
                                    request()->routeIs('admin.receivables.*')
                                        ? 'text-white'
                                        : 'text-gray-400 group-hover:text-blue-400'); ?>">
                                </i>
                                <span
                                    class="text-sm font-medium transition-colors duration-200
                                    <?php echo e(request()->routeIs('admin.backoffice.income.*') ||
                                    request()->routeIs('admin.backoffice.expense.*') ||
                                    request()->routeIs('admin.backoffice.stock-opname.*') ||
                                    request()->routeIs('admin.receivables.*')
                                        ? 'text-white'
                                        : 'group-hover:text-white'); ?>">
                                    Back Office
                                </span>
                            </span>

                            <i id="backofficeIcon"
                                class="fas fa-chevron-right text-xs transition-transform duration-300
                                <?php echo e(request()->routeIs('admin.backoffice.income.*') ||
                                request()->routeIs('admin.backoffice.expense.*') ||
                                request()->routeIs('admin.backoffice.stock-opname.*') ||
                                request()->routeIs('admin.receivables.*')
                                    ? 'rotate-90 text-white'
                                    : 'text-gray-500'); ?>">
                            </i>
                        </button>

                        <ul id="backofficeDropdown"
                            class="ml-4 mt-1 space-y-0.5 border-l-2 border-slate-800 dark:border-gray-700 pl-4
                            <?php echo e(request()->routeIs('admin.backoffice.income.*') ||
                            request()->routeIs('admin.backoffice.expense.*') ||
                            request()->routeIs('admin.backoffice.stock-opname.*') ||
                            request()->routeIs('admin.receivables.*')
                                ? 'block'
                                : 'hidden'); ?>">

                            <li>
                                <a href="<?php echo e(route('admin.backoffice.income.index')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.backoffice.income.*')
                                        ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20'
                                        : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                        <?php echo e(request()->routeIs('admin.backoffice.income.*') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Pemasukan
                                </a>
                            </li>

                            <li>
                                <a href="<?php echo e(route('admin.backoffice.expense.index')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.backoffice.expense.*')
                                        ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20'
                                        : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                        <?php echo e(request()->routeIs('admin.backoffice.expense.*') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Pengeluaran
                                </a>
                            </li>

                            <li>
                                <a href="<?php echo e(route('admin.backoffice.stock-opname.index')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.backoffice.stock-opname.*')
                                        ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20'
                                        : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                        <?php echo e(request()->routeIs('admin.backoffice.stock-opname.*') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Stock Opname
                                </a>
                            </li>

                            <li>
                                <a href="<?php echo e(route('admin.receivables.index')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.receivables.*')
                                        ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20'
                                        : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                        <?php echo e(request()->routeIs('admin.receivables.*') ? 'text-white rotate-90' : 'text-gray-600'); ?>">
                                    </i>
                                    Catatan Piutang
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <!-- Laporan -->
                <li>
                    <div class="dropdown">
                        <button onclick="toggleDropdown('laporanDropdown', 'laporanIcon')"
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-lg transition-all duration-200 group relative
                            <?php echo e(request()->routeIs('admin.reports.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                            <div
                                class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200
                                <?php echo e(request()->routeIs('admin.reports.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                            </div>
                            <span class="flex items-center">
                                <i
                                    class="fas fa-file-alt mr-3 text-base transition-colors duration-200
                                <?php echo e(request()->routeIs('admin.reports.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                                <span
                                    class="text-sm font-medium transition-colors duration-200
                                <?php echo e(request()->routeIs('admin.reports.*') ? 'text-white' : 'group-hover:text-white'); ?>">Laporan</span>
                            </span>
                            <i id="laporanIcon"
                                class="fas fa-chevron-right text-xs transition-transform duration-300
                                <?php echo e(request()->routeIs('admin.reports.*') ? 'rotate-90 text-white' : 'text-gray-500'); ?>"></i>
                        </button>
                        <ul id="laporanDropdown"
                            class="ml-4 mt-1 space-y-0.5 border-l-2 border-slate-800 dark:border-gray-700 pl-4
                        <?php echo e(request()->routeIs('admin.reports.*') ? 'block' : 'hidden'); ?>">
                            <li>
                                <a href="<?php echo e(route('admin.reports.sales')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.reports.sales*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('admin.reports.sales*') ? 'text-white rotate-90' : 'text-gray-600'); ?>"></i>
                                    Lap. Penjualan
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.reports.purchases')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.reports.purchases*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('admin.reports.purchases*') ? 'text-white rotate-90' : 'text-gray-600'); ?>"></i>
                                    Lap. Pembelian
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.reports.productions')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.reports.productions*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('admin.reports.productions*') ? 'text-white rotate-90' : 'text-gray-600'); ?>"></i>
                                    Lap. Produksi
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.reports.stock-limit')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.reports.stock-limit*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('admin.reports.stock-limit*') ? 'text-white rotate-90' : 'text-gray-600'); ?>"></i>
                                    Lap. Barang Limit
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.reports.damaged-items')); ?>"
                                    class="flex items-center px-3 py-2 rounded-lg transition-all duration-200 text-sm
                                    <?php echo e(request()->routeIs('admin.reports.damaged-items*') ? 'bg-blue-600 text-white shadow-md shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-400 hover:text-white'); ?>">
                                    <i
                                        class="fas fa-caret-right text-xs mr-2 transition-all duration-200
                                    <?php echo e(request()->routeIs('admin.reports.damaged-items*') ? 'text-white rotate-90' : 'text-gray-600'); ?>"></i>
                                    Lap. Barang Rusak
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <!-- Management User -->
                <li>
                    <a href="<?php echo e(route('admin.users.index')); ?>"
                        class="flex items-center px-4 py-2.5 rounded-lg transition-all duration-200 group relative <?php echo e(request()->routeIs('admin.users.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                        <div
                            class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200 <?php echo e(request()->routeIs('admin.users.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                        </div>
                        <i
                            class="fas fa-users-cog mr-3 text-base transition-colors duration-200 <?php echo e(request()->routeIs('admin.users.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                        <span
                            class="text-sm font-medium transition-colors duration-200 <?php echo e(request()->routeIs('admin.users.*') ? 'text-white' : 'group-hover:text-white'); ?>">Management User</span>
                    </a>
                </li>

                <!-- Contacts -->
                <li id="sidebar-contacts">
                    <a href="<?php echo e(route('admin.contacts.index')); ?>"
                        class="flex items-center px-4 py-2.5 rounded-lg transition-all duration-200 group relative <?php echo e(request()->routeIs('admin.contacts.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                        <div
                            class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200 <?php echo e(request()->routeIs('admin.contacts.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                        </div>
                        <i
                            class="fas fa-envelope mr-3 text-base transition-colors duration-200 <?php echo e(request()->routeIs('admin.contacts.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                        <span
                            class="flex-1 text-sm font-medium transition-colors duration-200 <?php echo e(request()->routeIs('admin.contacts.*') ? 'text-white' : 'group-hover:text-white'); ?>">Kontak</span>
                        <span id="sidebar-contacts-badge" class="badge ml-auto bg-red-500 text-white text-xs font-bold px-1.5 py-0.5 rounded-full min-w-[20px] text-center hidden">0</span>
                    </a>
                </li>

                <!-- Settings -->
                <li>
                    <a href="<?php echo e(route('admin.settings.index')); ?>"
                        class="flex items-center px-4 py-2.5 rounded-lg transition-all duration-200 group relative <?php echo e(request()->routeIs('admin.settings.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/20' : 'hover:bg-slate-800 dark:hover:bg-gray-800 text-gray-300 hover:text-white'); ?>">
                        <div
                            class="absolute left-0 w-1 h-6 rounded-r-full bg-blue-400 transition-all duration-200 <?php echo e(request()->routeIs('admin.settings.*') ? 'opacity-100' : 'opacity-0 group-hover:opacity-100'); ?>">
                        </div>
                        <i
                            class="fas fa-cog mr-3 text-base transition-colors duration-200 <?php echo e(request()->routeIs('admin.settings.*') ? 'text-white' : 'text-gray-400 group-hover:text-blue-400'); ?>"></i>
                        <span
                            class="text-sm font-medium transition-colors duration-200 <?php echo e(request()->routeIs('admin.settings.*') ? 'text-white' : 'group-hover:text-white'); ?>">Pengaturan</span>
                    </a>
                </li>

            </ul>
        </nav>
    </div>
</aside>

<!-- Mobile Overlay -->
<div id="sidebarOverlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden lg:hidden" style="opacity: 0; visibility: hidden;"></div>

<script>
    // Simple function to update navbar position
    function updateNavbarPosition() {
        const navbar = document.getElementById('adminNavbar');
        const sidebar = document.getElementById('sidebar');
        if (!navbar || !sidebar) return;
        
        const isMobile = window.innerWidth < 1024;
        if (isMobile) {
            navbar.style.left = '0';
            return;
        }
        
        const isHidden = sidebar.classList.contains('-translate-x-full');
        navbar.style.left = isHidden ? '0' : '256px';
    }
    
    // Smooth sidebar toggle
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        const mainContent = document.getElementById('mainContent');
        const isMobile = window.innerWidth < 1024;
        
        const isHidden = sidebar.classList.contains('-translate-x-full');
        
        if (isHidden) {
            // Show sidebar with smooth transition
            if (isMobile) {
                // Mobile: show overlay first, then sidebar
                overlay.classList.remove('hidden');
                overlay.style.opacity = '0';
                overlay.style.visibility = 'visible';
                void overlay.offsetHeight; // Force reflow
                overlay.style.opacity = '1';
                document.body.style.overflow = 'hidden';
                
                setTimeout(function() {
                    sidebar.classList.remove('-translate-x-full');
                    sidebar.style.transform = '';
                }, 10);
            } else {
                // Desktop: smooth transition
                sidebar.classList.remove('-translate-x-full');
                sidebar.style.transform = '';
                mainContent.classList.remove('ml-0');
                mainContent.classList.add('ml-64');
                mainContent.style.marginLeft = '';
                localStorage.setItem('adminSidebarState', 'visible');
                
                // Update navbar position
                updateNavbarPosition();
                
                // Fix layout width after transition
                setTimeout(function() {
                    if (typeof window.fixAdminLayout === 'function') {
                        window.fixAdminLayout();
                    }
                }, 300);
            }
        } else {
            // Hide sidebar with smooth transition
            if (isMobile) {
                // Mobile: hide sidebar first, then overlay
                sidebar.classList.add('-translate-x-full');
                sidebar.style.transform = 'translateX(-100%)';
                
                setTimeout(function() {
                    overlay.style.opacity = '0';
                    setTimeout(function() {
                        overlay.classList.add('hidden');
                        overlay.style.visibility = 'hidden';
                    }, 300);
                }, 50);
                document.body.style.overflow = 'auto';
            } else {
                // Desktop: smooth transition
                sidebar.classList.add('-translate-x-full');
                sidebar.style.transform = 'translateX(-100%)';
                mainContent.classList.remove('ml-64');
                mainContent.classList.add('ml-0');
                mainContent.style.marginLeft = '0';
                localStorage.setItem('adminSidebarState', 'hidden');
                
                // Update navbar position
                updateNavbarPosition();
                
                // Fix layout width - make content full width
                const viewportWidth = window.innerWidth;
                setTimeout(function() {
                    mainContent.style.width = viewportWidth + 'px';
                    mainContent.style.maxWidth = viewportWidth + 'px';
                    if (typeof window.fixAdminLayout === 'function') {
                        window.fixAdminLayout();
                    }
                }, 50);
            }
        }
    }

    // Close sidebar when clicking overlay
    document.getElementById('sidebarOverlay').addEventListener('click', function() {
        toggleSidebar();
    });

    // Close sidebar when clicking outside on mobile
    document.addEventListener('click', function(event) {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        const sidebarToggle = event.target.closest('[onclick="toggleSidebar()"]');

        if (window.innerWidth < 1024) {
            if (!sidebar.contains(event.target) && !sidebarToggle && !overlay.classList.contains('hidden')) {
                toggleSidebar();
            }
        }
    });

    // Handle window resize
    window.addEventListener('resize', function() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        const mainContent = document.getElementById('mainContent');

        if (window.innerWidth >= 1024) {
            const savedState = localStorage.getItem('adminSidebarState');
            const isHidden = savedState === 'hidden';
            
            if (isHidden) {
                sidebar.classList.add('-translate-x-full');
                sidebar.style.transform = 'translateX(-100%)';
                mainContent.classList.remove('ml-64');
                mainContent.classList.add('ml-0');
            } else {
                sidebar.classList.remove('-translate-x-full');
                sidebar.style.transform = '';
                mainContent.classList.remove('ml-0');
                mainContent.classList.add('ml-64');
            }
            overlay.classList.add('hidden');
        } else {
            if (sidebar.classList.contains('-translate-x-full')) {
                sidebar.style.transform = '';
            }
            mainContent.classList.remove('ml-64');
            mainContent.classList.add('ml-0');
            overlay.classList.add('hidden');
        }
        
        // Update navbar position on resize
        updateNavbarPosition();
    });
    
    // Initialize navbar position on load
    function initNavbarPosition() {
        if (document.getElementById('adminNavbar') && document.getElementById('sidebar')) {
            updateNavbarPosition();
        } else {
            setTimeout(initNavbarPosition, 50);
        }
    }
    
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initNavbarPosition);
    } else {
        initNavbarPosition();
    }

    // Dropdown toggle functionality
    function toggleDropdown(dropdownId, iconId) {
        const dropdown = document.getElementById(dropdownId);
        const icon = document.getElementById(iconId);

        if (dropdown.classList.contains('hidden')) {
            dropdown.classList.remove('hidden');
            icon.classList.add('rotate-90');
        } else {
            dropdown.classList.add('hidden');
            icon.classList.remove('rotate-90');
        }
    }
</script>
<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/partials/sidebar.blade.php ENDPATH**/ ?>